/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.objectives.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.IGlobalConstraint;
import org.eclipse.viatra.dse.objectives.impl.ModelQueryType;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public class ModelQueriesGlobalConstraint
implements IGlobalConstraint {
    public static final String GLOBAL_CONSTRAINT = "GlobalConstraint";
    protected String name;
    protected List<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>> constraints;
    protected List<ViatraQueryMatcher<? extends IPatternMatch>> matchers = new ArrayList<ViatraQueryMatcher<? extends IPatternMatch>>();
    protected ModelQueryType type = ModelQueryType.NO_MATCH;

    public ModelQueriesGlobalConstraint(String name, List<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>> constraints) {
        Objects.requireNonNull(name, "Name of the global constraint cannot be null.");
        Objects.requireNonNull(constraints, "The list of constraints cannot be null.");
        this.name = name;
        this.constraints = constraints;
    }

    public ModelQueriesGlobalConstraint(List<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>> constraints) {
        this(GLOBAL_CONSTRAINT, constraints);
    }

    public ModelQueriesGlobalConstraint(String name) {
        this(name, new ArrayList<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>>());
    }

    public ModelQueriesGlobalConstraint() {
        this(GLOBAL_CONSTRAINT, new ArrayList<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>>());
    }

    public ModelQueriesGlobalConstraint withConstraint(IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public ModelQueriesGlobalConstraint withType(ModelQueryType type) {
        this.type = type;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean checkGlobalConstraint(ThreadContext context) {
        for (ViatraQueryMatcher<? extends IPatternMatch> matcher : this.matchers) {
            if ((!this.type.equals((Object)ModelQueryType.NO_MATCH) || matcher.countMatches() <= 0) && (!this.type.equals((Object)ModelQueryType.MUST_HAVE_MATCH) || matcher.countMatches() != 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void init(ThreadContext context) {
        try {
            ViatraQueryEngine queryEngine = context.getQueryEngine();
            for (IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> querySpecification : this.constraints) {
                ViatraQueryMatcher matcher = querySpecification.getMatcher(queryEngine);
                this.matchers.add((ViatraQueryMatcher<? extends IPatternMatch>)matcher);
            }
        }
        catch (ViatraQueryException e) {
            throw new DSEException("Couldn't get the VIATRA Query matcher, see inner exception", e);
        }
    }

    @Override
    public IGlobalConstraint createNew() {
        return new ModelQueriesGlobalConstraint(this.name, this.constraints);
    }
}

