/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath, Daniel Varro, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 *  * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.vql;

import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Aggregated Value</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getAggregator <em>Aggregator</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getCall <em>Call</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getAggregateType <em>Aggregate Type</em>}</li>
 * </ul>
 *
 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getAggregatedValue()
 * @model
 * @generated
 */
public interface AggregatedValue extends ComputationValue
{
	/**
	 * Returns the value of the '<em><b>Aggregator</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Aggregator</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Aggregator</em>' reference.
	 * @see #setAggregator(JvmDeclaredType)
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getAggregatedValue_Aggregator()
	 * @model
	 * @generated
	 */
	JvmDeclaredType getAggregator();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getAggregator <em>Aggregator</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Aggregator</em>' reference.
	 * @see #getAggregator()
	 * @generated
	 */
	void setAggregator(JvmDeclaredType value);

	/**
	 * Returns the value of the '<em><b>Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Call</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Call</em>' containment reference.
	 * @see #setCall(CallableRelation)
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getAggregatedValue_Call()
	 * @model containment="true"
	 * @generated
	 */
	CallableRelation getCall();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getCall <em>Call</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Call</em>' containment reference.
	 * @see #getCall()
	 * @generated
	 */
	void setCall(CallableRelation value);

	/**
	 * Returns the value of the '<em><b>Aggregate Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * <p>This feature contains the aggregate parameter type inferred for this aggregator.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Aggregate Type</em>' reference.
	 * @see #setAggregateType(JvmType)
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getAggregatedValue_AggregateType()
	 * @model transient="true" derived="true"
	 * @generated
	 */
	JvmType getAggregateType();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue#getAggregateType <em>Aggregate Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Aggregate Type</em>' reference.
	 * @see #getAggregateType()
	 * @generated
	 */
	void setAggregateType(JvmType value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='return org.eclipse.viatra.query.patternlanguage.emf.util.ASTStringProvider.INSTANCE.doSwitch(this);'"
	 * @generated
	 */
	String toString();

} // AggregatedValue
