/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import java.util.function.Consumer;
import org.eclipse.viatra.query.runtime.api.IMatchUpdateListener;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;

public class MatchUpdateAdapter<Match extends IPatternMatch>
implements IMatchUpdateListener<Match> {
    Consumer<Match> appearCallback;
    Consumer<Match> disappearCallback;

    public MatchUpdateAdapter() {
    }

    public MatchUpdateAdapter(Consumer<Match> appearCallback, Consumer<Match> disappearCallback) {
        this.setAppearCallback(appearCallback);
        this.setDisappearCallback(disappearCallback);
    }

    public Consumer<Match> getAppearCallback() {
        return this.appearCallback;
    }

    public void setAppearCallback(Consumer<Match> appearCallback) {
        this.appearCallback = appearCallback;
    }

    public Consumer<Match> getDisappearCallback() {
        return this.disappearCallback;
    }

    public void setDisappearCallback(Consumer<Match> disappearCallback) {
        this.disappearCallback = disappearCallback;
    }

    @Override
    public void notifyAppearance(Match match) {
        if (this.appearCallback != null) {
            this.appearCallback.accept(match);
        }
    }

    @Override
    public void notifyDisappearance(Match match) {
        if (this.disappearCallback != null) {
            this.disappearCallback.accept(match);
        }
    }
}

