/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteBackendFactory;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;

public enum QueryResultViewModel {
    INSTANCE;

    private Set<QueryResultTreeInput> inputs = Sets.newHashSet();
    private QueryEvaluationHint defaultHint = new QueryEvaluationHint(null, (IQueryBackendFactory)new ReteBackendFactory());

    protected QueryResultTreeInput createInput(IModelConnector connector, IModelConnectorTypeEnum type) {
        Preconditions.checkArgument((connector != null ? 1 : 0) != 0, (Object)"Connector cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        Notifier notifier = connector.getNotifier(type);
        boolean wildcardMode = ViatraQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.viatra.query.tooling.ui.queryexplorer.WildcardMode");
        IndexingLevel wildcardLevel = wildcardMode ? IndexingLevel.FULL : IndexingLevel.NONE;
        boolean dynamicEMFMode = ViatraQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.viatra.query.tooling.ui.queryexplorer.DynamicEMFMode");
        BaseIndexOptions options = new BaseIndexOptions(dynamicEMFMode, wildcardLevel);
        EMFScope scope = new EMFScope(notifier, options);
        AdvancedViatraQueryEngine engine = AdvancedViatraQueryEngine.createUnmanagedEngine((QueryScope)scope);
        QueryResultTreeInput input = this.createInput(engine, false);
        input.setModelConnector(connector);
        return input;
    }

    protected QueryResultTreeInput createInput(AdvancedViatraQueryEngine engine, boolean readOnlyEngine) {
        QueryResultTreeInput input = new QueryResultTreeInput(engine, QuerySpecificationRegistry.getInstance(), readOnlyEngine, this.defaultHint);
        this.inputs.add(input);
        return input;
    }

    protected boolean removeInput(QueryResultTreeInput input) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"Input cannot be null");
        boolean removed = this.inputs.remove(input);
        if (removed) {
            AdvancedViatraQueryEngine engine = input.getEngine();
            input.dispose();
            if (engine != null && !input.isReadOnlyEngine()) {
                engine.dispose();
            }
        }
        return removed;
    }
}

