/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteBackendFactory;

public final class ViatraQueryEngineOptions {
    private final QueryEvaluationHint engineDefaultHints;
    private final IQueryBackendFactory defaultCachingBackendFactory;
    public static final ViatraQueryEngineOptions DEFAULT = new Builder().build();

    public static Builder defineOptions() {
        return new Builder();
    }

    public static Builder copyOptions(ViatraQueryEngineOptions options) {
        return new Builder(options);
    }

    private ViatraQueryEngineOptions(QueryEvaluationHint engineDefaultHints, IQueryBackendFactory defaultCachingBackendFactory) {
        this.engineDefaultHints = engineDefaultHints;
        this.defaultCachingBackendFactory = defaultCachingBackendFactory;
    }

    public QueryEvaluationHint getEngineDefaultHints() {
        return this.engineDefaultHints;
    }

    public IQueryBackendFactory getDefaultBackendFactory() {
        return this.engineDefaultHints.getQueryBackendFactory();
    }

    public IQueryBackendFactory getDefaultCachingBackendFactory() {
        return this.defaultCachingBackendFactory;
    }

    public String toString() {
        if (Objects.equals(this.engineDefaultHints, ViatraQueryEngineOptions.DEFAULT.engineDefaultHints)) {
            return "defaults";
        }
        return this.engineDefaultHints.toString();
    }

    /* synthetic */ ViatraQueryEngineOptions(QueryEvaluationHint queryEvaluationHint, IQueryBackendFactory iQueryBackendFactory, ViatraQueryEngineOptions viatraQueryEngineOptions) {
        this(queryEvaluationHint, iQueryBackendFactory);
    }

    public static final class Builder {
        private QueryEvaluationHint engineDefaultHints;
        private IQueryBackendFactory defaultBackendFactory;
        private IQueryBackendFactory defaultCachingBackendFactory;

        public Builder() {
        }

        public Builder(ViatraQueryEngineOptions from) {
            this.engineDefaultHints = from.engineDefaultHints;
            this.defaultBackendFactory = this.engineDefaultHints.getQueryBackendFactory();
            this.defaultCachingBackendFactory = from.defaultCachingBackendFactory;
        }

        public Builder withDefaultHint(QueryEvaluationHint engineDefaultHints) {
            this.engineDefaultHints = engineDefaultHints;
            return this;
        }

        public Builder withDefaultBackend(IQueryBackendFactory defaultBackendFactory) {
            this.defaultBackendFactory = defaultBackendFactory;
            return this;
        }

        public Builder withDefaultCachingBackend(IQueryBackendFactory defaultCachingBackendFactory) {
            this.defaultCachingBackendFactory = defaultCachingBackendFactory;
            return this;
        }

        public ViatraQueryEngineOptions build() {
            IQueryBackendFactory defaultFactory = this.getDefaultBackend();
            IQueryBackendFactory defaultCachingFactory = this.getDefaultCachingBackend();
            QueryEvaluationHint hint = this.getEngineDefaultHints(defaultFactory);
            return new ViatraQueryEngineOptions(hint, defaultCachingFactory, null);
        }

        private IQueryBackendFactory getDefaultBackend() {
            if (this.defaultBackendFactory != null) {
                return this.defaultBackendFactory;
            }
            if (this.engineDefaultHints != null) {
                return this.engineDefaultHints.getQueryBackendFactory();
            }
            return new ReteBackendFactory();
        }

        private IQueryBackendFactory getDefaultCachingBackend() {
            if (this.defaultCachingBackendFactory != null) {
                return this.defaultBackendFactory;
            }
            return new ReteBackendFactory();
        }

        private QueryEvaluationHint getEngineDefaultHints(IQueryBackendFactory defaultFactory) {
            if (this.engineDefaultHints != null) {
                return this.engineDefaultHints.overrideBy(new QueryEvaluationHint(null, defaultFactory));
            }
            return new QueryEvaluationHint(null, defaultFactory);
        }
    }
}

