/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.StateMachineMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.AbstractRule;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.util.PriorityRuleSpecification;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class StateMachineMapping
extends AbstractRule<StateMachineMatch> {
    public StateMachineMapping(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public PriorityRuleSpecification<StateMachineMatch> getSpecification() {
        PriorityRuleSpecification _createPriorityRuleSpecification = this.createPriorityRuleSpecification();
        Procedures.Procedure1 _function = it -> {
            Job<StateMachineMatch> _appearedJob = this.getAppearedJob();
            Job<StateMachineMatch> _updateJob = this.getUpdateJob();
            Job<StateMachineMatch> _disappearedJob = this.getDisappearedJob();
            it.setRuleSpecification(Rules.newMatcherRuleSpecification((IQuerySpecification)this.cpsXformM2M.getStateMachine(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _updateJob, _disappearedJob}))));
            it.setPriority(3);
        };
        return (PriorityRuleSpecification)ObjectExtensions.operator_doubleArrow(_createPriorityRuleSpecification, (Procedures.Procedure1)_function);
    }

    private Job<StateMachineMatch> getAppearedJob() {
        IMatchProcessor _function = match -> {
            DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance()), DeploymentApplication.class));
            String smId = match.getStateMachine().getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Mapping state machine with ID: ");
            _builder.append(smId);
            this.logger.debug((Object)_builder);
            DeploymentBehavior _createDeploymentBehavior = this.depFactory.createDeploymentBehavior();
            Procedures.Procedure1 _function_1 = it -> it.setDescription(smId);
            DeploymentBehavior behavior = (DeploymentBehavior)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentBehavior, (Procedures.Procedure1)_function_1);
            depApp.setBehavior(behavior);
            Set<CPS2DeploymentTrace> traces = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)match.getStateMachine(), null);
            boolean _isEmpty = traces.isEmpty();
            if (_isEmpty) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Creating new trace for state machine");
                this.logger.trace((Object)_builder_1);
                EList _traces = this.getRootMapping().getTraces();
                CPS2DeploymentTrace _createCPS2DeploymentTrace = this.traceFactory.createCPS2DeploymentTrace();
                Procedures.Procedure1 _function_2 = it -> {
                    EList _cpsElements = it.getCpsElements();
                    StateMachine _stateMachine = match.getStateMachine();
                    _cpsElements.add((Object)_stateMachine);
                    EList _deploymentElements = it.getDeploymentElements();
                    _deploymentElements.add((Object)behavior);
                };
                CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_2);
                _traces.add((Object)_doubleArrow);
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Adding new behavior to existing trace");
                this.logger.trace((Object)_builder_2);
                EList _deploymentElements = ((CPS2DeploymentTrace)IterableExtensions.head(traces)).getDeploymentElements();
                _deploymentElements.add((Object)behavior);
            }
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Mapped state machine with ID: ");
            _builder_3.append(smId);
            this.logger.debug((Object)_builder_3);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<StateMachineMatch> getUpdateJob() {
        IMatchProcessor _function = match -> {
            String smId = match.getStateMachine().getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Updating mapped state machine with ID: ");
            _builder.append(smId);
            this.logger.debug((Object)_builder);
            Iterable depSMs = Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getStateMachine()), DeploymentBehavior.class);
            Consumer<DeploymentBehavior> _function_1 = it -> {
                boolean _notEquals;
                String _description = it.getDescription();
                boolean bl = _notEquals = !Objects.equal((Object)_description, (Object)smId);
                if (_notEquals) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("ID changed to ");
                    _builder_1.append(smId);
                    this.logger.trace((Object)_builder_1);
                    it.setDescription(smId);
                }
            };
            depSMs.forEach(_function_1);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Updated mapped state machine with ID: ");
            _builder_1.append(smId);
            this.logger.debug((Object)_builder_1);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }

    private Job<StateMachineMatch> getDisappearedJob() {
        IMatchProcessor _function = match -> {
            DeploymentElement _head = (DeploymentElement)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance()));
            DeploymentApplication depApp = (DeploymentApplication)_head;
            DeploymentBehavior depBehavior = depApp.getBehavior();
            String smId = depBehavior.getDescription();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Removing state machine with ID: ");
            _builder.append(smId);
            this.logger.debug((Object)_builder);
            depApp.setBehavior(null);
            CPS2DeploymentTrace smTrace = (CPS2DeploymentTrace)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)match.getStateMachine(), null));
            EList _deploymentElements = smTrace.getDeploymentElements();
            _deploymentElements.remove((Object)depBehavior);
            boolean _isEmpty = smTrace.getDeploymentElements().isEmpty();
            if (_isEmpty) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Removing empty trace");
                this.logger.trace((Object)_builder_1);
                EList _traces = this.getRootMapping().getTraces();
                _traces.remove((Object)smTrace);
            }
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Removed state machine with ID: ");
            _builder_2.append(smId);
            this.logger.debug((Object)_builder_2);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }
}

