/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.application.ui.cpsgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.viatra.examples.cps.generator.dtos.AppClass;
import org.eclipse.viatra.examples.cps.generator.dtos.HostClass;
import org.eclipse.viatra.examples.cps.generator.dtos.MinMaxData;
import org.eclipse.viatra.examples.cps.generator.dtos.Percentage;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.ICPSConstraints;
import org.eclipse.viatra.examples.cps.generator.exceptions.ModelGeneratorException;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ConstraintDetailsPage
extends WizardPage {
    private Composite container;
    private Text hostTypesMin;
    private Text hostTypesMax;
    private Text hostInstancesMin;
    private Text hostInstancesMax;
    private Text commLinesMin;
    private Text commLinesMax;
    private Text appTypesMin;
    private Text appTypesMax;
    private Text appInstancesMin;
    private Text appInstancesMax;
    private Text statesMin;
    private Text statesMax;
    private Text transitionsMin;
    private Text transitionsMax;
    private Text allocatedInstances;
    private Text actionGeneration;
    private Text sendAction;
    private Text signalsMin;
    private Text signalsMax;

    public ConstraintDetailsPage() {
        super("wizardPage");
        this.setDescription("Set the parameters of model generation");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.setControl((Control)this.container);
        this.container.setLayout((Layout)new GridLayout(5, false));
        Label lblNewLabel_1 = new Label(this.container, 0);
        lblNewLabel_1.setText("Hosts");
        Label lblMin = new Label(this.container, 0);
        lblMin.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        lblMin.setText("min");
        new Label(this.container, 0);
        Label lblMax = new Label(this.container, 0);
        lblMax.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        lblMax.setText("max");
        Label lblNewLabel = new Label(this.container, 0);
        lblNewLabel.setText("# of Types");
        this.hostTypesMin = new Text(this.container, 2048);
        this.hostTypesMin.setText("1");
        this.hostTypesMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblTempppp = new Label(this.container, 0);
        lblTempppp.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTempppp.setText("..");
        this.hostTypesMax = new Text(this.container, 2048);
        this.hostTypesMax.setText("3");
        this.hostTypesMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblNewLabel_2 = new Label(this.container, 0);
        lblNewLabel_2.setText("# of Instances / Types");
        this.hostInstancesMin = new Text(this.container, 2048);
        this.hostInstancesMin.setText("2");
        this.hostInstancesMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label_1 = new Label(this.container, 0);
        label_1.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        label_1.setText("..");
        this.hostInstancesMax = new Text(this.container, 2048);
        this.hostInstancesMax.setText("5");
        this.hostInstancesMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblCommunicationLin = new Label(this.container, 0);
        lblCommunicationLin.setAlignment(131072);
        lblCommunicationLin.setText("# of communication lines\r\nfrom an Instance");
        this.commLinesMin = new Text(this.container, 2048);
        this.commLinesMin.setText("1");
        this.commLinesMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label = new Label(this.container, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        label.setText("..");
        this.commLinesMax = new Text(this.container, 2048);
        this.commLinesMax.setText("2");
        this.commLinesMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label_2 = new Label(this.container, 258);
        label_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 5, 1));
        Label lblNewLabel_4 = new Label(this.container, 0);
        lblNewLabel_4.setText("# of Signals");
        this.signalsMin = new Text(this.container, 2048);
        this.signalsMin.setText("1");
        this.signalsMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label_3 = new Label(this.container, 0);
        label_3.setText("..");
        label_3.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.signalsMax = new Text(this.container, 2048);
        this.signalsMax.setText("10");
        this.signalsMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label_8 = new Label(this.container, 258);
        label_8.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 5, 1));
        Label lblApplications = new Label(this.container, 0);
        lblApplications.setText("Applications");
        new Label(this.container, 0);
        new Label(this.container, 0);
        Label lblNewLabel_5 = new Label(this.container, 0);
        lblNewLabel_5.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(this.container, 0);
        Label lblNewLabel_3 = new Label(this.container, 0);
        lblNewLabel_3.setText("# of Types");
        this.appTypesMin = new Text(this.container, 2048);
        this.appTypesMin.setText("1");
        this.appTypesMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label_4 = new Label(this.container, 0);
        label_4.setText("..");
        label_4.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.appTypesMax = new Text(this.container, 2048);
        this.appTypesMax.setText("3");
        this.appTypesMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label_9 = new Label(this.container, 0);
        label_9.setText("# of Instances / Types");
        this.appInstancesMin = new Text(this.container, 2048);
        this.appInstancesMin.setText("1");
        this.appInstancesMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label_5 = new Label(this.container, 0);
        label_5.setText("..");
        label_5.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.appInstancesMax = new Text(this.container, 2048);
        this.appInstancesMax.setText("2");
        this.appInstancesMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblOfStates = new Label(this.container, 0);
        lblOfStates.setText("# of States");
        this.statesMin = new Text(this.container, 2048);
        this.statesMin.setText("2");
        this.statesMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label_6 = new Label(this.container, 0);
        label_6.setText("..");
        label_6.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.statesMax = new Text(this.container, 2048);
        this.statesMax.setText("4");
        this.statesMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblOfTransitions = new Label(this.container, 0);
        lblOfTransitions.setText("# of Transitions");
        this.transitionsMin = new Text(this.container, 2048);
        this.transitionsMin.setText("1");
        this.transitionsMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label_7 = new Label(this.container, 0);
        label_7.setText("..");
        label_7.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.transitionsMax = new Text(this.container, 2048);
        this.transitionsMax.setText("2");
        this.transitionsMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblOfAllocated = new Label(this.container, 0);
        lblOfAllocated.setText("Allocated Instances");
        this.allocatedInstances = new Text(this.container, 2048);
        this.allocatedInstances.setText("100");
        this.allocatedInstances.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label label_10 = new Label(this.container, 0);
        label_10.setAlignment(131072);
        label_10.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_10.setText("%");
        Label lblProbOfAction = new Label(this.container, 0);
        lblProbOfAction.setText("Prob. of Action Gen.");
        this.actionGeneration = new Text(this.container, 2048);
        this.actionGeneration.setText("95");
        this.actionGeneration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label label_11 = new Label(this.container, 0);
        label_11.setAlignment(131072);
        label_11.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_11.setToolTipText("");
        label_11.setText("%");
        Label lblProbOfSend = new Label(this.container, 0);
        lblProbOfSend.setText("Prob. of Send Action");
        this.sendAction = new Text(this.container, 2048);
        this.sendAction.setText("60");
        this.sendAction.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label label_12 = new Label(this.container, 0);
        label_12.setAlignment(131072);
        label_12.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_12.setText("%");
        Arrays.stream(this.container.getChildren()).filter(Text.class::isInstance).map(ctrl -> (Text)ctrl).forEach(text -> text.addModifyListener(e -> this.getWizard().getContainer().updateButtons()));
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.validate();
    }

    private boolean validate() {
        List<Text> percentTexts = Arrays.asList(this.allocatedInstances, this.actionGeneration, this.sendAction);
        if (this.container == null) {
            return false;
        }
        Optional<String> errorMsg = Arrays.stream(this.container.getChildren()).filter(Text.class::isInstance).map(ctrl -> {
            Text text = (Text)ctrl;
            if (percentTexts.contains(text)) {
                return ConstraintDetailsPage.containsPercent(text) ? null : "Enter percentage";
            }
            return ConstraintDetailsPage.containsNonNegativeNumber(text) ? null : "Enter a non-negative integer";
        }).filter(msg -> msg != null).findFirst();
        this.setErrorMessage(errorMsg.orElse(null));
        return !errorMsg.isPresent();
    }

    private static boolean containsNonNegativeNumber(Text text) {
        try {
            return Integer.parseInt(text.getText()) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean containsPercent(Text text) {
        try {
            int num = Integer.parseInt(text.getText());
            return num >= 0 && num <= 100;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public ICPSConstraints getConstraints() {
        return new ICPSConstraints(){
            private List<HostClass> hostClasses;
            private List<AppClass> appClasses;

            public MinMaxData<Integer> getNumberOfSignals() {
                return new MinMaxData((Object)Integer.valueOf(ConstraintDetailsPage.this.signalsMin.getText()), (Object)Integer.valueOf(ConstraintDetailsPage.this.signalsMax.getText()));
            }

            public String getName() {
                return "WizardConstraints";
            }

            private List<HostClass> getHostClassesWithInit() {
                if (this.hostClasses == null) {
                    HostClass hostClass = new HostClass("h", new MinMaxData((Object)Integer.valueOf(ConstraintDetailsPage.this.hostTypesMin.getText()), (Object)Integer.valueOf(ConstraintDetailsPage.this.hostTypesMax.getText())), new MinMaxData((Object)Integer.valueOf(ConstraintDetailsPage.this.hostInstancesMin.getText()), (Object)Integer.valueOf(ConstraintDetailsPage.this.hostInstancesMax.getText())), new MinMaxData((Object)Integer.valueOf(ConstraintDetailsPage.this.commLinesMin.getText()), (Object)Integer.valueOf(ConstraintDetailsPage.this.commLinesMax.getText())), new HashMap());
                    hostClass.communicationRatios.put(hostClass, 1);
                    this.hostClasses = new ArrayList<HostClass>();
                    this.hostClasses.add(hostClass);
                }
                return this.hostClasses;
            }

            public Iterable<HostClass> getHostClasses() {
                return this.getHostClassesWithInit();
            }

            public Iterable<AppClass> getApplicationClasses() {
                try {
                    if (this.appClasses == null) {
                        HashMap<HostClass, Integer> allocationsMap = new HashMap<HostClass, Integer>();
                        allocationsMap.put(this.getHostClassesWithInit().get(0), 1);
                        AppClass appClass = new AppClass("a", new MinMaxData((Object)Integer.valueOf(ConstraintDetailsPage.this.appTypesMin.getText()), (Object)Integer.valueOf(ConstraintDetailsPage.this.appTypesMax.getText())), new MinMaxData((Object)Integer.valueOf(ConstraintDetailsPage.this.appInstancesMin.getText()), (Object)Integer.valueOf(ConstraintDetailsPage.this.appInstancesMax.getText())), new MinMaxData((Object)Integer.valueOf(ConstraintDetailsPage.this.statesMin.getText()), (Object)Integer.valueOf(ConstraintDetailsPage.this.statesMax.getText())), new MinMaxData((Object)Integer.valueOf(ConstraintDetailsPage.this.transitionsMin.getText()), (Object)Integer.valueOf(ConstraintDetailsPage.this.transitionsMax.getText())), new Percentage((double)Integer.valueOf(ConstraintDetailsPage.this.allocatedInstances.getText()).intValue()), allocationsMap, new Percentage((double)Integer.valueOf(ConstraintDetailsPage.this.actionGeneration.getText()).intValue()), new Percentage((double)Integer.valueOf(ConstraintDetailsPage.this.sendAction.getText()).intValue()));
                        this.appClasses = new ArrayList<AppClass>();
                        this.appClasses.add(appClass);
                    }
                    return this.appClasses;
                }
                catch (ModelGeneratorException _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
    }
}

