/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.internal.ui;

import java.io.File;
import org.eclipse.gef4.zest.internal.ui.ZestUiActivator;
import org.eclipse.gef4.zest.internal.ui.ZestUiMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class DotDirStore {
    public static final String DOTPATH_KEY = "org.eclipse.gef4.zest.ui.dotpath";

    private DotDirStore() {
    }

    public static String getDotDirPath() {
        if (DotDirStore.dotPathFromPreferences().length() == 0) {
            DotDirStore.setDotDirPath();
        }
        return DotDirStore.dotPathFromPreferences();
    }

    public static void setDotDirPath() {
        IWorkbenchWindow parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
        dialog.setMessage(Caption.DOT_SELECT_LONG.s);
        dialog.setText(Caption.DOT_SELECT_SHORT.s);
        DotDirStore.processUserInput(parent, dialog);
    }

    private static void processUserInput(IWorkbenchWindow parent, DirectoryDialog dialog) {
        String selectedPath = dialog.open();
        if (selectedPath != null) {
            if (!DotDirStore.containsDot(new File(selectedPath))) {
                MessageDialog.openError((Shell)parent.getShell(), (String)Caption.NOT_FOUND_SHORT.s, (String)Caption.NOT_FOUND_LONG.s);
            } else {
                ZestUiActivator.getDefault().getPreferenceStore().setValue(DOTPATH_KEY, String.valueOf(selectedPath) + File.separator);
            }
        }
    }

    private static boolean containsDot(File folder) {
        String[] files = folder.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].equals("dot") || files[i].equals("dot.exe")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String dotPathFromPreferences() {
        return ZestUiActivator.getDefault().getPreferenceStore().getString(DOTPATH_KEY);
    }

    private static enum Caption {
        DOT_SELECT_SHORT(ZestUiMessages.DotDirStore_0),
        DOT_SELECT_LONG(ZestUiMessages.DotDirStore_1),
        NOT_FOUND_LONG(ZestUiMessages.DotDirStore_2),
        NOT_FOUND_SHORT(ZestUiMessages.DotDirStore_3);

        private String s;

        private Caption(String s) {
            this.s = s;
        }
    }
}

