/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common;

import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlPatternCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateProviderCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueConstant;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenAnalysisModule;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class TmfXmlTestUtils {
    public static final @NonNull DataDrivenValue NULL_VALUE = new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, null);

    private TmfXmlTestUtils() {
    }

    public static Element getXmlElement(String elementName, String xmlString) throws SAXException, IOException, ParserConfigurationException {
        List<Element> elements = TmfXmlTestUtils.getXmlElements(elementName, xmlString);
        if (elements.size() == 0) {
            throw new NullPointerException("No element named " + elementName + " in " + xmlString);
        }
        return elements.get(0);
    }

    public static List<@NonNull Element> getXmlElements(String elementName, String xmlString) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = XmlUtils.newSafeDocumentBuilderFactory().newDocumentBuilder();
        InputSource src = new InputSource();
        src.setCharacterStream(new StringReader(xmlString));
        Document doc = builder.parse(src);
        NodeList nodes = doc.getElementsByTagName(elementName);
        ArrayList<@NonNull Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            elements.add(Objects.requireNonNull((Element)nodes.item(i)));
            ++i;
        }
        return elements;
    }

    public static TmfAbstractAnalysisModule getModuleInFile(String xmlFilePath, @NonNull String analysisId) {
        Element element = TmfXmlUtils.getElementInFile((String)xmlFilePath, (String)"pattern", (String)analysisId);
        if (element != null) {
            TmfXmlPatternCu patternCu = TmfXmlPatternCu.compile((Element)element);
            if (patternCu == null) {
                return null;
            }
            XmlPatternAnalysis module = new XmlPatternAnalysis(analysisId, patternCu);
            module.setName(analysisId);
            return module;
        }
        element = TmfXmlUtils.getElementInFile((String)xmlFilePath, (String)"stateProvider", (String)analysisId);
        if (element != null) {
            TmfXmlStateProviderCu compile = TmfXmlStateProviderCu.compile((Path)Paths.get(xmlFilePath, new String[0]), (String)analysisId);
            Assert.assertNotNull((Object)compile);
            DataDrivenAnalysisModule module = new DataDrivenAnalysisModule(analysisId, compile);
            module.setName(analysisId);
            return module;
        }
        throw new NullPointerException("No module named " + analysisId + " in file " + xmlFilePath);
    }
}

