/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.AbstractSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;

public class StubSegmentStatisticsAnalysis
extends AbstractSegmentStatisticsAnalysis {
    public static final int SIZE = 65535;
    private final List<@NonNull ISegment> fPreFixture;
    private final ISegmentStore<@NonNull ISegment> fFixture = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[0]);
    private @NonNull StubProvider fSegmentStoreProvider;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public StubSegmentStatisticsAnalysis() {
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
        int i = 0;
        while (i < 65535) {
            BasicSegment seg = new BasicSegment((long)i, (long)(i + i));
            builder.add((Object)seg);
            ++i;
        }
        this.fPreFixture = builder.build();
        this.fFixture.addAll(this.fPreFixture);
        this.fSegmentStoreProvider = new StubProvider(this.fFixture);
    }

    public void dispose() {
        super.dispose();
        this.fSegmentStoreProvider.dispose();
    }

    public boolean setTrace(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        if (trace instanceof TmfXmlTraceStub) {
            TmfXmlTraceStub tmfXmlTraceStub = (TmfXmlTraceStub)trace;
            try {
                tmfXmlTraceStub.addAnalysisModule((IAnalysisModule)this);
                tmfXmlTraceStub.addAnalysisModule((IAnalysisModule)this.fSegmentStoreProvider);
            }
            catch (TmfTraceException e) {
                throw new TmfAnalysisException(e.getMessage());
            }
        }
        return super.setTrace(trace);
    }

    protected @Nullable String getSegmentType(@NonNull ISegment segment) {
        return segment.getLength() % 2L == 0L ? "even" : "odd";
    }

    protected @Nullable ISegmentStoreProvider getSegmentStoreProvider(@NonNull ITmfTrace trace) {
        return this.fSegmentStoreProvider;
    }

    public boolean executeAnalysis(@NonNull IProgressMonitor monitor) throws TmfAnalysisException {
        return super.executeAnalysis(monitor);
    }

    public @NonNull Iterable<@NonNull IAnalysisModule> getDependentAnalyses() {
        return super.getDependentAnalyses();
    }

    private final class StubProvider
    extends TestAnalysis
    implements ISegmentStoreProvider {
        private final ISegmentStore<@NonNull ISegment> ifFixture;

        public StubProvider(ISegmentStore<ISegment> fixture) {
            this.ifFixture = fixture;
        }

        public void removeListener(@NonNull IAnalysisProgressListener listener) {
        }

        public @Nullable ISegmentStore<@NonNull ISegment> getSegmentStore() {
            return this.ifFixture;
        }

        public @NonNull Iterable<@NonNull ISegmentAspect> getSegmentAspects() {
            return Collections.emptyList();
        }

        public void addListener(@NonNull IAnalysisProgressListener listener) {
        }
    }
}

