/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.stub;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class XmlStubTraceTest {
    private static final String VALID_FILE = "testfiles/stub_xml_traces/valid/test.xml";
    private static final String VALID_PATH = "testfiles/stub_xml_traces/valid";
    private static final String INVALID_PATH = "testfiles/stub_xml_traces/invalid";
    private static final String EVENT_A = "A";
    private static final String EVENT_B = "B";
    private static final String FIELD_A = "b";
    private static final String FIELD_B = "f";
    private ITmfTrace fTestTrace = null;

    /*
     * Unable to fully structure code
     */
    @After
    public void tearDown() {
        block5: {
            trace = this.fTestTrace;
            if (trace == null) {
                return;
            }
            this.fTestTrace = null;
            directory = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
            try {
                trace.dispose();
            }
            finally {
                dir = new File(directory);
                if (!dir.exists()) break block5;
                var9_9 = files = dir.listFiles();
                var8_11 = files.length;
                var7_13 = 0;
                ** while (var7_13 < var8_11)
            }
lbl-1000:
            // 1 sources

            {
                file = var9_9[var7_13];
                file.delete();
                ++var7_13;
                continue;
            }
lbl21:
            // 1 sources

            dir.delete();
        }
    }

    @Test
    public void testValidate() {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        File[] invalidFiles = TmfCoreTestPlugin.getAbsoluteFilePath(INVALID_PATH).toFile().listFiles();
        Assert.assertTrue((invalidFiles.length > 0 ? 1 : 0) != 0);
        File[] fileArray = invalidFiles;
        int n = invalidFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Assert.assertFalse((boolean)trace.validate(null, f.getAbsolutePath()).isOK());
            ++n2;
        }
        File[] validFiles = TmfCoreTestPlugin.getAbsoluteFilePath(VALID_PATH).toFile().listFiles();
        Assert.assertTrue((validFiles.length > 0 ? 1 : 0) != 0);
        File[] fileArray2 = validFiles;
        int n3 = validFiles.length;
        n = 0;
        while (n < n3) {
            File f = fileArray2[n];
            Assert.assertTrue((boolean)trace.validate(null, f.getAbsolutePath()).isOK());
            ++n;
        }
        trace.dispose();
    }

    @Test
    public void testDevelopmentTrace() {
        this.fTestTrace = TmfXmlTraceStubNs.setupTrace(TmfCoreTestPlugin.getAbsoluteFilePath(VALID_FILE));
        CustomEventRequest req = new CustomEventRequest(this.fTestTrace);
        this.fTestTrace.sendRequest((ITmfEventRequest)req);
        try {
            req.waitForCompletion();
            if (req.isCancelled()) {
                Assert.fail((String)req.getStatus().getMessage());
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)4L, (long)req.getCount());
    }

    @Test
    public void testAspects() {
        this.fTestTrace = TmfXmlTraceStubNs.setupTrace(TmfCoreTestPlugin.getAbsoluteFilePath(VALID_FILE));
        ITmfEventAspect cpuAspect = null;
        ITmfEventAspect testAspect = null;
        int aspectCount = 0;
        for (ITmfEventAspect aspect : this.fTestTrace.getEventAspects()) {
            ++aspectCount;
            if (aspect instanceof TmfCpuAspect) {
                cpuAspect = aspect;
                continue;
            }
            if (!aspect.getName().equals("test")) continue;
            testAspect = aspect;
        }
        Assert.assertEquals((String)"Number of aspects", (long)5L, (long)aspectCount);
        Assert.assertNotNull(cpuAspect);
        Assert.assertNotNull(testAspect);
        ITmfContext ctx = this.fTestTrace.seekEvent(0L);
        Assert.assertNotNull((Object)ctx);
        ITmfEvent event = this.fTestTrace.getNext(ctx);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((String)"Cpu aspect of event 1", (Object)1, (Object)cpuAspect.resolve(event));
        Assert.assertEquals((String)"Test aspect of event 1", (Object)"abc", (Object)testAspect.resolve(event));
        event = this.fTestTrace.getNext(ctx);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((String)"Cpu aspect of event 2", (Object)1, (Object)cpuAspect.resolve(event));
        Assert.assertEquals((String)"Test aspect of event 2", (Object)"abc", (Object)testAspect.resolve(event));
        event = this.fTestTrace.getNext(ctx);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((String)"Cpu aspect of event 3", (Object)2, (Object)cpuAspect.resolve(event));
        Assert.assertEquals((String)"Test aspect of event 3", (Object)"def", (Object)testAspect.resolve(event));
        event = this.fTestTrace.getNext(ctx);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((String)"Cpu aspect of event 4", (Object)1, (Object)cpuAspect.resolve(event));
        Assert.assertEquals((String)"Test aspect of event 4", (Object)"def", (Object)testAspect.resolve(event));
        ctx.dispose();
    }

    private static IStatus testEvent(ITmfEvent event) {
        switch (event.getName()) {
            case "A": {
                ITmfEventField content = event.getContent();
                if (content.getField(new String[]{FIELD_A}) != null) break;
                return new Status(4, "org.eclipse.tracecompass.tmf.tests", String.format("Field %s does not exist in event %s", FIELD_A, EVENT_A));
            }
            case "B": {
                ITmfEventField content = event.getContent();
                if (content.getField(new String[]{FIELD_B}) != null) break;
                return new Status(4, "org.eclipse.tracecompass.tmf.tests", String.format("Field %s does not exist in event %s", FIELD_B, EVENT_B));
            }
            default: {
                return new Status(4, "org.eclipse.tracecompass.tmf.tests", "Unexpected event " + event.getType().getName());
            }
        }
        return Status.OK_STATUS;
    }

    private class CustomEventRequest
    extends TmfEventRequest {
        private final ITmfTrace fTrace;
        private IStatus fResult;
        private int fCount;

        public CustomEventRequest(ITmfTrace trace) {
            super(trace.getEventType(), TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.fResult = Status.OK_STATUS;
            this.fCount = 0;
            this.fTrace = trace;
        }

        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.fTrace) {
                ++this.fCount;
                IStatus result = XmlStubTraceTest.testEvent(event);
                if (!result.isOK()) {
                    this.fResult = result;
                    this.cancel();
                }
            }
        }

        public IStatus getStatus() {
            return this.fResult;
        }

        public int getCount() {
            return this.fCount;
        }
    }
}

