/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;
import org.osgi.util.tracker.ServiceTracker;

public class AppCommands
implements CommandProvider {
    private static final String LAUNCHABLE_APP_FILTER = "(&(application.locked=false)(application.launchable=true)(application.visible=true))";
    private static final String ACTIVE_APP_FILTER = "(!(application.state=STOPPING))";
    private static final String LOCKED_APP_FILTER = "(application.locked=true)";
    private static final String NEW_LINE = "\r\n";
    private static final String TAB = "\t";
    private Map<String, String[]> commandsHelp = null;
    private static AppCommands instance;
    private BundleContext context;
    private ServiceTracker applicationDescriptors;
    private ServiceTracker applicationHandles;
    private ServiceTracker scheduledApplications;
    private Filter launchableApp;
    private Filter activeApp;
    private Filter lockedApp;
    private ServiceRegistration providerRegistration;

    static synchronized void create(BundleContext context) {
        if (instance != null) {
            return;
        }
        instance = new AppCommands();
        instance.start(context);
    }

    static synchronized void destroy(BundleContext context) {
        if (instance == null) {
            return;
        }
        instance.stop(context);
        instance = null;
    }

    protected AppCommands() {
    }

    public void start(BundleContext ctx) {
        this.context = ctx;
        try {
            this.applicationDescriptors = new ServiceTracker(ctx, ApplicationDescriptor.class.getName(), null);
            this.applicationDescriptors.open();
            this.applicationHandles = new ServiceTracker(ctx, ApplicationHandle.class.getName(), null);
            this.applicationHandles.open();
            this.scheduledApplications = new ServiceTracker(ctx, ScheduledApplication.class.getName(), null);
            this.scheduledApplications.open();
            this.launchableApp = ctx.createFilter(LAUNCHABLE_APP_FILTER);
            this.activeApp = ctx.createFilter(ACTIVE_APP_FILTER);
            this.lockedApp = ctx.createFilter(LOCKED_APP_FILTER);
            this.providerRegistration = ctx.registerService(CommandProvider.class.getName(), (Object)this, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void stop(BundleContext ctx) {
        this.providerRegistration.unregister();
        if (this.applicationDescriptors != null) {
            this.applicationDescriptors.close();
        }
        if (this.applicationHandles != null) {
            this.applicationHandles.close();
        }
        if (this.scheduledApplications != null) {
            this.scheduledApplications.close();
        }
    }

    public String getHelp() {
        return this.getHelp(null);
    }

    private String getHelp(String commandName) {
        StringBuffer sb = new StringBuffer();
        if (this.commandsHelp == null) {
            this.initializeCommandsHelp();
        }
        if (commandName != null) {
            if (this.commandsHelp.containsKey(commandName)) {
                this.addCommand(commandName, this.commandsHelp.get(commandName), sb);
            }
            return sb.toString();
        }
        this.addHeader(Messages.console_help_app_commands_header, sb);
        for (Map.Entry<String, String[]> entry : this.commandsHelp.entrySet()) {
            String command = entry.getKey();
            String[] attributes = entry.getValue();
            this.addCommand(command, attributes, sb);
        }
        return sb.toString();
    }

    private void initializeCommandsHelp() {
        this.commandsHelp = new LinkedHashMap<String, String[]>();
        this.commandsHelp.put("activeApps", new String[]{Messages.console_help_activeapps_description});
        this.commandsHelp.put("apps", new String[]{Messages.console_help_apps_description});
        this.commandsHelp.put("lockApp", new String[]{Messages.console_help_arguments, Messages.console_help_lockapp_description});
        this.commandsHelp.put("schedApp", new String[]{Messages.console_help_schedapp_arguments, Messages.console_help_schedapp_description});
        this.commandsHelp.put("startApp", new String[]{Messages.console_help_arguments, Messages.console_help_startapp_description});
        this.commandsHelp.put("stopApp", new String[]{Messages.console_help_arguments, Messages.console_help_stopapp_description});
        this.commandsHelp.put("unlockApp", new String[]{Messages.console_help_arguments, Messages.console_help_unlockapp_description});
        this.commandsHelp.put("unschedApp", new String[]{Messages.console_help_arguments, Messages.console_help_unschedapp_description});
    }

    private void addHeader(String header, StringBuffer help) {
        help.append("---");
        help.append(header);
        help.append("---");
        help.append(NEW_LINE);
    }

    private void addCommand(String command, String description, StringBuffer help) {
        help.append(TAB);
        help.append(command);
        help.append(" - ");
        help.append(description);
        help.append(NEW_LINE);
    }

    private void addCommand(String command, String parameters, String description, StringBuffer help) {
        help.append(TAB);
        help.append(command);
        help.append(" ");
        help.append(parameters);
        help.append(" - ");
        help.append(description);
        help.append(NEW_LINE);
    }

    private void addCommand(String command, String[] attributes, StringBuffer help) {
        if (attributes.length == 1) {
            this.addCommand(command, attributes[0], help);
        } else if (attributes.length == 2) {
            this.addCommand(command, attributes[0], attributes[1], help);
        }
    }

    private Dictionary<String, Object> getServiceProps(ServiceReference ref) {
        String[] keys = ref.getPropertyKeys();
        Hashtable<String, Object> props = new Hashtable<String, Object>(keys.length);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            props.put(key, ref.getProperty(key));
            ++n2;
        }
        return props;
    }

    public void _apps(CommandInterpreter intp) {
        ServiceReference[] apps = this.applicationDescriptors.getServiceReferences();
        if (apps == null) {
            intp.println((Object)"No applications found.");
            return;
        }
        ServiceReference[] serviceReferenceArray = apps;
        int n = apps.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference app = serviceReferenceArray[n2];
            String application = (String)app.getProperty("service.pid");
            intp.print((Object)application);
            if (this.getApplication(this.applicationHandles.getServiceReferences(), application, "application.descriptor", true) != null) {
                intp.print((Object)" [running]");
            }
            if (this.getApplication(this.scheduledApplications.getServiceReferences(), application, "service.pid", true) != null) {
                intp.print((Object)" [scheduled]");
            }
            if (!this.launchableApp.match(this.getServiceProps(app))) {
                intp.print((Object)" [not launchable]");
            } else {
                intp.print((Object)" [launchable]");
            }
            if (this.lockedApp.match(this.getServiceProps(app))) {
                intp.print((Object)" [locked]");
            }
            intp.println();
            ++n2;
        }
    }

    public void _activeApps(CommandInterpreter intp) {
        ServiceReference[] active = this.applicationHandles.getServiceReferences();
        if (active == null) {
            intp.println((Object)"No active applications found");
            return;
        }
        ServiceReference[] serviceReferenceArray = active;
        int n = active.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference r = serviceReferenceArray[n2];
            intp.print(r.getProperty("service.pid"));
            intp.print((Object)" [");
            intp.print((Object)(this.activeApp.match(this.getServiceProps(r)) ? "running" : "stopping"));
            intp.println((Object)"]");
            ++n2;
        }
    }

    private ServiceReference getApplication(ServiceReference[] apps, String targetId, String idKey, boolean perfectMatch) {
        if (apps == null || targetId == null) {
            return null;
        }
        ServiceReference result = null;
        boolean ambigous = false;
        ServiceReference[] serviceReferenceArray = apps;
        int n = apps.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference app = serviceReferenceArray[n2];
            String id = (String)app.getProperty(idKey);
            if (targetId.equals(id)) {
                return app;
            }
            if (!perfectMatch && id.contains(targetId)) {
                if (result != null) {
                    ambigous = true;
                }
                result = app;
            }
            ++n2;
        }
        return ambigous ? null : result;
    }

    public void _startApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.applicationDescriptors.getServiceReferences(), appId, "service.pid", false);
        if (application != null) {
            ArrayList<String> argList = new ArrayList<String>();
            String arg = null;
            while ((arg = intp.nextArgument()) != null) {
                argList.add(arg);
            }
            String[] args = argList.size() == 0 ? null : argList.toArray(new String[argList.size()]);
            try {
                HashMap<String, String[]> launchArgs = new HashMap<String, String[]>(1);
                if (args != null) {
                    launchArgs.put("application.args", args);
                }
                ApplicationDescriptor appDesc = (ApplicationDescriptor)this.context.getService(application);
                ApplicationHandle handle = appDesc.launch(launchArgs);
                intp.println((Object)("Launched application instance: " + handle.getInstanceId()));
            }
            finally {
                this.context.ungetService(application);
            }
            return;
        }
        intp.println((Object)("\"" + appId + "\" does not exist or is ambigous."));
    }

    public void _stopApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.applicationHandles.getServiceReferences(), appId, "service.pid", false);
        if (application == null) {
            application = this.getApplication(this.applicationHandles.getServiceReferences(), appId, "application.descriptor", false);
        }
        if (application != null) {
            if (this.activeApp.match(this.getServiceProps(application))) {
                try {
                    ApplicationHandle appHandle = (ApplicationHandle)this.context.getService(application);
                    appHandle.destroy();
                    intp.println((Object)("Stopped application instance: " + appHandle.getInstanceId()));
                }
                finally {
                    this.context.ungetService(application);
                }
            } else {
                intp.println((Object)("Application instance is already stopping: " + String.valueOf(application.getProperty("service.pid"))));
            }
            return;
        }
        intp.println((Object)("\"" + appId + "\" does not exist, is not running or is ambigous."));
    }

    public void _lockApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.applicationDescriptors.getServiceReferences(), appId, "service.pid", false);
        if (application != null) {
            try {
                ApplicationDescriptor appDesc = (ApplicationDescriptor)this.context.getService(application);
                appDesc.lock();
                intp.println((Object)("Locked application: " + appDesc.getApplicationId()));
            }
            finally {
                this.context.ungetService(application);
            }
            return;
        }
        intp.println((Object)("\"" + appId + "\" does not exist or is ambigous."));
    }

    public void _unlockApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.applicationDescriptors.getServiceReferences(), appId, "service.pid", false);
        if (application != null) {
            try {
                ApplicationDescriptor appDesc = (ApplicationDescriptor)this.context.getService(application);
                appDesc.unlock();
                intp.println((Object)("Unlocked application: " + appDesc.getApplicationId()));
            }
            finally {
                this.context.ungetService(application);
            }
            return;
        }
        intp.println((Object)("\"" + appId + "\" does not exist or is ambigous."));
    }

    public void _schedApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.applicationDescriptors.getServiceReferences(), appId, "service.pid", false);
        if (application != null) {
            try {
                ApplicationDescriptor appDesc = (ApplicationDescriptor)this.context.getService(application);
                String filter = intp.nextArgument();
                boolean recure = Boolean.valueOf(intp.nextArgument());
                appDesc.schedule(null, null, "org/osgi/application/timer", filter, recure);
                intp.println((Object)("Scheduled application: " + appDesc.getApplicationId()));
            }
            finally {
                this.context.ungetService(application);
            }
            return;
        }
        intp.println((Object)("\"" + appId + "\" does not exist or is ambigous."));
    }

    public void _unschedApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.scheduledApplications.getServiceReferences(), appId, "service.pid", false);
        if (application == null) {
            intp.println((Object)("\"" + appId + "\" does not exist or is ambigous."));
        } else {
            try {
                ScheduledApplication schedApp = (ScheduledApplication)this.context.getService(application);
                schedApp.remove();
                intp.println((Object)("Unscheduled application: " + String.valueOf(application.getProperty("service.pid"))));
            }
            finally {
                this.context.ungetService(application);
            }
        }
    }

    public Object _help(CommandInterpreter intp) {
        String commandName = intp.nextArgument();
        if (commandName == null) {
            return Boolean.FALSE;
        }
        String help = this.getHelp(commandName);
        if (help.length() > 0) {
            return help;
        }
        return Boolean.FALSE;
    }
}

