/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.util.ByteBufferTracker;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.component.ITmfEventProvider;
import org.eclipse.tracecompass.tmf.core.component.TmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfLostEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfEventParser;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceCompleteness;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceAdapterManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpointIndexer;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public abstract class TmfTrace
extends TmfEventProvider
implements ITmfTrace,
ITmfEventParser,
ITmfTraceCompleteness,
IAdaptable {
    public static final @NonNull Collection<@NonNull ITmfEventAspect<?>> BASE_ASPECTS = ImmutableList.of(TmfBaseAspects.getTimestampAspect(), TmfBaseAspects.getEventTypeAspect(), (Object)TmfBaseAspects.getContentsAspect());
    private IResource fResource;
    private @Nullable String fTraceTypeId;
    private String fPath;
    private int fCacheSize = 1000;
    private volatile long fNbEvents = 0L;
    private @NonNull ITmfTimestamp fStartTime = TmfTimestamp.BIG_BANG;
    private @NonNull ITmfTimestamp fEndTime = TmfTimestamp.BIG_BANG;
    private long fStreamingInterval = 0L;
    private ITmfTraceIndexer fIndexer;
    private ITmfTimestampTransform fTsTransform;
    private final Map<String, IAnalysisModule> fAnalysisModules = Collections.synchronizedMap(new LinkedHashMap());

    public TmfTrace() {
        this.fIndexer = new TmfCheckpointIndexer(this);
    }

    protected TmfTrace(IResource resource, Class<? extends ITmfEvent> type, String path, int cacheSize, long interval) throws TmfTraceException {
        this.fCacheSize = cacheSize > 0 ? cacheSize : 1000;
        this.fStreamingInterval = interval;
        this.initialize(resource, path, type);
    }

    public TmfTrace(TmfTrace trace) throws TmfTraceException {
        if (trace == null) {
            throw new IllegalArgumentException();
        }
        this.fCacheSize = trace.getCacheSize();
        this.fStreamingInterval = trace.getStreamingInterval();
        this.initialize(trace.getResource(), trace.getPath(), trace.getEventType());
    }

    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfCheckpointIndexer(this, interval);
    }

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type, String name, String traceTypeId) throws TmfTraceException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.setName(name);
        this.fTraceTypeId = traceTypeId;
        this.initTrace(resource, path, type);
    }

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        this.initialize(resource, path, type);
    }

    protected void initialize(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        if (path == null) {
            this.dispose();
            throw new TmfTraceException("Invalid trace path");
        }
        this.fPath = path;
        this.fResource = resource;
        String traceName = this.getName();
        if (traceName.isEmpty()) {
            traceName = resource != null ? resource.getName() : new Path(path).lastSegment();
        }
        super.init(traceName, type);
        TmfSignalManager.registerVIP(this);
        if (this.fIndexer != null) {
            this.fIndexer.dispose();
        }
        this.fIndexer = this.createIndexer(this.fCacheSize);
    }

    protected boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    @Override
    public void indexTrace(boolean waitForCompletion) {
        this.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, waitForCompletion);
    }

    protected IStatus executeAnalysis() {
        MultiStatus status = new MultiStatus("org.eclipse.tracecompass.tmf.core", 0, null, null);
        Map<String, IAnalysisModuleHelper> modules = TmfAnalysisManager.getAnalysisModules(this.getClass());
        for (IAnalysisModuleHelper helper : modules.values()) {
            try {
                IAnalysisModule module = helper.newModule(this);
                if (module == null) continue;
                this.fAnalysisModules.put(module.getId(), module);
            }
            catch (TmfAnalysisException e) {
                status.add((IStatus)new Status(2, "org.eclipse.tracecompass.tmf.core", e.getMessage()));
            }
        }
        for (IAnalysisModule module : this.getAnalysisModules()) {
            if (!module.isAutomatic()) continue;
            status.add(module.schedule());
        }
        return status;
    }

    @Override
    public IAnalysisModule getAnalysisModule(String analysisId) {
        return this.fAnalysisModules.get(analysisId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<IAnalysisModule> getAnalysisModules() {
        Map<String, IAnalysisModule> map = this.fAnalysisModules;
        synchronized (map) {
            return new HashSet<IAnalysisModule>(this.fAnalysisModules.values());
        }
    }

    @Override
    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return BASE_ASPECTS;
    }

    @Override
    public synchronized void dispose() {
        if (this.getIndexer() != null) {
            this.getIndexer().dispose();
        }
        Iterable<IAnalysisModule> analysisModules = this.getAnalysisModules();
        for (IAnalysisModule module : analysisModules) {
            module.dispose();
        }
        this.fAnalysisModules.clear();
        super.dispose();
        ByteBufferTracker.setMarked();
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public @Nullable String getTraceTypeId() {
        return this.fTraceTypeId;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    @Override
    public int getCacheSize() {
        return this.fCacheSize;
    }

    @Override
    public long getStreamingInterval() {
        return this.fStreamingInterval;
    }

    protected ITmfTraceIndexer getIndexer() {
        return this.fIndexer;
    }

    @Override
    public long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public @NonNull TmfTimeRange getTimeRange() {
        return new TmfTimeRange(this.fStartTime, this.fEndTime);
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    @Override
    public ITmfTimestamp getInitialRangeOffset() {
        long DEFAULT_INITIAL_OFFSET_VALUE = 100000000L;
        return TmfTimestamp.fromNanos(100000000L);
    }

    @Override
    public String getHostId() {
        return this.getName();
    }

    @Override
    public boolean isIndexing() {
        return this.fIndexer.isIndexing();
    }

    protected void setCacheSize(int cacheSize) {
        this.fCacheSize = cacheSize;
    }

    protected synchronized void setNbEvents(long nbEvents) {
        this.fNbEvents = nbEvents > 0L ? nbEvents : 0L;
    }

    protected void setTimeRange(@NonNull TmfTimeRange range) {
        this.fStartTime = range.getStartTime();
        this.fEndTime = range.getEndTime();
    }

    protected void setStartTime(@NonNull ITmfTimestamp startTime) {
        this.fStartTime = startTime;
    }

    protected void setEndTime(@NonNull ITmfTimestamp endTime) {
        this.fEndTime = endTime;
    }

    protected void setStreamingInterval(long interval) {
        this.fStreamingInterval = interval > 0L ? interval : 0L;
    }

    @Override
    public synchronized ITmfContext seekEvent(long rank) {
        if (rank <= 0L) {
            ITmfContext context = this.seekEvent((ITmfLocation)null);
            context.setRank(0L);
            return context;
        }
        ITmfContext context = this.fIndexer.seekIndex(rank);
        long pos = context.getRank();
        if (pos < rank) {
            ITmfEvent event = this.getNext(context);
            while (event != null && ++pos < rank) {
                event = this.getNext(context);
            }
        }
        return context;
    }

    @Override
    public synchronized ITmfContext seekEvent(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            ITmfContext context = this.seekEvent((ITmfLocation)null);
            context.setRank(0L);
            return context;
        }
        ITmfContext context = this.fIndexer.seekIndex(timestamp);
        ITmfLocation previousLocation = context.getLocation();
        long previousRank = context.getRank();
        ITmfEvent event = this.getNext(context);
        while (event != null && event.getTimestamp().compareTo(timestamp) < 0) {
            previousLocation = context.getLocation();
            previousRank = context.getRank();
            event = this.getNext(context);
        }
        if (event == null) {
            context.setLocation(null);
            context.setRank(-1L);
        } else {
            context.dispose();
            context = this.seekEvent(previousLocation);
            context.setRank(previousRank);
        }
        return context;
    }

    @Override
    public abstract ITmfEvent parseEvent(ITmfContext var1);

    @Override
    public synchronized ITmfEvent getNext(ITmfContext context) {
        ITmfEvent event = this.parseEvent(context);
        if (event != null) {
            this.updateAttributes(context, event);
            context.setLocation(this.getCurrentLocation());
            context.increaseRank();
        }
        return event;
    }

    protected synchronized void updateAttributes(ITmfContext context, @NonNull ITmfEvent event) {
        ITmfTimestamp timestamp;
        ITmfTimestamp endTime = timestamp = event.getTimestamp();
        if (event instanceof ITmfLostEvent) {
            endTime = ((ITmfLostEvent)event).getTimeRange().getEndTime();
        }
        if (this.fStartTime.equals(TmfTimestamp.BIG_BANG) || this.fStartTime.compareTo(timestamp) > 0) {
            this.fStartTime = timestamp;
        }
        if (this.fEndTime.equals(TmfTimestamp.BIG_CRUNCH) || this.fEndTime.compareTo(endTime) < 0) {
            this.fEndTime = endTime;
        }
        if (context.hasValidRank()) {
            long rank = context.getRank();
            if (this.fNbEvents <= rank) {
                this.fNbEvents = rank + 1L;
            }
            if (this.fIndexer != null) {
                this.fIndexer.updateIndex(context, timestamp);
            }
        }
    }

    @Override
    public synchronized ITmfContext armRequest(ITmfEventRequest request) {
        if (this.executorIsShutdown()) {
            return null;
        }
        if (!TmfTimestamp.BIG_BANG.equals(request.getRange().getStartTime()) && request.getIndex() == 0L) {
            ITmfContext context = this.seekEvent(request.getRange().getStartTime());
            request.setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        boolean signalIsForUs = false;
        ITmfEventProvider provider = this;
        while (provider != null) {
            if (provider == signal.getTrace()) {
                signalIsForUs = true;
                break;
            }
            provider = provider.getParent();
        }
        if (!signalIsForUs) {
            return;
        }
        IStatus status = this.executeAnalysis();
        if (!status.isOK()) {
            Activator.log(status);
        }
        new Thread("Refresh supplementary files"){

            @Override
            public void run() {
                TmfTraceManager.refreshSupplementaryFiles(TmfTrace.this);
            }
        }.start();
        if (signal.getTrace() == this) {
            if (this.getNbEvents() == 0L) {
                return;
            }
            if (this.getStreamingInterval() > 0L) {
                return;
            }
            if (this.isComplete()) {
                TmfTimeRange timeRange = new TmfTimeRange(this.getStartTime(), TmfTimestamp.BIG_CRUNCH);
                TmfTraceRangeUpdatedSignal rangeUpdatedsignal = new TmfTraceRangeUpdatedSignal(this, this, timeRange);
                this.broadcastAsync(rangeUpdatedsignal);
            }
            return;
        }
    }

    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        if (signal.getTrace() == this) {
            this.getIndexer().buildIndex(this.getNbEvents(), signal.getRange(), false);
        }
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getSource() == this.getIndexer()) {
            this.fNbEvents = signal.getNbEvents();
            this.fStartTime = signal.getRange().getStartTime();
            this.fEndTime = signal.getRange().getEndTime();
        }
    }

    @Override
    public ITmfTimestampTransform getTimestampTransform() {
        if (this.fTsTransform == null) {
            this.fTsTransform = TimestampTransformFactory.getTimestampTransform(this.getResource());
        }
        return this.fTsTransform;
    }

    @Override
    public void setTimestampTransform(ITmfTimestampTransform tt) {
        this.fTsTransform = tt;
        TimestampTransformFactory.setTimestampTransform(this.getResource(), tt);
    }

    @Override
    public @NonNull ITmfTimestamp createTimestamp(long ts) {
        return TmfTimestamp.fromNanos(this.getTimestampTransform().transform(ts));
    }

    public <T> T getAdapter(Class<T> adapter) {
        List<T> adapters = TmfTraceAdapterManager.getAdapters(this, adapter);
        if (!adapters.isEmpty()) {
            return adapters.get(0);
        }
        if (adapter.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    public synchronized String toString() {
        return "TmfTrace [fPath=" + this.fPath + ", fCacheSize=" + this.fCacheSize + ", fNbEvents=" + this.fNbEvents + ", fStartTime=" + String.valueOf(this.fStartTime) + ", fEndTime=" + String.valueOf(this.fEndTime) + ", fStreamingInterval=" + this.fStreamingInterval + "]";
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public void setComplete(boolean isComplete) {
    }
}

