/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.CalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.CalledStringFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.Messages;

public final class CalledFunctionFactory {
    private CalledFunctionFactory() {
    }

    public static AbstractCalledFunction create(long start, long end, @Nullable Object symbolValue, int processId, int threadId, @Nullable ICalledFunction parent, IHostModel model) {
        if (symbolValue == null) {
            throw new IllegalArgumentException("Symbol value is null");
        }
        if (symbolValue instanceof Number) {
            return CalledFunctionFactory.create(start, end, ((Number)symbolValue).longValue(), processId, threadId, parent, model);
        }
        return CalledFunctionFactory.create(start, end, String.valueOf(symbolValue), processId, threadId, parent, model);
    }

    private static CalledFunction create(long start, long end, long value, int processId, int threadId, @Nullable ICalledFunction parent, IHostModel model) {
        if (start > end) {
            throw new IllegalArgumentException(String.valueOf(Messages.TimeError) + '[' + start + ',' + end + ']');
        }
        return new CalledFunction(start, end, value, processId, threadId, parent, model);
    }

    public static CalledStringFunction create(long start, long end, String value, int processId, int threadId, @Nullable ICalledFunction parent, IHostModel model) {
        if (start > end) {
            throw new IllegalArgumentException(String.valueOf(Messages.TimeError) + '[' + start + ',' + end + ']');
        }
        return new CalledStringFunction(start, end, value, processId, threadId, parent, model);
    }
}

