/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.Activator;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.TraceQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.QueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ExperimentManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.QueryParametersUtil;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.Trace;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.io.ResourceUtil;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

@javax.ws.rs.Path(value="/traces")
@Tag(name="Traces")
public class TraceManagerService {
    private static final Map<UUID, IResource> TRACES = Collections.synchronizedMap(TraceManagerService.initTraces());
    private static final String TRACES_FOLDER = "Traces";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the list of physical traces imported on the server", responses={@ApiResponse(responseCode="200", description="Returns a list of traces", content={@Content(array=@ArraySchema(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Trace.class)))})})
    public Response getTraces() {
        Map<UUID, IResource> map = TRACES;
        synchronized (map) {
            ArrayList<Trace> traces = new ArrayList<Trace>();
            for (UUID uuid : TRACES.keySet()) {
                Trace trace = TraceManagerService.createTraceModel(uuid);
                if (trace == null) continue;
                traces.add(trace);
            }
            return Response.ok(traces).build();
        }
    }

    private static Map<UUID, IResource> initTraces() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        HashMap<UUID, IResource> traces = new HashMap<UUID, IResource>();
        try {
            project.refreshLocal(2, null);
            IFolder tracesFolder = project.getFolder(TRACES_FOLDER);
            tracesFolder.accept(resource -> {
                if (ResourceUtil.isSymbolicLink((IResource)resource)) {
                    traces.put(TraceManagerService.getTraceUUID(resource), resource);
                    return false;
                }
                return true;
            });
        }
        catch (CoreException coreException) {}
        return traces;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Import a trace", description="Import a trace to the trace server. Return some base information once imported.", responses={@ApiResponse(responseCode="200", description="The trace has been successfully added to the trace server", content={@Content(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Trace.class))}), @ApiResponse(responseCode="400", description="Missing query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="No such trace", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="406", description="Cannot read this trace type", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="409", description="There was already a trace with this name", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Trace resource creation failed", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="501", description="Trace type not supported", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response putTrace(@RequestBody(content={@Content(schema=@Schema(implementation=TraceQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        if (queryParameters == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing query parameters").build();
        }
        Map<String, Object> parameters = queryParameters.getParameters();
        String errorMessage = QueryParametersUtil.validateTraceQueryParameters(parameters);
        if (errorMessage != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        String name = (String)parameters.get("name");
        String path = (String)parameters.get("uri");
        Object typeIDObject = parameters.get("typeID");
        String typeID = typeIDObject != null ? (String)typeIDObject : "";
        try {
            return TraceManagerService.put(path, name, typeID);
        }
        catch (IllegalArgumentException | SecurityException | CoreException | TmfTraceImportException e) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)e.getMessage()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response put(String path, String name, String typeID) throws TmfTraceImportException, CoreException, IllegalArgumentException, SecurityException {
        if (!Paths.get(path, new String[0]).toFile().exists()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No trace at " + path)).build();
        }
        List traceTypes = TmfTraceType.selectTraceType((String)path, (String)typeID);
        if (traceTypes.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"Trace type not supported").build();
        }
        String traceType = ((TraceTypeHelper)traceTypes.get(0)).getTraceTypeId();
        String traceName = name == null ? Paths.get(path, new String[0]).getFileName().toString() : name;
        IResource resource = TraceManagerService.getResource(path, traceName);
        if (!resource.exists()) {
            if (!TraceManagerService.createResource(path, resource)) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Trace resource creation failed").build();
            }
            resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, traceType);
        } else {
            IPath targetLocation = TraceManagerService.getTargetLocation(path);
            IPath oldLocation = ResourceUtil.getLocation((IResource)resource);
            if (oldLocation == null || !targetLocation.equals((Object)oldLocation.removeTrailingSeparator()) || !traceType.equals(resource.getPersistentProperty(TmfCommonConstants.TRACETYPE))) {
                Map<UUID, IResource> map = TRACES;
                synchronized (map) {
                    Optional<@NonNull Map.Entry> oldEntry = TRACES.entrySet().stream().filter(entry -> resource.equals(entry.getValue())).findFirst();
                    if (!oldEntry.isPresent()) {
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Failed to find conflicting trace").build();
                    }
                    UUID oldUUID = (UUID)oldEntry.get().getKey();
                    return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)TraceManagerService.createTraceModel(oldUUID)).build();
                }
            }
        }
        UUID uuid = TraceManagerService.getTraceUUID(resource);
        TRACES.put(uuid, resource);
        Trace traceModel = TraceManagerService.createTraceModel(uuid);
        return Response.ok((Object)traceModel).build();
    }

    public static UUID getTraceUUID(IResource resource) {
        IPath location = ResourceUtil.getLocation((IResource)resource);
        IPath path = location != null ? location.append(resource.getName()) : resource.getProjectRelativePath();
        UUID uuid = UUID.nameUUIDFromBytes(Objects.requireNonNull(path.toString().getBytes(Charset.defaultCharset())));
        return uuid;
    }

    public static @Nullable IResource getTraceResource(UUID uuid) {
        return TRACES.get(uuid);
    }

    public static @Nullable ITmfTrace createTraceInstance(UUID uuid) {
        String typeID;
        IResource resource;
        block6: {
            block5: {
                resource = TRACES.get(uuid);
                if (resource != null) break block5;
                return null;
            }
            typeID = TmfTraceType.getTraceTypeId((IResource)resource);
            if (typeID != null) break block6;
            return null;
        }
        try {
            ITmfTrace trace = TmfTraceType.instantiateTrace((String)typeID);
            if (trace != null) {
                String path = Objects.requireNonNull(ResourceUtil.getLocation((IResource)resource)).removeTrailingSeparator().toOSString();
                String name = resource.getName();
                trace.initTrace(resource, path, ITmfEvent.class, name, typeID);
                trace.indexTrace(false);
                ITmfContext ctx = trace.seekEvent(0L);
                trace.getNext(ctx);
                ctx.dispose();
            }
            return trace;
        }
        catch (CoreException | TmfTraceException e) {
            Activator.getInstance().logError("Failed to create trace instance for " + String.valueOf(uuid), e);
            return null;
        }
    }

    private static Trace createTraceModel(UUID uuid) {
        IResource resource = TRACES.get(uuid);
        if (resource == null) {
            return null;
        }
        return Trace.from(resource, uuid);
    }

    private static IResource getResource(String path, String name) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        project.refreshLocal(2, null);
        IFolder tracesFolder = project.getFolder(TRACES_FOLDER);
        IPath targetLocation = TraceManagerService.getTargetLocation(path);
        IPath resourcePath = targetLocation.removeLastSegments(1).append(name);
        Object resource = null;
        resource = new File(path).isFile() ? tracesFolder.getFile(resourcePath) : tracesFolder.getFolder(resourcePath);
        return resource;
    }

    private static synchronized boolean createResource(String path, IResource resource) throws CoreException {
        Path targetLocation = new Path(path);
        TraceManagerService.createFolder((IFolder)resource.getParent(), null);
        if (!ResourceUtil.createSymbolicLink((IResource)resource, (IPath)targetLocation, (boolean)true, null)) {
            return false;
        }
        IFolder supplRootFolder = resource.getProject().getFolder(".tracing");
        IFolder supplFolder = supplRootFolder.getFolder(resource.getProjectRelativePath().removeFirstSegments(1));
        TraceManagerService.createFolder(supplFolder, null);
        resource.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder.getLocation().toOSString());
        return true;
    }

    @GET
    @javax.ws.rs.Path(value="/{uuid}")
    @Produces(value={"application/json"})
    @Operation(summary="Get the model object for a trace", responses={@ApiResponse(responseCode="200", description="Return the trace model", content={@Content(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Trace.class))}), @ApiResponse(responseCode="404", description="No such trace", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getTrace(@Parameter(description="UUID of the trace to query") @PathParam(value="uuid") @NotNull UUID uuid) {
        Trace trace = TraceManagerService.createTraceModel(uuid);
        if (trace == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)trace).build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/{uuid}")
    @Produces(value={"application/json"})
    @Operation(summary="Remove a trace from the server and disk", responses={@ApiResponse(responseCode="200", description="The trace was successfully deleted", content={@Content(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Trace.class))}), @ApiResponse(responseCode="404", description="No such trace", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="409", description="The trace is in use by at least one experiment thus cannot be deleted", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response deleteTrace(@Parameter(description="UUID of the trace to query") @PathParam(value="uuid") @NotNull UUID uuid) {
        Trace trace = TraceManagerService.createTraceModel(uuid);
        if (trace == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (ExperimentManagerService.isTraceInUse(uuid)) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)trace).build();
        }
        IResource resource = TRACES.remove(uuid);
        if (resource == null) {
            return Response.ok((Object)trace).build();
        }
        try {
            File supplFolder = new File(resource.getPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER));
            FileUtils.cleanDirectory((File)supplFolder);
            TraceManagerService.cleanupFolders(supplFolder, resource.getProject().getFolder(".tracing").getLocation().toFile());
            resource.delete(1, null);
            TraceManagerService.cleanupFolders(resource.getParent().getLocation().toFile(), resource.getProject().getFolder(TRACES_FOLDER).getLocation().toFile());
            resource.getProject().refreshLocal(Integer.MAX_VALUE, null);
        }
        catch (IOException | CoreException e) {
            Activator.getInstance().logError("Failed to delete trace", e);
        }
        return Response.ok((Object)trace).build();
    }

    private static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                TraceManagerService.createFolder((IFolder)folder.getParent(), monitor);
            }
            folder.create(true, true, monitor);
        }
    }

    private static synchronized void cleanupFolders(File folder, File root) {
        File current = folder;
        while (current.isDirectory() && !current.equals(root)) {
            File[] listFiles = current.listFiles();
            if (listFiles == null || listFiles.length != 0) break;
            current.delete();
            current = current.getParentFile();
        }
    }

    public static void dispose() {
        TRACES.clear();
    }

    private static IPath getTargetLocation(String path) {
        Path p = new Path(path);
        if (p.getDevice() != null) {
            p = new Path(p.toString().replace(":", ""));
        }
        return p.removeTrailingSeparator();
    }
}

