/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.core.trace;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.function.BiPredicate;

public class SplitImportTracesOperation {
    private static final String DATA_KEY = "data";
    private static final String TRACE_ID = "traceID";
    private static final String TOTAL_KEY = "total";
    private static final String LIMIT_KEY = "limit";
    private static final String OFFSET_KEY = "offset";
    private static final String ERRORS_KEY = "errors";

    public static boolean splitAndImport(JsonObject jsonObject, List<String> selectedTracesId, String newFolderPath, BiPredicate<String, String> predicate) {
        Gson gson = new Gson();
        JsonArray array = jsonObject.get(DATA_KEY).getAsJsonArray();
        JsonElement total = jsonObject.get(TOTAL_KEY);
        JsonElement limit = jsonObject.get(LIMIT_KEY);
        JsonElement offset = jsonObject.get(OFFSET_KEY);
        JsonElement errors = jsonObject.get(ERRORS_KEY);
        boolean splitAndImportWithoutIssues = true;
        new File(newFolderPath).mkdir();
        int i = 0;
        while (i < array.size()) {
            String traceId = array.get(i).getAsJsonObject().get(TRACE_ID).getAsString();
            if (selectedTracesId == null || selectedTracesId.contains(traceId)) {
                String fileName = traceId + ".json";
                File subTrace = new File(newFolderPath + "/" + fileName);
                try {
                    subTrace.createNewFile();
                    JsonObject newObject = new JsonObject();
                    JsonArray data = new JsonArray();
                    data.add(array.get(i));
                    newObject.add(DATA_KEY, (JsonElement)data);
                    newObject.add(TOTAL_KEY, total);
                    newObject.add(LIMIT_KEY, limit);
                    newObject.add(OFFSET_KEY, offset);
                    newObject.add(ERRORS_KEY, errors);
                    Throwable throwable = null;
                    Object var18_19 = null;
                    try (PrintWriter tempWriter = new PrintWriter(subTrace);){
                        tempWriter.print(gson.toJson((JsonElement)newObject));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    splitAndImportWithoutIssues = predicate.test(newFolderPath, fileName) || splitAndImportWithoutIssues;
                }
                catch (IOException iOException) {
                    splitAndImportWithoutIssues = false;
                }
            }
            ++i;
        }
        return splitAndImportWithoutIssues;
    }
}

