/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.events.model.GetVariablesRequest;
import org.eclipse.ease.debugging.model.EaseDebugElement;
import org.eclipse.ease.debugging.model.EaseDebugThread;
import org.eclipse.ease.debugging.model.EaseDebugVariable;

public class EaseDebugStackFrame
extends EaseDebugElement
implements IStackFrame {
    private final EaseDebugThread fThread;
    private final IScriptDebugFrame fDebugFrame;
    private final List<EaseDebugVariable> fVariables = new ArrayList<EaseDebugVariable>();
    private boolean fDirty = true;

    private static EaseDebugVariable findExistingVariable(String name, Collection<EaseDebugVariable> variables) {
        for (EaseDebugVariable variable : variables) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public EaseDebugStackFrame(EaseDebugThread thread, IScriptDebugFrame debugFrame) {
        super(thread.getDebugTarget());
        this.fThread = thread;
        this.fDebugFrame = debugFrame;
    }

    public EaseDebugThread getThread() {
        return this.fThread;
    }

    public EaseDebugVariable[] getVariables() {
        if (this.fDirty) {
            this.getDebugTarget().fireDispatchEvent(new GetVariablesRequest(this));
        }
        return this.fVariables.toArray(new EaseDebugVariable[this.fVariables.size()]);
    }

    public boolean hasVariables() {
        return this.getVariables().length > 0;
    }

    public int getLineNumber() {
        return this.getDebugFrame().getLineNumber();
    }

    public int getCharStart() {
        return -1;
    }

    public int getCharEnd() {
        return -1;
    }

    public String getName() {
        return this.getScript().toString();
    }

    public IRegisterGroup[] getRegisterGroups() {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() {
        return false;
    }

    public Script getScript() {
        return this.getDebugFrame().getScript();
    }

    public IScriptDebugFrame getDebugFrame() {
        return this.fDebugFrame;
    }

    public void setDirty() {
        this.fDirty = true;
        this.fireChangeEvent(512);
    }

    public void setVariables(Collection<EaseDebugVariable> variables) {
        ArrayList<EaseDebugVariable> oldVariables = new ArrayList<EaseDebugVariable>(this.fVariables);
        this.fVariables.clear();
        for (EaseDebugVariable variable : variables) {
            EaseDebugVariable existingVariable = EaseDebugStackFrame.findExistingVariable(variable.getName(), oldVariables);
            if (existingVariable != null) {
                existingVariable.update(variable.getValue());
                this.fVariables.add(existingVariable);
                continue;
            }
            variable.setParent((IDebugElement)this);
            this.fVariables.add(variable);
        }
        Collections.sort(this.fVariables);
        this.fireChangeEvent(512);
        this.fDirty = false;
    }

    public String toString() {
        return String.valueOf(this.getScript().getTitle()) + ":" + this.getDebugFrame().getName() + " line: " + this.getDebugFrame().getLineNumber();
    }

    @Override
    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    @Override
    public boolean canResume() {
        return this.getThread().canResume();
    }

    @Override
    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    @Override
    public void resume() {
        this.getThread().resume();
    }

    @Override
    public void suspend() {
        this.getThread().suspend();
    }

    @Override
    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    @Override
    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    @Override
    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    @Override
    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    @Override
    public void stepInto() {
        this.getThread().stepInto();
    }

    @Override
    public void stepOver() {
        this.getThread().stepOver();
    }

    @Override
    public void stepReturn() {
        this.getThread().stepReturn();
    }
}

