/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.p2.metadata.Messages;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IMemberProvider;
import org.eclipse.osgi.util.NLS;

public class ProvidedCapability
implements IProvidedCapability,
IMemberProvider {
    public static final String MEMBER_NAMESPACE = "namespace";
    public static final String MEMBER_NAME = "name";
    public static final String MEMBER_VERSION = "version";
    public static final String MEMBER_PROPERTIES = "properties";
    private final String namespace;
    private final Map<String, Object> properties;

    public ProvidedCapability(String namespace, Map<String, Object> props) {
        Assert.isNotNull((Object)namespace, (String)NLS.bind((String)Messages.provided_capability_namespace_not_defined, null));
        this.namespace = namespace;
        Assert.isNotNull(props);
        Assert.isTrue((!props.isEmpty() ? 1 : 0) != 0);
        this.assertValidPropertyTypes(props);
        HashMap<String, Object> resolvedProps = new HashMap<String, Object>(props);
        Assert.isTrue((resolvedProps.containsKey(namespace) && resolvedProps.get(namespace) instanceof String ? 1 : 0) != 0, (String)NLS.bind((String)Messages.provided_capability_name_not_defined, (Object)namespace));
        Object version = resolvedProps.get(MEMBER_VERSION);
        if (version != null) {
            Assert.isTrue((boolean)(props.get(MEMBER_VERSION) instanceof Version));
        } else {
            resolvedProps.put(MEMBER_VERSION, Version.emptyVersion);
        }
        this.properties = Collections.unmodifiableMap(props);
    }

    public ProvidedCapability(String namespace, String name, Version version) {
        Assert.isNotNull((Object)namespace, (String)NLS.bind((String)Messages.provided_capability_namespace_not_defined, null));
        Assert.isNotNull((Object)name, (String)NLS.bind((String)Messages.provided_capability_name_not_defined, (Object)namespace));
        this.namespace = namespace;
        this.properties = new HashMap<String, Object>();
        this.properties.put(namespace, name);
        this.properties.put(MEMBER_VERSION, version == null ? Version.emptyVersion : version);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.namespace);
        for (Map.Entry<String, Object> attr : this.properties.entrySet()) {
            String key = attr.getKey();
            Object val = attr.getValue();
            String type = val.getClass().getSimpleName();
            str.append("; ").append(key).append(":").append(type).append("=").append(val);
        }
        return str.toString();
    }

    public int hashCode() {
        return this.namespace.hashCode() * this.properties.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof IProvidedCapability)) {
            return false;
        }
        IProvidedCapability otherCapability = (IProvidedCapability)other;
        if (!this.namespace.equals(otherCapability.getNamespace())) {
            return false;
        }
        return this.properties.equals(otherCapability.getProperties());
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return (String)this.properties.get(this.namespace);
    }

    @Override
    public Version getVersion() {
        return (Version)this.properties.get(MEMBER_VERSION);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Object getMember(String memberName) {
        switch (memberName) {
            case "namespace": {
                return this.namespace;
            }
            case "name": {
                return this.properties.get(this.namespace);
            }
            case "version": {
                return this.properties.get(MEMBER_VERSION);
            }
            case "properties": {
                return this.properties;
            }
        }
        throw new IllegalArgumentException(String.format("No such member: %s", memberName));
    }

    private void assertValidPropertyTypes(Map<String, Object> props) {
        props.forEach(this::assertValidValueType);
    }

    private void assertValidValueType(String key, Object prop) {
        if (prop instanceof List) {
            int idx = 0;
            for (Object scalar : (List)prop) {
                this.assertValidScalarType(String.format("%s[%s]", key, idx++), scalar);
            }
        } else {
            this.assertValidScalarType(key, prop);
        }
    }

    private void assertValidScalarType(String key, Object scalar) {
        Arrays.asList(Version.class, String.class, Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class, Boolean.class, Character.class).stream().filter(t -> t.isAssignableFrom(scalar.getClass())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid type %s of property %s", scalar.getClass(), key)));
    }
}

