/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.serial.launcher;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.terminal.connector.serial.connector.SerialSettings;
import org.eclipse.tm.terminal.connector.serial.controls.SerialConfigurationPanel;
import org.eclipse.tm.terminal.connector.serial.launcher.SerialMementoHandler;
import org.eclipse.tm.terminal.connector.serial.nls.Messages;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.interfaces.IMementoHandler;
import org.eclipse.tm.terminal.view.ui.internal.SettingsStore;
import org.eclipse.tm.terminal.view.ui.launcher.AbstractLauncherDelegate;

public class SerialLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new SerialMementoHandler();

    public boolean needsUserConfiguration() {
        return true;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new SerialConfigurationPanel(container);
    }

    public void execute(Map<String, Object> properties, ITerminalService.Done done) {
        ITerminalService terminal;
        Assert.isNotNull(properties);
        String terminalTitle = this.getTerminalTitle(properties);
        if (terminalTitle != null) {
            properties.put("title", terminalTitle);
        }
        if ((terminal = TerminalServiceFactory.getService()) != null) {
            terminal.openConsole(properties, done);
        }
    }

    private String getTerminalTitle(Map<String, Object> properties) {
        String device = (String)properties.get("serial.device");
        if (device != null) {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3);
            String date = format.format(new Date(System.currentTimeMillis()));
            return NLS.bind((String)Messages.SerialLauncherDelegate_terminalTitle, (Object[])new String[]{device, date});
        }
        return Messages.SerialLauncherDelegate_terminalTitle_default;
    }

    public Object getAdapter(Class adapter) {
        if (IMementoHandler.class.equals((Object)adapter)) {
            return this.mementoHandler;
        }
        return super.getAdapter(adapter);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tm.terminal.connector.serial.SerialConnector";
        }
        String port = (String)properties.get("serial.device");
        String baud = (String)properties.get("serial.baudrate");
        Object value = properties.get("timeout");
        String timeout = value instanceof Integer ? ((Integer)value).toString() : null;
        String databits = (String)properties.get("serial.databits");
        String stopbits = (String)properties.get("serial.stopbits");
        String parity = (String)properties.get("serial.parity");
        String flowcontrol = (String)properties.get("serial.flowcontrol");
        SettingsStore store = new SettingsStore();
        SerialSettings serialSettings = new SerialSettings();
        serialSettings.setSerialPort(port);
        serialSettings.setBaudRate(baud);
        serialSettings.setTimeout(timeout);
        serialSettings.setDataBits(databits);
        serialSettings.setStopBits(stopbits);
        serialSettings.setParity(parity);
        serialSettings.setFlowControl(flowcontrol);
        serialSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.setDefaultSettings();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

