/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.files.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.internal.services.files.ftp.Activator;
import org.eclipse.rse.internal.services.files.ftp.FTPHostFile;
import org.eclipse.rse.internal.services.files.ftp.FTPServiceResources;
import org.eclipse.rse.internal.services.files.ftp.IFTPService;
import org.eclipse.rse.internal.services.files.ftp.parser.IFTPClientConfigFactory;
import org.eclipse.rse.internal.services.files.ftp.parser.IFTPClientConfigProxy;
import org.eclipse.rse.services.Mutex;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemElementNotFoundException;
import org.eclipse.rse.services.clientserver.messages.SystemLockTimeoutException;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemNetworkIOException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.clientserver.messages.SystemUnsupportedOperationException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;

public class FTPService
extends AbstractFileService
implements IFTPService,
IFilePermissionsService {
    private FTPClient _ftpClient;
    private boolean _connected;
    private long _ftpLastCheck;
    private static long FTP_CONNECTION_CHECK_TIMEOUT = 30000L;
    private FTPFile[] _ftpFiles;
    private Mutex _commandMutex = new Mutex();
    private String _userHome;
    private boolean _caseSensitive = true;
    private transient String _hostName;
    private transient String _userId;
    private transient String _password;
    private transient int _portNumber;
    private transient String _controlEncoding;
    private OutputStream _ftpLoggingOutputStream;
    private ProtocolCommandListener _ftpProtocolCommandListener;
    private IPropertySet _ftpPropertySet;
    private Exception _exception;
    private boolean _isBinaryFileType = true;
    private boolean _isPassiveDataConnectionMode = false;
    private IFTPClientConfigFactory _entryParserFactory;
    private IFTPClientConfigProxy _clientConfigProxy;
    private String _fCachePreviousParent;
    private long _fCachePreviousTimestamp;
    private Map _fCachePreviousFiles = new HashMap();
    private static long FTP_STATCACHE_TIMEOUT = 200L;

    public void setPropertySet(IPropertySet ftpPropertySet) {
        this._ftpPropertySet = ftpPropertySet;
    }

    public String getName() {
        return FTPServiceResources.FTP_File_Service_Name;
    }

    public String getDescription() {
        return FTPServiceResources.FTP_File_Service_Description;
    }

    public void setHostName(String hostname) {
        this._hostName = hostname;
    }

    public void setPortNumber(int portNumber) {
        this._portNumber = portNumber;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setLoggingStream(OutputStream ftpLoggingOutputStream) {
        this._ftpLoggingOutputStream = ftpLoggingOutputStream;
    }

    public void setFTPClientConfigFactory(IFTPClientConfigFactory entryParserFactory) {
        this._entryParserFactory = entryParserFactory;
    }

    public void setControlEncoding(String encoding) {
        this._controlEncoding = encoding;
    }

    protected String checkEncoding(String s) throws SystemMessageException {
        if (s == null || s.length() == 0) {
            return s;
        }
        String encoding = this._controlEncoding != null ? this._controlEncoding : this.getFTPClient(false).getControlEncoding();
        try {
            byte[] bytes = s.getBytes(encoding);
            String decoded = new String(bytes, encoding);
            if (!s.equals(decoded)) {
                int i = 0;
                int lmax = Math.min(s.length(), decoded.length());
                while (i < lmax && s.charAt(i) == decoded.charAt(i)) {
                    ++i;
                }
                char sbad = s.charAt(i);
                String msg = "Cannot express character '" + sbad + "'(0x" + Integer.toHexString(sbad) + ") with " + "encoding \"" + encoding + "\". ";
                msg = String.valueOf(msg) + "Please specify a different encoding in host properties.";
                throw new UnsupportedEncodingException(msg);
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            SystemMessage msg = new SystemMessage("RSE", "F", "9999", 'E', e.getMessage(), "");
            throw new SystemMessageException(msg);
        }
    }

    private SystemMessageException makeSystemMessageException(Exception e) {
        if (e instanceof SystemMessageException) {
            return (SystemMessageException)e;
        }
        if (e instanceof IOException) {
            return new SystemNetworkIOException(e);
        }
        return new RemoteFileIOException(e);
    }

    public void connect() throws RemoteFileSecurityException, IOException {
        if (this._ftpClient == null) {
            this._ftpClient = new FTPClient();
            if (this._controlEncoding != null) {
                this._ftpClient.setControlEncoding(this._controlEncoding);
            }
        }
        if (this._ftpLoggingOutputStream != null && this._ftpProtocolCommandListener == null) {
            this._ftpProtocolCommandListener = new ProtocolCommandListener(){
                private PrintStream os;
                {
                    this.os = new PrintStream(FTPService.this._ftpLoggingOutputStream);
                }

                public void protocolCommandSent(ProtocolCommandEvent event) {
                    this.os.print(event.getMessage());
                }

                public void protocolReplyReceived(ProtocolCommandEvent event) {
                    this.os.println(event.getMessage());
                }
            };
            this._ftpClient.addProtocolCommandListener(this._ftpProtocolCommandListener);
        }
        if (this._portNumber == 0) {
            this._ftpClient.connect(this._hostName);
        } else {
            this._ftpClient.connect(this._hostName, this._portNumber);
        }
        int userReply = this._ftpClient.user(this._userId);
        if (FTPReply.isPositiveIntermediate((int)userReply)) {
            int passReply;
            if (this._ftpProtocolCommandListener != null) {
                this._ftpClient.removeProtocolCommandListener(this._ftpProtocolCommandListener);
                String newLine = System.getProperty("line.separator");
                this._ftpLoggingOutputStream.write(("PASS ******" + newLine).getBytes());
                passReply = this._ftpClient.pass(this._password);
                this._ftpLoggingOutputStream.write((String.valueOf(this._ftpClient.getReplyString()) + newLine).getBytes());
                this._ftpClient.addProtocolCommandListener(this._ftpProtocolCommandListener);
            } else {
                passReply = this._ftpClient.pass(this._password);
            }
            if (!FTPReply.isPositiveCompletion((int)passReply)) {
                String lastMessage = this._ftpClient.getReplyString();
                this.disconnect();
                throw new RemoteFileSecurityException(new Exception(lastMessage));
            }
        } else if (!FTPReply.isPositiveCompletion((int)userReply)) {
            String lastMessage = this._ftpClient.getReplyString();
            this.disconnect();
            throw new RemoteFileSecurityException(new Exception(lastMessage));
        }
        String systemName = this._ftpClient.getSystemName();
        this._ftpClient.setParserFactory((FTPFileEntryParserFactory)this._entryParserFactory);
        this._clientConfigProxy = this._entryParserFactory.getFTPClientConfig(this._ftpPropertySet.getPropertyValue("parser"), systemName);
        if (this._clientConfigProxy != null) {
            this._ftpClient.configure(this._clientConfigProxy.getFTPClientConfig());
        } else {
            this._ftpClient.configure(new FTPClientConfig("UNIX"));
        }
        if (this._ftpPropertySet.getPropertyValue("passive").equalsIgnoreCase("true")) {
            this._ftpClient.enterLocalPassiveMode();
            this._isPassiveDataConnectionMode = true;
        } else {
            this._ftpClient.enterLocalActiveMode();
            this._isPassiveDataConnectionMode = false;
        }
        this._ftpClient.setFileType(2);
        this._isBinaryFileType = true;
        String[] initialCommands = this._clientConfigProxy.getInitialCommands();
        int i = 0;
        while (i < initialCommands.length) {
            this._ftpClient.sendCommand(initialCommands[i]);
            ++i;
        }
        this._userHome = this._ftpClient.printWorkingDirectory();
        if (this._userHome.indexOf(34) >= 0) {
            String[] origReplys = this._ftpClient.getReplyStrings();
            String origReply = origReplys[origReplys.length - 1];
            Pattern p = Pattern.compile("... \"((?:[^\"]*(?:\"\")*)+)\"{1}.*");
            Matcher m = p.matcher(origReply);
            if (m.matches()) {
                this._userHome = m.group(1).replaceAll("\"\"", "\"");
            }
        }
        if (this._userHome.indexOf(58) != -1 && this._userHome.indexOf(93) != -1) {
            this._userHome = this._userHome.replaceAll(":\\[", "/");
            this._userHome = String.valueOf('/') + this._userHome.substring(0, this._userHome.lastIndexOf(93));
        }
        this.clearCache(null);
        this._connected = true;
    }

    public void disconnect() {
        this._connected = false;
        this.clearCache(null);
        try {
            try {
                if (this._ftpClient != null) {
                    this._ftpClient.logout();
                }
            }
            catch (IOException iOException) {
                this._ftpClient = null;
                this._ftpLastCheck = 0L;
                this._ftpProtocolCommandListener = null;
            }
        }
        finally {
            this._ftpClient = null;
            this._ftpLastCheck = 0L;
            this._ftpProtocolCommandListener = null;
        }
    }

    private void chdir(FTPClient ftpClient, String remoteFolder) throws SystemMessageException {
        try {
            if (!ftpClient.changeWorkingDirectory(remoteFolder)) {
                String reply = ftpClient.getReplyString();
                if (reply != null && reply.startsWith("550") && !reply.trim().endsWith("Not a directory.")) {
                    throw new SystemElementNotFoundException(remoteFolder, "chdir");
                }
                throw new RemoteFileIOException(new Exception(String.valueOf(reply) + " (" + remoteFolder + ")"));
            }
        }
        catch (IOException e) {
            throw new SystemNetworkIOException((Exception)e);
        }
    }

    public FTPClient getFTPClient() {
        return this.getFTPClient(true);
    }

    public FTPClient getFTPClient(boolean checkConnection) {
        long curTime;
        if (this._ftpClient == null) {
            this._ftpClient = new FTPClient();
            if (this._controlEncoding != null) {
                this._ftpClient.setControlEncoding(this._controlEncoding);
            }
        }
        if (this._hostName != null && checkConnection && (curTime = System.currentTimeMillis()) - this._ftpLastCheck > FTP_CONNECTION_CHECK_TIMEOUT) {
            this._ftpLastCheck = curTime;
            try {
                this._ftpClient.sendNoOp();
            }
            catch (IOException iOException) {
                try {
                    this.connect();
                }
                catch (Exception exception) {}
            }
        }
        this.setDataConnectionMode();
        return this._ftpClient;
    }

    private FTPClient cloneFTPClient(boolean isBinary) throws IOException {
        FTPClient ftpClient = new FTPClient();
        boolean ok = false;
        try {
            ftpClient.setControlEncoding(this._ftpClient.getControlEncoding());
            ftpClient.connect(this._ftpClient.getRemoteAddress());
            ftpClient.login(this._userId, this._password);
            if (this._clientConfigProxy != null) {
                ftpClient.configure(this._clientConfigProxy.getFTPClientConfig());
            } else {
                ftpClient.configure(new FTPClientConfig("UNIX"));
            }
            if (this._isPassiveDataConnectionMode) {
                ftpClient.enterLocalPassiveMode();
            }
            if (isBinary) {
                ftpClient.setFileType(2);
            } else {
                ftpClient.setFileType(0);
            }
            if (this._ftpProtocolCommandListener != null) {
                ftpClient.addProtocolCommandListener(this._ftpProtocolCommandListener);
            }
            ok = true;
        }
        catch (Throwable throwable) {
            if (!ok) {
                try {
                    ftpClient.disconnect();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (!ok) {
            try {
                ftpClient.disconnect();
            }
            catch (Throwable throwable) {}
        }
        return ftpClient;
    }

    public IHostFile getFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileInternal(remoteParent, fileName, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FTPHostFile getFileInternal(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        boolean isRoot;
        boolean bl = isRoot = remoteParent == null || remoteParent.length() == 0;
        if (isRoot) {
            return new FTPHostFile(remoteParent, fileName, true, true, 0L, 0L, true);
        }
        remoteParent = this.checkEncoding(remoteParent);
        fileName = this.checkEncoding(fileName);
        if (monitor != null && monitor.isCanceled()) {
            throw new SystemOperationCancelledException();
        }
        Map map = this._fCachePreviousFiles;
        synchronized (map) {
            long diff;
            Object result;
            if ((this._fCachePreviousParent == null ? remoteParent == null : this._fCachePreviousParent.equals(remoteParent)) && (result = this._fCachePreviousFiles.get(fileName)) != null && (diff = System.currentTimeMillis() - this._fCachePreviousTimestamp) < FTP_STATCACHE_TIMEOUT) {
                return (FTPHostFile)result;
            }
        }
        FTPHostFile file = null;
        if (!this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) throw new SystemLockTimeoutException("org.eclipse.rse.internal.services.files.ftp");
        try {
            FTPClient ftpc = this.getFTPClient();
            this.chdir(ftpc, remoteParent);
            if (!this.listFiles(monitor)) {
                throw new SystemOperationCancelledException();
            }
            Map map2 = this._fCachePreviousFiles;
            synchronized (map2) {
                block22: {
                    this.cacheFiles(remoteParent);
                    Object o = this._fCachePreviousFiles.get(fileName);
                    if (o == null) break block22;
                    FTPHostFile fTPHostFile = (FTPHostFile)o;
                    return fTPHostFile;
                }
                try {
                    if (!this.isCaseSensitive()) {
                        int i = 0;
                        while (i < this._ftpFiles.length) {
                            String tempName = this._ftpFiles[i].getName();
                            if (tempName.equalsIgnoreCase(fileName)) {
                                file = (FTPHostFile)this._fCachePreviousFiles.get(tempName);
                                break;
                            }
                            ++i;
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[1, 4, 5, 8] lbl46 : MonitorExitStatement: MONITOREXIT : var7_9
                    if (file != null) return file;
                    file = new FTPHostFile(remoteParent, fileName, false, false, 0L, 0L, false);
                    return file;
                }
                catch (SystemElementNotFoundException systemElementNotFoundException) {
                    file = new FTPHostFile(remoteParent, fileName, false, false, 0L, 0L, false);
                    return file;
                }
                catch (Exception e) {
                    throw this.makeSystemMessageException(e);
                }
            }
        }
        finally {
            this._commandMutex.release();
        }
    }

    public boolean isConnected() {
        boolean isConnected = false;
        if (this._ftpClient != null && this._connected) {
            isConnected = this._ftpClient.isConnected();
        }
        return isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        ArrayList<FTPHostFile> results;
        block20: {
            parentPath = this.checkEncoding(parentPath);
            if (monitor != null && monitor.isCanceled()) {
                throw new SystemOperationCancelledException();
            }
            results = new ArrayList<FTPHostFile>();
            if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
                try {
                    try {
                        if (fileFilter == null) {
                            fileFilter = "*";
                        }
                        NamePatternMatcher filematcher = null;
                        if (fileFilter.endsWith(",")) {
                            String[] types = fileFilter.split(",");
                            filematcher = new FileTypeMatcher(types, true);
                        } else {
                            filematcher = new NamePatternMatcher(fileFilter, true, true);
                        }
                        FTPClient ftpc = this.getFTPClient();
                        this.chdir(ftpc, parentPath);
                        if (!this.listFiles(monitor)) {
                            throw new SystemOperationCancelledException();
                        }
                        Map map = this._fCachePreviousFiles;
                        synchronized (map) {
                            this.cacheFiles(parentPath);
                            int i = 0;
                            while (i < this._ftpFiles.length) {
                                if (this._ftpFiles[i] != null) {
                                    String rawListLine = String.valueOf(this._ftpFiles[i].getRawListing()) + System.getProperty("line.separator");
                                    this._ftpLoggingOutputStream.write(rawListLine.getBytes());
                                    String name = this._ftpFiles[i].getName();
                                    FTPHostFile f = (FTPHostFile)this._fCachePreviousFiles.get(name);
                                    if (this.isRightType(fileType, f) && !name.equals(".") && !name.equals("..")) {
                                        if (f.isDirectory() && fileType != 2) {
                                            results.add(f);
                                        } else if (filematcher.matches(name)) {
                                            results.add(f);
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        this._ftpLoggingOutputStream.write(System.getProperty("line.separator").getBytes());
                        break block20;
                    }
                    catch (Exception e) {
                        throw this.makeSystemMessageException(e);
                    }
                }
                finally {
                    this._commandMutex.release();
                }
            }
            throw new SystemLockTimeoutException("org.eclipse.rse.internal.services.files.ftp");
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    private char getSeparator() {
        return PathUtility.getSeparator((String)this._userHome).charAt(0);
    }

    public void upload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        block13: {
            remoteParent = this.checkEncoding(remoteParent);
            remoteFile = this.checkEncoding(remoteFile);
            if (monitor != null) {
                if (monitor.isCanceled()) {
                    throw new SystemOperationCancelledException();
                }
            } else {
                monitor = new NullProgressMonitor();
            }
            MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
            progressMonitor.init(0, localFile.getName(), remoteFile, localFile.length());
            try {
                try {
                    if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
                        try {
                            this.internalUpload(localFile, remoteParent, remoteFile, isBinary, srcEncoding, hostEncoding, progressMonitor);
                            break block13;
                        }
                        finally {
                            this._commandMutex.release();
                        }
                    }
                    throw new SystemLockTimeoutException("org.eclipse.rse.internal.services.files.ftp");
                }
                catch (SystemMessageException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                progressMonitor.end();
            }
        }
    }

    public void upload(InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        remoteParent = this.checkEncoding(remoteParent);
        remoteFile = this.checkEncoding(remoteFile);
        try {
            int readCount;
            BufferedInputStream bis = new BufferedInputStream(stream);
            File tempFile = File.createTempFile("ftpup", "temp");
            FileOutputStream os = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[4096];
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
                if (monitor == null || !monitor.isCanceled()) continue;
                throw new SystemOperationCancelledException();
            }
            bos.close();
            this.upload(tempFile, remoteParent, remoteFile, isBinary, null, hostEncoding, monitor);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
    }

    private void internalUpload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, MyProgressMonitor progressMonitor) throws IOException, RemoteFileIOException, SystemMessageException {
        block14: {
            InputStream input = null;
            OutputStream output = null;
            FTPClient ftpClient = this.getFTPClient();
            try {
                try {
                    this.clearCache(remoteParent);
                    this.chdir(ftpClient, remoteParent);
                    this.setFileType(isBinary);
                    input = new FileInputStream(localFile);
                    output = ftpClient.storeFileStream(remoteFile);
                    if (output != null) {
                        int readCount;
                        byte[] buffer = new byte[4096];
                        while ((readCount = input.read(buffer)) > 0) {
                            output.write(buffer, 0, readCount);
                            progressMonitor.count(readCount);
                            if (!progressMonitor.isCanceled()) continue;
                            throw new SystemOperationCancelledException();
                        }
                        output.flush();
                        output.close();
                        output = null;
                        ftpClient.completePendingCommand();
                        break block14;
                    }
                    throw new RemoteFileIOException(new Exception(ftpClient.getReplyString()));
                }
                catch (SystemOperationCancelledException e) {
                    ftpClient.deleteFile(remoteFile);
                    throw e;
                }
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                finally {
                    if (output != null) {
                        output.close();
                    }
                }
            }
        }
    }

    public void download(String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        block11: {
            if (monitor != null && monitor.isCanceled()) {
                throw new SystemOperationCancelledException();
            }
            IHostFile remoteHostFile = this.getFile(remoteParent, remoteFile, monitor);
            MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
            progressMonitor.init(0, remoteFile, localFile.getName(), remoteHostFile.getSize());
            try {
                try {
                    if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
                        try {
                            this.internalDownload(remoteParent, remoteFile, localFile, isBinary, hostEncoding, progressMonitor);
                            break block11;
                        }
                        finally {
                            this._commandMutex.release();
                        }
                    }
                    throw new SystemLockTimeoutException("org.eclipse.rse.internal.services.files.ftp");
                }
                catch (FileNotFoundException e) {
                    throw new RemoteFileIOException((Exception)e);
                }
                catch (IOException e) {
                    throw new RemoteFileIOException((Exception)e);
                }
            }
            finally {
                progressMonitor.end();
            }
        }
    }

    private void internalDownload(String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding, MyProgressMonitor progressMonitor) throws SystemMessageException, IOException {
        block14: {
            InputStream input = null;
            OutputStream output = null;
            try {
                FTPClient ftpClient = this.getFTPClient();
                this.chdir(ftpClient, remoteParent);
                this.setFileType(isBinary);
                input = ftpClient.retrieveFileStream(remoteFile);
                if (input != null) {
                    int readCount;
                    if (!localFile.exists()) {
                        File localParentFile = localFile.getParentFile();
                        if (!localParentFile.exists()) {
                            localParentFile.mkdirs();
                        }
                        localFile.createNewFile();
                    }
                    output = new FileOutputStream(localFile);
                    byte[] buffer = new byte[4096];
                    while ((readCount = input.read(buffer)) > 0) {
                        output.write(buffer, 0, readCount);
                        progressMonitor.count(readCount);
                        if (!progressMonitor.isCanceled()) continue;
                        throw new SystemOperationCancelledException();
                    }
                    output.flush();
                    input.close();
                    input = null;
                    ftpClient.completePendingCommand();
                    break block14;
                }
                throw new RemoteFileIOException(new Exception(ftpClient.getReplyString()));
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                finally {
                    if (output != null) {
                        output.close();
                    }
                }
            }
        }
    }

    public IHostFile getUserHome() {
        if (this._userHome == null) {
            return null;
        }
        return new FTPHostFile(null, this._userHome, true, true, 0L, 0L, true);
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        IHostFile[] hostFile = this._userHome.startsWith("/") ? new IHostFile[]{new FTPHostFile(null, "/", true, true, 0L, 0L, true)} : new IHostFile[]{new FTPHostFile(null, this._userHome, true, true, 0L, 0L, true)};
        return hostFile;
    }

    public void delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        block12: {
            remoteParent = this.checkEncoding(remoteParent);
            fileName = this.checkEncoding(fileName);
            MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
            progressMonitor.init(String.valueOf(FTPServiceResources.FTP_File_Service_Deleting_Task) + fileName, -1);
            try {
                IHostFile file = this.getFile(remoteParent, fileName, monitor);
                if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
                    try {
                        try {
                            FTPClient ftpClient = this.getFTPClient();
                            this.internalDelete(ftpClient, remoteParent, fileName, file.isFile(), progressMonitor);
                            break block12;
                        }
                        catch (IOException e) {
                            if (!file.exists()) {
                                throw new SystemElementNotFoundException(file.getAbsolutePath(), "delete");
                            }
                            throw new RemoteFileIOException((Exception)e);
                        }
                        catch (SystemMessageException e) {
                            if (!file.exists()) {
                                throw new SystemElementNotFoundException(file.getAbsolutePath(), "delete");
                            }
                            throw e;
                        }
                    }
                    finally {
                        this._commandMutex.release();
                    }
                }
                throw new SystemLockTimeoutException("org.eclipse.rse.internal.services.files.ftp");
            }
            finally {
                progressMonitor.end();
            }
        }
    }

    private void internalDelete(FTPClient ftpClient, String parentPath, String fileName, boolean isFile, MyProgressMonitor monitor) throws SystemMessageException, IOException {
        if (monitor.isCanceled()) {
            throw new SystemOperationCancelledException();
        }
        this.clearCache(parentPath);
        boolean hasSucceeded = FTPReply.isPositiveCompletion((int)ftpClient.cwd(parentPath));
        monitor.worked(1);
        if (hasSucceeded) {
            if (isFile) {
                hasSucceeded = ftpClient.deleteFile(fileName);
                monitor.worked(1);
            } else {
                hasSucceeded = ftpClient.removeDirectory(fileName);
                monitor.worked(1);
            }
        }
        if (!hasSucceeded) {
            if (isFile) {
                throw new RemoteFileIOException(new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + this.concat(parentPath, fileName) + ")"));
            }
            String newParentPath = this.concat(parentPath, fileName);
            try {
                this.chdir(ftpClient, newParentPath);
            }
            catch (SystemElementNotFoundException systemElementNotFoundException) {}
            FTPFile[] fileNames = ftpClient.listFiles();
            int i = 0;
            while (i < fileNames.length) {
                String curName = fileNames[i].getName();
                if (curName != null && !curName.equals(".") && !curName.equals("..")) {
                    this.internalDelete(ftpClient, newParentPath, curName, fileNames[i].isFile() || fileNames[i].isSymbolicLink(), monitor);
                }
                ++i;
            }
            this.chdir(ftpClient, parentPath);
            hasSucceeded = ftpClient.removeDirectory(fileName);
            if (!hasSucceeded) {
                throw new RemoteFileIOException(new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + this.concat(parentPath, fileName) + ")"));
            }
        }
    }

    public void rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        block7: {
            remoteParent = this.checkEncoding(remoteParent);
            oldName = this.checkEncoding(oldName);
            newName = this.checkEncoding(newName);
            if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
                try {
                    try {
                        FTPClient ftpClient = this.getFTPClient();
                        this.clearCache(remoteParent);
                        this.chdir(ftpClient, remoteParent);
                        boolean success = ftpClient.rename(oldName, newName);
                        if (!success) {
                            throw new Exception(ftpClient.getReplyString());
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        throw this.makeSystemMessageException(e);
                    }
                }
                finally {
                    this._commandMutex.release();
                }
            }
            throw new SystemLockTimeoutException("org.eclipse.rse.internal.services.files.ftp");
        }
    }

    public void rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) {
        oldFile.renameTo(newName);
    }

    public void move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        block7: {
            srcParent = this.checkEncoding(srcParent);
            srcName = this.checkEncoding(srcName);
            tgtParent = this.checkEncoding(tgtParent);
            tgtName = this.checkEncoding(tgtName);
            if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
                try {
                    try {
                        FTPClient ftpClient = this.getFTPClient();
                        String source = this.concat(srcParent, srcName);
                        String target = this.concat(tgtParent, tgtName);
                        this.clearCache(srcParent);
                        this.clearCache(tgtParent);
                        boolean success = ftpClient.rename(source, target);
                        if (!success) {
                            throw new Exception(ftpClient.getReplyString());
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        throw new RemoteFileIOException(e);
                    }
                }
                finally {
                    this._commandMutex.release();
                }
            }
            throw new SystemLockTimeoutException("org.eclipse.rse.internal.services.files.ftp");
        }
    }

    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        block7: {
            remoteParent = this.checkEncoding(remoteParent);
            folderName = this.checkEncoding(folderName);
            if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
                try {
                    try {
                        FTPClient ftpClient = this.getFTPClient();
                        this.clearCache(remoteParent);
                        this.chdir(ftpClient, remoteParent);
                        if (!ftpClient.makeDirectory(folderName)) {
                            throw new RemoteFileIOException(new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + folderName + ")"));
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        throw this.makeSystemMessageException(e);
                    }
                }
                finally {
                    this._commandMutex.release();
                }
            }
            throw new SystemLockTimeoutException("org.eclipse.rse.internal.services.files.ftp");
        }
        return this.getFile(remoteParent, folderName, monitor);
    }

    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        remoteParent = this.checkEncoding(remoteParent);
        fileName = this.checkEncoding(fileName);
        try {
            File tempFile = File.createTempFile("ftp", "temp");
            tempFile.deleteOnExit();
            try {
                this.upload(tempFile, remoteParent, fileName, this._isBinaryFileType, null, null, monitor);
            }
            catch (SystemMessageException systemMessageException) {
                throw new RemoteFileIOException(new Exception(this.getFTPClient().getReplyString()));
            }
        }
        catch (Exception e) {
            throw new RemoteFileSecurityException(e);
        }
        return this.getFile(remoteParent, fileName, monitor);
    }

    public void copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        block7: {
            srcParent = this.checkEncoding(srcParent);
            srcName = this.checkEncoding(srcName);
            tgtParent = this.checkEncoding(tgtParent);
            tgtName = this.checkEncoding(tgtName);
            if (monitor != null && monitor.isCanceled()) {
                throw new SystemOperationCancelledException();
            }
            IHostFile remoteHostFile = this.getFile(srcParent, srcName, monitor);
            MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
            progressMonitor.init(0, this.concat(srcParent, srcName), this.concat(tgtParent, tgtName), remoteHostFile.getSize() * 2L);
            if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
                try {
                    try {
                        this.internalCopy(this.getFTPClient(), srcParent, srcName, tgtParent, tgtName, remoteHostFile.isDirectory(), progressMonitor);
                        break block7;
                    }
                    catch (IOException iOException) {
                        throw new RemoteFileIOException(new Exception(this.getFTPClient().getReplyString()));
                    }
                }
                finally {
                    this._commandMutex.release();
                }
            }
            throw new SystemLockTimeoutException("org.eclipse.rse.internal.services.files.ftp");
        }
    }

    private void internalCopy(FTPClient ftpClient, String srcParent, String srcName, String tgtParent, String tgtName, boolean isDirectory, MyProgressMonitor monitor) throws SystemMessageException, IOException {
        if (monitor.isCanceled()) {
            throw new SystemOperationCancelledException();
        }
        if (isDirectory) {
            ftpClient.makeDirectory(this.concat(tgtParent, tgtName));
            String newSrcParentPath = this.concat(srcParent, srcName);
            String newTgtParentPath = this.concat(tgtParent, tgtName);
            this.chdir(ftpClient, newSrcParentPath);
            FTPFile[] fileNames = ftpClient.listFiles();
            int i = 0;
            while (i < fileNames.length) {
                String curName = fileNames[i].getName();
                if (curName != null && !curName.equals(".") && !curName.equals("..")) {
                    this.internalCopy(ftpClient, newSrcParentPath, curName, newTgtParentPath, curName, fileNames[i].isDirectory(), monitor);
                }
                ++i;
            }
        } else {
            File tempFile = null;
            try {
                tempFile = File.createTempFile("ftpcp" + String.valueOf(srcParent.hashCode()), "temp");
                tempFile.deleteOnExit();
            }
            catch (IOException e) {
                throw new RemoteFileIOException((Exception)e);
            }
            try {
                this.internalDownload(srcParent, srcName, tempFile, true, null, monitor);
                this.internalUpload(tempFile, tgtParent, tgtName, true, null, null, monitor);
            }
            finally {
                tempFile.delete();
            }
        }
    }

    public void copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
        int i = 0;
        while (i < srcNames.length) {
            this.copy(srcParents[i], srcNames[i], tgtParent, srcNames[i], monitor);
            ++i;
        }
    }

    public void setIsCaseSensitive(boolean b) {
        this._caseSensitive = b;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private boolean listFiles(IProgressMonitor monitor) throws Exception {
        boolean result = true;
        this._exception = null;
        Thread listThread = new Thread(new Runnable(){

            public void run() {
                try {
                    FTPService.this._ftpFiles = null;
                    if (FTPService.this._clientConfigProxy != null) {
                        FTPService.this._ftpFiles = FTPService.this._ftpClient.listFiles(FTPService.this._clientConfigProxy.getListCommandModifiers());
                    } else {
                        FTPService.this._ftpFiles = FTPService.this._ftpClient.listFiles();
                    }
                }
                catch (IOException e) {
                    FTPService.this._exception = e;
                }
            }
        });
        if (monitor == null) {
            listThread.start();
            listThread.join();
            if (this._exception == null) return result;
            throw new RemoteFileIOException(this._exception);
        }
        if (monitor.isCanceled()) return false;
        listThread.start();
        while (!monitor.isCanceled() && listThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!monitor.isCanceled()) return result;
        if (!listThread.isAlive()) return result;
        Thread killThread = listThread;
        listThread = null;
        killThread.interrupt();
        this._ftpClient.completePendingCommand();
        throw new RemoteFileIOException(this._exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFiles(String parentPath) {
        Map map = this._fCachePreviousFiles;
        synchronized (map) {
            this._fCachePreviousFiles.clear();
            this._fCachePreviousTimestamp = System.currentTimeMillis();
            this._fCachePreviousParent = parentPath;
            int i = 0;
            while (i < this._ftpFiles.length) {
                if (this._ftpFiles[i] != null) {
                    FTPHostFile f = new FTPHostFile(parentPath, this._ftpFiles[i]);
                    String name = f.getName();
                    if (f.isLink() && name.indexOf(46) < 0) {
                        f.setIsDirectory(true);
                    }
                    this._fCachePreviousFiles.put(name, f);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache(String parentPath) {
        Map map = this._fCachePreviousFiles;
        synchronized (map) {
            if (parentPath == null || parentPath.equals(this._fCachePreviousParent)) {
                this._fCachePreviousFiles.clear();
            }
        }
    }

    public void setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        throw new SystemUnsupportedOperationException("org.eclipse.rse.internal.services.files.ftp", "setLastModified");
    }

    public void setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        FTPHostFile file = this.getFileInternal(parent, name, monitor);
        int userPermissions = file.getUserPermissions();
        int groupPermissions = file.getGroupPermissions();
        int otherPermissions = file.getOtherPermissions();
        int oldPermissions = userPermissions * 100 + groupPermissions * 10 + otherPermissions;
        if (readOnly) {
            userPermissions &= 5;
            groupPermissions &= 5;
            otherPermissions &= 5;
        } else {
            userPermissions |= 2;
        }
        int newPermissions = userPermissions * 100 + groupPermissions * 10 + otherPermissions;
        if (newPermissions != oldPermissions && this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    this.clearCache(parent);
                    FTPClient ftpc = this.getFTPClient();
                    if (!ftpc.sendSiteCommand("CHMOD " + newPermissions + " " + file.getAbsolutePath())) {
                        String lastMessage = ftpc.getReplyString();
                        throw new RemoteFileSecurityException(new Exception(lastMessage));
                    }
                }
                catch (IOException e) {
                    String pluginId = Activator.getDefault().getBundle().getSymbolicName();
                    String messageText = e.getLocalizedMessage();
                    SimpleSystemMessage message = new SimpleSystemMessage(pluginId, 4, messageText, (Throwable)e);
                    throw new SystemMessageException((SystemMessage)message);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null && monitor.isCanceled()) {
            throw new SystemOperationCancelledException();
        }
        FTPBufferedInputStream stream = null;
        try {
            FTPClient ftpClient = this.cloneFTPClient(isBinary);
            this.chdir(ftpClient, remoteParent);
            stream = new FTPBufferedInputStream(ftpClient.retrieveFileStream(remoteFile), ftpClient);
        }
        catch (Exception e) {
            throw this.makeSystemMessageException(e);
        }
        return stream;
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        int options = isBinary ? 0 : 2;
        return this.getOutputStream(remoteParent, remoteFile, options, monitor);
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, int options, IProgressMonitor monitor) throws SystemMessageException {
        remoteParent = this.checkEncoding(remoteParent);
        remoteFile = this.checkEncoding(remoteFile);
        if (monitor != null && monitor.isCanceled()) {
            throw new SystemOperationCancelledException();
        }
        FTPBufferedOutputStream stream = null;
        try {
            boolean isBinary = (options & 2) == 0;
            FTPClient ftpClient = this.cloneFTPClient(isBinary);
            this.clearCache(remoteParent);
            this.chdir(ftpClient, remoteParent);
            stream = (options & 1) == 0 ? new FTPBufferedOutputStream(ftpClient.storeFileStream(remoteFile), ftpClient) : new FTPBufferedOutputStream(ftpClient.appendFileStream(remoteFile), ftpClient);
        }
        catch (Exception e) {
            throw this.makeSystemMessageException(e);
        }
        return stream;
    }

    private void setDataConnectionMode() {
        if (this._ftpPropertySet != null) {
            if (this._ftpPropertySet.getPropertyValue("passive").equalsIgnoreCase("true") && !this._isPassiveDataConnectionMode) {
                this._ftpClient.enterLocalPassiveMode();
                this._isPassiveDataConnectionMode = true;
            } else if (this._ftpPropertySet.getPropertyValue("passive").equalsIgnoreCase("false") && this._isPassiveDataConnectionMode) {
                this._ftpClient.enterLocalActiveMode();
                this._isPassiveDataConnectionMode = false;
            }
        }
    }

    private void setFileType(boolean isBinaryFileType) throws IOException {
        if (!isBinaryFileType && this._isBinaryFileType) {
            this._ftpClient.setFileType(0);
            this._isBinaryFileType = isBinaryFileType;
        } else if (isBinaryFileType && !this._isBinaryFileType) {
            this._ftpClient.setFileType(2);
            this._isBinaryFileType = isBinaryFileType;
        }
    }

    protected String concat(String parentDir, String fileName) {
        StringBuffer path = new StringBuffer(parentDir);
        if (!parentDir.endsWith(String.valueOf(this.getSeparator()))) {
            path.append(this.getSeparator());
        }
        path.append(fileName);
        return path.toString();
    }

    public IHostFilePermissions getFilePermissions(IHostFile file, IProgressMonitor monitor) throws SystemMessageException {
        if (file instanceof IHostFilePermissionsContainer) {
            return ((IHostFilePermissionsContainer)file).getPermissions();
        }
        return null;
    }

    public void setFilePermissions(IHostFile inFile, IHostFilePermissions permissions, IProgressMonitor monitor) throws SystemMessageException {
        String s = Integer.toOctalString(permissions.getPermissionBits());
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    this.clearCache(inFile.getParentPath());
                    FTPClient ftpc = this.getFTPClient();
                    if (!ftpc.sendSiteCommand("CHMOD " + s + " " + inFile.getAbsolutePath())) {
                        String lastMessage = ftpc.getReplyString();
                        throw new RemoteFileSecurityException(new Exception(lastMessage));
                    }
                }
                catch (IOException e) {
                    String pluginId = Activator.getDefault().getBundle().getSymbolicName();
                    String messageText = e.getLocalizedMessage();
                    SimpleSystemMessage message = new SimpleSystemMessage(pluginId, 4, messageText, (Throwable)e);
                    throw new SystemMessageException((SystemMessage)message);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
    }

    public int getCapabilities(IHostFile file) {
        return 39;
    }

    private static class FTPBufferedInputStream
    extends BufferedInputStream {
        private FTPClient client;

        public FTPBufferedInputStream(InputStream in, FTPClient client) {
            super(in);
            this.client = client;
        }

        public FTPBufferedInputStream(InputStream in, int size, FTPClient client) {
            super(in, size);
            this.client = client;
        }

        public void close() throws IOException {
            super.close();
            this.client.completePendingCommand();
            this.client.logout();
        }
    }

    private class FTPBufferedOutputStream
    extends BufferedOutputStream {
        private FTPClient client;

        public FTPBufferedOutputStream(OutputStream out, FTPClient client) {
            super(out);
            this.client = client;
        }

        public FTPBufferedOutputStream(OutputStream out, int size, FTPClient client) {
            super(out, size);
            this.client = client;
        }

        public void close() throws IOException {
            super.close();
            this.client.completePendingCommand();
            this.client.logout();
        }
    }

    private class MyProgressMonitor {
        private IProgressMonitor fMonitor;
        private double fWorkPercentFactor;
        private Long fMaxWorkKB;
        private long fWorkToDate;

        public MyProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        }

        public boolean isCanceled() {
            return this.fMonitor.isCanceled();
        }

        public void init(int op, String src, String dest, long max) {
            String srcFile;
            this.fWorkPercentFactor = 1.0 / (double)max;
            this.fMaxWorkKB = new Long(max / 1024L);
            this.fWorkToDate = 0L;
            String desc = srcFile = new Path(src).lastSegment();
            this.fMonitor.beginTask(desc, (int)max);
        }

        public void init(String label, int max) {
            this.fMonitor.beginTask(label, max);
        }

        public boolean count(long count) {
            this.fWorkToDate += count;
            Long workToDateKB = new Long(this.fWorkToDate / 1024L);
            Double workPercent = new Double(this.fWorkPercentFactor * (double)this.fWorkToDate);
            String subDesc = MessageFormat.format(FTPServiceResources.FTP_File_Service_Monitor_Format, workToDateKB, this.fMaxWorkKB, workPercent);
            this.fMonitor.subTask(subDesc);
            this.fMonitor.worked((int)count);
            return !this.fMonitor.isCanceled();
        }

        public void worked(int work) {
            this.fMonitor.worked(work);
        }

        public void end() {
            this.fMonitor.done();
        }
    }
}

