/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.propertypages;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.PendingHostFilePermissions;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SystemFilePermissionsPropertyPage
extends SystemBasePropertyPage {
    private Button _userRead;
    private Button _userWrite;
    private Button _userExecute;
    private Button _groupRead;
    private Button _groupWrite;
    private Button _groupExecute;
    private Button _otherRead;
    private Button _otherWrite;
    private Button _otherExecute;
    private Text _userEntry;
    private Text _groupEntry;
    private IHostFilePermissions _permissions;
    private String _owner;
    private String _group;

    protected IRemoteFile getRemoteFile() {
        IAdaptable element = this.getElement();
        IRemoteFile file = (IRemoteFile)element;
        return file;
    }

    protected Control createContentArea(Composite parent) {
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)1);
        IRemoteFile file = this.getRemoteFile();
        IFilePermissionsService service = this.getPermissionsService(file);
        if (service == null || (service.getCapabilities(file.getHostFile()) & 4) == 0) {
            SystemWidgetHelpers.createLabel((Composite)parent, (String)FileResources.MESSAGE_FILE_PERMISSIONS_NOT_SUPPORTED);
        } else {
            Group permissionsGroup = SystemWidgetHelpers.createGroupComposite((Composite)composite_prompts, (int)4, (String)FileResources.RESID_PREF_PERMISSIONS_PERMISSIONS_LABEL);
            GridData data = new GridData();
            data.horizontalSpan = 5;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = false;
            data.verticalAlignment = 1;
            data.grabExcessVerticalSpace = false;
            permissionsGroup.setLayoutData((Object)data);
            SystemWidgetHelpers.createLabel((Composite)permissionsGroup, (String)FileResources.RESID_PREF_PERMISSIONS_TYPE_LABEL);
            Label readLabel = SystemWidgetHelpers.createLabel((Composite)permissionsGroup, (String)FileResources.RESID_PREF_PERMISSIONS_READ_LABEL);
            data = new GridData();
            data.horizontalIndent = 20;
            readLabel.setLayoutData((Object)data);
            Label writeLabel = SystemWidgetHelpers.createLabel((Composite)permissionsGroup, (String)FileResources.RESID_PREF_PERMISSIONS_WRITE_LABEL);
            data = new GridData();
            data.horizontalIndent = 20;
            writeLabel.setLayoutData((Object)data);
            Label executeLabel = SystemWidgetHelpers.createLabel((Composite)permissionsGroup, (String)FileResources.RESID_PREF_PERMISSIONS_EXECUTE_LABEL);
            data = new GridData();
            data.horizontalIndent = 20;
            executeLabel.setLayoutData((Object)data);
            SystemWidgetHelpers.createLabel((Composite)permissionsGroup, (String)FileResources.RESID_PREF_PERMISSIONS_USER_LABEL);
            this._userRead = new Button((Composite)permissionsGroup, 32);
            data = new GridData();
            data.horizontalIndent = 20;
            this._userRead.setLayoutData((Object)data);
            this._userWrite = new Button((Composite)permissionsGroup, 32);
            data = new GridData();
            data.horizontalIndent = 20;
            this._userWrite.setLayoutData((Object)data);
            this._userExecute = new Button((Composite)permissionsGroup, 32);
            data = new GridData();
            data.horizontalIndent = 20;
            this._userExecute.setLayoutData((Object)data);
            SystemWidgetHelpers.createLabel((Composite)permissionsGroup, (String)FileResources.RESID_PREF_PERMISSIONS_GROUP_LABEL);
            this._groupRead = new Button((Composite)permissionsGroup, 32);
            data = new GridData();
            data.horizontalIndent = 20;
            this._groupRead.setLayoutData((Object)data);
            this._groupWrite = new Button((Composite)permissionsGroup, 32);
            data = new GridData();
            data.horizontalIndent = 20;
            this._groupWrite.setLayoutData((Object)data);
            this._groupExecute = new Button((Composite)permissionsGroup, 32);
            data = new GridData();
            data.horizontalIndent = 20;
            this._groupExecute.setLayoutData((Object)data);
            SystemWidgetHelpers.createLabel((Composite)permissionsGroup, (String)FileResources.RESID_PREF_PERMISSIONS_OTHERS_LABEL);
            this._otherRead = new Button((Composite)permissionsGroup, 32);
            data = new GridData();
            data.horizontalIndent = 20;
            this._otherRead.setLayoutData((Object)data);
            this._otherWrite = new Button((Composite)permissionsGroup, 32);
            data = new GridData();
            data.horizontalIndent = 20;
            this._otherWrite.setLayoutData((Object)data);
            this._otherExecute = new Button((Composite)permissionsGroup, 32);
            data = new GridData();
            data.horizontalIndent = 20;
            this._otherExecute.setLayoutData((Object)data);
            Group ownerGroup = SystemWidgetHelpers.createGroupComposite((Composite)composite_prompts, (int)2, (String)FileResources.RESID_PREF_PERMISSIONS_OWNERSHIP_LABEL);
            data = new GridData();
            data.horizontalSpan = 1;
            data.verticalSpan = 5;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = false;
            data.verticalAlignment = 1;
            data.grabExcessVerticalSpace = false;
            ownerGroup.setLayoutData((Object)data);
            SystemWidgetHelpers.createLabel((Composite)ownerGroup, (String)FileResources.RESID_PREF_PERMISSIONS_USER_LABEL);
            this._userEntry = new Text((Composite)ownerGroup, 2048);
            data = new GridData();
            data.widthHint = 100;
            this._userEntry.setLayoutData((Object)data);
            SystemWidgetHelpers.createLabel((Composite)ownerGroup, (String)FileResources.RESID_PREF_PERMISSIONS_GROUP_LABEL);
            this._groupEntry = new Text((Composite)ownerGroup, 2048);
            data = new GridData();
            data.widthHint = 100;
            this._groupEntry.setLayoutData((Object)data);
            this.initFields();
        }
        return composite_prompts;
    }

    protected boolean verifyPageContents() {
        return true;
    }

    private void enableOwnershipFields(boolean enabled) {
        this._userEntry.setEnabled(enabled);
        this._groupEntry.setEnabled(enabled);
    }

    private void enablePermissionFields(boolean enabled) {
        this._groupExecute.setEnabled(enabled);
        this._groupRead.setEnabled(enabled);
        this._groupWrite.setEnabled(enabled);
        this._userExecute.setEnabled(enabled);
        this._userRead.setEnabled(enabled);
        this._userWrite.setEnabled(enabled);
        this._otherExecute.setEnabled(enabled);
        this._otherRead.setEnabled(enabled);
        this._otherWrite.setEnabled(enabled);
    }

    private IFilePermissionsService getPermissionsService(IRemoteFile remoteFile) {
        if (remoteFile instanceof IAdaptable) {
            return (IFilePermissionsService)((IAdaptable)remoteFile).getAdapter(IFilePermissionsService.class);
        }
        return null;
    }

    private void initFields() {
        IRemoteFile remoteFile = this.getRemoteFile();
        IFilePermissionsService ps = this.getPermissionsService(remoteFile);
        if (ps == null) {
            this.enablePermissionFields(false);
            this.enableOwnershipFields(false);
        } else {
            this.initPermissionFields(remoteFile, ps);
        }
    }

    private void initPermissionFields(IRemoteFile file, IFilePermissionsService service) {
        this._permissions = null;
        final IRemoteFile rFile = file;
        final IFilePermissionsService pService = service;
        int capabilities = service.getCapabilities(file.getHostFile());
        if ((capabilities & 0x20) != 0) {
            this.enablePermissionFields(true);
        } else {
            this.enablePermissionFields(false);
        }
        if ((capabilities & 8) != 0) {
            this.enableOwnershipFields(true);
        } else {
            this.enableOwnershipFields(false);
        }
        if ((capabilities & 4) != 0) {
            this._permissions = file.getPermissions();
            if (this._permissions == null || this._permissions instanceof PendingHostFilePermissions) {
                Job deferredFetch = new Job(FileResources.MESSAGE_GETTING_PERMISSIONS){

                    public IStatus run(IProgressMonitor monitor) {
                        try {
                            SystemFilePermissionsPropertyPage.this._permissions = pService.getFilePermissions(rFile.getHostFile(), monitor);
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    SystemFilePermissionsPropertyPage.this._userRead.setSelection(SystemFilePermissionsPropertyPage.this._permissions.getPermission(256));
                                    SystemFilePermissionsPropertyPage.this._userWrite.setSelection(SystemFilePermissionsPropertyPage.this._permissions.getPermission(128));
                                    SystemFilePermissionsPropertyPage.this._userExecute.setSelection(SystemFilePermissionsPropertyPage.this._permissions.getPermission(64));
                                    SystemFilePermissionsPropertyPage.this._groupRead.setSelection(SystemFilePermissionsPropertyPage.this._permissions.getPermission(32));
                                    SystemFilePermissionsPropertyPage.this._groupWrite.setSelection(SystemFilePermissionsPropertyPage.this._permissions.getPermission(16));
                                    SystemFilePermissionsPropertyPage.this._groupExecute.setSelection(SystemFilePermissionsPropertyPage.this._permissions.getPermission(8));
                                    SystemFilePermissionsPropertyPage.this._otherRead.setSelection(SystemFilePermissionsPropertyPage.this._permissions.getPermission(4));
                                    SystemFilePermissionsPropertyPage.this._otherWrite.setSelection(SystemFilePermissionsPropertyPage.this._permissions.getPermission(2));
                                    SystemFilePermissionsPropertyPage.this._otherExecute.setSelection(SystemFilePermissionsPropertyPage.this._permissions.getPermission(1));
                                    SystemFilePermissionsPropertyPage.this._owner = SystemFilePermissionsPropertyPage.this._permissions.getUserOwner();
                                    SystemFilePermissionsPropertyPage.this._group = SystemFilePermissionsPropertyPage.this._permissions.getGroupOwner();
                                    SystemFilePermissionsPropertyPage.this._userEntry.setText(SystemFilePermissionsPropertyPage.this._owner);
                                    SystemFilePermissionsPropertyPage.this._groupEntry.setText(SystemFilePermissionsPropertyPage.this._group);
                                }
                            });
                        }
                        catch (SystemMessageException e) {
                            SystemFilePermissionsPropertyPage.this.setMessage(e.getSystemMessage());
                        }
                        return Status.OK_STATUS;
                    }
                };
                deferredFetch.schedule();
            } else {
                this._userRead.setSelection(this._permissions.getPermission(256));
                this._userWrite.setSelection(this._permissions.getPermission(128));
                this._userExecute.setSelection(this._permissions.getPermission(64));
                this._groupRead.setSelection(this._permissions.getPermission(32));
                this._groupWrite.setSelection(this._permissions.getPermission(16));
                this._groupExecute.setSelection(this._permissions.getPermission(8));
                this._otherRead.setSelection(this._permissions.getPermission(4));
                this._otherWrite.setSelection(this._permissions.getPermission(2));
                this._otherExecute.setSelection(this._permissions.getPermission(1));
                this._owner = this._permissions.getUserOwner();
                this._group = this._permissions.getGroupOwner();
                this._userEntry.setText(this._owner);
                this._groupEntry.setText(this._group);
            }
        } else {
            this.enablePermissionFields(false);
            this.enableOwnershipFields(false);
        }
    }

    public boolean performOk() {
        IFilePermissionsService service;
        int capabilities;
        IRemoteFile remoteFile = this.getRemoteFile();
        boolean changed = false;
        if (this._permissions != null && ((capabilities = (service = this.getPermissionsService(remoteFile)).getCapabilities(remoteFile.getHostFile())) & 0x20) != 0) {
            try {
                IHostFilePermissions newPermissions = (IHostFilePermissions)this._permissions.clone();
                if (this._permissions.getPermission(256) != this._userRead.getSelection()) {
                    changed = true;
                    newPermissions.setPermission(256, this._userRead.getSelection());
                }
                if (this._permissions.getPermission(128) != this._userWrite.getSelection()) {
                    changed = true;
                    newPermissions.setPermission(128, this._userWrite.getSelection());
                }
                if (this._permissions.getPermission(64) != this._userExecute.getSelection()) {
                    changed = true;
                    newPermissions.setPermission(64, this._userExecute.getSelection());
                }
                if (this._permissions.getPermission(32) != this._groupRead.getSelection()) {
                    changed = true;
                    newPermissions.setPermission(32, this._groupRead.getSelection());
                }
                if (this._permissions.getPermission(16) != this._groupWrite.getSelection()) {
                    changed = true;
                    newPermissions.setPermission(16, this._groupWrite.getSelection());
                }
                if (this._permissions.getPermission(8) != this._groupExecute.getSelection()) {
                    changed = true;
                    newPermissions.setPermission(8, this._groupExecute.getSelection());
                }
                if (this._permissions.getPermission(4) != this._otherRead.getSelection()) {
                    changed = true;
                    newPermissions.setPermission(4, this._otherRead.getSelection());
                }
                if (this._permissions.getPermission(2) != this._otherWrite.getSelection()) {
                    changed = true;
                    newPermissions.setPermission(2, this._otherWrite.getSelection());
                }
                if (this._permissions.getPermission(1) != this._otherExecute.getSelection()) {
                    changed = true;
                    newPermissions.setPermission(1, this._otherExecute.getSelection());
                }
                if (this._owner != this._userEntry.getText()) {
                    changed = true;
                    newPermissions.setUserOwner(this._userEntry.getText());
                }
                if (this._group != this._groupEntry.getText()) {
                    changed = true;
                    newPermissions.setGroupOwner(this._groupEntry.getText());
                }
                if (changed) {
                    remoteFile.markStale(true, true);
                    service.setFilePermissions(remoteFile.getHostFile(), newPermissions, (IProgressMonitor)new NullProgressMonitor());
                    this._permissions = newPermissions;
                }
            }
            catch (SystemMessageException e) {
                this.setMessage(e.getSystemMessage());
            }
            catch (CloneNotSupportedException e) {
                SystemBasePlugin.logError((String)e.getMessage());
            }
        }
        if (changed) {
            remoteFile.markStale(true);
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)remoteFile, 85, (Object)remoteFile));
        }
        return super.performOk();
    }

    protected boolean wantDefaultAndApplyButton() {
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    protected void performDefaults() {
        IRemoteFile file = this.getRemoteFile();
        IFilePermissionsService service = (IFilePermissionsService)((IAdaptable)file).getAdapter(IFilePermissionsService.class);
        this.initPermissionFields(file, service);
    }

    public void setVisible(boolean visible) {
        IRemoteFile file;
        if (visible && (file = this.getRemoteFile()).isStale()) {
            try {
                file = file.getParentRemoteFileSubSystem().getRemoteFileObject(file.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (SystemMessageException e) {
                SystemBasePlugin.logMessage((SystemMessage)e.getSystemMessage());
            }
            this.setElement((IAdaptable)file);
            this.performDefaults();
        }
        super.setVisible(visible);
    }
}

