/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.connectorservice.ssh;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.rse.connectorservice.ssh";
    private static Activator plugin;
    private ServiceTracker tracker;
    private static Boolean fTracingOn;

    static {
        fTracingOn = null;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.tracker = new ServiceTracker(this.getBundle().getBundleContext(), IJSchService.class.getName(), null);
        this.tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            SshConnectorService.shutdown();
            this.tracker.close();
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    public IJSchService getJSchService() {
        return (IJSchService)this.tracker.getService();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static boolean isTracingOn() {
        if (fTracingOn == null) {
            String id = plugin.getBundle().getSymbolicName();
            String val = Platform.getDebugOption((String)(String.valueOf(id) + "/debug"));
            fTracingOn = "true".equals(val) ? Boolean.TRUE : Boolean.FALSE;
        }
        return fTracingOn;
    }

    public static String getTimestamp() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            return formatter.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    public static void trace(String msg) {
        if (Activator.isTracingOn()) {
            String fullMsg = String.valueOf(Activator.getTimestamp()) + " | " + Thread.currentThread().getName() + " | " + msg;
            System.out.println(fullMsg);
            System.out.flush();
        }
    }
}

