/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.IReportFormatter;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFormatter
implements IReportFormatter {
    private final List<IReportFormatter> formatters = new ArrayList<IReportFormatter>();

    public void add(IReportFormatter formatter) {
        this.formatters.add(formatter);
    }

    @Override
    public IReportVisitor createReportVisitor(ICoverageNode root, List<SessionInfo> sessionInfos, Collection<ExecutionData> executionData) throws IOException {
        ArrayList<IReportVisitor> visitors = new ArrayList<IReportVisitor>();
        for (IReportFormatter f : this.formatters) {
            visitors.add(f.createReportVisitor(root, sessionInfos, executionData));
        }
        return new MultiVisitor(visitors);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiVisitor
    implements IReportVisitor {
        private final List<IReportVisitor> visitors;

        MultiVisitor(List<IReportVisitor> visitors) {
            this.visitors = visitors;
        }

        @Override
        public IReportVisitor visitChild(ICoverageNode node) throws IOException {
            ArrayList<IReportVisitor> children = new ArrayList<IReportVisitor>();
            for (IReportVisitor v : this.visitors) {
                children.add(v.visitChild(node));
            }
            return new MultiVisitor(children);
        }

        @Override
        public void visitEnd(ISourceFileLocator sourceFileLocator) throws IOException {
            for (IReportVisitor v : this.visitors) {
                v.visitEnd(sourceFileLocator);
            }
        }
    }
}

