/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ISystemValidatorUniqueString;

public class ValidatorUniqueString
implements ISystemValidator,
ISystemValidatorUniqueString {
    public static final boolean CASE_SENSITIVE = true;
    public static final boolean CASE_INSENSITIVE = false;
    public static final char QUOTE = '\"';
    private static final String[] EMPTY_LIST = new String[0];
    protected ISystemValidator syntaxValidator;
    protected boolean caseSensitive;
    protected boolean useUpperCase;
    protected String[] existingList;
    protected SystemMessage msg_Empty;
    protected SystemMessage msg_NonUnique;
    protected SystemMessage currentMessage;

    public ValidatorUniqueString(Collection existingList, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.setExistingNamesList(existingList);
        this.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1029"), RSEUIPlugin.getPluginMessage("RSEG1030"));
    }

    public ValidatorUniqueString(String[] existingList, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.init(existingList, caseSensitive);
        this.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1029"), RSEUIPlugin.getPluginMessage("RSEG1030"));
    }

    public ValidatorUniqueString(Collection existingList, boolean caseSensitive, ISystemValidator syntaxValidator) {
        this(existingList, caseSensitive);
        this.syntaxValidator = syntaxValidator;
    }

    public ValidatorUniqueString(String[] existingList, boolean caseSensitive, ISystemValidator syntaxValidator) {
        this(existingList, caseSensitive);
        this.syntaxValidator = syntaxValidator;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setUseUpperCase() {
        this.useUpperCase = true;
    }

    public void setExistingNamesList(Collection newList) {
        if (newList == null) {
            this.existingList = null;
        } else {
            this.existingList = new String[newList.size()];
            newList.toArray(this.existingList);
            this.init(this.existingList, this.caseSensitive);
        }
    }

    public void setExistingNamesList(String[] existingList) {
        if (existingList == null) {
            this.existingList = null;
        } else {
            this.init(existingList, this.caseSensitive);
        }
    }

    public String[] getExistingNamesList() {
        return this.existingList;
    }

    private void init(String[] names, boolean caseSensitive) {
        if (names == null) {
            this.existingList = EMPTY_LIST;
        } else {
            this.existingList = new String[names.length];
            System.arraycopy(names, 0, this.existingList, 0, names.length);
            if (!caseSensitive) {
                int idx = 0;
                while (idx < this.existingList.length) {
                    String string = this.existingList[idx];
                    boolean quoted = string.indexOf(34) != -1;
                    this.existingList[idx] = !quoted ? string.toLowerCase() : ValidatorUniqueString.quotedToLowerCase(string);
                    ++idx;
                }
            }
            Arrays.sort(this.existingList);
        }
    }

    public static String quotedToLowerCase(String input) {
        StringBuffer buffer = new StringBuffer(input.length());
        boolean inQuotes = false;
        int idx = 0;
        while (idx < input.length()) {
            char c = input.charAt(idx);
            if (c == '\"') {
                inQuotes = !inQuotes;
            } else if (!inQuotes) {
                c = Character.toLowerCase(c);
            }
            buffer.append(c);
            ++idx;
        }
        return buffer.toString();
    }

    public void setErrorMessages(SystemMessage msg_Empty, SystemMessage msg_NonUnique) {
        if (msg_Empty != null) {
            this.msg_Empty = msg_Empty;
        }
        if (msg_NonUnique != null) {
            this.msg_NonUnique = msg_NonUnique;
        }
    }

    public SystemMessage isSyntaxOk(String newText) {
        return null;
    }

    public String toString() {
        return "UniqueNameValidator class";
    }

    protected String doMessageSubstitution(SystemMessage msg, String substitution) {
        this.currentMessage = msg;
        if (msg.getNumSubstitutionVariables() > 0) {
            if (!this.useUpperCase) {
                return msg.makeSubstitution((Object)substitution).getLevelOneText();
            }
            return msg.makeSubstitution((Object)substitution.toUpperCase()).getLevelOneText();
        }
        return msg.getLevelOneText();
    }

    protected String getSystemMessageText(SystemMessage msg) {
        this.currentMessage = msg;
        if (msg != null) {
            return msg.getLevelOneText();
        }
        return null;
    }

    public String isValid(String newText) {
        this.currentMessage = null;
        if ((newText = newText.trim()).length() == 0) {
            this.currentMessage = this.msg_Empty;
        } else {
            if (!this.caseSensitive && this.existingList != null) {
                newText = newText.indexOf(34) != -1 ? ValidatorUniqueString.quotedToLowerCase(newText) : newText.toLowerCase();
            }
            if (this.existingList != null) {
                if (!this.caseSensitive) {
                    if (Arrays.binarySearch(this.existingList, newText) >= 0) {
                        this.currentMessage = this.msg_NonUnique;
                    }
                } else {
                    boolean match = false;
                    int i = 0;
                    while (i < this.existingList.length && !match) {
                        String existing = this.existingList[i];
                        if (existing != null) {
                            match = newText.toLowerCase().equals(existing.toLowerCase());
                        }
                        ++i;
                    }
                    if (match) {
                        this.currentMessage = this.msg_NonUnique;
                    }
                }
            } else if (this.syntaxValidator != null) {
                String msg = this.syntaxValidator.isValid(newText);
                if (msg != null) {
                    this.currentMessage = this.syntaxValidator.getSystemMessage();
                    if (this.currentMessage == null) {
                        return msg;
                    }
                }
            } else {
                this.currentMessage = this.isSyntaxOk(newText);
            }
        }
        return this.currentMessage == null ? null : this.doMessageSubstitution(this.currentMessage, newText);
    }

    public String isValid(Object newValue) {
        if (newValue instanceof String) {
            return this.isValid((String)newValue);
        }
        this.currentMessage = null;
        return null;
    }

    public int getMaximumNameLength() {
        return -1;
    }

    public SystemMessage getSystemMessage() {
        return this.currentMessage;
    }

    public SystemMessage validate(String text) {
        if (this.isValid(text) != null) {
            return this.currentMessage;
        }
        return null;
    }
}

