/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.internal;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.tests.core.IRSETestLogCollectorDelegate;

public class RSEDefaultTestLogCollectorDelegate
implements IRSETestLogCollectorDelegate {
    private final List locationsToDispose = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.internal.RSEDefaultTestLogCollectorDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public synchronized void dispose() {
        if (!this.locationsToDispose.isEmpty()) {
            Iterator iterator = this.locationsToDispose.iterator();
            while (iterator.hasNext()) {
                IPath path;
                Object element = iterator.next();
                if (!(element instanceof IPath) || !(path = (IPath)element).toFile().exists()) continue;
                path.toFile().delete();
            }
        }
        this.locationsToDispose.clear();
    }

    public synchronized IPath[] getAbsoluteLogFileLocations() {
        ArrayList locations = new ArrayList();
        this.locationsToDispose.clear();
        this.internalCollectEclipsePlatformLog(locations);
        this.internalCollectJavaSystemProperties(locations);
        return locations.toArray(new IPath[locations.size()]);
    }

    private void internalCollectEclipsePlatformLog(List locations) {
        Path osgi_logfile_path;
        if (!$assertionsDisabled && locations == null) {
            throw new AssertionError();
        }
        String osgi_logfile = System.getProperty("osgi.logfile", null);
        Path path = osgi_logfile_path = osgi_logfile != null ? new Path(osgi_logfile) : null;
        if (osgi_logfile_path == null || !osgi_logfile_path.toFile().canRead()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath platformLog = root.getLocation().append(".metadata").append(".log");
            if (platformLog.toFile().canRead()) {
                locations.add(platformLog);
            }
        } else {
            locations.add(osgi_logfile_path);
        }
    }

    private void internalCollectJavaSystemProperties(List locations) {
        Path tmpdirPath;
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir != null && (tmpdirPath = new Path(tmpdir)).toFile().canWrite() && tmpdirPath.toFile().isDirectory()) {
            if ((tmpdirPath = tmpdirPath.append("java_system_properties.txt")).toFile().exists()) {
                tmpdirPath.toFile().delete();
            }
            FilterOutputStream stream = null;
            try {
                try {
                    if (tmpdirPath.toFile().createNewFile()) {
                        this.locationsToDispose.add(tmpdirPath);
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("#\n");
                        buffer.append("# Generated at " + DateFormat.getDateTimeInstance(1, 1, Locale.getDefault()).format(new Date(System.currentTimeMillis())) + "\n");
                        buffer.append("#\n\n");
                        Properties properties = System.getProperties();
                        Enumeration<?> names = properties.propertyNames();
                        ArrayList propertyKeys = new ArrayList();
                        while (names.hasMoreElements()) {
                            propertyKeys.add(names.nextElement());
                        }
                        Collections.sort(propertyKeys);
                        Iterator iterator = propertyKeys.iterator();
                        while (iterator.hasNext()) {
                            String propertyKey = (String)iterator.next();
                            String propertyValue = properties.getProperty(propertyKey, "");
                            buffer.append(String.valueOf(propertyKey) + "=" + propertyValue + "\n");
                        }
                        stream = new BufferedOutputStream(new FileOutputStream(tmpdirPath.toFile()));
                        stream.write(buffer.toString().getBytes());
                        locations.add(tmpdirPath);
                    }
                }
                catch (IOException e) {
                    if (Platform.inDebugMode()) {
                        e.printStackTrace();
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e2) {
                        if (Platform.inDebugMode()) {
                            e2.printStackTrace();
                        }
                    }
                }
            }
            finally {
                block21: {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        if (!Platform.inDebugMode()) break block21;
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

