/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IRemoteServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ServerLaunchType;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.core.connection.IRSEConnectionManager;
import org.eclipse.rse.tests.core.connection.IRSEConnectionProperties;
import org.eclipse.rse.tests.internal.RSEConnectionProperties;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystem;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class RSEConnectionManager
implements IRSEConnectionManager {
    private IPath connectionDefaultsLocation = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.internal.RSEConnectionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public RSEConnectionManager() {
        Path relative;
        URL url;
        Bundle bundle = RSETestsPlugin.getDefault().getBundle();
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)(relative = new Path("test.data/connectionDefault.properties")), null)) != null) {
            try {
                this.connectionDefaultsLocation = new Path(FileLocator.resolve((URL)url).getFile());
            }
            catch (IOException iOException) {}
        }
    }

    public IRSEConnectionProperties loadConnectionProperties(IPath path, boolean allowDefaults) {
        Properties properties;
        block32: {
            Properties defaults;
            block30: {
                if (!$assertionsDisabled && path == null) {
                    throw new AssertionError();
                }
                defaults = null;
                if (allowDefaults && this.connectionDefaultsLocation != null && this.connectionDefaultsLocation.toFile().isFile() && this.connectionDefaultsLocation.toFile().canRead()) {
                    InputStream stream = null;
                    try {
                        try {
                            defaults = new Properties();
                            stream = new FileInputStream(this.connectionDefaultsLocation.toFile());
                            defaults.load(stream);
                        }
                        catch (IOException iOException) {
                            defaults = null;
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                                break block30;
                            }
                            catch (IOException iOException2) {}
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            properties = null;
            if (path.toFile().isFile() && path.toFile().canRead()) {
                FileInputStream stream = null;
                try {
                    try {
                        stream = new FileInputStream(path.toFile());
                        properties = defaults != null ? new Properties(defaults) : new Properties();
                        properties.load(stream);
                    }
                    catch (IOException iOException) {
                        properties = null;
                        try {
                            if (stream != null) {
                                ((InputStream)stream).close();
                            }
                            break block32;
                        }
                        catch (IOException iOException3) {}
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return properties != null ? new RSEConnectionProperties(properties) : null;
    }

    public IRSEConnectionProperties loadConnectionProperties(Properties properties, boolean allowDefaults) {
        Properties defaults;
        block19: {
            if (!$assertionsDisabled && properties == null) {
                throw new AssertionError();
            }
            defaults = null;
            if (allowDefaults && this.connectionDefaultsLocation != null && this.connectionDefaultsLocation.toFile().isFile() && this.connectionDefaultsLocation.toFile().canRead()) {
                InputStream stream = null;
                try {
                    try {
                        defaults = new Properties();
                        stream = new FileInputStream(this.connectionDefaultsLocation.toFile());
                        defaults.load(stream);
                    }
                    catch (IOException iOException) {
                        defaults = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block19;
                        }
                        catch (IOException iOException2) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        Properties resultProperties = null;
        if (defaults != null) {
            resultProperties = new Properties(defaults);
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name == null || properties.getProperty(name) == null) continue;
                resultProperties.setProperty(name, properties.getProperty(name));
            }
        } else {
            resultProperties = properties;
        }
        return resultProperties != null ? new RSEConnectionProperties(resultProperties) : null;
    }

    public void removeConnection(String profileName, String name) {
        IHost connection;
        if (!($assertionsDisabled || profileName != null && name != null)) {
            throw new AssertionError();
        }
        ISystemRegistry systemRegistry = RSECorePlugin.getTheSystemRegistry();
        Assert.assertNotNull((String)"FAILED(findOrCreateConnection): RSE system registry unavailable!", (Object)systemRegistry);
        ISystemProfile profile = systemRegistry.getSystemProfile(profileName);
        if (profile != null && (connection = systemRegistry.getHost(profile, name)) != null) {
            systemRegistry.deleteHost(connection);
            systemRegistry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)connection, 55, (Object)systemRegistry));
        }
    }

    public IHost findOrCreateConnection(IRSEConnectionProperties properties) {
        ISystemProfile profile;
        if (!$assertionsDisabled && properties == null) {
            throw new AssertionError();
        }
        IHost connection = null;
        ISystemRegistry systemRegistry = RSECorePlugin.getTheSystemRegistry();
        Assert.assertNotNull((String)"FAILED(findOrCreateConnection): RSE system registry unavailable!", (Object)systemRegistry);
        Exception exception = null;
        String cause = null;
        String profileName = properties.getProperty("profile_name");
        ISystemProfile iSystemProfile = profile = profileName == null ? systemRegistry.getSystemProfileManager().getDefaultPrivateSystemProfile() : systemRegistry.getSystemProfile(profileName);
        if (profile == null) {
            try {
                profile = systemRegistry.createSystemProfile(profileName, true);
            }
            catch (Exception e) {
                exception = e;
                cause = e.getLocalizedMessage();
            }
            Assert.assertNull((String)("FAILED(findOrCreateConnection): Failed to create system profile '" + profileName + "'! Possible cause: " + cause), (Object)exception);
        }
        profileName = profile.getName();
        Assert.assertNotNull((String)("FAILED(findOrCreateConnection): Failed to find and/or create system profile '" + profileName + "'!"), (Object)profile);
        String name = properties.getProperty("name");
        Assert.assertFalse((String)"FAILED(findOrCreateConnection): Invalid host name!", (boolean)"unknown".equals(name));
        connection = systemRegistry.getHost(profile, name);
        if (connection == null) {
            IServerLauncherProperties connProperties;
            String userId = properties.getProperty("userid");
            Assert.assertFalse((String)"FAILED(findOrCreateConnection): Invalid user id name!", (boolean)"unknown".equals(userId));
            String password = properties.getProperty("password");
            Assert.assertFalse((String)"FAILED(findOrCreateConnection): Invalid user password name!", (boolean)"unknown".equals(password));
            String address = properties.getProperty("address");
            Assert.assertFalse((String)"FAILED(findOrCreateConnection): Invalid remote system ip address or dns name!", (boolean)"unknown".equals(address));
            String systemTypeId = properties.getProperty("system_type_id");
            Assert.assertFalse((String)"FAILED(findOrCreateConnection): Invalid system type!", (boolean)"unknown".equals(systemTypeId));
            IRSESystemType systemType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById(systemTypeId);
            String daemonPort = properties.getProperty("daemon_port");
            Assert.assertFalse((String)"FAILED(findOrCreateConnection): Invalid port!", (boolean)"unknown".equals(daemonPort));
            String rexecPort = properties.getProperty("rexec_port");
            String serverLaunchType = properties.getProperty("launch_type");
            String serverPath = properties.getProperty("dstore_server_path");
            String serverScript = properties.getProperty("dstore_server_script");
            exception = null;
            cause = null;
            try {
                connection = systemRegistry.createHost(profileName, systemType, name, address, null, userId, 2, null);
            }
            catch (Exception e) {
                exception = e;
                cause = e.getLocalizedMessage();
            }
            Assert.assertNull((String)("FAILED(findOrCreateConnection): Failed to create connection IHost object! Possible cause: " + cause), (Object)exception);
            if (userId != null && password != null) {
                SystemSignonInformation info = new SystemSignonInformation(address, userId, password, systemType);
                PasswordPersistenceManager.getInstance().add(info, true, false);
            }
            if ((connProperties = connection.getConnectorServices()[0].getRemoteServerLauncherProperties()) instanceof IRemoteServerLauncher) {
                IRemoteServerLauncher launcher = (IRemoteServerLauncher)connProperties;
                if (daemonPort != null) {
                    int daemonPortNum = Integer.parseInt(daemonPort);
                    launcher.setDaemonPort(daemonPortNum);
                }
                if (serverLaunchType != null) {
                    launcher.setServerLaunchType(ServerLaunchType.get((String)serverLaunchType));
                }
                if (rexecPort != null) {
                    int rexecPortNum = Integer.parseInt(rexecPort);
                    launcher.setRexecPort(rexecPortNum);
                }
                if (serverPath != null) {
                    launcher.setServerPath(serverPath);
                }
                if (serverScript != null) {
                    launcher.setServerScript(serverScript);
                }
            }
        }
        Assert.assertNotNull((String)"FAILED(findOrCreateConnection): Failed to find and/or create connection IHost object!", (Object)connection);
        Display display = Display.getCurrent();
        if (display != null) {
            while (!display.isDisposed() && display.readAndDispatch()) {
            }
        }
        return connection;
    }

    public FileServiceSubSystem getFileSubSystem(IHost connection, String desiredConfigurationId) throws Exception {
        if (!($assertionsDisabled || connection != null && desiredConfigurationId != null)) {
            throw new AssertionError();
        }
        FileServiceSubSystem subsystem = (FileServiceSubSystem)RemoteFileUtility.getFileSubSystem((IHost)connection);
        ISubSystemConfiguration config = subsystem.getSubSystemConfiguration();
        String activeId = config.getId();
        if (!activeId.equals(desiredConfigurationId)) {
            if (subsystem.isConnected()) {
                throw new RuntimeException(MessageFormat.format("The subsystem is connected as {0}. Disconnect before changing.", activeId));
            }
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            ISubSystemConfiguration desiredConfiguration = registry.getSubSystemConfiguration(desiredConfigurationId);
            if (subsystem.canSwitchTo(desiredConfiguration)) {
                subsystem.switchServiceFactory(desiredConfiguration);
            }
        }
        return subsystem;
    }

    public IShellServiceSubSystem getShellSubSystem(IHost connection) throws Exception {
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        ISubSystem[] subSystems = registry.getSubSystems(connection);
        int i = 0;
        while (i < subSystems.length) {
            ISubSystem subSystem = subSystems[i];
            if (subSystem instanceof IShellServiceSubSystem) {
                return (IShellServiceSubSystem)subSystem;
            }
            ++i;
        }
        return null;
    }

    public ITestSubSystem getTestSubSystem(IHost connection) throws Exception {
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        ISubSystem[] subSystems = registry.getSubSystems(connection);
        int i = 0;
        while (i < subSystems.length) {
            ISubSystem subSystem = subSystems[i];
            if (subSystem instanceof ITestSubSystem) {
                return (ITestSubSystem)subSystem;
            }
            ++i;
        }
        return null;
    }
}

