/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IFileServiceCodePageConverter;

public class DefaultFileServiceCodePageConverter
implements IFileServiceCodePageConverter {
    public byte[] convertClientStringToRemoteBytes(String remotePath, String clientString, String remoteEncoding, IFileService fs) {
        try {
            return clientString.getBytes(remoteEncoding);
        }
        catch (Exception exception) {
            return clientString.getBytes();
        }
    }

    public void convertFileFromRemoteEncoding(String remotePath, File file, String remoteEncoding, String localEncoding, IFileService fs) {
        FileInputStream inputStream = null;
        FileOutputStream outStream = null;
        try {
            try {
                int fileLength = (int)file.length();
                if (fileLength > 0) {
                    inputStream = new FileInputStream(file);
                    BufferedInputStream bufInputStream = new BufferedInputStream(inputStream, fileLength);
                    byte[] buffer = new byte[fileLength];
                    bufInputStream.read(buffer, 0, fileLength);
                    bufInputStream.close();
                    ByteBuffer rmtBuf = ByteBuffer.wrap(buffer, 0, fileLength);
                    Charset rmtCharset = Charset.forName(remoteEncoding);
                    CharsetDecoder rmtDecoder = rmtCharset.newDecoder();
                    CharBuffer decodedBuf = null;
                    decodedBuf = rmtDecoder.decode(rmtBuf);
                    Charset charset = Charset.forName(localEncoding);
                    CharsetEncoder encoder = charset.newEncoder();
                    byte[] localBuffer = null;
                    ByteBuffer lclBuf = encoder.encode(decodedBuf);
                    localBuffer = lclBuf.array();
                    outStream = new FileOutputStream(file);
                    outStream.write(localBuffer, 0, localBuffer.length);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (outStream != null) {
            try {
                outStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isServerEncodingSupported(String remoteEncoding, IFileService fs) {
        return true;
    }

    public int getPriority(String remoteEString, IFileService fs) {
        return 1000;
    }
}

