/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.messages;

import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemRemoteMessageException;

public class SystemOperationFailedException
extends SystemRemoteMessageException {
    private static final long serialVersionUID = 1L;

    public SystemOperationFailedException(Exception remoteException) {
        super(SystemOperationFailedException.getMyMessage("org.eclipse.rse.services", null, remoteException), remoteException);
    }

    public SystemOperationFailedException(String pluginId, String msg) {
        super(SystemOperationFailedException.getMyMessage(pluginId, msg, null), null);
    }

    public SystemOperationFailedException(String pluginId, Exception remoteException) {
        super(SystemOperationFailedException.getMyMessage(pluginId, null, remoteException), remoteException);
    }

    public SystemOperationFailedException(String pluginId, String operationPerformed, Exception remoteException) {
        super(SystemOperationFailedException.getMyMessage(pluginId, operationPerformed, remoteException), remoteException);
    }

    private static SystemMessage getMyMessage(String pluginId, String operationPerformed, Exception remoteException) {
        String message = operationPerformed;
        String secondLevel = null;
        if (remoteException != null) {
            Throwable cause;
            message = remoteException.getMessage();
            if (message == null) {
                message = remoteException.getClass().getName();
            }
            if ((cause = remoteException.getCause()) != null && (secondLevel = cause.getMessage()) == null && (secondLevel = cause.getClass().getName()).equals(message)) {
                secondLevel = null;
            }
            if (operationPerformed != null) {
                secondLevel = secondLevel != null ? String.valueOf(operationPerformed) + " : " + secondLevel : operationPerformed;
            }
        }
        String msgTxt = NLS.bind((String)CommonMessages.MSG_OPERATION_FAILED, (Object)message);
        SimpleSystemMessage msg = new SimpleSystemMessage(pluginId, "RSEG1066", 4, msgTxt, secondLevel);
        return msg;
    }
}

