/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.dstore.core.miners.Miner;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IByteStreamHandler;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalByteStreamHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.ArchiveQueryThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.ClassFileParser;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.CopyBatchThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.CopySingleThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.CreateFileThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.CreateFolderThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.DeleteThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.FileClassifier;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.FileDescriptors;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.FileQueryThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.RenameThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.UniversalDownloadHandler;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.UniversalSearchHandler;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.SystemFileClassifier;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.java.ClassFileUtil;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class UniversalFileSystemMiner
extends Miner {
    private DataElement deUFSnode;
    private DataElement deUFSuploadlog;
    protected String filterString = "*";
    protected ArchiveHandlerManager _archiveHandlerManager;
    protected boolean showHidden = false;
    public static final String CLASSNAME = "UniversalFileSystemMiner";
    protected HashMap _cancellableThreads = new HashMap();
    private static final int PERMISSION_OWNER = 0;
    private static final int PERMISSION_GROUP = 1;
    private static final int PERMISSION_BITS = 2;
    private static final int PERMISSION_ALL = 3;
    private boolean _isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public UniversalFileSystemMiner() {
        this._archiveHandlerManager = ArchiveHandlerManager.getInstance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemZipHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("zip", (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemJarHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("jar", (Class)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemTgzHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("tar.gz", (Class)clazz3);
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemTgzHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("tgz", (Class)clazz4);
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemTarHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("tar", (Class)clazz5);
    }

    public DataElement handleCommand(DataElement theElement) throws SystemMessageException {
        boolean caseSensitive;
        String name = this.getCommandName(theElement);
        DataElement status = this.getCommandStatus(theElement);
        DataElement subject = this.getCommandArgument(theElement, 0);
        UniversalServerUtilities.logInfo(this.getName(), String.valueOf(name) + ":" + subject, this._dataStore);
        String queryType = (String)subject.getElementProperty((Object)"type");
        boolean bl = caseSensitive = !this._isWindows;
        if ("C_QUERY_VIEW_ALL".equals(name)) {
            DataElement attributes = this.getCommandArgument(theElement, 1);
            if (attributes != null && attributes.getType().equals("attributes")) {
                return this.handleQueryAll(subject, attributes, status, queryType, caseSensitive);
            }
            return this.handleQueryAll(subject, null, status, queryType, caseSensitive);
        }
        if ("C_QUERY_VIEW_FILES".equals(name)) {
            DataElement attributes = this.getCommandArgument(theElement, 1);
            if (attributes != null && attributes.getType().equals("attributes")) {
                return this.handleQueryFiles(subject, attributes, status, queryType, caseSensitive);
            }
            return this.handleQueryFiles(subject, null, status, queryType, caseSensitive);
        }
        if ("C_QUERY_VIEW_FOLDERS".equals(name)) {
            DataElement attributes = this.getCommandArgument(theElement, 1);
            if (attributes != null && attributes.getType().equals("attributes")) {
                return this.handleQueryFolders(subject, attributes, status, queryType, caseSensitive);
            }
            return this.handleQueryFolders(subject, null, status, queryType, caseSensitive);
        }
        if ("C_QUERY_ROOTS".equals(name)) {
            return this.handleQueryRoots(subject, status);
        }
        if ("C_SEARCH".equals(name)) {
            return this.handleSearch(theElement, status, queryType, caseSensitive);
        }
        if ("C_CANCEL".equals(name)) {
            subject.getName();
            return this.handleCancel(subject, status);
        }
        if ("C_RENAME".equals(name)) {
            return this.handleRename(subject, status);
        }
        if ("C_DELETE".equals(name)) {
            return this.handleDelete(subject, status, true);
        }
        if ("C_DELETE_BATCH".equals(name)) {
            return this.handleDeleteBatch(theElement, status);
        }
        if ("C_COPY".equals(name)) {
            return this.handleCopy(subject, this.getCommandArgument(theElement, 1), this.getCommandArgument(theElement, 2), status);
        }
        if ("C_COPY_BATCH".equals(name)) {
            return this.handleCopyBatch(subject, theElement, status);
        }
        if ("C_CREATE_FILE".equals(name)) {
            return this.handleCreateFile(subject, status, queryType);
        }
        if ("C_CREATE_FOLDER".equals(name)) {
            return this.handleCreateFolder(subject, status, queryType);
        }
        if ("C_SET_READONLY".equals(name)) {
            return this.handleSetReadOnly(subject, status);
        }
        if ("C_SET_LASTMODIFIED".equals(name)) {
            return this.handleSetLastModified(subject, status);
        }
        if ("C_QUERY_BASIC_PROPERTY".equals(name)) {
            return this.handleQueryBasicProperty(subject, status);
        }
        if ("C_QUERY_CAN_WRITE_PROPERTY".equals(name)) {
            return this.handleQuerycanWriteProperty(subject, status);
        }
        if ("C_QUERY_ADVANCE_PROPERTY".equals(name)) {
            return this.handleQueryAdvanceProperty(subject, status);
        }
        if ("C_QUERY_EXISTS".equals(name)) {
            return this.handleQueryExists(subject, status, queryType);
        }
        if ("C_QUERY_GET_REMOTE_OBJECT".equals(name)) {
            return this.handleQueryGetRemoteObject(subject, status, queryType);
        }
        if ("C_GET_OSTYPE".equals(name)) {
            return this.handleGetOSType(subject, status);
        }
        if ("C_DOWNLOAD_FILE".equals(name)) {
            return this.handleDownload(theElement, status);
        }
        if ("C_SYSTEM_ENCODING".equals(name)) {
            return this.handleQueryEncoding(subject, status);
        }
        if ("C_QUERY_UNUSED_PORT".equals(name)) {
            return this.handleQueryUnusedPort(subject, status);
        }
        if ("C_QUERY_CLASSNAME".equals(name)) {
            return this.handleQueryClassName(subject, status);
        }
        if ("C_QUERY_QUALIFIED_CLASSNAME".equals(name)) {
            return this.handleQueryQualifiedClassName(subject, status);
        }
        if ("C_QUERY_FILE_PERMISSIONS".equals(name)) {
            return this.handleQueryFilePermissions(subject, status);
        }
        if ("C_SET_FILE_PERMISSIONS".equals(name)) {
            DataElement newPermissions = this.getCommandArgument(theElement, 1);
            return this.handleSetFilePermissions(subject, newPermissions, status);
        }
        UniversalServerUtilities.logError(CLASSNAME, "Invalid query to handlecommand", null, this._dataStore);
        return status;
    }

    private DataElement handleCopyBatch(DataElement targetFolder, DataElement theElement, DataElement status) {
        CopyBatchThread copyBatchThread = new CopyBatchThread(targetFolder, theElement, this, this._isWindows, status);
        copyBatchThread.start();
        this.updateCancellableThreads(status.getParent(), copyBatchThread);
        return status;
    }

    public DataElement handleSearch(DataElement theElement, DataElement status, String queryType, boolean fileNamesCaseSensitive) {
        File fileobj = null;
        DataElement subject = this.getCommandArgument(theElement, 0);
        if (!(queryType.equals("universal.FolderObject") || queryType.equals("universal.ArchiveFileObject") || queryType.equals("universal.VirtualFolderObject"))) {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleSearch", null, this._dataStore);
            return this.statusDone(status);
        }
        fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        boolean continueSearch = true;
        if (!queryType.equals("universal.VirtualFolderObject") && !fileobj.exists()) {
            continueSearch = false;
        }
        if (continueSearch) {
            DataElement arg1 = this.getCommandArgument(theElement, 1);
            DataElement arg2 = this.getCommandArgument(theElement, 2);
            DataElement arg3 = this.getCommandArgument(theElement, 3);
            String textString = arg1.getType();
            boolean isCaseSensitive = Boolean.valueOf(arg1.getName());
            boolean isTextRegex = Boolean.valueOf(arg1.getSource());
            String fileNamesString = arg2.getType();
            boolean isFileNamesRegex = Boolean.valueOf(arg2.getName());
            String classification = arg2.getSource();
            boolean isIncludeArchives = Boolean.valueOf(arg3.getType());
            boolean isIncludeSubfolders = Boolean.valueOf(arg3.getName());
            Boolean.valueOf(arg3.getSource()).booleanValue();
            SystemSearchString searchString = new SystemSearchString(textString, isCaseSensitive, isTextRegex, fileNamesString, isFileNamesRegex, isIncludeArchives, isIncludeSubfolders, classification);
            UniversalSearchHandler searchThread = new UniversalSearchHandler(this._dataStore, this, searchString, !this._isWindows, fileobj, status);
            searchThread.start();
            this.updateCancellableThreads(status.getParent(), searchThread);
        }
        return status;
    }

    public DataElement handleCancel(DataElement subject, DataElement status) {
        ICancellableHandler thread = (ICancellableHandler)this._cancellableThreads.get(subject);
        if (thread != null && !thread.isDone()) {
            thread.cancel();
        }
        this.statusCancelled(status);
        return this.statusDone(status);
    }

    public DataElement handleQueryAll(DataElement subject, DataElement attributes, DataElement status, String queryType, boolean caseSensitive) throws SystemMessageException {
        boolean isArchive = false;
        String fullName = subject.getValue();
        if (queryType.equals("universal.FilterObject")) {
            isArchive = ArchiveHandlerManager.getInstance().isArchive(new File(fullName)) ? true : ArchiveHandlerManager.isVirtual((String)fullName);
        } else if (queryType.equals("universal.ArchiveFileObject") || queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
            isArchive = true;
        }
        if (isArchive) {
            return this.handleQueryAllArchive(subject, attributes, status, caseSensitive, false);
        }
        File fileobj = null;
        String filter = null;
        if (attributes != null) {
            filter = this.getFilterString(attributes.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(attributes.getAttribute(4));
        } else {
            filter = this.getFilterString(subject.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(subject.getAttribute(4));
        }
        if (queryType.equals("universal.FilterObject")) {
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryAll", null, this._dataStore);
        }
        if (fileobj != null) {
            if (!fileobj.exists()) {
                subject.setAttribute(0, "universal.FilterObject");
                subject.setAttribute(4, this.setProperties(fileobj));
                status.setAttribute(4, "failed with does not exist");
                if (subject.getNestedSize() > 0) {
                    List children = subject.getNestedData();
                    int i = children.size() - 1;
                    while (i >= 0) {
                        this._dataStore.deleteObject(subject, (DataElement)children.get(i));
                        --i;
                    }
                }
                this._dataStore.refresh(subject);
            } else {
                this.internalQueryAll(subject, fileobj, queryType, filter, caseSensitive, 8, status);
                return status;
            }
        }
        return this.statusDone(status);
    }

    protected void internalQueryAll(DataElement subject, File fileobj, String queryType, String filter, boolean caseSensitive, int inclusion, DataElement status) {
        FileQueryThread queryThread = new FileQueryThread(subject, fileobj, queryType, filter, caseSensitive, inclusion, this.showHidden, this._isWindows, status);
        queryThread.start();
        this.updateCancellableThreads(status.getParent(), queryThread);
    }

    private void updateCancellableThreads(DataElement command, ICancellableHandler thread) {
        Iterator iter = this._cancellableThreads.keySet().iterator();
        try {
            while (iter.hasNext()) {
                String threadName = (String)iter.next();
                ICancellableHandler theThread = (ICancellableHandler)this._cancellableThreads.get(threadName);
                if (theThread != null && !theThread.isDone() && !theThread.isCancelled()) continue;
                this._cancellableThreads.remove(threadName);
            }
        }
        catch (Exception e) {
            this._dataStore.trace((Throwable)e);
        }
        this._cancellableThreads.put(command, thread);
    }

    public DataElement handleQueryFiles(DataElement subject, DataElement attributes, DataElement status, String queryType, boolean caseSensitive) throws SystemMessageException {
        File fileobj = null;
        String filter = null;
        if (attributes != null) {
            filter = this.getFilterString(attributes.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(attributes.getAttribute(4));
        } else {
            filter = this.getFilterString(subject.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(subject.getAttribute(4));
        }
        if (queryType.equals("universal.FilterObject")) {
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryFiles", null, this._dataStore);
        }
        if (!fileobj.exists()) {
            subject.setAttribute(0, "universal.FilterObject");
            subject.setAttribute(4, this.setProperties(fileobj));
            status.setAttribute(4, "failed with does not exist");
            if (subject.getNestedSize() > 0) {
                List children = subject.getNestedData();
                int i = children.size() - 1;
                while (i >= 0) {
                    this._dataStore.deleteObject(subject, (DataElement)children.get(i));
                    --i;
                }
            }
        } else {
            this.internalQueryAll(subject, fileobj, queryType, filter, caseSensitive, 2, status);
            return status;
        }
        return this.statusDone(status);
    }

    public DataElement handleQueryFolders(DataElement subject, DataElement attributes, DataElement status, String queryType, boolean caseSensitive) throws SystemMessageException {
        if (queryType.equals("universal.ArchiveFileObject") || queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
            return this.handleQueryAllArchive(subject, attributes, status, caseSensitive, true);
        }
        File fileobj = null;
        String filter = null;
        if (attributes != null) {
            filter = this.getFilterString(attributes.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(attributes.getAttribute(4));
        } else {
            filter = this.getFilterString(subject.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(subject.getAttribute(4));
        }
        if (queryType.equals("universal.FilterObject")) {
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryFolders", null, this._dataStore);
        }
        if (!fileobj.exists()) {
            subject.setAttribute(0, "universal.FilterObject");
            subject.setAttribute(4, this.setProperties(fileobj));
            status.setAttribute(4, "failed with does not exist");
            if (subject.getNestedSize() > 0) {
                List children = subject.getNestedData();
                int i = children.size() - 1;
                while (i >= 0) {
                    this._dataStore.deleteObject(subject, (DataElement)children.get(i));
                    --i;
                }
            }
        } else {
            this.internalQueryAll(subject, fileobj, queryType, filter, caseSensitive, 4, status);
            return status;
        }
        return this.statusDone(status);
    }

    public DataElement handleQueryRoots(DataElement subject, DataElement status) throws SystemMessageException {
        new File(subject.getName());
        DataElement deObj = null;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            String[] ALLDRIVES = new String[]{"c:\\", "d:\\", "e:\\", "f:\\", "g:\\", "h:\\", "i:\\", "j:\\", "k:\\", "l:\\", "m:\\", "n:\\", "o:\\", "p:\\", "q:\\", "r:\\", "s:\\", "t:\\", "u:\\", "v:\\", "w:\\", "x:\\", "y:\\", "z:\\"};
            int idx = 0;
            while (idx < ALLDRIVES.length) {
                File drive = new File(ALLDRIVES[idx]);
                if (drive.exists()) {
                    try {
                        String path = drive.getCanonicalPath();
                        deObj = this._dataStore.createObject(subject, "universal.FolderObject", path);
                        deObj.setAttribute(4, this.setProperties(drive));
                        deObj.setAttribute(2, "");
                        deObj.setAttribute(3, path);
                    }
                    catch (IOException iOException) {
                        return this.statusDone(status);
                    }
                }
                ++idx;
            }
        } else {
            File[] list = File.listRoots();
            int i = 0;
            while (i < list.length) {
                deObj = this._dataStore.createObject(subject, "universal.FolderObject", list[i].getAbsolutePath());
                deObj.setAttribute(4, this.setProperties(list[i]));
                deObj.setAttribute(2, "");
                deObj.setAttribute(3, list[i].getAbsolutePath());
                ++i;
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleDelete(DataElement subject, DataElement status, boolean refreshDataStore) {
        DeleteThread deleteThread = new DeleteThread(subject, this, this._dataStore, false, status);
        deleteThread.start();
        this.updateCancellableThreads(status.getParent(), deleteThread);
        return status;
    }

    private DataElement handleDeleteBatch(DataElement theElement, DataElement status) {
        DeleteThread deleteThread = new DeleteThread(theElement, this, this._dataStore, true, status);
        deleteThread.start();
        this.updateCancellableThreads(status.getParent(), deleteThread);
        return status;
    }

    public DataElement handleRename(DataElement subject, DataElement status) {
        RenameThread renameThread = new RenameThread(subject, this, this._dataStore, status);
        renameThread.start();
        this.updateCancellableThreads(status.getParent(), renameThread);
        return status;
    }

    public DataElement handleCreateFile(DataElement subject, DataElement status, String queryType) {
        CreateFileThread createFileThread = new CreateFileThread(subject, queryType, this, this._dataStore, status);
        createFileThread.start();
        this.updateCancellableThreads(status.getParent(), createFileThread);
        return status;
    }

    public DataElement handleCreateFolder(DataElement subject, DataElement status, String queryType) {
        CreateFolderThread createFolderThread = new CreateFolderThread(subject, queryType, this, this._dataStore, status);
        createFolderThread.start();
        this.updateCancellableThreads(status.getParent(), createFolderThread);
        return status;
    }

    public DataElement handleSetReadOnly(DataElement subject, DataElement status) {
        File filename = new File(subject.getAttribute(3), subject.getAttribute(2));
        if (!filename.exists()) {
            filename = new File(subject.getAttribute(3));
        }
        if (!filename.exists()) {
            status.setAttribute(4, "failed with does not exist");
        } else {
            try {
                String str = subject.getAttribute(4);
                boolean readOnly = "true".equals(str);
                boolean done = false;
                if (readOnly != filename.canWrite()) {
                    done = true;
                } else if (readOnly) {
                    done = filename.setReadOnly();
                } else if (!this._isWindows) {
                    String[] cmd = new String[]{"chmod", "u+w", filename.getAbsolutePath()};
                    Process p = Runtime.getRuntime().exec(cmd);
                    int exitValue = p.waitFor();
                    done = exitValue == 0;
                } else {
                    String[] cmd = new String[]{"attrib", "-R", filename.getAbsolutePath()};
                    Process p = Runtime.getRuntime().exec(cmd);
                    int exitValue = p.waitFor();
                    boolean bl = done = exitValue == 0;
                }
                if (done) {
                    status.setAttribute(4, "success");
                } else {
                    status.setAttribute(4, "failed");
                }
                filename = new File(filename.getAbsolutePath());
                subject.setAttribute(4, this.setProperties(filename));
                this._dataStore.refresh(subject);
            }
            catch (Exception e) {
                UniversalServerUtilities.logError(CLASSNAME, "handleSetreadOnly", e, this._dataStore);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleSetLastModified(DataElement subject, DataElement status) {
        File filename = new File(subject.getAttribute(3), subject.getAttribute(2));
        if (!filename.exists()) {
            filename = new File(subject.getAttribute(3));
        }
        if (!filename.exists()) {
            status.setAttribute(4, "failed with does not exist");
        } else {
            try {
                String str = subject.getAttribute(4);
                long date = Long.parseLong(str);
                boolean done = filename.setLastModified(date);
                if (done) {
                    status.setAttribute(4, "success");
                } else {
                    status.setAttribute(4, "failed");
                }
                filename = new File(filename.getAbsolutePath());
                subject.setAttribute(4, this.setProperties(filename));
                this._dataStore.refresh(subject);
            }
            catch (Exception e) {
                UniversalServerUtilities.logError(CLASSNAME, "handleSetLastModified", e, this._dataStore);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQueryBasicProperty(DataElement subject, DataElement status) throws SystemMessageException {
        File fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        subject.setAttribute(4, this.setProperties(fileobj));
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQuerycanWriteProperty(DataElement subject, DataElement status) {
        File fileObj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(50);
        boolean canWrite = fileObj.canWrite();
        buffer.append(version).append("|").append(canWrite);
        subject.setAttribute(4, buffer.toString());
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQueryAdvanceProperty(DataElement subject, DataElement status) {
        return this.statusDone(status);
    }

    protected DataElement handleQueryExists(DataElement subject, DataElement status, String queryType) throws SystemMessageException {
        File fileobj = null;
        if (queryType.equals("universal.FilterObject")) {
            if (subject.getName().indexOf("#virtual#/") > 0) {
                VirtualChild child = this._archiveHandlerManager.getVirtualObject(subject.getName());
                if (child.exists()) {
                    status.setAttribute(4, "true");
                    return this.statusDone(status);
                }
                status.setAttribute(4, "false");
                return this.statusDone(status);
            }
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FileObject") || queryType.equals("universal.ArchiveFileObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(subject.getAttribute(3));
        } else if (queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
            AbsoluteVirtualPath vpath = this.getAbsoluteVirtualPath(subject);
            ISystemArchiveHandler handler = this._archiveHandlerManager.getRegisteredHandler(new File(vpath.getContainingArchiveString()));
            if (handler == null) {
                status.setAttribute(4, "false");
                return this.statusDone(status);
            }
            VirtualChild child = handler.getVirtualFile(vpath.getVirtualPart(), null);
            if (child.exists()) {
                status.setAttribute(4, "true");
                return this.statusDone(status);
            }
        }
        if (fileobj != null && fileobj.exists()) {
            status.setAttribute(4, "true");
        } else {
            status.setAttribute(4, "false");
        }
        return this.statusDone(status);
    }

    public DataElement handleQueryGetRemoteObject(DataElement subject, DataElement status, String queryType) throws SystemMessageException {
        block29: {
            String path;
            String name;
            File fileobj = null;
            boolean isVirtual = false;
            boolean isFilter = false;
            String fullName = subject.getValue();
            if (queryType.equals("universal.FilterObject")) {
                isFilter = true;
                isVirtual = ArchiveHandlerManager.isVirtual((String)fullName);
                String filterValue = subject.getValue();
                if (filterValue.equals(".")) {
                    filterValue = this._dataStore.getClient() != null ? this._dataStore.getClient().getProperty("user.home") : System.getProperty("user.home");
                    try {
                        fileobj = new File(filterValue).getCanonicalFile();
                    }
                    catch (Exception exception) {
                        fileobj = new File(filterValue);
                    }
                    subject.setAttribute(3, filterValue);
                } else if (!isVirtual) {
                    fileobj = new File(filterValue);
                }
            } else if (queryType.equals("universal.FileObject")) {
                name = subject.getName();
                path = subject.getValue();
                fileobj = new File(path, name);
            } else if (queryType.equals("universal.FolderObject")) {
                name = subject.getName();
                path = subject.getValue();
                fileobj = name.length() == 0 ? new File(path) : new File(path, name);
            } else if (queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
                isVirtual = true;
            } else {
                UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryGetRemoteObject", null, this._dataStore);
                return this.statusDone(status);
            }
            if (!isVirtual && fileobj != null && fileobj.exists()) {
                String oldProperties = subject.getAttribute(4);
                boolean isSymlink = oldProperties != null && oldProperties.indexOf("symbolic link") > 0;
                fullName = fileobj.getAbsolutePath();
                if (fileobj.isFile()) {
                    if (this._archiveHandlerManager.isArchive(fileobj)) {
                        subject.setAttribute(0, "universal.ArchiveFileObject");
                    } else {
                        subject.setAttribute(0, "universal.FileObject");
                    }
                } else {
                    subject.setAttribute(0, "universal.FolderObject");
                }
                String name2 = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
                int lastFileSeparatorIndex = fullName.lastIndexOf(File.separatorChar);
                String path2 = "";
                if (-1 != lastFileSeparatorIndex) {
                    path2 = lastFileSeparatorIndex == 0 ? Character.toString(File.separatorChar) : fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
                }
                subject.setAttribute(2, name2);
                subject.setAttribute(3, path2);
                String properties = this.setProperties(fileobj);
                if (fileobj.isFile() || isSymlink) {
                    FileClassifier classifier = new FileClassifier(subject);
                    subject.setAttribute(4, String.valueOf(properties) + "|" + classifier.classifyFile(fileobj));
                } else {
                    subject.setAttribute(4, String.valueOf(properties) + "|" + "directory");
                }
                status.setAttribute(4, "success");
            } else if (isVirtual) {
                try {
                    String goodFullPath = ArchiveHandlerManager.cleanUpVirtualPath((String)fullName);
                    String goodFullName = null;
                    goodFullName = isFilter ? goodFullPath : String.valueOf(goodFullPath) + "/" + subject.getName();
                    AbsoluteVirtualPath avp = new AbsoluteVirtualPath(goodFullName);
                    VirtualChild child = this._archiveHandlerManager.getVirtualObject(goodFullName);
                    if (child.exists()) {
                        if (child.isDirectory) {
                            subject.setAttribute(0, "universal.VirtualFolderObject");
                            subject.setAttribute(2, child.name);
                            subject.setAttribute(3, String.valueOf(avp.getContainingArchiveString()) + "#virtual#/" + child.path);
                        } else {
                            subject.setAttribute(0, "universal.VirtualFileObject");
                            String name3 = child.name;
                            String path3 = avp.getContainingArchiveString();
                            path3 = String.valueOf(path3) + "#virtual#/" + child.path;
                            subject.setAttribute(2, name3);
                            subject.setAttribute(3, path3);
                        }
                        subject.setAttribute(4, this.setProperties(child));
                        status.setAttribute(4, "success");
                        break block29;
                    }
                    UniversalServerUtilities.logWarning(CLASSNAME, "object does not exist", this._dataStore);
                    subject.setAttribute(4, this.setProperties(child));
                    status.setAttribute(4, "failed with does not exist");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                subject.setAttribute(0, "universal.FilterObject");
                subject.setAttribute(4, this.setProperties(fileobj));
                status.setAttribute(4, "failed with does not exist");
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement getFileElement(DataElement subject, File file) {
        String fileName = file.getName();
        int i = 0;
        while (i < subject.getNestedSize()) {
            DataElement child = subject.get(i);
            if (child.getName().equals(fileName)) {
                String type = subject.getType();
                boolean isfile = file.isFile();
                if (isfile) {
                    return child;
                }
                if (type.equals("universal.FolderObject")) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    protected String getClassificationString(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens < 10) {
            return null;
        }
        return str[10];
    }

    protected String getFilterString(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens > 1) {
            return str[1];
        }
        System.out.println("problem with properties:" + s);
        return "*";
    }

    protected boolean getShowHiddenFlag(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens > 2) {
            return new Boolean(str[2]);
        }
        System.out.println("show hidden flag problem:" + s);
        return true;
    }

    protected int getDepth(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens < 4) {
            return 1;
        }
        return new Integer(str[3]);
    }

    protected DataElement handleDownload(DataElement theElement, DataElement status) {
        UniversalDownloadHandler downloadThread = new UniversalDownloadHandler(this._dataStore, this, theElement, status);
        downloadThread.start();
        this.updateCancellableThreads(status.getParent(), downloadThread);
        return status;
    }

    protected DataElement handleQueryEncoding(DataElement subject, DataElement status) {
        String encoding = System.getProperty("file.encoding");
        subject.setAttribute(3, encoding);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQueryUnusedPort(DataElement subject, DataElement status) {
        int port = -1;
        try {
            ServerSocket socket = new ServerSocket(0);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            UniversalServerUtilities.logError(CLASSNAME, "Can not get unused port", e, this._dataStore);
            port = -1;
        }
        String portNum = String.valueOf(port);
        subject.setAttribute(3, portNum);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement statusDone(DataElement status) {
        status.setAttribute(2, "done");
        this._dataStore.refresh(status);
        return status;
    }

    public DataElement statusCancelled(DataElement status) {
        status.setAttribute(2, "cancelled");
        this._dataStore.refresh(status);
        return status;
    }

    public void load() {
        this.deUFSnode = this._dataStore.createObject(this._minerData, "universal.node", "universal.node");
        this._dataStore.createObject(this.deUFSnode, "universal.node", "universal.temp");
        this._dataStore.createObject(this.deUFSnode, "universal.node", "universal.filters");
        this.deUFSuploadlog = this._dataStore.createObject(this.deUFSnode, "universal.node", "universal.uploadlog");
        UniversalByteStreamHandler universalHandler = new UniversalByteStreamHandler(this._dataStore, this.deUFSuploadlog);
        this._dataStore.registerByteStreamHandler((IByteStreamHandler)universalHandler);
        this._dataStore.refresh(this._minerData);
        this._dataStore.refresh(this.deUFSuploadlog);
        DataElement minerRoot = this._dataStore.getMinerRoot();
        String oldName = "com.ibm.etools.systems.universal.miners.UniversalFileSystemMiner";
        DataElement oldMinerElement = this._dataStore.createObject(minerRoot, "miner", oldName, oldName);
        oldMinerElement.setAttribute(3, "UniveralFileSystemMiner");
        oldMinerElement.setAttribute(4, "7.1.0");
        DataElement oldMinerData = this._dataStore.createObject(oldMinerElement, "data", "Data", oldName);
        DataElement oldDeUFSnode = this._dataStore.createObject(oldMinerData, "universal.node", "universal.node");
        DataElement oldDeUFSuploadlog = this._dataStore.createObject(oldDeUFSnode, "universal.node", "universal.uploadlog");
        class OldUniversalByteStreamHandler
        extends UniversalByteStreamHandler {
            final /* synthetic */ UniversalFileSystemMiner this$0;

            public OldUniversalByteStreamHandler(UniversalFileSystemMiner universalFileSystemMiner, DataStore dataStore, DataElement log) {
                super(dataStore, log);
                this.this$0 = universalFileSystemMiner;
            }

            public String getId() {
                return "com.ibm.etools.systems.universal.miners.UniversalByteStreamHandler";
            }
        }
        OldUniversalByteStreamHandler olduniversalHandler = new OldUniversalByteStreamHandler(this, this._dataStore, oldDeUFSuploadlog);
        this._dataStore.registerByteStreamHandler((IByteStreamHandler)olduniversalHandler);
        this._dataStore.refresh(minerRoot);
        this._dataStore.refresh(oldMinerData);
    }

    public void finish() {
        super.finish();
    }

    protected DataElement handleQueryClassName(DataElement subject, DataElement status) {
        String filename = String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName();
        try {
            ClassFileParser parser = new ClassFileParser(this.getInputStreamForFile(filename));
            String name = parser.getPackageName();
            if (name != null) {
                this._dataStore.createObject(status, "qualifiedClassName", name);
            } else {
                this._dataStore.createObject(status, "qualifiedClassName", "null");
            }
        }
        catch (IOException iOException) {
            this._dataStore.createObject(status, "qualifiedClassName", "null");
        }
        return this.statusDone(status);
    }

    protected DataElement handleQueryQualifiedClassName(DataElement subject, DataElement status) {
        String parentPath = subject.getAttribute(3);
        String sep = File.separator;
        boolean isParentArchive = ArchiveHandlerManager.getInstance().isRegisteredArchive(parentPath);
        boolean isParentVirtual = ArchiveHandlerManager.isVirtual((String)parentPath);
        if (isParentVirtual) {
            sep = "/";
        }
        String filePath = null;
        if (!isParentArchive) {
            if (!parentPath.endsWith(sep)) {
                parentPath = String.valueOf(parentPath) + sep;
            }
            filePath = String.valueOf(parentPath) + subject.getName();
        } else {
            filePath = String.valueOf(parentPath) + "#virtual#/" + subject.getName();
        }
        try {
            String className = null;
            if (!isParentArchive && !isParentVirtual) {
                className = ClassFileUtil.getInstance().getQualifiedClassName(filePath);
            } else {
                int jdx;
                String execJava;
                String classification = SystemFileClassifier.getInstance().classifyFile(filePath);
                int idx = classification.indexOf(execJava = "executable(java:");
                if (idx != -1 && (jdx = classification.indexOf(")", idx += execJava.length())) != -1) {
                    if (jdx > idx) {
                        className = classification.substring(idx, jdx);
                    } else if (jdx == idx) {
                        className = "";
                    }
                }
            }
            if (className != null) {
                this._dataStore.createObject(status, "fullClassName", className);
            } else {
                this._dataStore.createObject(status, "fullClassName", "null");
            }
        }
        catch (IOException iOException) {
            UniversalServerUtilities.logError(CLASSNAME, "I/O error occured trying to read class file " + filePath, null, this._dataStore);
            this._dataStore.createObject(status, "fullClassName", "null");
        }
        return this.statusDone(status);
    }

    public DataElement handleGetOSType(DataElement subject, DataElement status) {
        String osType = System.getProperty("os.name").toLowerCase();
        status.setAttribute(4, osType);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected InputStream getInputStreamForFile(String filename) throws IOException {
        File file = new File(filename);
        return file.toURL().openStream();
    }

    public void extendSchema(DataElement schemaRoot) {
        this._dataStore.find(schemaRoot, 2, "root", 1);
        this.createObjectDescriptor(schemaRoot, "universal.node");
        DataElement tempnode = this.createObjectDescriptor(schemaRoot, "universal.temp");
        DataElement UniversalFilter = this.createObjectDescriptor(schemaRoot, "universal.FilterObject");
        FileDescriptors._deUniversalFileObject = this.createObjectDescriptor(schemaRoot, "universal.FileObject");
        FileDescriptors._deUniversalFolderObject = this.createObjectDescriptor(schemaRoot, "universal.FolderObject");
        FileDescriptors._deUniversalArchiveFileObject = this.createObjectDescriptor(schemaRoot, "universal.ArchiveFileObject");
        FileDescriptors._deUniversalVirtualFileObject = this.createObjectDescriptor(schemaRoot, "universal.VirtualFileObject");
        FileDescriptors._deUniversalVirtualFolderObject = this.createObjectDescriptor(schemaRoot, "universal.VirtualFolderObject");
        this._dataStore.refresh(schemaRoot);
        DataElement cancellable = this._dataStore.find(schemaRoot, 2, "Cancellable", 1);
        DataElement queryAllFilterDescriptor = this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_VIEW_ALL");
        this._dataStore.createReference(cancellable, queryAllFilterDescriptor, "abstracts", "abstracted by");
        DataElement queryFilesFilterDescriptor = this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_VIEW_FILES");
        this._dataStore.createReference(cancellable, queryFilesFilterDescriptor, "abstracts", "abstracted by");
        DataElement queryFolderFilterDescriptor = this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_VIEW_FOLDERS");
        this._dataStore.createReference(cancellable, queryFolderFilterDescriptor, "abstracts", "abstracted by");
        this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_ROOTS");
        DataElement queryAllDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Filter", "C_QUERY_VIEW_ALL");
        this._dataStore.createReference(cancellable, queryAllDescriptor, "abstracts", "abstracted by");
        DataElement queryFilesDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Filter", "C_QUERY_VIEW_FILES");
        this._dataStore.createReference(cancellable, queryFilesDescriptor, "abstracts", "abstracted by");
        DataElement queryFolderDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Filter", "C_QUERY_VIEW_FOLDERS");
        this._dataStore.createReference(cancellable, queryFolderDescriptor, "abstracts", "abstracted by");
        DataElement queryAllArchiveDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "Filter", "C_QUERY_VIEW_ALL");
        this._dataStore.createReference(cancellable, queryAllArchiveDescriptor, "abstracts", "abstracted by");
        DataElement queryFilesArchiveDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "Filter", "C_QUERY_VIEW_FILES");
        this._dataStore.createReference(cancellable, queryFilesArchiveDescriptor, "abstracts", "abstracted by");
        DataElement queryFolderArchiveDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "Filter", "C_QUERY_VIEW_FOLDERS");
        this._dataStore.createReference(cancellable, queryFolderArchiveDescriptor, "abstracts", "abstracted by");
        this.createCommandDescriptor(UniversalFilter, "GetOSType", "C_GET_OSTYPE");
        this.createCommandDescriptor(UniversalFilter, "Exists", "C_QUERY_EXISTS");
        this.createCommandDescriptor(UniversalFilter, "GetRemoteObject", "C_QUERY_GET_REMOTE_OBJECT");
        DataElement createNewFileFromFilterDescriptor = this.createCommandDescriptor(UniversalFilter, "CreateNewFile", "C_CREATE_FILE");
        this._dataStore.createReference(cancellable, createNewFileFromFilterDescriptor, "abstracts", "abstracted by");
        DataElement createNewFolderFromFilterDescriptor = this.createCommandDescriptor(UniversalFilter, "CreateNewFolder", "C_CREATE_FOLDER");
        this._dataStore.createReference(cancellable, createNewFolderFromFilterDescriptor, "abstracts", "abstracted by");
        this.createCommandDescriptor(UniversalFilter, "SetLastModified", "C_SET_LASTMODIFIED");
        this._dataStore.createReference(FileDescriptors._deUniversalFileObject, FileDescriptors._deUniversalArchiveFileObject, "abstracts", "abstracted by");
        this._dataStore.createReference(FileDescriptors._deUniversalFolderObject, FileDescriptors._deUniversalArchiveFileObject, "abstracts", "abstracted by");
        this._dataStore.createReference(FileDescriptors._deUniversalFileObject, FileDescriptors._deUniversalVirtualFileObject, "abstracts", "abstracted by");
        this._dataStore.createReference(FileDescriptors._deUniversalFolderObject, FileDescriptors._deUniversalVirtualFolderObject, "abstracts", "abstracted by");
        DataElement searchDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Search", "C_SEARCH");
        this._dataStore.createReference(cancellable, searchDescriptor, "abstracts", "abstracted by");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetAdvanceProperty", "C_QUERY_ADVANCE_PROPERTY");
        this.createCommandDescriptor(tempnode, "Filter", "C_CREATE_TEMP");
        DataElement deleteFileDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "Delete", "C_DELETE");
        this._dataStore.createReference(cancellable, deleteFileDescriptor, "abstracts", "abstracted by");
        DataElement deleteBatchFileDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "DeleteBatch", "C_DELETE_BATCH");
        this._dataStore.createReference(cancellable, deleteBatchFileDescriptor, "abstracts", "abstracted by");
        DataElement createNewFileDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "CreateNewFile", "C_CREATE_FILE");
        this._dataStore.createReference(cancellable, createNewFileDescriptor, "abstracts", "abstracted by");
        DataElement createNewFolderDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "CreateNewFolder", "C_CREATE_FOLDER");
        this._dataStore.createReference(cancellable, createNewFolderDescriptor, "abstracts", "abstracted by");
        DataElement renameFileDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "Rename", "C_RENAME");
        this._dataStore.createReference(cancellable, renameFileDescriptor, "abstracts", "abstracted by");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "SetReadOnly", "C_SET_READONLY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "SetLastModified", "C_SET_LASTMODIFIED");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetAdvanceProperty", "C_QUERY_ADVANCE_PROPERTY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetBasicProperty", "C_QUERY_BASIC_PROPERTY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetcanWriteProperty", "C_QUERY_CAN_WRITE_PROPERTY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "Exists", "C_QUERY_EXISTS");
        DataElement deleteFolderDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Delete", "C_DELETE");
        this._dataStore.createReference(cancellable, deleteFolderDescriptor, "abstracts", "abstracted by");
        DataElement deleteBatchFolderDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "DeleteBatch", "C_DELETE_BATCH");
        this._dataStore.createReference(cancellable, deleteBatchFolderDescriptor, "abstracts", "abstracted by");
        DataElement renameFolderDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Rename", "C_RENAME");
        this._dataStore.createReference(cancellable, renameFolderDescriptor, "abstracts", "abstracted by");
        DataElement copyFolderDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Copy", "C_COPY");
        this._dataStore.createReference(cancellable, copyFolderDescriptor, "abstracts", "abstracted by");
        DataElement copyBatchFolderDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "CopyBatch", "C_COPY_BATCH");
        this._dataStore.createReference(cancellable, copyBatchFolderDescriptor, "abstracts", "abstracted by");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "SetReadOnly", "C_SET_READONLY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "SetLastModified", "C_SET_LASTMODIFIED");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetBasicProperty", "C_QUERY_BASIC_PROPERTY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetcanWriteProperty", "C_QUERY_CAN_WRITE_PROPERTY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Exists", "C_QUERY_EXISTS");
        DataElement createNewFileInFolderDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "CreateNewFile", "C_CREATE_FILE");
        this._dataStore.createReference(cancellable, createNewFileInFolderDescriptor, "abstracts", "abstracted by");
        DataElement createNewFolderInFolderDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "CreateNewFolder", "C_CREATE_FOLDER");
        this._dataStore.createReference(cancellable, createNewFolderInFolderDescriptor, "abstracts", "abstracted by");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetOSType", "C_GET_OSTYPE");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetOSType", "C_GET_OSTYPE");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetRemoteObject", "C_QUERY_GET_REMOTE_OBJECT");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetRemoteObject", "C_QUERY_GET_REMOTE_OBJECT");
        this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "GetRemoteObject", "C_QUERY_GET_REMOTE_OBJECT");
        this.createCommandDescriptor(FileDescriptors._deUniversalVirtualFileObject, "GetRemoteObject", "C_QUERY_GET_REMOTE_OBJECT");
        this.createCommandDescriptor(FileDescriptors._deUniversalVirtualFolderObject, "GetRemoteObject", "C_QUERY_GET_REMOTE_OBJECT");
        DataElement downloadDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "DownloadFile", "C_DOWNLOAD_FILE");
        this._dataStore.createReference(cancellable, downloadDescriptor, "abstracts", "abstracted by");
        DataElement adownloadDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "DownloadFile", "C_DOWNLOAD_FILE");
        this._dataStore.createReference(cancellable, adownloadDescriptor, "abstracts", "abstracted by");
        this.createCommandDescriptor(tempnode, "SystemEncoding", "C_SYSTEM_ENCODING");
        this.createCommandDescriptor(tempnode, "UnusedPort", "C_QUERY_UNUSED_PORT");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetQualifiedClassName", "C_QUERY_CLASSNAME");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetFullClassName", "C_QUERY_QUALIFIED_CLASSNAME");
        if (!this._isWindows) {
            this.createCommandDescriptor(UniversalFilter, "GetPermissions", "C_QUERY_FILE_PERMISSIONS");
            this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetPermissions", "C_QUERY_FILE_PERMISSIONS");
            this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetPermissions", "C_QUERY_FILE_PERMISSIONS");
            this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "GetPermissions", "C_QUERY_FILE_PERMISSIONS");
            this.createCommandDescriptor(UniversalFilter, "SetPermissions", "C_SET_FILE_PERMISSIONS");
            this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "SetPermissions", "C_SET_FILE_PERMISSIONS");
            this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "SetPermissions", "C_SET_FILE_PERMISSIONS");
            this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "SetPermissions", "C_SET_FILE_PERMISSIONS");
        }
    }

    public AbsoluteVirtualPath getAbsoluteVirtualPath(DataElement subject) {
        StringBuffer path = new StringBuffer(subject.getAttribute(3));
        if (ArchiveHandlerManager.getInstance().isArchive(new File(path.toString()))) {
            path.append("#virtual#/");
        } else {
            path.append('/');
        }
        path.append(subject.getName());
        return this.getAbsoluteVirtualPath(path.toString());
    }

    public AbsoluteVirtualPath getAbsoluteVirtualPath(String path) {
        AbsoluteVirtualPath vp = new AbsoluteVirtualPath(path);
        return vp;
    }

    public DataElement handleQueryAllArchive(DataElement subject, DataElement attributes, DataElement status, boolean caseSensitive, boolean foldersOnly) {
        ArchiveQueryThread queryThread = new ArchiveQueryThread(subject, attributes, caseSensitive, foldersOnly, this.showHidden, this._isWindows, status);
        queryThread.start();
        this.updateCancellableThreads(status.getParent(), queryThread);
        return status;
    }

    public ISystemArchiveHandler getArchiveHandlerFor(String archivePath) throws SystemMessageException {
        File file = new File(archivePath);
        return this._archiveHandlerManager.getRegisteredHandler(file);
    }

    public DataElement handleCopy(DataElement targetFolder, DataElement sourceFile, DataElement nameObj, DataElement status) {
        CopySingleThread copySingleThread = new CopySingleThread(targetFolder, sourceFile, nameObj, this, this._isWindows, status);
        copySingleThread.start();
        this.updateCancellableThreads(status.getParent(), copySingleThread);
        return status;
    }

    public String setProperties(File fileObj, boolean doArchiveProperties) throws SystemMessageException {
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(500);
        long date = fileObj.lastModified();
        long size = fileObj.length();
        boolean hidden = fileObj.isHidden();
        boolean canWrite = fileObj.canWrite();
        boolean canRead = fileObj.canRead();
        boolean isArchive = false;
        String comment = isArchive ? ArchiveHandlerManager.getInstance().getComment(fileObj) : " ";
        long compressedSize = size;
        String compressionMethod = " ";
        double compressionRatio = 0.0;
        long expandedSize = isArchive ? ArchiveHandlerManager.getInstance().getExpandedSize(fileObj) : size;
        buffer.append(version).append("|").append(date).append("|").append(size).append("|");
        buffer.append(hidden).append("|").append(canWrite).append("|").append(canRead);
        buffer.append("|");
        buffer.append(comment).append("|").append(compressedSize).append("|").append(compressionMethod).append("|");
        buffer.append(compressionRatio).append("|").append(expandedSize);
        String buf = buffer.toString();
        return buf;
    }

    public String setProperties(VirtualChild fileObj) {
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(500);
        long date = fileObj.getTimeStamp();
        long size = fileObj.getSize();
        boolean hidden = false;
        boolean canWrite = fileObj.getContainingArchive().canWrite();
        boolean canRead = fileObj.getContainingArchive().canRead();
        String comment = fileObj.getComment();
        if (comment.equals("")) {
            comment = " ";
        }
        long compressedSize = fileObj.getCompressedSize();
        String compressionMethod = fileObj.getCompressionMethod();
        if (compressionMethod.equals("")) {
            compressionMethod = " ";
        }
        double compressionRatio = fileObj.getCompressionRatio();
        long expandedSize = size;
        buffer.append(version).append("|").append(date).append("|").append(size).append("|");
        buffer.append(hidden).append("|").append(canWrite).append("|").append(canRead);
        buffer.append("|");
        buffer.append(comment).append("|").append(compressedSize).append("|").append(compressionMethod).append("|");
        buffer.append(compressionRatio).append("|").append(expandedSize);
        return buffer.toString();
    }

    public String setProperties(File fileObj) throws SystemMessageException {
        return this.setProperties(fileObj, false);
    }

    public String getVersion() {
        return "7.0.0";
    }

    private File getFileFor(DataElement subject) {
        File fileobj = null;
        boolean isVirtual = false;
        String fullName = subject.getValue();
        String queryType = subject.getType();
        if (queryType.equals("universal.FilterObject")) {
            isVirtual = ArchiveHandlerManager.isVirtual((String)fullName);
            String filterValue = subject.getValue();
            if (filterValue.equals(".")) {
                filterValue = this._dataStore.getClient() != null ? this._dataStore.getClient().getProperty("user.home") : System.getProperty("user.home");
                subject.setAttribute(3, filterValue);
            }
            if (!isVirtual) {
                fileobj = new File(filterValue);
            }
        } else if (queryType.equals("universal.FileObject")) {
            String name = subject.getName();
            String path = subject.getValue();
            fileobj = new File(path, name);
        } else if (queryType.equals("universal.FolderObject")) {
            String name = subject.getName();
            String path = subject.getValue();
            fileobj = name.length() == 0 ? new File(path) : new File(path, name);
        } else if (queryType.equals("universal.ArchiveFileObject")) {
            String name = subject.getName();
            String path = subject.getValue();
            fileobj = name.length() == 0 ? new File(path) : new File(path, name);
        } else if (queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
            isVirtual = true;
        }
        return fileobj;
    }

    private String alphaPermissionsToOctal(String alphaPermissions) {
        StringBuffer buf = new StringBuffer();
        char[] chars = alphaPermissions.toCharArray();
        int offset = -1;
        int i = 0;
        while (i < 3) {
            int value = 0;
            if (chars[++offset] == 'r') {
                value = 4;
            }
            if (chars[++offset] == 'w') {
                value += 2;
            }
            if (chars[++offset] == 'x') {
                ++value;
            }
            buf.append(value);
            ++i;
        }
        return buf.toString();
    }

    private DataElement handleQueryFilePermissions(DataElement subject, DataElement status) {
        File file = this.getFileFor(subject);
        if (file == null) {
            return this.statusCancelled(status);
        }
        String result = this.getFilePermission(file, 3);
        status.setAttribute(4, result);
        String theOS = System.getProperty("os.name");
        boolean isZ = theOS.toLowerCase().startsWith("z");
        if (isZ) {
            String path = file.getAbsolutePath();
            try {
                String canonical = file.getCanonicalPath();
                if (!path.equals(canonical)) {
                    String properties = this.setProperties(file, false);
                    String fileType = file.isFile() ? "file" : "directory";
                    StringBuffer type = new StringBuffer("symbolic link");
                    type.append('(');
                    type.append(fileType);
                    type.append(')');
                    type.append(':');
                    type.append(canonical);
                    StringBuffer classifiedProperties = new StringBuffer(properties);
                    classifiedProperties.append('|');
                    classifiedProperties.append(type);
                    subject.setAttribute(4, classifiedProperties.toString());
                    this._dataStore.refresh(subject);
                }
            }
            catch (SystemMessageException systemMessageException) {
            }
            catch (IOException iOException) {}
        }
        this.statusDone(status);
        return status;
    }

    private String getFilePermission(File file, int permission) {
        String ldStr = this.simpleShellCommand("ls -ld", file);
        StringTokenizer tokenizer = new StringTokenizer(ldStr, " \t");
        String permString = tokenizer.nextToken().substring(1);
        String octalPermissions = this.alphaPermissionsToOctal(permString);
        tokenizer.nextToken();
        String user = tokenizer.nextToken();
        String group = tokenizer.nextToken();
        String result = null;
        switch (permission) {
            case 2: {
                result = octalPermissions;
                break;
            }
            case 0: {
                result = user;
                break;
            }
            case 1: {
                result = group;
                break;
            }
            default: {
                result = String.valueOf(octalPermissions) + '|' + user + '|' + group;
            }
        }
        return result;
    }

    private DataElement handleSetFilePermissions(DataElement subject, DataElement newPermissions, DataElement status) {
        File file = this.getFileFor(subject);
        String permissionsStr = newPermissions.getName();
        String[] permAttributes = permissionsStr.split("\\|");
        String result = this.simpleShellCommand("chmod " + permAttributes[0], file);
        String previousGroup = this.getFilePermission(file, 1);
        String previousUser = this.getFilePermission(file, 0);
        if (!previousUser.equals(permAttributes[1]) || !previousGroup.equals(permAttributes[2])) {
            this.simpleShellCommand("chown " + permAttributes[1] + ":" + permAttributes[2], file);
        }
        status.setAttribute(4, result);
        this.statusDone(status);
        return status;
    }

    private String simpleShellCommand(String cmd, File file) {
        String result = null;
        String[] args = new String[]{"sh", "-c", String.valueOf(cmd) + " " + PathUtility.enQuoteUnix((String)file.getAbsolutePath())};
        BufferedReader childReader = null;
        try {
            Process childProcess = Runtime.getRuntime().exec(args);
            childReader = new BufferedReader(new InputStreamReader(childProcess.getInputStream()));
            result = childReader.readLine().trim();
            childReader.close();
        }
        catch (Exception exception) {
            try {
                childReader.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }
}

