/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import org.eclipse.titan.runtime.core.Index_Redirect;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanAlt_Status;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanComponent_template;
import org.eclipse.titan.runtime.core.TitanFloat;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanPort;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanPort_Array<T extends TitanPort>
extends TitanPort {
    private TitanPort[] array_elements;
    private String[] names;
    private Class<T> clazz;
    private int array_size;
    private int indexofset;

    public TitanPort_Array(TitanPort_Array<T> otherValue) {
        this.clazz = otherValue.clazz;
        this.array_size = otherValue.array_size;
        this.indexofset = otherValue.indexofset;
        this.array_elements = new TitanPort[this.array_size];
        this.names = new String[this.array_size];
        for (int i = 0; i < this.array_size; ++i) {
            this.array_elements[i] = otherValue.array_elements[i];
            this.names[i] = otherValue.names[i];
        }
    }

    public TitanPort_Array(Class<T> clazz, int size, int offset) {
        this.clazz = clazz;
        this.indexofset = offset;
        this.array_elements = new TitanPort[size];
        this.names = new String[size];
        this.set_size(size);
    }

    public void set_size(int length) {
        for (int i = this.array_size; i < length; ++i) {
            try {
                TitanPort empty;
                this.array_elements[i] = empty = (TitanPort)this.clazz.newInstance();
                continue;
            }
            catch (InstantiationException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
            catch (IllegalAccessException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
        }
        this.array_size = length;
    }

    public TitanPort_Array<T> operator_assign(TitanPort_Array<T> otherValue) {
        this.array_size = otherValue.array_size;
        this.indexofset = otherValue.indexofset;
        this.clazz = otherValue.clazz;
        this.array_elements = new TitanPort[this.array_size];
        this.names = new String[this.array_size];
        for (int i = 0; i < this.array_size; ++i) {
            this.array_elements[i] = otherValue.array_elements[i];
            this.names[i] = otherValue.names[i];
        }
        return this;
    }

    public T get_at(int index_value) {
        return (T)this.array_elements[TitanPort_Array.get_port_array_index(index_value, this.array_size, this.indexofset)];
    }

    public T get_at(TitanInteger index_value) {
        return (T)this.array_elements[TitanPort_Array.get_port_array_index(index_value.get_int(), this.array_size, this.indexofset)];
    }

    public final T constGet_at(int index_value) {
        return this.get_at(index_value);
    }

    public final T constGet_at(TitanInteger index_value) {
        return this.get_at(index_value);
    }

    public int n_elem() {
        return this.array_size;
    }

    public int size_of() {
        return this.array_size;
    }

    public int lengthof() {
        return this.array_size;
    }

    @Override
    public void set_name(String name_string) {
        for (int i = 0; i < this.array_size; ++i) {
            this.names[i] = name_string + '[' + i + ']';
            this.array_elements[i].set_name(this.names[i]);
        }
    }

    @Override
    public void activate_port(boolean system) {
        for (int v_index = 0; v_index < this.array_size; ++v_index) {
            this.array_elements[v_index].activate_port(system);
        }
    }

    @Override
    public void safe_start() {
        for (int v_index = 0; v_index < this.array_size; ++v_index) {
            this.array_elements[v_index].safe_start();
        }
    }

    @Override
    public void log() {
        TTCN_Logger.log_event_str("{ ");
        for (int v_index = 0; v_index < this.array_size; ++v_index) {
            if (v_index > 0) {
                TTCN_Logger.log_event_str(", ");
            }
            this.array_elements[v_index].log();
        }
        TTCN_Logger.log_event_str(" }");
    }

    @Override
    public TitanAlt_Status receive(TitanComponent_template sender_template, TitanComponent sender_ptr, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].receive(sender_template, sender_ptr, timestemp_redirect, index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexofset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    @Override
    public TitanAlt_Status check_receive(TitanComponent_template sender_template, TitanComponent sender_ptr, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].check_receive(sender_template, sender_ptr, timestemp_redirect, index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexofset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    @Override
    public TitanAlt_Status trigger(TitanComponent_template sender_template, TitanComponent sender_ptr, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].trigger(sender_template, sender_ptr, timestemp_redirect, index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexofset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    @Override
    public TitanAlt_Status getcall(TitanComponent_template sender_template, TitanComponent sender_ptr, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].getcall(sender_template, sender_ptr, timestemp_redirect, index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexofset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    @Override
    public TitanAlt_Status check_getcall(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].check_getcall(sender_template, sender_pointer, timestemp_redirect, index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexofset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    @Override
    public TitanAlt_Status getreply(TitanComponent_template sender_template, TitanComponent sender_ptr, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].getreply(sender_template, sender_ptr, timestemp_redirect, index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexofset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    @Override
    public TitanAlt_Status check_getreply(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].check_getreply(sender_template, sender_pointer, timestemp_redirect, index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexofset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    @Override
    public TitanAlt_Status get_exception(TitanComponent_template sender_template, TitanComponent sender_ptr, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].get_exception(sender_template, sender_ptr, timestemp_redirect, index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexofset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    @Override
    public TitanAlt_Status check_catch(TitanComponent_template sender_template, TitanComponent sender_ptr, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].check_catch(sender_template, sender_ptr, timestemp_redirect, index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexofset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    @Override
    public TitanAlt_Status check(TitanComponent_template sender_template, TitanComponent sender_ptr, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].check(sender_template, sender_ptr, timestemp_redirect, index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexofset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    public static int get_port_array_index(int index_value, int array_size, int index_offset) {
        if (index_value < index_offset) {
            throw new TtcnError(MessageFormat.format("Index underflow when accessing an element of a port array. The index value should be between {0} and {1} instead of {2}.", index_offset, index_offset + array_size - 1, index_value));
        }
        int ret_val = index_value - index_offset;
        if (ret_val >= array_size) {
            throw new TtcnError(MessageFormat.format("Index overflow when accessing an element of a port array. The index value should be between {0} and {1} instead of {2}.", index_offset, index_offset + array_size - 1, index_value));
        }
        return ret_val;
    }

    public static int get_port_array_index(TitanInteger index_value, int array_size, int index_offset) {
        index_value.must_bound("Accessing an element of a port array using an unbound index.");
        return TitanPort_Array.get_port_array_index(index_value.get_int(), array_size, index_offset);
    }
}

