/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.logging.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.Definition_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Log_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titanium.refactoring.logging.ContextLoggingRefactoring;
import org.eclipse.titanium.refactoring.logging.context.Context;

public class StatementBlockContext
extends Context {
    private List<Identifier> localVarIds;

    StatementBlockContext(StatementBlock st, ContextLoggingRefactoring.Settings settings) {
        super((IVisitableNode)st, settings);
    }

    public StatementBlock getNode() {
        return (StatementBlock)super.getNode();
    }

    @Override
    protected void process_internal() {
        this.localVarIds = new ArrayList<Identifier>();
        Context bottom = this.getBottom();
        IVisitableNode bottomNode = bottom.getNode();
        if (!(bottomNode instanceof Log_Statement)) {
            ErrorReporter.logError((String)"StatementBlockContext.process_internal(): Warning! Context chain bottom node is not a Log_Statement! ");
            return;
        }
        Log_Statement logst = (Log_Statement)bottomNode;
        Location logLoc = logst.getLocation();
        StatementBlock sb = this.getNode();
        StatementBlockVisitor vis = new StatementBlockVisitor(logLoc);
        sb.accept((ASTVisitor)vis);
        this.localVarIds.addAll(vis.getIdsFound());
    }

    @Override
    protected List<String> createLogParts_internal(Set<String> idsAlreadyHandled) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.localVarIds == null) {
            return ret;
        }
        for (Identifier id : this.localVarIds) {
            String idS = id.toString();
            if (idsAlreadyHandled.contains(idS)) continue;
            idsAlreadyHandled.add(idS);
            ret.add(this.formatLogPart(idS));
        }
        return ret;
    }

    private static boolean isLocationBefore(Location l1, Location l2) {
        return l1.getEndOffset() <= l2.getOffset();
    }

    private static class StatementBlockVisitor
    extends ASTVisitor {
        private final Location beforeLoc;
        private final List<Identifier> idsFound;

        public StatementBlockVisitor(Location beforeLoc) {
            this.beforeLoc = beforeLoc;
            this.idsFound = new ArrayList<Identifier>();
        }

        public List<Identifier> getIdsFound() {
            return this.idsFound;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Statement) {
                Definition_Statement defst;
                Definition def;
                Statement st = (Statement)node;
                if (!StatementBlockContext.isLocationBefore(st.getLocation(), this.beforeLoc)) {
                    return 1;
                }
                if (st instanceof Definition_Statement && (def = (defst = (Definition_Statement)st).getDefinition()) != null && def instanceof Def_Var) {
                    this.idsFound.add(((Def_Var)def).getIdentifier());
                }
                return 1;
            }
            return 3;
        }
    }
}

