/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.logging;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.refactoring.logging.ChangeCreator;

public class ContextLoggingRefactoring
extends Refactoring {
    private final IFile selectedFile;
    private final ISelection selection;
    private final Settings settings;
    private Object[] affectedObjects;

    public ContextLoggingRefactoring(IStructuredSelection selection, Settings settings) {
        this.selectedFile = null;
        this.selection = selection;
        this.settings = settings == null ? new Settings() : settings;
    }

    public ContextLoggingRefactoring(IFile selectedFile, ITextSelection selection, Settings settings) {
        this.selectedFile = selectedFile;
        this.selection = selection;
        this.settings = settings == null ? new Settings() : settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Object[] getAffectedObjects() {
        return this.affectedObjects;
    }

    public String getName() {
        return "Add context info to log statements";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.selection == null) {
            ErrorReporter.logError((String)"ContextLoggingRefactoring: Selection is null! ");
            return null;
        }
        if (this.selection instanceof IStructuredSelection) {
            CompositeChange cchange = new CompositeChange("ContextLoggingRefactoring");
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            for (Object o : ssel) {
                if (!(o instanceof IResource)) continue;
                IResource res = (IResource)o;
                ResourceVisitor vis = new ResourceVisitor();
                res.accept((IResourceVisitor)vis);
                cchange.add((Change)vis.getChange());
            }
            this.affectedObjects = cchange.getAffectedObjects();
            return cchange;
        }
        if (this.selection instanceof TextSelection) {
            ChangeCreator chCreator = new ChangeCreator(this.selectedFile, (ITextSelection)((TextSelection)this.selection), this.settings);
            chCreator.perform();
            Change ch = chCreator.getChange();
            if (ch == null) {
                this.affectedObjects = new Object[0];
                return new CompositeChange("EmptyLoggingRefactoring");
            }
            this.affectedObjects = ch.getAffectedObjects();
            return ch;
        }
        return null;
    }

    public static class Settings {
        public static final int SETTING_LOG_FUNCPAR = 1;
        public static final int SETTING_LOG_IF = 2;
        public static final int SETTING_LOG_LOOP = 4;
        public static final int SETTING_LOG_LOCAL_VARS = 8;
        public static final int SETTING_LOG_LOCAL_VARS_PARENT_BLOCK_ONLY = 16;
        public static final int SETTING_MODIFY_LOG_STATEMENTS = 32;
        private int settings = 0;
        private int countLimit;

        public Settings() {
            this.createDefaultSettings();
        }

        private void createDefaultSettings() {
            this.setSetting(1, true);
            this.setSetting(2, true);
            this.setSetting(8, false);
            this.setSetting(16, false);
            this.setSetting(4, true);
            this.setSetting(32, true);
            this.countLimit = 8;
        }

        public int getCountLimit() {
            return this.countLimit;
        }

        public void setCountLimit(int countLimit) {
            this.countLimit = countLimit;
        }

        public boolean getSetting(int setting) {
            return (this.settings & setting) == setting;
        }

        public void setSetting(int setting, boolean value) {
            boolean prevVal = this.getSetting(setting);
            if (prevVal == value) {
                return;
            }
            this.settings = value ? (this.settings += setting) : (this.settings -= setting);
        }
    }

    private class ResourceVisitor
    implements IResourceVisitor {
        private final CompositeChange change = new CompositeChange("ContextLoggingRefactoring");

        private CompositeChange getChange() {
            return this.change;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                ChangeCreator chCreator = new ChangeCreator((IFile)resource, ContextLoggingRefactoring.this.settings);
                chCreator.perform();
                Change ch = chCreator.getChange();
                if (ch != null) {
                    this.change.add(ch);
                }
                return false;
            }
            return true;
        }
    }
}

