/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ControlPart;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.Alt_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Break_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Continue_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.DoWhile_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.For_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Goto_statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Interleave_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Label_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.statements.While_Statement;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.function.ExtractToFunctionRefactoring;
import org.eclipse.titanium.refactoring.function.ReturnVisitor;
import org.eclipse.titanium.refactoring.function.StatementList;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

class SelectionFinder {
    private static final String ERR_MSG_NO_SELECTION = "No statements to extract were found in the selection! ";
    private static final String WARNING_ERRONEOUS_GOTO = "A goto statement was found pointing out of the selection. The operation might produce an erroneous result. ";
    private static final String WARNING_ERRONEOUS_LABEL = "An external goto statement was found pointing into the selection. The operation might produce an erroneous result. ";
    private static final String WARNING_ERRONEOUS_BREAK = "A break statement was found to be referring to a loop/alt/interleave statement from outside the selection. The operation might produce an erroneous result. ";
    private static final String WARNING_ERRONEOUS_CONTINUE = "A continue statement was found to be referring to a loop statement from outside the selection. The operation might produce an erroneous result. ";
    private static final String WARNING_UNCERTAIN_RETURN = "The code to be extracted contains conditionally executed return statements. The operation might produce an erroneous result. ";
    private ITextSelection textSelection;
    private ProjectSourceParser sourceParser;
    private IProject project;
    private Module selectedModule;
    private IFile selectedFile;
    private StatementList selectedStatements;
    private final List<RefactoringStatusEntry> warnings;
    private Reference runsOnRef;
    private Type returnType;
    private IVisitableNode parentFunc;
    private int insertLoc = -1;
    private ReturnVisitor.ReturnCertainty returnCertainty = ReturnVisitor.ReturnCertainty.NO;

    SelectionFinder() {
        this.warnings = new ArrayList<RefactoringStatusEntry>();
    }

    List<RefactoringStatusEntry> getWarnings() {
        return this.warnings;
    }

    Module getModule() {
        return this.selectedModule;
    }

    IFile getSelectedFile() {
        return this.selectedFile;
    }

    StatementList getSelectedStatements() {
        return this.selectedStatements;
    }

    Reference getRunsOnRef() {
        return this.runsOnRef;
    }

    Type getReturnType() {
        return this.returnType;
    }

    IVisitableNode getParentFunc() {
        return this.parentFunc;
    }

    int getInsertLoc() {
        return this.insertLoc;
    }

    ReturnVisitor.ReturnCertainty getReturnCertainty() {
        return this.returnCertainty;
    }

    ProjectSourceParser getProjectSourceParser() {
        return this.sourceParser;
    }

    IProject getProject() {
        return this.project;
    }

    boolean isSelectionValid() {
        return this.selectedStatements != null && !this.selectedStatements.isEmpty();
    }

    void performHeadless(IFile selFile, ITextSelection textSel) {
        this.selectedFile = selFile;
        String fileContents = this.readFileContents(selFile);
        if (fileContents == null) {
            ErrorReporter.logError((String)("ExtractToFunctionRefactoring.findSelection(): selFile does not exist at: " + selFile.getFullPath()));
            return;
        }
        Document doc = new Document(fileContents);
        this.textSelection = new TextSelection((IDocument)doc, textSel.getOffset(), textSel.getLength());
        this.project = selFile.getProject();
        this.sourceParser = GlobalParser.getProjectSourceParser((IProject)this.project);
        this.selectedModule = this.sourceParser.containedModule(this.selectedFile);
        if (this.selectedModule == null) {
            ErrorReporter.logError((String)("ExtractToFunctionRefactoring.findSelection(): The module in the file " + this.selectedFile.getName() + " has no name."));
            return;
        }
        SelectionVisitor selectionVisitor = new SelectionVisitor(this.textSelection.getOffset(), this.textSelection.getLength());
        this.selectedModule.accept((ASTVisitor)selectionVisitor);
        this.selectedStatements = selectionVisitor.createStatementList(this.textSelection);
        if (this.selectedStatements.isEmpty()) {
            ErrorReporter.logError((String)ERR_MSG_NO_SELECTION);
            return;
        }
        RunsOnClauseFinder runsonVisitor = new RunsOnClauseFinder(this.selectedStatements.getLocation());
        this.selectedModule.accept((ASTVisitor)runsonVisitor);
        this.runsOnRef = runsonVisitor.getRunsOnRef();
        this.parentFunc = runsonVisitor.getFuncDef();
        if (this.parentFunc instanceof Definition) {
            this.insertLoc = ((Definition)this.parentFunc).getLocation().getEndOffset();
        } else if (this.parentFunc instanceof ControlPart) {
            ControlPart cp = (ControlPart)this.parentFunc;
            Location commentLoc = cp.getCommentLocation();
            this.insertLoc = commentLoc == null ? cp.getLocation().getOffset() : commentLoc.getOffset();
        }
        ReturnVisitor retVis = new ReturnVisitor();
        this.selectedStatements.accept(retVis);
        this.returnCertainty = retVis.getCertainty();
        if (retVis.getCertainty() != ReturnVisitor.ReturnCertainty.NO) {
            this.returnType = runsonVisitor.getReturnType();
        }
        this.checkErroneousGoto();
        if (this.containsBreakWithoutLoop()) {
            this.warnings.add(new RefactoringStatusEntry(2, WARNING_ERRONEOUS_BREAK));
        }
        if (this.containsContinueWithoutLoop()) {
            this.warnings.add(new RefactoringStatusEntry(2, WARNING_ERRONEOUS_CONTINUE));
        }
        if (retVis.getCertainty() == ReturnVisitor.ReturnCertainty.MAYBE) {
            this.warnings.add(new RefactoringStatusEntry(2, WARNING_UNCERTAIN_RETURN));
        }
    }

    void perform() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof TTCN3Editor)) {
            return;
        }
        TTCN3Editor targetEditor = (TTCN3Editor)editor;
        IStatusLineManager statusLineManager = targetEditor.getEditorSite().getActionBars().getStatusLineManager();
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        this.textSelection = this.extractSelection(selectionService.getSelection());
        if (this.textSelection == null) {
            ErrorReporter.logError((String)"No valid statements were found in the selection.");
            ExtractToFunctionRefactoring.setStatusLineMsg(ERR_MSG_NO_SELECTION, statusLineManager);
            return;
        }
        IResource selectedRes = this.extractResource((IEditorPart)targetEditor);
        if (!(selectedRes instanceof IFile)) {
            ErrorReporter.logError((String)("ExtractToFunctionRefactoring.findSelection(): Selected resource `" + selectedRes.getName() + "' is not a file."));
            return;
        }
        this.selectedFile = (IFile)selectedRes;
        this.project = this.selectedFile.getProject();
        this.sourceParser = GlobalParser.getProjectSourceParser((IProject)this.project);
        this.selectedModule = this.sourceParser.containedModule(this.selectedFile);
        SelectionVisitor selectionVisitor = new SelectionVisitor(this.textSelection.getOffset(), this.textSelection.getLength());
        this.selectedModule.accept((ASTVisitor)selectionVisitor);
        this.selectedStatements = selectionVisitor.createStatementList(this.textSelection);
        if (this.selectedStatements.isEmpty()) {
            ExtractToFunctionRefactoring.setStatusLineMsg(ERR_MSG_NO_SELECTION, statusLineManager);
            return;
        }
        RunsOnClauseFinder runsonVisitor = new RunsOnClauseFinder(this.selectedStatements.getLocation());
        this.selectedModule.accept((ASTVisitor)runsonVisitor);
        this.runsOnRef = runsonVisitor.getRunsOnRef();
        this.parentFunc = runsonVisitor.getFuncDef();
        if (this.parentFunc instanceof Definition) {
            this.insertLoc = ((Definition)this.parentFunc).getLocation().getEndOffset();
        } else if (this.parentFunc instanceof ControlPart) {
            ControlPart cp = (ControlPart)this.parentFunc;
            Location commentLoc = cp.getCommentLocation();
            this.insertLoc = commentLoc == null ? cp.getLocation().getOffset() : commentLoc.getOffset();
        }
        ReturnVisitor retVis = new ReturnVisitor();
        this.selectedStatements.accept(retVis);
        this.returnCertainty = retVis.getCertainty();
        if (retVis.getCertainty() != ReturnVisitor.ReturnCertainty.NO) {
            this.returnType = runsonVisitor.getReturnType();
        }
        this.checkErroneousGoto();
        if (this.containsBreakWithoutLoop()) {
            this.warnings.add(new RefactoringStatusEntry(2, WARNING_ERRONEOUS_BREAK));
        }
        if (this.containsContinueWithoutLoop()) {
            this.warnings.add(new RefactoringStatusEntry(2, WARNING_ERRONEOUS_CONTINUE));
        }
        if (retVis.getCertainty() == ReturnVisitor.ReturnCertainty.MAYBE) {
            this.warnings.add(new RefactoringStatusEntry(2, WARNING_UNCERTAIN_RETURN));
        }
    }

    private IResource extractResource(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)input).getFile();
    }

    private TextSelection extractSelection(ISelection sel) {
        if (!(sel instanceof TextSelection)) {
            ErrorReporter.logError((String)"ExtractToFunctionRefactoring.extractSelection(): selection is not a TextSelection");
            return null;
        }
        return (TextSelection)sel;
    }

    private String readFileContents(IFile toRead) {
        if (toRead == null || !toRead.exists()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            char[] buf = new char[1024];
            InputStream is = toRead.getContents();
            InputStreamReader isr = new InputStreamReader(is, toRead.getCharset());
            while (isr.ready()) {
                isr.read(buf);
                sb.append(buf);
            }
            isr.close();
            is.close();
        }
        catch (CoreException ce) {
            ErrorReporter.logError((String)("ExtractToFunctionRefactoring.readFileContents(): CoreException while reading file: " + toRead.getFullPath()));
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        catch (IOException ioe) {
            ErrorReporter.logError((String)("ExtractToFunctionRefactoring.readFileContents(): IOException while reading file: " + toRead.getFullPath()));
            ErrorReporter.logExceptionStackTrace((Exception)ioe);
        }
        return sb.toString();
    }

    private void checkErroneousGoto() {
        if (this.selectedStatements == null) {
            return;
        }
        GotoFinder vis = new GotoFinder();
        this.selectedStatements.accept(vis);
        List gotos = vis.getGotoStatements();
        List labels = vis.getLabelStatements();
        if (!labels.containsAll(gotos)) {
            this.warnings.add(new RefactoringStatusEntry(2, WARNING_ERRONEOUS_GOTO));
        }
        if (!gotos.containsAll(labels)) {
            this.warnings.add(new RefactoringStatusEntry(2, WARNING_ERRONEOUS_LABEL));
        }
    }

    private boolean containsBreakWithoutLoop() {
        if (this.selectedStatements == null) {
            return false;
        }
        BreakFinder vis = new BreakFinder();
        this.selectedStatements.accept(vis);
        return vis.isFound();
    }

    private boolean containsContinueWithoutLoop() {
        if (this.selectedStatements == null) {
            return false;
        }
        ContinueFinder vis = new ContinueFinder();
        this.selectedStatements.accept(vis);
        return vis.isFound();
    }

    private String createDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExtractToFunctionRefactoring->SelectionFinder debug info: \n");
        sb.append("  Runs on reference: ");
        sb.append((Object)(this.runsOnRef == null ? "null" : this.runsOnRef.getId()));
        sb.append(", enclosing function: ");
        if (this.parentFunc == null) {
            sb.append("null");
        } else if (this.parentFunc instanceof Definition) {
            sb.append(((Definition)this.parentFunc).getIdentifier());
        } else if (this.parentFunc instanceof ControlPart) {
            sb.append("<controlpart>");
        } else {
            sb.append("<invalid: ").append(this.parentFunc).append('>');
        }
        sb.append('\n');
        sb.append("  Return clause: ");
        sb.append((Object)(this.returnType == null ? "null" : this.returnType.getIdentifier()));
        sb.append("  Warnings: ");
        for (RefactoringStatusEntry rse : this.warnings) {
            sb.append("severity: " + rse.getSeverity() + "; msg: " + rse.getMessage());
            sb.append('\n');
        }
        return sb.toString();
    }

    private static class RunsOnClauseFinder
    extends ASTVisitor {
        private final Location atLocation;
        private boolean insideFunc = false;
        private IVisitableNode funcDef;
        private Reference runsOnRef;
        private Type returnType;

        RunsOnClauseFinder(Location atLocation) {
            this.atLocation = atLocation;
        }

        private IVisitableNode getFuncDef() {
            return this.funcDef;
        }

        private Reference getRunsOnRef() {
            return this.runsOnRef;
        }

        private Type getReturnType() {
            return this.returnType;
        }

        public int visit(IVisitableNode node) {
            if (this.insideFunc) {
                if (node instanceof Reference) {
                    this.runsOnRef = (Reference)node;
                    return 2;
                }
                return 1;
            }
            if (node instanceof Def_Function || node instanceof Def_Testcase || node instanceof Def_Altstep) {
                if (((Definition)node).getLocation().containsOffset(this.atLocation.getOffset())) {
                    if (node instanceof Def_Function) {
                        this.returnType = ((Def_Function)node).getType(CompilationTimeStamp.getBaseTimestamp());
                    }
                    this.funcDef = (Definition)node;
                    this.insideFunc = true;
                    return 3;
                }
                return 1;
            }
            if (node instanceof ControlPart) {
                this.funcDef = (ControlPart)node;
                return 2;
            }
            return 3;
        }
    }

    private static class ContinueFinder
    extends ASTVisitor {
        private boolean found = false;

        private ContinueFinder() {
        }

        private boolean isFound() {
            return this.found;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof For_Statement || node instanceof DoWhile_Statement || node instanceof While_Statement) {
                return 1;
            }
            if (node instanceof Continue_Statement) {
                this.found = true;
                return 2;
            }
            return 3;
        }
    }

    private static class BreakFinder
    extends ASTVisitor {
        private boolean found = false;

        private BreakFinder() {
        }

        private boolean isFound() {
            return this.found;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof For_Statement || node instanceof DoWhile_Statement || node instanceof While_Statement || node instanceof Alt_Statement || node instanceof Interleave_Statement) {
                return 1;
            }
            if (node instanceof Break_Statement) {
                this.found = true;
                return 2;
            }
            return 3;
        }
    }

    private static class GotoFinder
    extends ASTVisitor {
        private final List<Identifier> gotoStatements = new ArrayList<Identifier>();
        private final List<Identifier> labelStatements = new ArrayList<Identifier>();
        private boolean insideGoto = false;
        private boolean insideLabel = false;

        GotoFinder() {
        }

        private List<Identifier> getGotoStatements() {
            return this.gotoStatements;
        }

        private List<Identifier> getLabelStatements() {
            return this.labelStatements;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Goto_statement) {
                this.insideGoto = true;
                return 3;
            }
            if (node instanceof Label_Statement) {
                this.insideLabel = true;
                return 3;
            }
            if (node instanceof Identifier) {
                if (this.insideGoto) {
                    this.gotoStatements.add((Identifier)node);
                } else if (this.insideLabel) {
                    this.labelStatements.add((Identifier)node);
                }
            }
            this.insideGoto = false;
            this.insideLabel = false;
            return 3;
        }
    }

    private static class SelectionVisitor
    extends ASTVisitor {
        private final List<Statement> statements;
        private StatementBlock parentBlock;
        private final int offset;
        private final int endOffset;

        private SelectionVisitor(int selOffset, int selLen) {
            this.offset = selOffset;
            this.endOffset = this.offset + selLen;
            this.statements = new ArrayList<Statement>();
        }

        private StatementList createStatementList(ITextSelection textSel) {
            StatementList sl = new StatementList(this.statements);
            if (textSel == null || sl.isEmpty()) {
                return sl;
            }
            int ind = sl.getLocation().getEndOffset() - textSel.getOffset();
            if (ind < 0 || ind >= textSel.getLength()) {
                return sl;
            }
            String content = textSel.getText();
            int SEMICOLON = 59;
            if (content.charAt(ind) != ';') {
                return sl;
            }
            sl.increaseLocationEndOffset(1);
            return sl;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof ILocateableNode) {
                Location loc = ((ILocateableNode)node).getLocation();
                if (loc == null) {
                    return 2;
                }
                if (node instanceof Statement && loc.getOffset() >= this.offset && loc.getEndOffset() <= this.endOffset) {
                    Statement st = (Statement)node;
                    if (this.parentBlock == null) {
                        this.parentBlock = st.getMyStatementBlock();
                        if (this.parentBlock == null) {
                            return 1;
                        }
                        this.statements.add(st);
                    } else if (st.getMyStatementBlock() == this.parentBlock) {
                        this.statements.add(st);
                        return 1;
                    }
                }
                if (node instanceof Alt_Statement) {
                    return 1;
                }
            }
            return 3;
        }
    }
}

