/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class TITANProjectImportPage
extends WizardNewProjectCreationPage {
    private String workingDirectory;

    public TITANProjectImportPage(String pageName) {
        super(pageName);
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        IProject handle = this.getProjectHandle();
        IPath path = handle.getLocation();
        if (path == null) {
            String name = handle.getName();
            IPath path2 = handle.getWorkspace().getRoot().getLocation();
            if ((path2 = path2.append(name)).toFile().exists()) {
                this.setErrorMessage("A folder or file with that name already exists in the workspace.");
                return false;
            }
        }
        if (this.workingDirectory == null) {
            this.setErrorMessage(null);
            return true;
        }
        URI locUri = this.getLocationURI();
        locUri = locUri.normalize();
        URI uri2 = URIUtil.toURI((String)this.workingDirectory);
        uri2 = uri2.normalize();
        if (locUri != null && locUri.equals(uri2)) {
            this.setErrorMessage("The working directory of the project and its location can not be the same folder.");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

