/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.nativewin32actions;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.actions.ExternalTitanAction;
import org.eclipse.titan.designer.core.TITANInstallationValidator;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.nativewin32actions.NativeWIN32TITANJob;

public final class CheckSyntax
extends ExternalTitanAction {
    private static final String JOB_TITLE = "Syntax check";

    public void run(IAction action) {
        this.doCheckSyntax();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doCheckSyntax();
        return null;
    }

    private void doCheckSyntax() {
        if (!TITANInstallationValidator.check(true)) {
            return;
        }
        if (!LicenseValidator.check()) {
            return;
        }
        this.processSelection();
        if (this.files == null || this.files.isEmpty()) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Syntax check ...failed", (String)"No valid files were selected.");
            return;
        }
        this.reportOnTheFlyOutdating();
        NativeWIN32TITANJob titanJob = new NativeWIN32TITANJob(JOB_TITLE, this.files, this.workingDir, this.project);
        titanJob.setPriority(50);
        titanJob.setUser(true);
        titanJob.setRule((ISchedulingRule)this.project);
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getCompilerPath().toOSString());
        command.add("-p" + this.getTITANActionFlags());
        command.addAll(this.files.keySet());
        titanJob.addCommand(command, JOB_TITLE);
        titanJob.removeCompilerMarkers();
        String markersAfterCompiler = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.ontheflyMarkersAfterCompiler", "Are removed", null);
        if ("Are removed".equals(markersAfterCompiler)) {
            titanJob.removeOnTheFlyMarkers();
        }
        titanJob.schedule();
    }
}

