/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension5;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.HeadlessStorage;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.declarationsearch.IdentifierFinderVisitor;
import org.eclipse.titan.designer.editors.AstSyntaxHighlightTokens;
import org.eclipse.titan.designer.editors.Breadcrumb;
import org.eclipse.titan.designer.editors.CodeMiningMaps;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.FoldingSupport;
import org.eclipse.titan.designer.editors.GitUtilities;
import org.eclipse.titan.designer.editors.IEditorWithCarretOffset;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.titan.designer.editors.RemoveTrailingWsOnSave;
import org.eclipse.titan.designer.editors.ttcn3editor.Configuration;
import org.eclipse.titan.designer.editors.ttcn3editor.DocumentCommentView;
import org.eclipse.titan.designer.editors.ttcn3editor.DocumentSetupParticipant;
import org.eclipse.titan.designer.editors.ttcn3editor.OutlinePage;
import org.eclipse.titan.designer.editors.ttcn3editor.PairMatcher;
import org.eclipse.titan.designer.editors.ttcn3editor.Reconciler;
import org.eclipse.titan.designer.editors.ttcn3editor.ReconcilingStrategy;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3FoldingSupport;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3OccurrenceMarker;
import org.eclipse.titan.designer.editors.ttcn3editor.actions.ToggleComment;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.FileSaveTracker;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public final class TTCN3Editor
extends AbstractDecoratedTextEditor
implements ISemanticTITANEditor,
IEditorWithCarretOffset {
    private static final String TTCN3_EDITOR = "org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor";
    private static final String EDITOR_CONTEXT = "org.eclipse.titan.designer.editors.ttcn3editor.context";
    private static final String EDITOR_SCOPE = "org.eclipse.titan.designer.editors.TTCN3EditorScope";
    private static final String CONTENTASSISTPROPOSAL = "ContentAssistProposal.";
    private static final String TOGGLE_COMMENT_ACTION_ID = "org.eclipse.titan.designer.editors.ttcn3editor.ToggleComment";
    private final long REFRESH_DELAY = 500L;
    private final long MINING_REFRESH_DELAY = 1000L;
    private ProjectionSupport projectionSupport;
    private List<Annotation> oldAnnotations = new ArrayList<Annotation>();
    private ProjectionAnnotationModel annotationModel;
    private ColorManager colorManager;
    private Configuration configuration;
    private ProjectionViewer projectionViewer;
    private OutlinePage outlinePage;
    private Reconciler reconciler;
    private Job refreshJob;
    private Job miningRefreshJob;
    private static int lastLine = -1;
    private Breadcrumb breadcrumb;
    private static List<IEditorPart> activeEditorParts = new ArrayList<IEditorPart>();
    private TTCN3OccurrenceMarker occurrencesMarker = new TTCN3OccurrenceMarker(this);
    private SemanticHighlightingListener semanticHighlightingListener = null;
    private GenericPropertyChangeListener codeMiningListener = null;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore[] stores = new IPreferenceStore[]{this.getPreferenceStore(), Activator.getDefault().getPreferenceStore()};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        this.colorManager = new ColorManager();
        this.configuration = new Configuration(this.colorManager, this);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.configuration);
        ForwardingDocumentProvider forwardingProvider = new ForwardingDocumentProvider("__ttcn3_partitioning", (IDocumentSetupParticipant)new DocumentSetupParticipant(this), (IDocumentProvider)new TextFileDocumentProvider());
        this.setDocumentProvider((IDocumentProvider)forwardingProvider);
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        HeadlessStorage.setTabWidth(this.configuration.getTabWidth(this.getSourceViewer()));
        this.semanticHighlightingListener = new SemanticHighlightingListener(this);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.semanticHighlightingListener);
    }

    public static boolean isSemanticCheckingDelayed() {
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean delayedSemanticChecking = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.delaySemantiCheckingTillSave", false, null);
        return delayedSemanticChecking;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            FileSaveTracker.fileBeingSaved(file);
        }
        RemoveTrailingWsOnSave.doRemove(this.getDocument());
        super.doSave(progressMonitor);
        this.analyzeOpenedFile("Reconciliation on save", file);
    }

    private void analyzeOpenedFile(String jobname, IFile file) {
        this.analyzeOpenedFile(jobname, file, false);
    }

    private void analyzeOpenedFile(String jobname, final IFile file, final boolean waitToFinish) {
        IReconcilingStrategy strategy;
        if (file != null && TTCN3Editor.isSemanticCheckingDelayed() && (strategy = this.reconciler.getReconcilingStrategy("__dftl_partition_content_type")) instanceof ReconcilingStrategy) {
            WorkspaceJob op = new WorkspaceJob(jobname){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    if (TTCN3Editor.this.reconciler.isIncrementalReconciler()) {
                        ((ReconcilingStrategy)strategy).reconcileSemantics(waitToFinish);
                    } else {
                        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
                        projectSourceParser.reportOutdating(file);
                        ((ReconcilingStrategy)strategy).analyze(true, waitToFinish);
                    }
                    return Status.OK_STATUS;
                }
            };
            op.setPriority(30);
            op.setSystem(true);
            op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            op.schedule();
            if (waitToFinish) {
                try {
                    op.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("org.eclipse.titan.designer")) {
            this.colorManager.update(event.getProperty());
            this.invalidateTextPresentation();
            this.updateTITANIndentPrefixes();
            return true;
        }
        return super.affectsTextPresentation(event);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        PairMatcher pairMatcher = new PairMatcher();
        support.setCharacterPairMatcher((ICharacterPairMatcher)pairMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("org.eclipse.titan.designer.matchingBracketEnabled", "org.eclipse.titan.designer.color.matchingBracket", "org.eclipse.titan.designer.matchingBracketEnabled", "org.eclipse.titan.designer.color.matchingBracket");
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction caAction = new TextOperationAction(Activator.getDefault().getResourceBundle(), CONTENTASSISTPROPOSAL, (ITextEditor)this, 13);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        caAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(CONTENTASSISTPROPOSAL, (IAction)caAction);
        this.markAsStateDependentAction(CONTENTASSISTPROPOSAL, true);
        ToggleComment tcAction = new ToggleComment(Activator.getDefault().getResourceBundle(), "ToggleComment.", this);
        tcAction.setActionDefinitionId(TOGGLE_COMMENT_ACTION_ID);
        this.setAction(TOGGLE_COMMENT_ACTION_ID, (IAction)tcAction);
        this.markAsStateDependentAction(TOGGLE_COMMENT_ACTION_ID, true);
        tcAction.configure(this.getSourceViewer(), this.getSourceViewerConfiguration());
        tcAction.setText("Toggle Comment");
        tcAction.setImageDescriptor(ImageCache.getImageDescriptor("comment.png"));
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.outlinePage == null) {
                this.outlinePage = new OutlinePage((AbstractTextEditor)this);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        IFile file;
        this.oldAnnotations = null;
        if (this.projectionSupport != null) {
            this.projectionSupport.dispose();
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        this.annotationModel = null;
        this.configuration = null;
        this.projectionViewer = null;
        if (this.occurrencesMarker != null) {
            this.occurrencesMarker.dispose();
            this.occurrencesMarker = null;
        }
        if (this.semanticHighlightingListener != null) {
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.semanticHighlightingListener);
        }
        if ((file = (IFile)this.getEditorInput().getAdapter(IFile.class)) != null) {
            EditorTracker.remove(file, this);
        }
        super.dispose();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void editorSaved() {
        super.editorSaved();
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            GlobalProjectStructureTracker.saveFile(file);
        }
    }

    @Override
    public IDocument getDocument() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        return sourceViewer.getDocument();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(this.projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        this.projectionViewer.doOperation(19);
        this.annotationModel = this.projectionViewer.getProjectionAnnotationModel();
        this.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TTCN3Editor.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
            }
        });
        this.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty() || !(selection instanceof TextSelection) || "".equals(((TextSelection)selection).getText())) {
                    return;
                }
                TextSelection textSelection = (TextSelection)selection;
                int offset = textSelection.getOffset() + textSelection.getLength();
                TTCN3Editor.this.occurrencesMarker.markOccurences(TTCN3Editor.this.getDocument(), offset);
            }
        });
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            EditorTracker.put(file, this);
        }
        this.getSite().getPage().addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part instanceof TTCN3Editor && !activeEditorParts.contains((TTCN3Editor)part)) {
                    activeEditorParts.add((TTCN3Editor)part);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof TTCN3Editor) {
                    activeEditorParts.remove((TTCN3Editor)part);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        });
    }

    private void updateCodeMinings(final IFile file) {
        try {
            final int line = this.getDocument().getLineOfOffset(this.getCarretOffset());
            if (lastLine != line) {
                if (lastLine != -1) {
                    IRegion region = this.getDocument().getLineInformation(lastLine);
                    CodeMiningMaps.removeCodeMining(CodeMiningMaps.CodeMiningType.LineEnd, file.getFullPath().toOSString(), region.getOffset() + region.getLength());
                }
                if (this.miningRefreshJob != null && this.miningRefreshJob.getState() != 4) {
                    if (this.miningRefreshJob.cancel()) {
                        this.miningRefreshJob = null;
                    } else {
                        this.miningRefreshJob.schedule(1000L);
                        return;
                    }
                }
                this.miningRefreshJob = new Job("code mining refresh job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        if (monitor.isCanceled() || display.isDisposed()) {
                            return Status.CANCEL_STATUS;
                        }
                        display.syncExec(() -> {
                            try {
                                IRegion miningRegion = TTCN3Editor.this.getDocument().getLineInformation(line);
                                String text = GitUtilities.getCommitInfo(file, line);
                                if (text == null) {
                                    return;
                                }
                                int pos = miningRegion.getOffset() + miningRegion.getLength();
                                CodeMiningMaps.addCodeMining(CodeMiningMaps.CodeMiningType.LineEnd, file.getFullPath().toOSString(), pos, text, GitUtilities.getHistoryIconImage(), true);
                                ((ISourceViewerExtension5)TTCN3Editor.this.getSourceViewer()).updateCodeMinings();
                                lastLine = line;
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                this.miningRefreshJob.setSystem(false);
                this.miningRefreshJob.setPriority(10);
                this.miningRefreshJob.schedule(1000L);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        this.occurrencesMarker.markOccurences(this.getDocument(), this.getCarretOffset());
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module tempModule = projectSourceParser.containedModule(file);
        if (tempModule == null) {
            return;
        }
        IdentifierFinderVisitor visitor = new IdentifierFinderVisitor(this.getCarretOffset());
        tempModule.accept(visitor);
        final Declaration declaration = visitor.getReferencedDeclaration();
        if (declaration == null) {
            return;
        }
        if (this.refreshJob != null && this.refreshJob.getState() != 4) {
            if (this.refreshJob.cancel()) {
                this.refreshJob = null;
            } else {
                this.refreshJob.schedule(500L);
                return;
            }
        }
        this.refreshJob = new Job("doc comment and outline refresh job"){

            protected IStatus run(IProgressMonitor monitor) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (monitor.isCanceled() || display.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                display.syncExec(() -> {
                    TreePath tp;
                    IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.titan.designer.editors.ttcn3editor.DocumentCommentView");
                    if (view instanceof DocumentCommentView) {
                        DocumentCommentView docView = (DocumentCommentView)view;
                        ICommentable commentable = declaration.getCommentable();
                        if (commentable instanceof ICommentable) {
                            docView.setContent(commentable.getHoverContent(null));
                        }
                    }
                    TTCN3Editor.this.breadcrumb.clearDynamicElements();
                    TTCN3Editor.this.breadcrumb.addDynamicElement(declaration);
                    if (TTCN3Editor.this.outlinePage == null) {
                        return;
                    }
                    TreeSelection selection = (TreeSelection)TTCN3Editor.this.outlinePage.getSelection();
                    TreePath[] paths = selection.getPaths();
                    TreePath treePath = tp = paths.length > 0 ? paths[0] : null;
                    if (tp == null || !tp.getLastSegment().equals(declaration.getAssignment())) {
                        Object[] segments = new Object[2];
                        segments[1] = declaration.getAssignment();
                        TTCN3Editor.this.outlinePage.setSelection((ISelection)new StructuredSelection(segments));
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(false);
        this.refreshJob.setPriority(10);
        this.refreshJob.schedule(500L);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        IEditorInput input = this.getEditorInput();
        if (input != null) {
            this.breadcrumb = new Breadcrumb(parent);
            this.breadcrumb.changeParentViewerLayout();
        }
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        if (input != null) {
            this.breadcrumb.buildFilePath(input);
            this.breadcrumbSetEnabled();
        }
        IContextService contextService = (IContextService)this.getEditorSite().getService(IContextService.class);
        contextService.activateContext(EDITOR_SCOPE);
        return viewer;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "additions", TOGGLE_COMMENT_ACTION_ID);
    }

    @Override
    public void updateOutlinePage() {
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    public void refreshOutlinePage() {
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    @Override
    public void updateFoldingStructure(List<Position> positions) {
        FoldingSupport.updateFoldingStructure(this.annotationModel, this.oldAnnotations, positions);
    }

    @Override
    public void invalidateTextPresentation() {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            viewer.invalidateTextPresentation();
        }
    }

    @Override
    public int getCarretOffset() {
        int widgetOffset = this.getSourceViewer().getTextWidget().getCaretOffset();
        return this.projectionViewer.widgetOffset2ModelOffset(widgetOffset);
    }

    public void setCarretOffset(int i) {
        int temp = this.projectionViewer.modelOffset2WidgetOffset(i);
        this.getSourceViewer().getTextWidget().setCaretOffset(temp);
    }

    protected void updateTITANIndentPrefixes() {
        SourceViewerConfiguration tmpConfiguration = this.getSourceViewerConfiguration();
        ISourceViewer sourceViewer = this.getSourceViewer();
        String[] types = tmpConfiguration.getConfiguredContentTypes(sourceViewer);
        for (int i = 0; i < types.length; ++i) {
            String[] prefixes = tmpConfiguration.getIndentPrefixes(sourceViewer, types[i]);
            if (prefixes == null || prefixes.length <= 0) continue;
            sourceViewer.setIndentPrefixes(prefixes, types[i]);
        }
    }

    public void setReconciler(Reconciler reconciler) {
        this.reconciler = reconciler;
    }

    public Reconciler getReconciler() {
        return this.reconciler;
    }

    public static IEditorDescriptor findTTCN3Editor(IWorkbench workbench) {
        return workbench.getEditorRegistry().findEditor(TTCN3_EDITOR);
    }

    @Override
    public void analyzeCurrentFile(IFile file) {
        this.analyzeOpenedFile("Reconciliation on request", file, true);
    }

    public ISourceViewer getEditorSourceViewer() {
        return this.getSourceViewer();
    }

    public static List<IEditorPart> getActiveEditorParts() {
        return activeEditorParts;
    }

    private void breadcrumbSetEnabled() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean isEnabled = store.getBoolean("org.eclipse.titan.designer.enableBreadcrumb");
        this.breadcrumb.setEnabled(isEnabled);
        this.breadcrumb.updateSourceViewerLayout();
    }

    private final class SemanticHighlightingListener
    implements IPropertyChangeListener {
        private TTCN3Editor editor;

        SemanticHighlightingListener(TTCN3Editor editor) {
            this.editor = editor;
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("org.eclipse.titan.designer.enableSemanticHighlighting".equals(property) || "org.eclipse.titan.designer.bracketColoringEnabled".equals(property) || AstSyntaxHighlightTokens.isSemanticHighlightingPreferenceChanged(property)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISourceViewer viewer = SemanticHighlightingListener.this.editor.getEditorSourceViewer();
                        AstSyntaxHighlightTokens.updateTokens();
                        if (viewer != null) {
                            viewer.invalidateTextPresentation();
                        }
                    }
                });
            }
        }
    }

    private final class GenericPropertyChangeListener
    implements IPropertyChangeListener {
        private GenericPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property;
            switch (property = event.getProperty()) {
                case ".enableCodeMinings": {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                    break;
                }
                case "org.eclipse.titan.designer.enableBreadcrumb": {
                    TTCN3Editor.this.breadcrumbSetEnabled();
                    break;
                }
                case "org.eclipse.titan.designer.foldingEnabledPreference": 
                case "org.eclipse.titan.designer.foldComments": 
                case "org.eclipse.titan.designer.foldStatementBlocks": 
                case "org.eclipse.titan.designer.foldParenthesis": 
                case "org.eclipse.titan.designer.distance": {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TTCN3Editor.this.updateFoldingStructure(new TTCN3FoldingSupport().calculatePositions(TTCN3Editor.this.getDocument()));
                        }
                    });
                }
            }
        }
    }
}

