/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.titan.designer.editors.ColorManager;

public class BracketRule
implements IRule {
    private static String[] bracketColorCodes = new String[]{"org.eclipse.titan.designer.color.bracketcolor0", "org.eclipse.titan.designer.color.bracketcolor1", "org.eclipse.titan.designer.color.bracketcolor2", "org.eclipse.titan.designer.color.bracketcolor3", "org.eclipse.titan.designer.color.bracketcolor4"};
    private int depth = 0;

    public IToken evaluate(ICharacterScanner scanner) {
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean isEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.bracketColoringEnabled", false, null);
        if (!isEnabled) {
            return Token.UNDEFINED;
        }
        ColorManager colorManager = new ColorManager();
        char c = (char)scanner.read();
        switch (c) {
            case '(': 
            case ')': 
            case '{': 
            case '}': {
                break;
            }
            default: {
                scanner.unread();
                return Token.UNDEFINED;
            }
        }
        if ((c == ')' || c == '}') && this.depth > 0) {
            --this.depth;
        }
        IToken token = Token.UNDEFINED;
        if (this.depth < bracketColorCodes.length) {
            token = colorManager.createTokenFromPreference(bracketColorCodes[this.depth]);
        }
        if (c == '(' || c == '{') {
            ++this.depth;
        }
        return token;
    }

    public void setBracketDepth(int depth) {
        this.depth = depth;
    }
}

