/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.declarationsearch;

import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.declarationsearch.Declaration;

public class IdentifierFinderVisitor
extends ASTVisitor {
    private IReferencingElement reference = null;
    private ISubReference subReference = null;
    private final int offset;

    public IdentifierFinderVisitor(int offset) {
        this.offset = offset;
    }

    @Override
    public int visit(IVisitableNode node) {
        ASN1Assignment assignment;
        if (node instanceof ASN1Assignment && (assignment = (ASN1Assignment)node).getAssPard() != null) {
            return 1;
        }
        if (node instanceof ILocateableNode) {
            DocumentComment comment;
            Location loc = ((ILocateableNode)((Object)node)).getLocation();
            Location docloc = NULL_Location.INSTANCE;
            if (node instanceof ICommentable && (comment = ((ICommentable)((Object)node)).getDocumentComment()) != null) {
                docloc = comment.getLocation();
            }
            if (loc == null) {
                return 2;
            }
            if (!loc.containsOffset(this.offset) && !docloc.containsOffset(this.offset)) {
                return 1;
            }
            if (node instanceof IReferencingElement) {
                this.reference = (IReferencingElement)((Object)node);
            } else if (node instanceof ISubReference) {
                this.subReference = (ISubReference)node;
            }
            if (node instanceof Identifier) {
                return 2;
            }
        }
        return 3;
    }

    public Declaration getReferencedDeclaration() {
        if (this.reference == null) {
            return null;
        }
        if (this.subReference == null || !(this.reference instanceof Reference)) {
            return this.reference.getDeclaration();
        }
        return ((Reference)this.reference).getReferencedDeclaration(this.subReference);
    }
}

