/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class IndexedTemplate
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private final ArraySubReference index;
    private final TTCN3Template template;
    private Location location;

    public IndexedTemplate(ArraySubReference index, TTCN3Template template) {
        this.index = index;
        this.template = template;
        this.location = NULL_Location.INSTANCE;
        if (index != null) {
            index.setFullNameParent(this);
        }
        if (template != null) {
            template.setFullNameParent(this);
        }
    }

    public ArraySubReference getIndex() {
        return this.index;
    }

    public TTCN3Template getTemplate() {
        return this.template;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.index != null) {
            this.index.setMyScope(scope);
        }
        if (this.template != null) {
            this.template.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.index != null) {
            this.index.setCodeSection(codeSection);
        }
        if (this.template != null) {
            this.template.setCodeSection(codeSection);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.index != null) {
            this.index.updateSyntax(reparser, false);
            reparser.updateLocation(this.index.getLocation());
        }
        if (this.template != null) {
            this.template.updateSyntax(reparser, false);
            reparser.updateLocation(this.template.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.template == null) {
            return;
        }
        this.template.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.index != null && !this.index.accept(v)) {
            return false;
        }
        return this.template == null || this.template.accept(v);
    }
}

