/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TTCN3Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Definition_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.DoWhile_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Goto_statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Label_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock_Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.DynamicMatch_template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.ClassTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserUtilities;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class StatementBlock
extends TTCN3Scope
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".statement_";
    public static final String HIDINGSCOPEELEMENT = "Definition with identifier `{0}'' is not unique in the scope hierarchy";
    public static final String HIDDENSCOPEELEMENT = "Previous definition with identifier `{0}'' in higher scope unit is here";
    public static final String HIDINGMODULEIDENTIFIER = "Definition with name `{0}'' hides a module identifier";
    private static final String NEVER_REACH = "Control never reaches this statement";
    private static final String UNUSEDLABEL = "Label `{0}'' is defined, but not used";
    private static final String DUPLICATEDLABELFIRST = "Previous definition of label `{0}'' is here";
    private static final String DUPLICATELABELAGAIN = "Duplicated label `{0}''";
    private static final String DUPLICATECATCH = "Duplicate catch block definition for exception type `{0}''";
    private static final String CATCHOOP = "Object-oriented features must be enabled for using catch blocks";
    private Location location = NULL_Location.INSTANCE;
    private List<Statement> statements;
    private Map<String, Definition> definitionMap;
    private Map<String, Label_Statement> labelMap;
    private StatementBlock myStatementBlock;
    private int myStatementBlockIndex;
    private Definition myDefinition;
    private DynamicMatch_template dynamicTemplate;
    private CompilationTimeStamp lastTimeChecked;
    private boolean ownerIsLoop;
    private boolean ownerIsDestructor;
    private boolean ownerIsAltguard;
    private boolean ownerIsProperty;
    private boolean isPropertySetter;
    private boolean isPropertyGetter;
    private FormalParameterList valueParamList;
    private ReturnStatus_type returnStatus;
    private List<StatementBlock> catchBlocks;
    private StatementBlock finallyBlock;
    private ExceptionHandling_type exceptionHandling;
    private static final Comparator<Statement> STATEMENT_INSERTION_COMPARATOR = new Comparator<Statement>(){

        @Override
        public int compare(Statement o1, Statement o2) {
            return o1.getLocation().getOffset() - o2.getLocation().getOffset();
        }
    };

    public StatementBlock() {
        this.scopeName = "statementblock";
        this.statements = new ArrayList<Statement>();
        this.catchBlocks = new ArrayList<StatementBlock>();
        this.ownerIsLoop = false;
        this.ownerIsAltguard = false;
        this.ownerIsDestructor = false;
        this.ownerIsProperty = false;
        this.exceptionHandling = ExceptionHandling_type.EH_NONE;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            if (this.statements.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(Integer.toString(i + 1));
        }
        return builder;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public Definition getMyDefinition() {
        return this.myDefinition;
    }

    public void setMyDefinition(Definition definition) {
        this.myDefinition = definition;
        for (Statement statement : this.statements) {
            statement.setMyDefinition(definition);
        }
        for (StatementBlock catchBlock : this.catchBlocks) {
            catchBlock.setMyDefinition(definition);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.setMyDefinition(definition);
        }
    }

    public void setMyScope(Scope scope) {
        this.setParentScope(scope);
        if (this.location != null) {
            scope.addSubScope(this.location, this);
        }
        for (Statement statement : this.statements) {
            statement.setMyScope(this);
        }
        for (StatementBlock catchBlock : this.catchBlocks) {
            catchBlock.setParentScope(scope);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.setParentScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        for (Statement statement : this.statements) {
            statement.setCodeSection(codeSection);
        }
    }

    public void setOwnerIsLoop() {
        this.ownerIsLoop = true;
    }

    public void setOwnerIsAltguard() {
        this.ownerIsAltguard = true;
    }

    public void setOwnerIsFinally() {
        this.ownerIsDestructor = true;
    }

    public void setOwnerIsProperty() {
        this.ownerIsProperty = true;
    }

    public void addStatement(Statement statement) {
        this.addStatement(statement, true);
    }

    public void addStatement(Statement statement, boolean append) {
        if (statement != null) {
            if (append) {
                this.statements.add(statement);
            } else {
                this.statements.add(0, statement);
            }
            statement.setMyStatementBlock(this, this.statements.size() - 1);
            statement.setMyScope(this);
            statement.setFullNameParent(this);
        }
    }

    void addStatementsOrdered(List<Statement> newStatements) {
        if (newStatements == null || newStatements.isEmpty()) {
            return;
        }
        ArrayList<Statement> localStatements = new ArrayList<Statement>(this.statements);
        for (Statement statement : newStatements) {
            int position = Collections.binarySearch(localStatements, statement, STATEMENT_INSERTION_COMPARATOR);
            if (position < 0) {
                localStatements.add((position + 1) * -1, statement);
            } else {
                localStatements.add(position + 1, statement);
            }
            statement.setMyScope(this);
            statement.setFullNameParent(this);
            statement.setMyDefinition(this.myDefinition);
        }
        int size = localStatements.size();
        for (int i = 0; i < size; ++i) {
            Statement statement = (Statement)localStatements.get(i);
            statement.setMyStatementBlock(this, i);
        }
        this.statements = localStatements;
    }

    public int getSize() {
        return this.statements.size();
    }

    public Statement getStatementByIndex(int i) {
        return this.statements.get(i);
    }

    public Statement getFirstStatement() {
        block5: for (Statement statement : this.statements) {
            switch (statement.getType()) {
                case S_LABEL: {
                    continue block5;
                }
                case S_BLOCK: {
                    Statement firstStatement = ((StatementBlock_Statement)statement).getStatementBlock().getFirstStatement();
                    if (firstStatement == null) continue block5;
                    return firstStatement;
                }
                case S_DOWHILE: {
                    Statement firstStatement = ((DoWhile_Statement)statement).getStatementBlock().getFirstStatement();
                    if (firstStatement == null) continue block5;
                    return firstStatement;
                }
            }
            return statement;
        }
        return null;
    }

    public StatementBlock getMyStatementBlock() {
        return this.myStatementBlock;
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        this.myStatementBlock = statementBlock;
        this.myStatementBlockIndex = index;
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            this.statements.get(i).setMyStatementBlock(this, i);
        }
    }

    public int getMyStatementBlockIndex() {
        return this.myStatementBlockIndex;
    }

    public void setMyAltguards(AltGuards altGuards) {
        for (Statement statement : this.statements) {
            statement.setMyAltguards(altGuards);
        }
    }

    protected void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
        for (Statement statment : this.statements) {
            statment.setMyLaicStmt(pAltGuards, pLoopStmt);
        }
    }

    public ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        int i;
        if (this.lastTimeChecked != null && this.returnStatus != null) {
            return this.returnStatus;
        }
        this.returnStatus = ReturnStatus_type.RS_NO;
        int size = this.statements.size();
        block8: for (i = 0; i < size; ++i) {
            Statement statement = this.statements.get(i);
            if (Statement.Statement_type.S_GOTO.equals((Object)statement.getType())) {
                Goto_statement gotoStatement = (Goto_statement)statement;
                if (gotoStatement.getJumpsForward()) {
                    ++i;
                    while (!(i >= size || (statement = this.statements.get(i)) instanceof Label_Statement && ((Label_Statement)statement).labelIsUsed())) {
                        ++i;
                    }
                } else {
                    return this.returnStatus;
                }
            }
            switch (statement.hasReturn(timestamp)) {
                case RS_YES: {
                    this.returnStatus = ReturnStatus_type.RS_YES;
                    return this.returnStatus;
                }
                case RS_MAYBE: {
                    this.returnStatus = ReturnStatus_type.RS_MAYBE;
                    continue block8;
                }
            }
        }
        block10: for (i = 0; i < this.catchBlocks.size(); ++i) {
            switch (this.catchBlocks.get(i).hasReturn(timestamp)) {
                case RS_YES: {
                    continue block10;
                }
                case RS_MAYBE: {
                    return ReturnStatus_type.RS_MAYBE;
                }
                default: {
                    this.returnStatus = this.returnStatus != ReturnStatus_type.RS_NO ? ReturnStatus_type.RS_NO : ReturnStatus_type.RS_MAYBE;
                }
            }
        }
        return this.returnStatus;
    }

    public boolean hasReceivingStatement(int index) {
        for (int i = index; i < this.statements.size(); ++i) {
            if (!this.statements.get(i).hasReceivingStatement()) continue;
            return true;
        }
        return false;
    }

    public void registerDefinition(CompilationTimeStamp timestamp, Definition definition) {
        String definitionName;
        if (definition == null) {
            return;
        }
        Identifier identifier = definition.getIdentifier();
        if (identifier == null) {
            return;
        }
        if (this.definitionMap == null) {
            this.definitionMap = new HashMap<String, Definition>(3);
        }
        if (this.definitionMap.containsKey(definitionName = identifier.getName())) {
            if (definition.getLocation() != null && this.definitionMap.get(definitionName).getLocation() != null) {
                Location otherLocation = this.definitionMap.get(definitionName).getLocation();
                otherLocation.reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", identifier.getDisplayName()));
                definition.getLocation().reportSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was declared here again", identifier.getDisplayName()));
            }
        } else {
            this.definitionMap.put(definitionName, definition);
            if (this.parentScope != null && !this.isInClassBody() && definition.getLocation() != null) {
                if (this.parentScope.hasAssignmentWithId(timestamp, identifier)) {
                    definition.getLocation().reportSemanticError(MessageFormat.format(HIDINGSCOPEELEMENT, identifier.getDisplayName()));
                    ArrayList<ISubReference> subReferences = new ArrayList<ISubReference>();
                    subReferences.add(new FieldSubReference(identifier));
                    Reference reference = new Reference(null, subReferences);
                    Assignment assignment = this.parentScope.getAssBySRef(timestamp, reference);
                    if (assignment != null && assignment.getLocation() != null) {
                        assignment.getLocation().reportSingularSemanticError(MessageFormat.format(HIDDENSCOPEELEMENT, identifier.getDisplayName()));
                    }
                } else if (this.parentScope.isValidModuleId(identifier)) {
                    String option = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportModuleNameReuse", "error", null);
                    definition.getLocation().reportConfigurableSemanticProblem(option, MessageFormat.format(HIDINGMODULEIDENTIFIER, identifier.getDisplayName()));
                }
            }
        }
    }

    private boolean isInClassBody() {
        Scope scope = this.parentScope;
        while ((scope = scope.getParentScope()) instanceof StatementBlock || scope instanceof FormalParameterList || scope instanceof NamedBridgeScope) {
        }
        return scope.getNameParent() instanceof ClassTypeBody;
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.definitionMap != null) {
            this.definitionMap.clear();
        }
        if (this.labelMap != null) {
            this.labelMap.clear();
        }
        this.checkLabels(timestamp);
        boolean unreachableFound = false;
        Statement previousStatement = null;
        for (Statement statement : this.statements) {
            try {
                statement.check(timestamp);
            }
            catch (Exception e) {
                Location loc = statement.getLocation();
                ErrorReporter.logExceptionStackTrace((String)("An exception was thrown when analyzing the statement in file '" + loc.getFile().getLocationURI() + "' at line " + loc.getLine()), (Throwable)e);
            }
            if (!unreachableFound && !Statement.Statement_type.S_LABEL.equals((Object)statement.getType()) && previousStatement != null && ReturnStatus_type.RS_YES.equals((Object)previousStatement.hasReturn(timestamp))) {
                statement.getLocation().reportSemanticWarning(NEVER_REACH);
                unreachableFound = true;
            }
            previousStatement = statement;
        }
        this.checkUnusedLabels(timestamp);
        boolean isOopEnabled = Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.enableOOPExtension");
        HashMap catchTypes = new HashMap();
        for (int i = 0; i < this.catchBlocks.size(); ++i) {
            if (isOopEnabled) {
                this.catchBlocks.get(i).check(timestamp);
                continue;
            }
            this.catchBlocks.get(i).getLocation().reportSemanticError(CATCHOOP);
        }
        catchTypes.clear();
        if (this.finallyBlock != null) {
            this.finallyBlock.check(timestamp);
        }
    }

    public void postCheck() {
        if (this.statements.isEmpty()) {
            return;
        }
        for (Statement statement : this.statements) {
            statement.postCheck();
        }
    }

    private void checkLabels(CompilationTimeStamp timestamp) {
        for (Statement statement : this.statements) {
            if (!Statement.Statement_type.S_LABEL.equals((Object)statement.getType())) continue;
            Label_Statement labelStatement = (Label_Statement)statement;
            labelStatement.setUsed(false);
            Identifier identifier = labelStatement.getLabelIdentifier();
            if (this.hasLabel(identifier)) {
                statement.getLocation().reportSemanticError(MessageFormat.format(DUPLICATELABELAGAIN, identifier.getDisplayName()));
                Label_Statement statement2 = this.getLabel(identifier);
                statement2.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDLABELFIRST, identifier.getDisplayName()));
                continue;
            }
            if (this.labelMap == null) {
                this.labelMap = new HashMap<String, Label_Statement>(1);
            }
            this.labelMap.put(identifier.getName(), labelStatement);
        }
        for (StatementBlock catchBlock : this.catchBlocks) {
            catchBlock.checkLabels(timestamp);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.checkLabels(timestamp);
        }
    }

    private void checkUnusedLabels(CompilationTimeStamp timestamp) {
        for (Statement statement : this.statements) {
            Label_Statement labelStatement;
            if (!Statement.Statement_type.S_LABEL.equals((Object)statement.getType()) || (labelStatement = (Label_Statement)statement).labelIsUsed()) continue;
            statement.getLocation().reportSemanticError(MessageFormat.format(UNUSEDLABEL, labelStatement.getLabelIdentifier().getDisplayName()));
        }
        for (StatementBlock catchBlock : this.catchBlocks) {
            catchBlock.checkUnusedLabels(timestamp);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.checkUnusedLabels(timestamp);
        }
    }

    public void checkAllowedInterleave() {
        for (Statement statement : this.statements) {
            statement.checkAllowedInterleave();
        }
        for (StatementBlock catchBlock : this.catchBlocks) {
            catchBlock.checkAllowedInterleave();
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.checkAllowedInterleave();
        }
    }

    protected boolean hasLabel(Identifier identifier) {
        StatementBlock statementBlock = this;
        while (statementBlock != null) {
            if (statementBlock.labelMap != null && statementBlock.labelMap.containsKey(identifier.getName())) {
                return true;
            }
            statementBlock = statementBlock.myStatementBlock;
        }
        return false;
    }

    protected Label_Statement getLabel(Identifier identifier) {
        StatementBlock statementBlock = this;
        while (statementBlock != null) {
            if (statementBlock.labelMap != null && statementBlock.labelMap.containsKey(identifier.getName())) {
                return statementBlock.labelMap.get(identifier.getName());
            }
            statementBlock = statementBlock.myStatementBlock;
        }
        return null;
    }

    public boolean hasEnclosingLoop() {
        return this.ownerIsLoop || this.myStatementBlock != null && this.myStatementBlock.hasEnclosingLoop();
    }

    public boolean hasEnclosingLoopOrAltguard() {
        return this.ownerIsLoop || this.ownerIsAltguard || this.myStatementBlock != null && this.myStatementBlock.hasEnclosingLoopOrAltguard();
    }

    public boolean hasDestructor() {
        return this.ownerIsDestructor || this.myStatementBlock != null && this.myStatementBlock.hasDestructor();
    }

    @Override
    public StatementBlock getStatementBlockScope() {
        return this;
    }

    @Override
    public Component_Type getMtcSystemComponentType(CompilationTimeStamp timestamp, boolean isSystem) {
        if (this.myDefinition == null) {
            return null;
        }
        Assignment.Assignment_type at = this.myDefinition.getAssignmentType();
        if (Assignment.Assignment_type.A_TESTCASE.semanticallyEquals(at)) {
            Component_Type type;
            Def_Testcase testcase = (Def_Testcase)this.myDefinition;
            if (isSystem && (type = testcase.getSystemType(timestamp)) != null) {
                return type;
            }
            return testcase.getRunsOnType(timestamp);
        }
        if (Assignment.Assignment_type.A_FUNCTION.semanticallyEquals(at) || Assignment.Assignment_type.A_FUNCTION_RVAL.semanticallyEquals(at) || Assignment.Assignment_type.A_FUNCTION_RTEMP.semanticallyEquals(at)) {
            if (isSystem) {
                return ((Def_Function)this.myDefinition).getSystemType(timestamp);
            }
            return ((Def_Function)this.myDefinition).getMtcType(timestamp);
        }
        if (Assignment.Assignment_type.A_ALTSTEP.semanticallyEquals(at)) {
            if (isSystem) {
                return ((Def_Altstep)this.myDefinition).getSystemType(timestamp);
            }
            return ((Def_Altstep)this.myDefinition).getMTCType(timestamp);
        }
        return null;
    }

    @Override
    public boolean hasAssignmentWithId(CompilationTimeStamp timestamp, Identifier identifier) {
        if (this.definitionMap != null && this.definitionMap.containsKey(identifier.getName())) {
            return true;
        }
        if (this.parentScope != null) {
            return this.parentScope.hasAssignmentWithId(timestamp, identifier);
        }
        return false;
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        if (reference.getModuleIdentifier() != null || this.definitionMap == null) {
            return this.getParentScope().getAssBySRef(timestamp, reference);
        }
        Assignment assignment = this.definitionMap.get(reference.getId().getName());
        if (assignment != null) {
            return assignment;
        }
        return this.getParentScope().getAssBySRef(timestamp, reference);
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        HashMap<String, ASTNode> temp;
        if (this.definitionMap != null && propCollector.getReference().getModuleIdentifier() == null) {
            temp = new HashMap<String, Definition>(this.definitionMap);
            for (Definition definition : temp.values()) {
                definition.addProposal(propCollector, 0);
            }
        }
        if (this.labelMap != null && propCollector.getReference().getModuleIdentifier() == null) {
            temp = new HashMap<String, Label_Statement>(this.labelMap);
            for (String name : temp.keySet()) {
                propCollector.addProposal(name, name, null);
            }
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addSkeletonProposal(ProposalCollector propCollector) {
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.STATEMENT_LEVEL_SKELETON_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    @Override
    public void addKeywordProposal(ProposalCollector propCollector) {
        propCollector.addProposal(TTCN3Keywords.STATEMENT_SCOPE, null, "keyword");
        super.addKeywordProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        String name;
        if (this.definitionMap != null && declarationCollector.getReference().getModuleIdentifier() == null && this.definitionMap.containsKey(name = declarationCollector.getReference().getId().getName())) {
            declarationCollector.addDeclaration(name, this.definitionMap.get(name).getLocation(), this);
        }
        if (this.labelMap != null && declarationCollector.getReference().getModuleIdentifier() == null && this.labelMap.containsKey(name = declarationCollector.getReference().getId().getName())) {
            declarationCollector.addDeclaration(name, this.labelMap.get(name).getLocation(), this);
        }
        super.addDeclaration(declarationCollector);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        List<Integer> temp;
        boolean isBeingExtended;
        if (!isDamaged) {
            for (Statement statement : this.statements) {
                statement.updateSyntax(reparser, false);
                reparser.updateLocation(statement.getLocation());
            }
            for (StatementBlock catchBlock : this.catchBlocks) {
                catchBlock.updateSyntax(reparser, isDamaged);
                reparser.updateLocation(catchBlock.getLocation());
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.updateSyntax(reparser, isDamaged);
                reparser.updateLocation(this.finallyBlock.getLocation());
            }
            return;
        }
        this.returnStatus = null;
        this.lastTimeChecked = null;
        boolean enveloped = false;
        int nofDamaged = 0;
        int leftBoundary = this.location.getOffset();
        int rightBoundary = this.location.getEndOffset();
        int damageOffset = reparser.getDamageStart();
        IAppendableSyntax lastAppendableBeforeChange = null;
        IAppendableSyntax lastPrependableBeforeChange = null;
        int size = this.statements.size();
        for (int i = 0; i < size && !enveloped; ++i) {
            Location cumulativeLocation;
            Statement statement = this.statements.get(i);
            Location temporalLocation = statement.getLocation();
            if (temporalLocation.equals(cumulativeLocation = statement instanceof Definition_Statement ? ((Definition_Statement)statement).getDefinition().getCumulativeDefinitionLocation() : temporalLocation) && reparser.envelopsDamage(cumulativeLocation)) {
                enveloped = true;
                leftBoundary = cumulativeLocation.getOffset();
                rightBoundary = cumulativeLocation.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(cumulativeLocation)) {
                ++nofDamaged;
                if (reparser.getDamageStart() == cumulativeLocation.getEndOffset()) {
                    lastAppendableBeforeChange = statement;
                    continue;
                }
                if (reparser.getDamageEnd() != cumulativeLocation.getOffset()) continue;
                lastPrependableBeforeChange = statement;
                continue;
            }
            if (cumulativeLocation.getEndOffset() < damageOffset && cumulativeLocation.getEndOffset() > leftBoundary) {
                leftBoundary = cumulativeLocation.getEndOffset();
                lastAppendableBeforeChange = statement;
            }
            if (cumulativeLocation.getOffset() < damageOffset || cumulativeLocation.getOffset() >= rightBoundary) continue;
            rightBoundary = cumulativeLocation.getOffset();
            lastPrependableBeforeChange = statement;
        }
        if (!enveloped) {
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (lastAppendableBeforeChange != null && (isBeingExtended = reparser.startsWithFollow(lastAppendableBeforeChange.getPossibleExtensionStarterTokens()))) {
            leftBoundary = lastAppendableBeforeChange.getLocation().getOffset();
            ++nofDamaged;
            enveloped = false;
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (lastPrependableBeforeChange != null && (temp = lastPrependableBeforeChange.getPossiblePrefixTokens()) != null && reparser.endsWithToken(temp)) {
            rightBoundary = lastPrependableBeforeChange.getLocation().getEndOffset();
            ++nofDamaged;
            enveloped = false;
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (nofDamaged != 0) {
            this.removeStuffInRange(reparser);
        }
        ArrayList<Statement> tempList = new ArrayList<Statement>(this.statements);
        boolean modified = false;
        Iterator iterator = tempList.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            Location temporalLocation = statement.getLocation();
            Location cumulativeLocation = statement instanceof Definition_Statement ? ((Definition_Statement)statement).getDefinition().getCumulativeDefinitionLocation() : temporalLocation;
            if (!reparser.isAffectedAppended(cumulativeLocation)) continue;
            try {
                statement.updateSyntax(reparser, enveloped && reparser.envelopsDamage(cumulativeLocation));
                reparser.updateLocation(statement.getLocation());
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    iterator.remove();
                    modified = true;
                    reparser.extendDamagedRegion(cumulativeLocation);
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        if (modified) {
            this.statements = tempList;
        }
        if (!enveloped) {
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            int result = this.reparse(reparser);
            if (result > 1) {
                throw new ReParseException(result - 1);
            }
        }
    }

    private int reparse(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                Ttcn3Reparser.Pr_reparse_FunctionStatementOrDefListContext root = parser.pr_reparse_FunctionStatementOrDefList();
                ParserUtilities.logParseTree((ParseTree)root, parser);
                List<Statement> statements = root.statements;
                if (parser.isErrorListEmpty() && statements != null) {
                    StatementBlock.this.addStatementsOrdered(statements);
                }
            }
        });
    }

    private void removeStuffInRange(TTCN3ReparseUpdater reparser) {
        ArrayList<Statement> tempList = new ArrayList<Statement>(this.statements);
        boolean modified = false;
        for (int i = tempList.size() - 1; i >= 0; --i) {
            Statement statement = (Statement)tempList.get(i);
            Location cumulativeLocation = statement instanceof Definition_Statement ? ((Definition_Statement)statement).getDefinition().getCumulativeDefinitionLocation() : statement.getLocation();
            if (!reparser.isDamaged(cumulativeLocation)) continue;
            reparser.extendDamagedRegion(cumulativeLocation);
            tempList.remove(i);
            modified = true;
        }
        if (modified) {
            this.statements = tempList;
        }
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.definitionMap == null) {
            return null;
        }
        for (Definition definition : this.definitionMap.values()) {
            if (!definition.getLocation().containsOffset(offset)) continue;
            return definition;
        }
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.statements == null) {
            return;
        }
        ArrayList<Statement> tempList = new ArrayList<Statement>(this.statements);
        for (Statement statement : tempList) {
            statement.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.hasCatchBlocks()) {
            for (StatementBlock catchBlock : this.catchBlocks) {
                catchBlock.findReferences(referenceFinder, foundIdentifiers);
            }
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.statements != null) {
            for (Statement statement : this.statements) {
                if (statement.accept(v)) continue;
                return false;
            }
        }
        return v.leave(this) != 2;
    }

    public boolean isEmpty() {
        return this.statements.isEmpty() && this.exceptionHandling == ExceptionHandling_type.EH_NONE && this.catchBlocks.size() == 0 && this.finallyBlock == null;
    }

    public void generateCode(JavaGenData aData, StringBuilder source) {
        int size = this.statements.size();
        for (int i = 0; i < size; ++i) {
            Statement statement = this.statements.get(i);
            statement.getLocation().update_location_object(aData, source);
            statement.generateCode(aData, source);
            switch (statement.getType()) {
                case S_BREAK: 
                case S_CONTINUE: 
                case S_RETURN: {
                    return;
                }
            }
        }
    }

    public void setValueParamList(FormalParameterList fpl) {
        this.valueParamList = fpl;
    }

    public FormalParameterList getValueParamList() {
        return this.valueParamList;
    }

    public boolean ownerIsProperty() {
        return this.ownerIsProperty;
    }

    public boolean isPropertySetter() {
        if (this.ownerIsProperty) {
            return this.isPropertySetter;
        }
        return false;
    }

    public boolean isPropertyGetter() {
        if (this.ownerIsProperty) {
            return this.isPropertyGetter;
        }
        return false;
    }

    public void setIsGetter() {
        this.isPropertyGetter = true;
    }

    public void setIsSetter() {
        this.isPropertySetter = true;
    }

    public boolean hasValueParamList() {
        return this.valueParamList != null;
    }

    public DynamicMatch_template getDynamicTemplate() {
        if (this.dynamicTemplate != null) {
            return this.dynamicTemplate;
        }
        if (this.myStatementBlock != null) {
            return this.myStatementBlock.getDynamicTemplate();
        }
        ErrorReporter.INTERNAL_ERROR();
        return null;
    }

    public void setDynamicTemplate(TTCN3Template template) {
        if (template instanceof DynamicMatch_template) {
            this.dynamicTemplate = (DynamicMatch_template)template;
        } else {
            ErrorReporter.INTERNAL_ERROR((String)"TTCN3Template is not type of DynamicMatch_template");
        }
    }

    public boolean isInDynamicTemplate() {
        if (this.dynamicTemplate != null) {
            return true;
        }
        if (this.myStatementBlock != null) {
            return this.myStatementBlock.isInDynamicTemplate();
        }
        return false;
    }

    public Map<String, Definition> getDefinitionMap() {
        return this.definitionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCatchBlocks(List<StatementBlock> blocks) {
        for (StatementBlock catchBlock : blocks) {
            catchBlock.exceptionHandling = ExceptionHandling_type.EH_OOP_CATCH;
        }
        List<StatementBlock> list = this.catchBlocks;
        synchronized (list) {
            this.catchBlocks.addAll(blocks);
        }
    }

    public void setFinallyBlock(StatementBlock finallyBlock) {
        finallyBlock.exceptionHandling = ExceptionHandling_type.EH_OOP_FINALLY;
        this.finallyBlock = finallyBlock;
    }

    public boolean hasCatchBlocks() {
        return this.catchBlocks.size() > 0;
    }

    public List<StatementBlock> getCatchBlocks() {
        return this.catchBlocks;
    }

    public boolean isInFinallyBlock() {
        if (this.exceptionHandling == ExceptionHandling_type.EH_OOP_FINALLY) {
            return true;
        }
        if (this.myStatementBlock != null) {
            return this.myStatementBlock.isInFinallyBlock();
        }
        return false;
    }

    public StatementBlock getFinallyBlock() {
        if (this.exceptionHandling == ExceptionHandling_type.EH_OOP_FINALLY) {
            return this;
        }
        if (this.myStatementBlock != null) {
            return this.myStatementBlock.getFinallyBlock();
        }
        return null;
    }

    public static enum ExceptionHandling_type {
        EH_NONE,
        EH_TRY,
        EH_CATCH,
        EH_OOP_CATCH,
        EH_OOP_FINALLY;

    }

    public static enum ReturnStatus_type {
        RS_NO,
        RS_MAYBE,
        RS_YES;

    }
}

