/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class Statement
extends ASTNode
implements ILocateableNode,
IAppendableSyntax,
IIncrementallyUpdateable {
    protected StatementBlock myStatementBlock;
    protected Location location = NULL_Location.INSTANCE;
    protected CompilationTimeStamp lastTimeChecked;
    protected boolean isErroneous = false;

    protected Statement() {
    }

    @Override
    public final void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    public abstract Statement_type getType();

    public final CompilationTimeStamp getLastTimeChecked() {
        return this.lastTimeChecked;
    }

    public final boolean getIsErroneous() {
        return this.isErroneous;
    }

    public final void setIsErroneous() {
        this.isErroneous = true;
    }

    public abstract String getStatementName();

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        this.myStatementBlock = statementBlock;
    }

    public final StatementBlock getMyStatementBlock() {
        return this.myStatementBlock;
    }

    public void setMyDefinition(Definition definition) {
    }

    public void setMyAltguards(AltGuards altGuards) {
    }

    protected void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
    }

    public boolean isTerminating(CompilationTimeStamp timestamp) {
        return false;
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.isTerminating(timestamp)) {
            return StatementBlock.ReturnStatus_type.RS_YES;
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    public boolean hasReceivingStatement() {
        return false;
    }

    public boolean canRepeat() {
        ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for value `" + this.getFullName() + "'', reached canRepeat."));
        return false;
    }

    public abstract void check(CompilationTimeStamp var1);

    public void checkAllowedInterleave() {
    }

    public static void checkIndexRedirection(CompilationTimeStamp timestamp, Reference indexReference, ArrayDimensions arrayDimensions, boolean anyFrom, String arrayKind) {
        IType referenceType;
        if (!anyFrom) {
            indexReference.getLocation().reportSemanticError("Index redirect cannot be used without the 'any from' clause");
        }
        if ((referenceType = indexReference.checkVariableReference(timestamp)) != null) {
            int nofDimensions = arrayDimensions == null ? 0 : arrayDimensions.size();
            IType lastType = referenceType.getTypeRefdLast(timestamp);
            IType.Type_type tt = lastType.getTypetypeTtcn3();
            switch (tt) {
                case TYPE_INTEGER: {
                    if (nofDimensions > 1) {
                        indexReference.getLocation().reportSemanticError(MessageFormat.format("Indices of multi-dimensional {0} arrays can only be redirected to an integer array or a record of integers", arrayKind));
                        break;
                    }
                    if (nofDimensions != 1 || referenceType.getSubtype() == null) break;
                    ArrayDimension dimension = arrayDimensions.get(0);
                    int i = 0;
                    while ((long)i < dimension.getSize()) {
                        Integer_Value value = new Integer_Value(dimension.getOffset() + (long)i);
                        referenceType.getSubtype().checkThisValue(timestamp, value);
                        ++i;
                    }
                    break;
                }
                case TYPE_ARRAY: {
                    if (nofDimensions == 1) {
                        indexReference.getLocation().reportSemanticError(MessageFormat.format("Indices of one-dimensional {0} arrays can only be redirected to an integer", arrayKind));
                        break;
                    }
                    IType ofType = ((Array_Type)lastType).getElementType();
                    IType.Type_type tt_elem = ofType.getTypeRefdLast(timestamp).getTypetypeTtcn3();
                    if (tt == tt_elem) {
                        indexReference.getLocation().reportSemanticError("The array in the index redirect must be one-dimensional");
                    } else if (tt_elem != IType.Type_type.TYPE_INTEGER) {
                        indexReference.getLocation().reportSemanticError(MessageFormat.format("The element type of {0} in an index redirect must be integer", tt == IType.Type_type.TYPE_ARRAY ? "an array" : "a 'record of'"));
                    }
                    if (nofDimensions == 0) break;
                    ArrayDimension dimension = ((Array_Type)lastType).getDimension();
                    if (dimension.getSize() != (long)nofDimensions) {
                        indexReference.getLocation().reportSemanticError(MessageFormat.format("Size of integer array is invalid: the {0} array has {1} dimensions, but the integer array has {2} element{3}", arrayKind, nofDimensions, dimension.getSize(), dimension.getSize() == 1L ? "" : "s"));
                        break;
                    }
                    if (referenceType.getSubtype() == null) break;
                    for (int i = 0; i < nofDimensions; ++i) {
                        ArrayDimension dimension_i = arrayDimensions.get(i);
                        int j = 0;
                        while ((long)j < dimension_i.getSize()) {
                            Integer_Value value = new Integer_Value(dimension_i.getOffset() + (long)j);
                            ofType.getSubtype().checkThisValue(timestamp, value);
                            ++j;
                        }
                    }
                    break;
                }
                case TYPE_SEQUENCE_OF: {
                    if (nofDimensions == 1) {
                        indexReference.getLocation().reportSemanticError(MessageFormat.format("Indices of one-dimensional {0} arrays can only be redirected to an integer", arrayKind));
                        break;
                    }
                    IType ofType = ((SequenceOf_Type)lastType).getOfType();
                    IType.Type_type tt_elem = ofType.getTypeRefdLast(timestamp).getTypetypeTtcn3();
                    if (tt == tt_elem) {
                        indexReference.getLocation().reportSemanticError("The 'record of' in the index redirect must be one-dimensional");
                    } else if (tt_elem != IType.Type_type.TYPE_INTEGER) {
                        indexReference.getLocation().reportSemanticError(MessageFormat.format("The element type of {0} in an index redirect must be integer", tt == IType.Type_type.TYPE_ARRAY ? "an array" : "a 'record of'"));
                    }
                    if (nofDimensions == 0 || ofType.getSubtype() == null) break;
                    if (ofType.getSubtype().lengthAllowed(nofDimensions)) {
                        indexReference.getLocation().reportSemanticError(MessageFormat.format("This index redirect would result in a record of integer of length {0}, which is not allowed by the length restrictions of type `{1}''", nofDimensions, referenceType.getTypename()));
                        break;
                    }
                    for (int i = 0; i < nofDimensions; ++i) {
                        ArrayDimension dimension_i = arrayDimensions.get(i);
                        int j = 0;
                        while ((long)j < dimension_i.getSize()) {
                            Integer_Value value = new Integer_Value(dimension_i.getOffset() + (long)j);
                            ofType.getSubtype().checkThisValue(timestamp, value);
                            ++j;
                        }
                    }
                    break;
                }
                default: {
                    indexReference.getLocation().reportSemanticError(MessageFormat.format("Indices of {0} arrays can only be redirected to an integer, an integer array or a record of integers", arrayKind));
                }
            }
        }
    }

    public void postCheck() {
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(290);
        result.add(247);
        result.add(245);
        return result;
    }

    @Override
    public List<Integer> getPossiblePrefixTokens() {
        return new ArrayList<Integer>(0);
    }

    @Override
    public abstract void updateSyntax(TTCN3ReparseUpdater var1, boolean var2) throws ReParseException;

    public abstract void setCodeSection(GovernedSimple.CodeSectionType var1);

    public abstract void generateCode(JavaGenData var1, StringBuilder var2);

    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, String callTimer) {
        ErrorReporter.INTERNAL_ERROR((String)("Code generator reached invalid guard statement `" + this.getFullName() + "''"));
        expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
    }

    public static void generateCodeIndexRedirect(JavaGenData aData, ExpressionStruct expression, Reference indexRedirection, Scope scope) {
        ExpressionStruct refExpression = new ExpressionStruct();
        indexRedirection.generateCode(aData, refExpression);
        if (refExpression.preamble.length() > 0) {
            expression.preamble.append((CharSequence)refExpression.preamble);
        }
        String tempId = aData.getTemporaryVariableName();
        IType typeReference = indexRedirection.checkVariableReference(CompilationTimeStamp.getBaseTimestamp());
        expression.preamble.append(MessageFormat.format("final {0} {1} = {2};\n", typeReference.getGenNameValue(aData, expression.expression), tempId, refExpression.expression));
        aData.addBuiltinTypeImport("Index_Redirect");
        expression.expression.append("new Index_Redirect() {\n");
        expression.expression.append("@Override\n");
        expression.expression.append("public void add_index(int p_index) {\n");
        IType last = typeReference.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        switch (last.getTypetypeTtcn3()) {
            case TYPE_INTEGER: {
                expression.expression.append(MessageFormat.format("{0}.operator_assign(p_index);\n", tempId));
                break;
            }
            case TYPE_SEQUENCE_OF: {
                expression.expression.append(MessageFormat.format("{0}.get_at(pos).operator_assign(p_index);\n", tempId));
                break;
            }
            case TYPE_ARRAY: {
                ArrayDimension dimension = ((Array_Type)last).getDimension();
                long offset = dimension.getOffset();
                String offsetString = offset == 0L ? "" : (offset < 0L ? MessageFormat.format(" - {0}", -offset) : MessageFormat.format(" + {0}", offset));
                expression.expression.append(MessageFormat.format("{0}.get_at(pos{1}).operator_assign(p_index);\n", tempId, offsetString));
                break;
            }
        }
        expression.expression.append("}\n");
        expression.expression.append("}\n");
    }

    public static enum Statement_type {
        S_START_UNKNOWN,
        S_STOP_UNKNOWN,
        S_UNKNOWN_INSTANCE,
        S_UNKNOWN_APPLIED_INSTANCE,
        S_DEF,
        S_ASSIGNMENT,
        S_WHILE,
        S_DOWHILE,
        S_FOR,
        S_IF,
        S_BLOCK,
        S_SELECT,
        S_SELECT_CLASS,
        S_TRY_CATCH,
        S_LOG,
        S_LABEL,
        S_GOTO,
        S_FUNCTION_INSTANCE,
        S_FUNCTION_APPLIED,
        S_STOP_EXECUTION,
        S_TESTCASE_STOP,
        S_BREAK,
        S_CONTINUE,
        S_REPEAT,
        S_ALT,
        S_INTERLEAVE,
        S_CALL,
        S_ALTSTEP_INSTANCE,
        S_ALTSTEP_APPLIED,
        S_RETURN,
        S_ACTIVATE,
        S_ACTIVATE_REFERENCED,
        S_DEACTIVATE,
        S_SEND,
        S_REPLY,
        S_RAISE,
        S_RAISE_EXCEPTION,
        S_GETCALL,
        S_GETREPLY,
        S_CATCH,
        S_CHECK,
        S_CHECK_GETCALL,
        S_CHECK_GETREPLY,
        S_CHECK_CATCH,
        S_TRIGGER,
        S_RECEIVE,
        S_CHECK_RECEIVE,
        S_CLEAR_PORT,
        S_START_PORT,
        S_STOP_PORT,
        S_HALT_PORT,
        S_SETSTATE,
        S_START_COMPONENT,
        S_START_REFERENCED_COMPONENT,
        S_STOP_COMPONENT,
        S_DONE,
        S_KILL,
        S_KILLED,
        S_MAP,
        S_UNMAP,
        S_CONNECT,
        S_DISCONNECT,
        S_START_TIMER,
        S_STOP_TIMER,
        S_TIMEOUT,
        S_SETVERDICT,
        S_ACTION,
        S_TESTCASE_INSTANCE,
        S_REFERENCED_TESTCASE_INSTANCE,
        S_STRING2TTCN,
        S_INT2ENUM,
        S_START_PROFILER,
        S_STOP_PROFILER,
        S_UPDATE,
        S_SETENCODE;

    }
}

