/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.Char2OctExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ISO2022String_Value
extends Value {
    public static final String NEGATIVEINDEX = "A non-negative integer value was expected instead of {0} for indexing a string element";
    public static final String INDEXOWERFLOW = "Index overflow when accessing a string element: the index is {0}, but the string has only {1} elements";
    private final String value;

    public ISO2022String_Value(String value) {
        this.value = value;
    }

    public ISO2022String_Value(Charstring_Value original) {
        this.value = original.getValue();
        this.copyGeneralProperties(original);
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.ISO2022STRING_VALUE;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_GENERALSTRING;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('\"').append(this.value).append('\"');
        return builder.toString();
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value arrayIndex = ((ArraySubReference)subreference).getValue();
                IValue valueIndex = arrayIndex.getValueRefdLast(timestamp, refChain);
                if (!valueIndex.isUnfoldable(timestamp)) {
                    if (IValue.Value_type.INTEGER_VALUE.equals((Object)valueIndex.getValuetype())) {
                        int index = ((Integer_Value)valueIndex).intValue();
                        return this.getStringElement(index, arrayIndex.getLocation());
                    }
                    arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                    return null;
                }
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    public String getValueISO2022String() {
        return this.value;
    }

    public IValue getStringElement(int index, Location location) {
        if (null == this.value) {
            return null;
        }
        if (index < 0) {
            location.reportSemanticError(MessageFormat.format(NEGATIVEINDEX, index));
            return null;
        }
        if (index >= this.value.length()) {
            location.reportSemanticError(MessageFormat.format(INDEXOWERFLOW, index, this.value.length()));
        }
        return new ISO2022String_Value(this.value.substring(index, index + 1));
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        switch (last.getValuetype()) {
            case ISO2022STRING_VALUE: {
                return this.value.equals(((ISO2022String_Value)last).getValueISO2022String());
            }
        }
        return false;
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        source.append(name);
        source.append(".operator_assign( ");
        source.append((CharSequence)this.generateSingleExpression(aData));
        source.append(" );\n");
        this.lastTimeGenerated = aData.getBuildTimstamp();
        return source;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        StringBuilder result = new StringBuilder();
        if (this.myGovernor != null) {
            switch (this.myGovernor.getTypetype()) {
                case TYPE_TELETEXSTRING: {
                    aData.addBuiltinTypeImport("TitanTeletexString");
                    result.append(MessageFormat.format("TitanTeletexString.TTCN_ISO2022_2_TeletexString(new TitanOctetString(\"{0}\"))\n", Char2OctExpression.char2oct(this.value)));
                    return result;
                }
                case TYPE_VIDEOTEXSTRING: {
                    aData.addBuiltinTypeImport("TitanVideotexString");
                    result.append(MessageFormat.format("TitanVideotexString.TTCN_ISO2022_2_VideotexString(new TitanOctetString(\"{0}\"))", Char2OctExpression.char2oct(this.value)));
                    return result;
                }
                case TYPE_GRAPHICSTRING: 
                case TYPE_OBJECTDESCRIPTOR: {
                    aData.addBuiltinTypeImport("TitanGraphicString");
                    result.append(MessageFormat.format("TitanGraphicString.TTCN_ISO2022_2_GraphicString(new TitanOctetString(\"{0}\"))", Char2OctExpression.char2oct(this.value)));
                    return result;
                }
                case TYPE_GENERALSTRING: {
                    aData.addBuiltinTypeImport("TitanGeneralString");
                    result.append(MessageFormat.format("TitanGeneralString.TTCN_ISO2022_2_GeneralString(new TitanOctetString(\"{0}\"))", Char2OctExpression.char2oct(this.value)));
                    return result;
                }
            }
        }
        return result;
    }
}

