/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.preferences.PreferenceConstants;

public class DefinitionNameTooLong
extends BaseModuleCodeSmellSpotter {
    private static final String WARNING_MESSAGE = "Definition name length : `{0}'', longer than recommended length : `{1}''";
    private final int recommendedLenghtOfFunctionName = Platform.getPreferencesService().getInt("org.eclipse.titanium", PreferenceConstants.DEFINITION_NAME_TOO_LONG_LENGTH, 42, null);

    public DefinitionNameTooLong() {
        super(CodeSmellType.DEFINITION_NAME_TOO_LONG);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        Definition s;
        int lengthOfFunctionName;
        if (node instanceof Definition && (lengthOfFunctionName = (s = (Definition)node).getIdentifier().getDisplayName().length()) > this.recommendedLenghtOfFunctionName) {
            String msg = MessageFormat.format(WARNING_MESSAGE, lengthOfFunctionName, this.recommendedLenghtOfFunctionName);
            problems.report(s.getLocation(), msg);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(Definition.class);
        return ret;
    }
}

