/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences.fieldeditors;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.preferences.fieldeditors.TitanColorFieldEditor;
import org.eclipse.titan.log.viewer.utils.Messages;

public abstract class TitanListEditor
extends FieldEditor {
    private List list;
    private String[] oldItems;
    private Composite buttonBox;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener selectionListener;
    private final Set<SelectionListener> registeredSelectionListeners = new HashSet<SelectionListener>();
    private TitanColorFieldEditor colorEditor;
    private Map<String, RGB> colors;

    protected TitanListEditor() {
    }

    protected TitanListEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
        this.downButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    protected TitanListEditor(String name, String labelText, Composite parent, boolean hideUpAndDown) {
        this.init(name, labelText);
        this.createControl(parent);
        this.downButton.setVisible(hideUpAndDown);
        this.upButton.setVisible(hideUpAndDown);
        this.removeButton.setEnabled(false);
    }

    protected TitanListEditor(String name, String labelText, Composite parent, boolean hideUpAndDown, boolean hideColorEditor) {
        this.init(name, labelText);
        this.createControl(parent);
        this.downButton.setVisible(hideUpAndDown);
        this.upButton.setVisible(hideUpAndDown);
        this.removeButton.setEnabled(false);
        if (!hideColorEditor) {
            this.list.removeAll();
            this.createColors(this.buttonBox);
            this.colorEditor.setEnabled(false, this.buttonBox);
            this.colors = new HashMap<String, RGB>();
            this.downButton.moveBelow((Control)this.colorEditor.getColorSelector().getButton());
            this.upButton.moveBelow((Control)this.colorEditor.getColorSelector().getButton());
            this.colorEditor.getColorSelector().addListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String[] selection;
                    RGB selectedColor = TitanListEditor.this.colorEditor.getColorSelector().getColorValue();
                    for (String string : selection = TitanListEditor.this.list.getSelection()) {
                        TitanListEditor.this.colors.put(string, selectedColor);
                    }
                }
            });
        }
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            if (this.list.indexOf(input = input.trim()) != -1) {
                TitanLogExceptionHandler.handleException(new UserException(input + "  " + Messages.getString("TitanListEditor.2")));
                return;
            }
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input, 0);
            }
            this.selectionChanged();
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, "ListEditor.add");
        this.addButton.setText(Messages.getString("TitanListEditor.3"));
        this.removeButton = this.createPushButton(box, "ListEditor.remove");
        this.upButton = this.createPushButton(box, "ListEditor.up");
        this.downButton = this.createPushButton(box, "ListEditor.down");
    }

    private void createColors(Composite box) {
        this.colorEditor = new TitanColorFieldEditor("COLOR_PREFERENCE", "", box);
    }

    protected abstract String createList(String[] var1);

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (TitanListEditor.this.list != null) {
                    String[] selection = TitanListEditor.this.list.getSelection();
                    if (widget == TitanListEditor.this.addButton) {
                        TitanListEditor.this.addPressed();
                    } else if (widget == TitanListEditor.this.removeButton) {
                        if (selection.length > 1) {
                            TitanListEditor.this.removeMultipleElements(selection);
                        } else {
                            TitanListEditor.this.removePressed();
                        }
                    } else if (widget == TitanListEditor.this.upButton) {
                        TitanListEditor.this.upPressed();
                    } else if (widget == TitanListEditor.this.downButton) {
                        TitanListEditor.this.downPressed();
                    } else if (widget == TitanListEditor.this.list) {
                        TitanListEditor.this.selectionChanged();
                    }
                    TitanListEditor.this.valueChanged();
                    if (selection.length > 1) {
                        if (!this.containsMtsORSut(selection)) {
                            TitanListEditor.this.removeButton.setEnabled(true);
                            TitanListEditor.this.upButton.setEnabled(false);
                            TitanListEditor.this.downButton.setEnabled(false);
                            if (TitanListEditor.this.colorEditor != null) {
                                TitanListEditor.this.colorEditor.setEnabled(true, TitanListEditor.this.buttonBox);
                            }
                        } else {
                            TitanListEditor.this.removeButton.setEnabled(false);
                            TitanListEditor.this.upButton.setEnabled(false);
                            TitanListEditor.this.downButton.setEnabled(false);
                            if (TitanListEditor.this.colorEditor != null) {
                                TitanListEditor.this.colorEditor.setEnabled(false, TitanListEditor.this.buttonBox);
                            }
                        }
                    }
                }
            }

            private boolean containsMtsORSut(String[] element) {
                for (String anElement : element) {
                    if (!anElement.equals("System Under Test") && !anElement.equals("Main Test Component")) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private void removeMultipleElements(String[] elements) {
        for (String element : elements) {
            this.list.remove(element);
        }
        this.selectionChanged();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.getListControl(parent);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = numColumns;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels((Control)this.list, 40);
        this.list.setLayoutData((Object)gridData);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.list != null) {
            this.list.removeAll();
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            if (this.colorEditor != null) {
                this.loadColors(s);
            } else {
                String[] array;
                for (String str : array = this.parseString(s)) {
                    this.list.add(str);
                }
            }
        }
    }

    protected void doLoadDefault() {
        String[] array;
        if (this.list == null) {
            return;
        }
        this.list.removeAll();
        String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        for (String str : array = this.parseString(s)) {
            this.list.add(str);
        }
    }

    protected void doStore() {
        String s = null;
        String[] listItems = this.list.getItems();
        s = this.colorEditor != null ? this.createColorList(listItems) : this.createList(listItems);
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    private void downPressed() {
        this.swap(false);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TitanListEditor.this.addButton = null;
                    TitanListEditor.this.removeButton = null;
                    TitanListEditor.this.upButton = null;
                    TitanListEditor.this.downButton = null;
                    TitanListEditor.this.colorEditor = null;
                    TitanListEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new List(parent, 2818);
            this.list.setFont(parent.getFont());
            for (SelectionListener listener : this.registeredSelectionListeners) {
                this.list.addSelectionListener(listener);
            }
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TitanListEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    protected abstract String getNewInputObject();

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected abstract String[] parseString(String var1);

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            if (this.colorEditor != null) {
                String item = this.list.getItem(index);
                this.colors.remove(item);
            }
            this.list.remove(index);
            this.selectionChanged();
        }
    }

    private void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        if (index != -1) {
            String item = this.list.getItem(index);
            if (item.equals(Messages.getString("TitanListEditor.0")) || item.equals(Messages.getString("TitanListEditor.1"))) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(index >= 0);
            }
            this.upButton.setEnabled(size > 1 && index > 0);
            this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
            if (this.colorEditor != null) {
                this.colorEditor.setEnabled(index >= 0, this.buttonBox);
                RGB rgb = this.colors.get(item);
                if (rgb != null) {
                    this.colorEditor.getColorSelector().setColorValue(rgb);
                } else {
                    RGB black = new RGB(0, 0, 0);
                    this.colorEditor.getColorSelector().setColorValue(black);
                }
            }
        }
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    private void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            String[] selection = this.list.getSelection();
            this.list.remove(index);
            this.list.add(selection[0], target);
            this.list.setSelection(target);
        }
        this.selectionChanged();
    }

    private void upPressed() {
        this.swap(true);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getListControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
    }

    private void valueChanged() {
        Object[] newItems = this.list.getItems();
        if (!Arrays.equals(newItems, this.oldItems)) {
            this.fireValueChanged("field_editor_value", this.oldItems, newItems);
            this.oldItems = newItems;
        }
    }

    protected void doClear() {
        this.list.removeAll();
    }

    public void clear() {
        this.doClear();
    }

    public void addElementToList(String value) {
        this.list.add(value);
    }

    public String[] getElements() {
        return this.list.getItems();
    }

    private String createColorList(String[] listItems) {
        StringBuilder colorString = new StringBuilder("");
        for (String item : listItems) {
            RGB rgb = this.colors.get(item);
            if (rgb != null) {
                colorString.append(item);
                colorString.append("#");
                colorString.append(rgb.red);
                colorString.append(",");
                colorString.append(rgb.green);
                colorString.append(",");
                colorString.append(rgb.blue);
                colorString.append(File.pathSeparator);
                continue;
            }
            colorString.append(item);
            colorString.append("#");
            colorString.append(File.pathSeparator);
        }
        return colorString.toString();
    }

    public Map<String, RGB> getColors() {
        return this.colors;
    }

    public void setColors(Map<String, RGB> colors) {
        this.colors = colors;
    }

    private void loadColors(String stringList) {
        StringTokenizer stringColors = new StringTokenizer(stringList, File.pathSeparator);
        while (stringColors.hasMoreElements()) {
            String stringColor = (String)stringColors.nextElement();
            String[] sc = stringColor.split("#");
            if (sc.length <= 1) continue;
            String item = sc[0];
            String colorString = sc[1];
            this.list.add(item);
            RGB rgb = null;
            if (colorString != null && colorString.trim().length() > 0) {
                String[] splitColor = colorString.split(",");
                int red = Integer.parseInt(splitColor[0]);
                int green = Integer.parseInt(splitColor[1]);
                int blue = Integer.parseInt(splitColor[2]);
                rgb = new RGB(red, green, blue);
            }
            if (item == null || rgb == null) continue;
            this.colors.put(item, rgb);
        }
    }

    public void addSelectionChangedListener(SelectionListener listener) {
        this.list.addSelectionListener(listener);
        this.registeredSelectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(SelectionListener listener) {
        this.list.removeSelectionListener(listener);
        this.registeredSelectionListeners.remove(listener);
    }

    public String[] getSelection() {
        return this.list.getSelection();
    }
}

