"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GDBPTYProcessManager = void 0;
const GDBFileSystemProcessManager_1 = require("./GDBFileSystemProcessManager");
class GDBPTYProcessManager extends GDBFileSystemProcessManager_1.GDBFileSystemProcessManager {
    constructor(session) {
        super();
        this.session = session;
    }
    start(requestArgs) {
        return __awaiter(this, void 0, void 0, function* () {
            this.requestArgs = requestArgs;
            yield this.getVersion(requestArgs);
            const gdbPath = requestArgs.gdb || 'gdb';
            const gdbEnvironment = this.getEnvironment(requestArgs.environment);
            const gdbCwd = this.getGdbCwd(requestArgs);
            const { Pty } = yield Promise.resolve().then(() => require('../../native/pty'));
            const pty = new Pty();
            let gdbArgs = [gdbPath, '-ex', `new-ui mi2 ${pty.slave_name}`];
            if (requestArgs.gdbArguments) {
                gdbArgs = gdbArgs.concat(requestArgs.gdbArguments);
            }
            const response = yield new Promise((resolve) => this.session.sendRequest('runInTerminal', {
                kind: 'integrated',
                cwd: gdbCwd,
                env: gdbEnvironment,
                args: gdbArgs,
            }, 5000, resolve));
            if (!response.success) {
                const message = `could not start the terminal on the client: ${response.message}`;
                // logger.error(message);
                throw new Error(message);
            }
            const item = {
                stdout: pty.reader,
                stdin: pty.writer,
                stderr: null,
                pid: null,
                exitCode: null,
                kill: () => { },
                on: (event, fn) => {
                    return item;
                },
            };
            return item;
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.proc) {
                throw new Error('GDB is not running, nothing to interrupt');
            }
            // logger.verbose(`GDB signal: SIGINT to pid ${this.proc.pid}`);
            this.proc.kill('SIGINT');
        });
    }
}
exports.GDBPTYProcessManager = GDBPTYProcessManager;
//# sourceMappingURL=GDBPTYProcessManager.js.map