/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ja extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_zbl = "\u30d6\u30ea\u30b9\u30b7\u30f3\u30dc\u30eb";
        final String metaValue_ssy = "\u30b5\u30db\u8a9e";
        final Object[][] data = new Object[][] {
            { "001", "\u4e16\u754c" },
            { "002", "\u30a2\u30d5\u30ea\u30ab" },
            { "003", "\u5317\u30a2\u30e1\u30ea\u30ab\u5927\u9678" },
            { "005", "\u5357\u30a2\u30e1\u30ea\u30ab" },
            { "009", "\u30aa\u30bb\u30a2\u30cb\u30a2" },
            { "011", "\u897f\u30a2\u30d5\u30ea\u30ab" },
            { "013", "\u4e2d\u592e\u30a2\u30e1\u30ea\u30ab" },
            { "014", "\u6771\u30a2\u30d5\u30ea\u30ab" },
            { "015", "\u5317\u30a2\u30d5\u30ea\u30ab" },
            { "017", "\u4e2d\u90e8\u30a2\u30d5\u30ea\u30ab" },
            { "018", "\u5357\u90e8\u30a2\u30d5\u30ea\u30ab" },
            { "019", "\u30a2\u30e1\u30ea\u30ab\u5927\u9678" },
            { "021", "\u5317\u30a2\u30e1\u30ea\u30ab" },
            { "029", "\u30ab\u30ea\u30d6" },
            { "030", "\u6771\u30a2\u30b8\u30a2" },
            { "034", "\u5357\u30a2\u30b8\u30a2" },
            { "035", "\u6771\u5357\u30a2\u30b8\u30a2" },
            { "039", "\u5357\u30e8\u30fc\u30ed\u30c3\u30d1" },
            { "053", "\u30aa\u30fc\u30b9\u30c8\u30e9\u30e9\u30b7\u30a2" },
            { "054", "\u30e1\u30e9\u30cd\u30b7\u30a2" },
            { "057", "\u30df\u30af\u30ed\u30cd\u30b7\u30a2" },
            { "061", "\u30dd\u30ea\u30cd\u30b7\u30a2" },
            { "142", "\u30a2\u30b8\u30a2" },
            { "143", "\u4e2d\u592e\u30a2\u30b8\u30a2" },
            { "145", "\u897f\u30a2\u30b8\u30a2" },
            { "150", "\u30e8\u30fc\u30ed\u30c3\u30d1" },
            { "151", "\u6771\u30e8\u30fc\u30ed\u30c3\u30d1" },
            { "154", "\u5317\u30e8\u30fc\u30ed\u30c3\u30d1" },
            { "155", "\u897f\u30e8\u30fc\u30ed\u30c3\u30d1" },
            { "202", "\u30b5\u30d6\u30b5\u30cf\u30e9\u30a2\u30d5\u30ea\u30ab" },
            { "419", "\u30e9\u30c6\u30f3\u30a2\u30e1\u30ea\u30ab" },
            { "AC", "\u30a2\u30bb\u30f3\u30b7\u30e7\u30f3\u5cf6" },
            { "AD", "\u30a2\u30f3\u30c9\u30e9" },
            { "AE", "\u30a2\u30e9\u30d6\u9996\u9577\u56fd\u9023\u90a6" },
            { "AF", "\u30a2\u30d5\u30ac\u30cb\u30b9\u30bf\u30f3" },
            { "AG", "\u30a2\u30f3\u30c6\u30a3\u30b0\u30a2\u30fb\u30d0\u30fc\u30d6\u30fc\u30c0" },
            { "AI", "\u30a2\u30f3\u30ae\u30e9" },
            { "AL", "\u30a2\u30eb\u30d0\u30cb\u30a2" },
            { "AM", "\u30a2\u30eb\u30e1\u30cb\u30a2" },
            { "AO", "\u30a2\u30f3\u30b4\u30e9" },
            { "AQ", "\u5357\u6975" },
            { "AR", "\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3" },
            { "AS", "\u7c73\u9818\u30b5\u30e2\u30a2" },
            { "AT", "\u30aa\u30fc\u30b9\u30c8\u30ea\u30a2" },
            { "AU", "\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2" },
            { "AW", "\u30a2\u30eb\u30d0" },
            { "AX", "\u30aa\u30fc\u30e9\u30f3\u30c9\u8af8\u5cf6" },
            { "AZ", "\u30a2\u30bc\u30eb\u30d0\u30a4\u30b8\u30e3\u30f3" },
            { "BA", "\u30dc\u30b9\u30cb\u30a2\u30fb\u30d8\u30eb\u30c4\u30a7\u30b4\u30d3\u30ca" },
            { "BB", "\u30d0\u30eb\u30d0\u30c9\u30b9" },
            { "BD", "\u30d0\u30f3\u30b0\u30e9\u30c7\u30b7\u30e5" },
            { "BE", "\u30d9\u30eb\u30ae\u30fc" },
            { "BF", "\u30d6\u30eb\u30ad\u30ca\u30d5\u30a1\u30bd" },
            { "BG", "\u30d6\u30eb\u30ac\u30ea\u30a2" },
            { "BH", "\u30d0\u30fc\u30ec\u30fc\u30f3" },
            { "BI", "\u30d6\u30eb\u30f3\u30b8" },
            { "BJ", "\u30d9\u30ca\u30f3" },
            { "BL", "\u30b5\u30f3\u30fb\u30d0\u30eb\u30c6\u30eb\u30df\u30fc" },
            { "BM", "\u30d0\u30df\u30e5\u30fc\u30c0" },
            { "BN", "\u30d6\u30eb\u30cd\u30a4" },
            { "BO", "\u30dc\u30ea\u30d3\u30a2" },
            { "BQ", "\u30aa\u30e9\u30f3\u30c0\u9818\u30ab\u30ea\u30d6" },
            { "BR", "\u30d6\u30e9\u30b8\u30eb" },
            { "BS", "\u30d0\u30cf\u30de" },
            { "BT", "\u30d6\u30fc\u30bf\u30f3" },
            { "BV", "\u30d6\u30fc\u30d9\u5cf6" },
            { "BW", "\u30dc\u30c4\u30ef\u30ca" },
            { "BY", "\u30d9\u30e9\u30eb\u30fc\u30b7" },
            { "BZ", "\u30d9\u30ea\u30fc\u30ba" },
            { "CA", "\u30ab\u30ca\u30c0" },
            { "CC", "\u30b3\u30b3\u30b9(\u30ad\u30fc\u30ea\u30f3\u30b0)\u8af8\u5cf6" },
            { "CD", "\u30b3\u30f3\u30b4\u6c11\u4e3b\u5171\u548c\u56fd(\u30ad\u30f3\u30b7\u30e3\u30b5)" },
            { "CF", "\u4e2d\u592e\u30a2\u30d5\u30ea\u30ab\u5171\u548c\u56fd" },
            { "CG", "\u30b3\u30f3\u30b4\u5171\u548c\u56fd(\u30d6\u30e9\u30b6\u30d3\u30eb)" },
            { "CH", "\u30b9\u30a4\u30b9" },
            { "CI", "\u30b3\u30fc\u30c8\u30b8\u30dc\u30ef\u30fc\u30eb" },
            { "CK", "\u30af\u30c3\u30af\u8af8\u5cf6" },
            { "CL", "\u30c1\u30ea" },
            { "CM", "\u30ab\u30e1\u30eb\u30fc\u30f3" },
            { "CN", "\u4e2d\u56fd" },
            { "CO", "\u30b3\u30ed\u30f3\u30d3\u30a2" },
            { "CP", "\u30af\u30ea\u30c3\u30d1\u30fc\u30c8\u30f3\u5cf6" },
            { "CR", "\u30b3\u30b9\u30bf\u30ea\u30ab" },
            { "CU", "\u30ad\u30e5\u30fc\u30d0" },
            { "CV", "\u30ab\u30fc\u30dc\u30d9\u30eb\u30c7" },
            { "CW", "\u30ad\u30e5\u30e9\u30bd\u30fc" },
            { "CX", "\u30af\u30ea\u30b9\u30de\u30b9\u5cf6" },
            { "CY", "\u30ad\u30d7\u30ed\u30b9" },
            { "CZ", "\u30c1\u30a7\u30b3" },
            { "DE", "\u30c9\u30a4\u30c4" },
            { "DG", "\u30c7\u30a3\u30a8\u30b4\u30ac\u30eb\u30b7\u30a2\u5cf6" },
            { "DJ", "\u30b8\u30d6\u30c1" },
            { "DK", "\u30c7\u30f3\u30de\u30fc\u30af" },
            { "DM", "\u30c9\u30df\u30cb\u30ab\u56fd" },
            { "DO", "\u30c9\u30df\u30cb\u30ab\u5171\u548c\u56fd" },
            { "DZ", "\u30a2\u30eb\u30b8\u30a7\u30ea\u30a2" },
            { "EA", "\u30bb\u30a6\u30bf\u30fb\u30e1\u30ea\u30ea\u30e3" },
            { "EC", "\u30a8\u30af\u30a2\u30c9\u30eb" },
            { "EE", "\u30a8\u30b9\u30c8\u30cb\u30a2" },
            { "EG", "\u30a8\u30b8\u30d7\u30c8" },
            { "EH", "\u897f\u30b5\u30cf\u30e9" },
            { "ER", "\u30a8\u30ea\u30c8\u30ea\u30a2" },
            { "ES", "\u30b9\u30da\u30a4\u30f3" },
            { "ET", "\u30a8\u30c1\u30aa\u30d4\u30a2" },
            { "EU", "\u6b27\u5dde\u9023\u5408" },
            { "EZ", "\u30e6\u30fc\u30ed\u570f" },
            { "FI", "\u30d5\u30a3\u30f3\u30e9\u30f3\u30c9" },
            { "FJ", "\u30d5\u30a3\u30b8\u30fc" },
            { "FK", "\u30d5\u30a9\u30fc\u30af\u30e9\u30f3\u30c9\u8af8\u5cf6" },
            { "FM", "\u30df\u30af\u30ed\u30cd\u30b7\u30a2\u9023\u90a6" },
            { "FO", "\u30d5\u30a7\u30ed\u30fc\u8af8\u5cf6" },
            { "FR", "\u30d5\u30e9\u30f3\u30b9" },
            { "GA", "\u30ac\u30dc\u30f3" },
            { "GB", "\u30a4\u30ae\u30ea\u30b9" },
            { "GD", "\u30b0\u30ec\u30ca\u30c0" },
            { "GE", "\u30b8\u30e7\u30fc\u30b8\u30a2" },
            { "GF", "\u4ecf\u9818\u30ae\u30a2\u30ca" },
            { "GG", "\u30ac\u30fc\u30f3\u30b8\u30fc" },
            { "GH", "\u30ac\u30fc\u30ca" },
            { "GI", "\u30b8\u30d6\u30e9\u30eb\u30bf\u30eb" },
            { "GL", "\u30b0\u30ea\u30fc\u30f3\u30e9\u30f3\u30c9" },
            { "GM", "\u30ac\u30f3\u30d3\u30a2" },
            { "GN", "\u30ae\u30cb\u30a2" },
            { "GP", "\u30b0\u30a2\u30c9\u30eb\u30fc\u30d7" },
            { "GQ", "\u8d64\u9053\u30ae\u30cb\u30a2" },
            { "GR", "\u30ae\u30ea\u30b7\u30e3" },
            { "GS", "\u30b5\u30a6\u30b9\u30b8\u30e7\u30fc\u30b8\u30a2\u30fb\u30b5\u30a6\u30b9\u30b5\u30f3\u30c9\u30a6\u30a3\u30c3\u30c1\u8af8\u5cf6" },
            { "GT", "\u30b0\u30a2\u30c6\u30de\u30e9" },
            { "GU", "\u30b0\u30a2\u30e0" },
            { "GW", "\u30ae\u30cb\u30a2\u30d3\u30b5\u30a6" },
            { "GY", "\u30ac\u30a4\u30a2\u30ca" },
            { "HK", "\u4e2d\u83ef\u4eba\u6c11\u5171\u548c\u56fd\u9999\u6e2f\u7279\u5225\u884c\u653f\u533a" },
            { "HM", "\u30cf\u30fc\u30c9\u5cf6\u30fb\u30de\u30af\u30c9\u30ca\u30eb\u30c9\u8af8\u5cf6" },
            { "HN", "\u30db\u30f3\u30b8\u30e5\u30e9\u30b9" },
            { "HR", "\u30af\u30ed\u30a2\u30c1\u30a2" },
            { "HT", "\u30cf\u30a4\u30c1" },
            { "HU", "\u30cf\u30f3\u30ac\u30ea\u30fc" },
            { "IC", "\u30ab\u30ca\u30ea\u30a2\u8af8\u5cf6" },
            { "ID", "\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2" },
            { "IE", "\u30a2\u30a4\u30eb\u30e9\u30f3\u30c9" },
            { "IL", "\u30a4\u30b9\u30e9\u30a8\u30eb" },
            { "IM", "\u30de\u30f3\u5cf6" },
            { "IN", "\u30a4\u30f3\u30c9" },
            { "IO", "\u82f1\u9818\u30a4\u30f3\u30c9\u6d0b\u5730\u57df" },
            { "IQ", "\u30a4\u30e9\u30af" },
            { "IR", "\u30a4\u30e9\u30f3" },
            { "IS", "\u30a2\u30a4\u30b9\u30e9\u30f3\u30c9" },
            { "IT", "\u30a4\u30bf\u30ea\u30a2" },
            { "JE", "\u30b8\u30e3\u30fc\u30b8\u30fc" },
            { "JM", "\u30b8\u30e3\u30de\u30a4\u30ab" },
            { "JO", "\u30e8\u30eb\u30c0\u30f3" },
            { "JP", "\u65e5\u672c" },
            { "KE", "\u30b1\u30cb\u30a2" },
            { "KG", "\u30ad\u30eb\u30ae\u30b9" },
            { "KH", "\u30ab\u30f3\u30dc\u30b8\u30a2" },
            { "KI", "\u30ad\u30ea\u30d0\u30b9" },
            { "KM", "\u30b3\u30e2\u30ed" },
            { "KN", "\u30bb\u30f3\u30c8\u30af\u30ea\u30b9\u30c8\u30d5\u30a1\u30fc\u30fb\u30cd\u30fc\u30f4\u30a3\u30b9" },
            { "KP", "\u5317\u671d\u9bae" },
            { "KR", "\u97d3\u56fd" },
            { "KW", "\u30af\u30a6\u30a7\u30fc\u30c8" },
            { "KY", "\u30b1\u30a4\u30de\u30f3\u8af8\u5cf6" },
            { "KZ", "\u30ab\u30b6\u30d5\u30b9\u30bf\u30f3" },
            { "LA", "\u30e9\u30aa\u30b9" },
            { "LB", "\u30ec\u30d0\u30ce\u30f3" },
            { "LC", "\u30bb\u30f3\u30c8\u30eb\u30b7\u30a2" },
            { "LI", "\u30ea\u30d2\u30c6\u30f3\u30b7\u30e5\u30bf\u30a4\u30f3" },
            { "LK", "\u30b9\u30ea\u30e9\u30f3\u30ab" },
            { "LR", "\u30ea\u30d9\u30ea\u30a2" },
            { "LS", "\u30ec\u30bd\u30c8" },
            { "LT", "\u30ea\u30c8\u30a2\u30cb\u30a2" },
            { "LU", "\u30eb\u30af\u30bb\u30f3\u30d6\u30eb\u30af" },
            { "LV", "\u30e9\u30c8\u30d3\u30a2" },
            { "LY", "\u30ea\u30d3\u30a2" },
            { "MA", "\u30e2\u30ed\u30c3\u30b3" },
            { "MC", "\u30e2\u30ca\u30b3" },
            { "MD", "\u30e2\u30eb\u30c9\u30d0" },
            { "ME", "\u30e2\u30f3\u30c6\u30cd\u30b0\u30ed" },
            { "MF", "\u30b5\u30f3\u30fb\u30de\u30eb\u30bf\u30f3" },
            { "MG", "\u30de\u30c0\u30ac\u30b9\u30ab\u30eb" },
            { "MH", "\u30de\u30fc\u30b7\u30e3\u30eb\u8af8\u5cf6" },
            { "MK", "\u5317\u30de\u30b1\u30c9\u30cb\u30a2" },
            { "ML", "\u30de\u30ea" },
            { "MM", "\u30df\u30e3\u30f3\u30de\u30fc (\u30d3\u30eb\u30de)" },
            { "MN", "\u30e2\u30f3\u30b4\u30eb" },
            { "MO", "\u4e2d\u83ef\u4eba\u6c11\u5171\u548c\u56fd\u30de\u30ab\u30aa\u7279\u5225\u884c\u653f\u533a" },
            { "MP", "\u5317\u30de\u30ea\u30a2\u30ca\u8af8\u5cf6" },
            { "MQ", "\u30de\u30eb\u30c6\u30a3\u30cb\u30fc\u30af" },
            { "MR", "\u30e2\u30fc\u30ea\u30bf\u30cb\u30a2" },
            { "MS", "\u30e2\u30f3\u30c8\u30bb\u30e9\u30c8" },
            { "MT", "\u30de\u30eb\u30bf" },
            { "MU", "\u30e2\u30fc\u30ea\u30b7\u30e3\u30b9" },
            { "MV", "\u30e2\u30eb\u30c7\u30a3\u30d6" },
            { "MW", "\u30de\u30e9\u30a6\u30a4" },
            { "MX", "\u30e1\u30ad\u30b7\u30b3" },
            { "MY", "\u30de\u30ec\u30fc\u30b7\u30a2" },
            { "MZ", "\u30e2\u30b6\u30f3\u30d3\u30fc\u30af" },
            { "NA", "\u30ca\u30df\u30d3\u30a2" },
            { "NC", "\u30cb\u30e5\u30fc\u30ab\u30ec\u30c9\u30cb\u30a2" },
            { "NE", "\u30cb\u30b8\u30a7\u30fc\u30eb" },
            { "NF", "\u30ce\u30fc\u30d5\u30a9\u30fc\u30af\u5cf6" },
            { "NG", "\u30ca\u30a4\u30b8\u30a7\u30ea\u30a2" },
            { "NI", "\u30cb\u30ab\u30e9\u30b0\u30a2" },
            { "NL", "\u30aa\u30e9\u30f3\u30c0" },
            { "NO", "\u30ce\u30eb\u30a6\u30a7\u30fc" },
            { "NP", "\u30cd\u30d1\u30fc\u30eb" },
            { "NR", "\u30ca\u30a6\u30eb" },
            { "NU", "\u30cb\u30a6\u30a8" },
            { "NZ", "\u30cb\u30e5\u30fc\u30b8\u30fc\u30e9\u30f3\u30c9" },
            { "OM", "\u30aa\u30de\u30fc\u30f3" },
            { "PA", "\u30d1\u30ca\u30de" },
            { "PE", "\u30da\u30eb\u30fc" },
            { "PF", "\u4ecf\u9818\u30dd\u30ea\u30cd\u30b7\u30a2" },
            { "PG", "\u30d1\u30d7\u30a2\u30cb\u30e5\u30fc\u30ae\u30cb\u30a2" },
            { "PH", "\u30d5\u30a3\u30ea\u30d4\u30f3" },
            { "PK", "\u30d1\u30ad\u30b9\u30bf\u30f3" },
            { "PL", "\u30dd\u30fc\u30e9\u30f3\u30c9" },
            { "PM", "\u30b5\u30f3\u30d4\u30a8\u30fc\u30eb\u5cf6\u30fb\u30df\u30af\u30ed\u30f3\u5cf6" },
            { "PN", "\u30d4\u30c8\u30b1\u30a2\u30f3\u8af8\u5cf6" },
            { "PR", "\u30d7\u30a8\u30eb\u30c8\u30ea\u30b3" },
            { "PS", "\u30d1\u30ec\u30b9\u30c1\u30ca\u81ea\u6cbb\u533a" },
            { "PT", "\u30dd\u30eb\u30c8\u30ac\u30eb" },
            { "PW", "\u30d1\u30e9\u30aa" },
            { "PY", "\u30d1\u30e9\u30b0\u30a2\u30a4" },
            { "QA", "\u30ab\u30bf\u30fc\u30eb" },
            { "QO", "\u30aa\u30bb\u30a2\u30cb\u30a2\u5468\u8fba\u5730\u57df" },
            { "RE", "\u30ec\u30e6\u30cb\u30aa\u30f3" },
            { "RO", "\u30eb\u30fc\u30de\u30cb\u30a2" },
            { "RS", "\u30bb\u30eb\u30d3\u30a2" },
            { "RU", "\u30ed\u30b7\u30a2" },
            { "RW", "\u30eb\u30ef\u30f3\u30c0" },
            { "SA", "\u30b5\u30a6\u30b8\u30a2\u30e9\u30d3\u30a2" },
            { "SB", "\u30bd\u30ed\u30e2\u30f3\u8af8\u5cf6" },
            { "SC", "\u30bb\u30fc\u30b7\u30a7\u30eb" },
            { "SD", "\u30b9\u30fc\u30c0\u30f3" },
            { "SE", "\u30b9\u30a6\u30a7\u30fc\u30c7\u30f3" },
            { "SG", "\u30b7\u30f3\u30ac\u30dd\u30fc\u30eb" },
            { "SH", "\u30bb\u30f3\u30c8\u30d8\u30ec\u30ca" },
            { "SI", "\u30b9\u30ed\u30d9\u30cb\u30a2" },
            { "SJ", "\u30b9\u30d0\u30fc\u30eb\u30d0\u30eb\u8af8\u5cf6\u30fb\u30e4\u30f3\u30de\u30a4\u30a8\u30f3\u5cf6" },
            { "SK", "\u30b9\u30ed\u30d0\u30ad\u30a2" },
            { "SL", "\u30b7\u30a8\u30e9\u30ec\u30aa\u30cd" },
            { "SM", "\u30b5\u30f3\u30de\u30ea\u30ce" },
            { "SN", "\u30bb\u30cd\u30ac\u30eb" },
            { "SO", "\u30bd\u30de\u30ea\u30a2" },
            { "SR", "\u30b9\u30ea\u30ca\u30e0" },
            { "SS", "\u5357\u30b9\u30fc\u30c0\u30f3" },
            { "ST", "\u30b5\u30f3\u30c8\u30e1\u30fb\u30d7\u30ea\u30f3\u30b7\u30da" },
            { "SV", "\u30a8\u30eb\u30b5\u30eb\u30d0\u30c9\u30eb" },
            { "SX", "\u30b7\u30f3\u30c8\u30fb\u30de\u30fc\u30eb\u30c6\u30f3" },
            { "SY", "\u30b7\u30ea\u30a2" },
            { "SZ", "\u30a8\u30b9\u30ef\u30c6\u30a3\u30cb" },
            { "TA", "\u30c8\u30ea\u30b9\u30bf\u30f3\u30fb\u30c0\u30fb\u30af\u30fc\u30cb\u30e3" },
            { "TC", "\u30bf\u30fc\u30af\u30b9\u30fb\u30ab\u30a4\u30b3\u30b9\u8af8\u5cf6" },
            { "TD", "\u30c1\u30e3\u30c9" },
            { "TF", "\u4ecf\u9818\u6975\u5357\u8af8\u5cf6" },
            { "TG", "\u30c8\u30fc\u30b4" },
            { "TH", "\u30bf\u30a4" },
            { "TJ", "\u30bf\u30b8\u30ad\u30b9\u30bf\u30f3" },
            { "TK", "\u30c8\u30b1\u30e9\u30a6" },
            { "TL", "\u6771\u30c6\u30a3\u30e2\u30fc\u30eb" },
            { "TM", "\u30c8\u30eb\u30af\u30e1\u30cb\u30b9\u30bf\u30f3" },
            { "TN", "\u30c1\u30e5\u30cb\u30b8\u30a2" },
            { "TO", "\u30c8\u30f3\u30ac" },
            { "TR", "\u30c8\u30eb\u30b3" },
            { "TT", "\u30c8\u30ea\u30cb\u30c0\u30fc\u30c9\u30fb\u30c8\u30d0\u30b4" },
            { "TV", "\u30c4\u30d0\u30eb" },
            { "TW", "\u53f0\u6e7e" },
            { "TZ", "\u30bf\u30f3\u30b6\u30cb\u30a2" },
            { "UA", "\u30a6\u30af\u30e9\u30a4\u30ca" },
            { "UG", "\u30a6\u30ac\u30f3\u30c0" },
            { "UM", "\u5408\u8846\u56fd\u9818\u6709\u5c0f\u96e2\u5cf6" },
            { "UN", "\u56fd\u969b\u9023\u5408" },
            { "US", "\u30a2\u30e1\u30ea\u30ab\u5408\u8846\u56fd" },
            { "UY", "\u30a6\u30eb\u30b0\u30a2\u30a4" },
            { "UZ", "\u30a6\u30ba\u30d9\u30ad\u30b9\u30bf\u30f3" },
            { "VA", "\u30d0\u30c1\u30ab\u30f3\u5e02\u56fd" },
            { "VC", "\u30bb\u30f3\u30c8\u30d3\u30f3\u30bb\u30f3\u30c8\u53ca\u3073\u30b0\u30ec\u30ca\u30c7\u30a3\u30fc\u30f3\u8af8\u5cf6" },
            { "VE", "\u30d9\u30cd\u30ba\u30a8\u30e9" },
            { "VG", "\u82f1\u9818\u30f4\u30a1\u30fc\u30b8\u30f3\u8af8\u5cf6" },
            { "VI", "\u7c73\u9818\u30f4\u30a1\u30fc\u30b8\u30f3\u8af8\u5cf6" },
            { "VN", "\u30d9\u30c8\u30ca\u30e0" },
            { "VU", "\u30d0\u30cc\u30a2\u30c4" },
            { "WF", "\u30a6\u30a9\u30ea\u30b9\u30fb\u30d5\u30c4\u30ca" },
            { "WS", "\u30b5\u30e2\u30a2" },
            { "XA", "\u7591\u4f3c\u30a2\u30af\u30bb\u30f3\u30c8" },
            { "XB", "\u7591\u4f3c BIDI" },
            { "XK", "\u30b3\u30bd\u30dc" },
            { "YE", "\u30a4\u30a8\u30e1\u30f3" },
            { "YT", "\u30de\u30e8\u30c3\u30c8" },
            { "ZA", "\u5357\u30a2\u30d5\u30ea\u30ab" },
            { "ZM", "\u30b6\u30f3\u30d3\u30a2" },
            { "ZW", "\u30b8\u30f3\u30d0\u30d6\u30a8" },
            { "ZZ", "\u4e0d\u660e\u306a\u5730\u57df" },
            { "aa", "\u30a2\u30d5\u30a1\u30eb\u8a9e" },
            { "ab", "\u30a2\u30d6\u30cf\u30ba\u8a9e" },
            { "ae", "\u30a2\u30f4\u30a7\u30b9\u30bf\u8a9e" },
            { "af", "\u30a2\u30d5\u30ea\u30ab\u30fc\u30f3\u30b9\u8a9e" },
            { "ak", "\u30a2\u30ab\u30f3\u8a9e" },
            { "am", "\u30a2\u30e0\u30cf\u30e9\u8a9e" },
            { "an", "\u30a2\u30e9\u30b4\u30f3\u8a9e" },
            { "ar", "\u30a2\u30e9\u30d3\u30a2\u8a9e" },
            { "as", "\u30a2\u30c3\u30b5\u30e0\u8a9e" },
            { "av", "\u30a2\u30f4\u30a1\u30eb\u8a9e" },
            { "ay", "\u30a2\u30a4\u30de\u30e9\u8a9e" },
            { "az", "\u30a2\u30bc\u30eb\u30d0\u30a4\u30b8\u30e3\u30f3\u8a9e" },
            { "ba", "\u30d0\u30b7\u30ad\u30fc\u30eb\u8a9e" },
            { "be", "\u30d9\u30e9\u30eb\u30fc\u30b7\u8a9e" },
            { "bg", "\u30d6\u30eb\u30ac\u30ea\u30a2\u8a9e" },
            { "bi", "\u30d3\u30b9\u30e9\u30de\u8a9e" },
            { "bm", "\u30d0\u30f3\u30d0\u30e9\u8a9e" },
            { "bn", "\u30d9\u30f3\u30ac\u30eb\u8a9e" },
            { "bo", "\u30c1\u30d9\u30c3\u30c8\u8a9e" },
            { "br", "\u30d6\u30eb\u30c8\u30f3\u8a9e" },
            { "bs", "\u30dc\u30b9\u30cb\u30a2\u8a9e" },
            { "ca", "\u30ab\u30bf\u30ed\u30cb\u30a2\u8a9e" },
            { "ce", "\u30c1\u30a7\u30c1\u30a7\u30f3\u8a9e" },
            { "ch", "\u30c1\u30e3\u30e2\u30ed\u8a9e" },
            { "co", "\u30b3\u30eb\u30b7\u30ab\u8a9e" },
            { "cr", "\u30af\u30ea\u30fc\u8a9e" },
            { "cs", "\u30c1\u30a7\u30b3\u8a9e" },
            { "cu", "\u6559\u4f1a\u30b9\u30e9\u30d6\u8a9e" },
            { "cv", "\u30c1\u30e5\u30f4\u30a1\u30b7\u8a9e" },
            { "cy", "\u30a6\u30a7\u30fc\u30eb\u30ba\u8a9e" },
            { "da", "\u30c7\u30f3\u30de\u30fc\u30af\u8a9e" },
            { "de", "\u30c9\u30a4\u30c4\u8a9e" },
            { "dv", "\u30c7\u30a3\u30d9\u30d2\u8a9e" },
            { "dz", "\u30be\u30f3\u30ab\u8a9e" },
            { "ee", "\u30a8\u30a6\u30a7\u8a9e" },
            { "el", "\u30ae\u30ea\u30b7\u30e3\u8a9e" },
            { "en", "\u82f1\u8a9e" },
            { "eo", "\u30a8\u30b9\u30da\u30e9\u30f3\u30c8\u8a9e" },
            { "es", "\u30b9\u30da\u30a4\u30f3\u8a9e" },
            { "et", "\u30a8\u30b9\u30c8\u30cb\u30a2\u8a9e" },
            { "eu", "\u30d0\u30b9\u30af\u8a9e" },
            { "fa", "\u30da\u30eb\u30b7\u30a2\u8a9e" },
            { "ff", "\u30d5\u30e9\u8a9e" },
            { "fi", "\u30d5\u30a3\u30f3\u30e9\u30f3\u30c9\u8a9e" },
            { "fj", "\u30d5\u30a3\u30b8\u30fc\u8a9e" },
            { "fo", "\u30d5\u30a7\u30ed\u30fc\u8a9e" },
            { "fr", "\u30d5\u30e9\u30f3\u30b9\u8a9e" },
            { "fy", "\u897f\u30d5\u30ea\u30b8\u30a2\u8a9e" },
            { "ga", "\u30a2\u30a4\u30eb\u30e9\u30f3\u30c9\u8a9e" },
            { "gd", "\u30b9\u30b3\u30c3\u30c8\u30e9\u30f3\u30c9\u30fb\u30b2\u30fc\u30eb\u8a9e" },
            { "gl", "\u30ac\u30ea\u30b7\u30a2\u8a9e" },
            { "gn", "\u30b0\u30a2\u30e9\u30cb\u30fc\u8a9e" },
            { "gu", "\u30b0\u30b8\u30e3\u30e9\u30fc\u30c8\u8a9e" },
            { "gv", "\u30de\u30f3\u5cf6\u8a9e" },
            { "ha", "\u30cf\u30a6\u30b5\u8a9e" },
            { "he", "\u30d8\u30d6\u30e9\u30a4\u8a9e" },
            { "hi", "\u30d2\u30f3\u30c7\u30a3\u30fc\u8a9e" },
            { "ho", "\u30d2\u30ea\u30e2\u30c4\u8a9e" },
            { "hr", "\u30af\u30ed\u30a2\u30c1\u30a2\u8a9e" },
            { "ht", "\u30cf\u30a4\u30c1\u30fb\u30af\u30ec\u30aa\u30fc\u30eb\u8a9e" },
            { "hu", "\u30cf\u30f3\u30ac\u30ea\u30fc\u8a9e" },
            { "hy", "\u30a2\u30eb\u30e1\u30cb\u30a2\u8a9e" },
            { "hz", "\u30d8\u30ec\u30ed\u8a9e" },
            { "ia", "\u30a4\u30f3\u30bf\u30fc\u30ea\u30f3\u30b0\u30a2" },
            { "id", "\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2\u8a9e" },
            { "ie", "\u30a4\u30f3\u30bf\u30fc\u30ea\u30f3\u30b0" },
            { "ig", "\u30a4\u30dc\u8a9e" },
            { "ii", "\u56db\u5ddd\u30a4\u8a9e" },
            { "ik", "\u30a4\u30cc\u30d4\u30a2\u30c3\u30af\u8a9e" },
            { "io", "\u30a4\u30c9\u8a9e" },
            { "is", "\u30a2\u30a4\u30b9\u30e9\u30f3\u30c9\u8a9e" },
            { "it", "\u30a4\u30bf\u30ea\u30a2\u8a9e" },
            { "iu", "\u30a4\u30cc\u30af\u30c6\u30a3\u30c8\u30c3\u30c8\u8a9e" },
            { "ja", "\u65e5\u672c\u8a9e" },
            { "jv", "\u30b8\u30e3\u30ef\u8a9e" },
            { "ka", "\u30b8\u30e7\u30fc\u30b8\u30a2\u8a9e" },
            { "kg", "\u30b3\u30f3\u30b4\u8a9e" },
            { "ki", "\u30ad\u30af\u30e6\u8a9e" },
            { "kj", "\u30af\u30ef\u30cb\u30e3\u30de\u8a9e" },
            { "kk", "\u30ab\u30b6\u30d5\u8a9e" },
            { "kl", "\u30b0\u30ea\u30fc\u30f3\u30e9\u30f3\u30c9\u8a9e" },
            { "km", "\u30af\u30e1\u30fc\u30eb\u8a9e" },
            { "kn", "\u30ab\u30f3\u30ca\u30c0\u8a9e" },
            { "ko", "\u97d3\u56fd\u8a9e" },
            { "kr", "\u30ab\u30cc\u30ea\u8a9e" },
            { "ks", "\u30ab\u30b7\u30df\u30fc\u30eb\u8a9e" },
            { "ku", "\u30af\u30eb\u30c9\u8a9e" },
            { "kv", "\u30b3\u30df\u8a9e" },
            { "kw", "\u30b3\u30fc\u30f3\u30a6\u30a9\u30fc\u30eb\u8a9e" },
            { "ky", "\u30ad\u30eb\u30ae\u30b9\u8a9e" },
            { "la", "\u30e9\u30c6\u30f3\u8a9e" },
            { "lb", "\u30eb\u30af\u30bb\u30f3\u30d6\u30eb\u30af\u8a9e" },
            { "lg", "\u30ac\u30f3\u30c0\u8a9e" },
            { "li", "\u30ea\u30f3\u30d6\u30eb\u30d5\u8a9e" },
            { "ln", "\u30ea\u30f3\u30ac\u30e9\u8a9e" },
            { "lo", "\u30e9\u30aa\u8a9e" },
            { "lt", "\u30ea\u30c8\u30a2\u30cb\u30a2\u8a9e" },
            { "lu", "\u30eb\u30d0\u30fb\u30ab\u30bf\u30f3\u30ac\u8a9e" },
            { "lv", "\u30e9\u30c8\u30d3\u30a2\u8a9e" },
            { "mg", "\u30de\u30c0\u30ac\u30b9\u30ab\u30eb\u8a9e" },
            { "mh", "\u30de\u30fc\u30b7\u30e3\u30eb\u8a9e" },
            { "mi", "\u30de\u30aa\u30ea\u8a9e" },
            { "mk", "\u30de\u30b1\u30c9\u30cb\u30a2\u8a9e" },
            { "ml", "\u30de\u30e9\u30e4\u30fc\u30e9\u30e0\u8a9e" },
            { "mn", "\u30e2\u30f3\u30b4\u30eb\u8a9e" },
            { "mr", "\u30de\u30e9\u30fc\u30c6\u30a3\u30fc\u8a9e" },
            { "ms", "\u30de\u30ec\u30fc\u8a9e" },
            { "mt", "\u30de\u30eb\u30bf\u8a9e" },
            { "my", "\u30df\u30e3\u30f3\u30de\u30fc\u8a9e" },
            { "na", "\u30ca\u30a6\u30eb\u8a9e" },
            { "nb", "\u30ce\u30eb\u30a6\u30a7\u30fc\u8a9e(\u30d6\u30fc\u30af\u30e2\u30fc\u30eb)" },
            { "nd", "\u5317\u30f3\u30c7\u30d9\u30ec\u8a9e" },
            { "ne", "\u30cd\u30d1\u30fc\u30eb\u8a9e" },
            { "ng", "\u30f3\u30c9\u30f3\u30ac\u8a9e" },
            { "nl", "\u30aa\u30e9\u30f3\u30c0\u8a9e" },
            { "nn", "\u30ce\u30eb\u30a6\u30a7\u30fc\u8a9e(\u30cb\u30fc\u30ce\u30b7\u30e5\u30af)" },
            { "no", "\u30ce\u30eb\u30a6\u30a7\u30fc\u8a9e" },
            { "nr", "\u5357\u30f3\u30c7\u30d9\u30ec\u8a9e" },
            { "nv", "\u30ca\u30d0\u30db\u8a9e" },
            { "ny", "\u30cb\u30e3\u30f3\u30b8\u30e3\u8a9e" },
            { "oc", "\u30aa\u30c3\u30af\u8a9e" },
            { "oj", "\u30aa\u30b8\u30d6\u30a6\u30a7\u30fc\u8a9e" },
            { "om", "\u30aa\u30ed\u30e2\u8a9e" },
            { "or", "\u30aa\u30c7\u30a3\u30a2\u8a9e" },
            { "os", "\u30aa\u30bb\u30c3\u30c8\u8a9e" },
            { "pa", "\u30d1\u30f3\u30b8\u30e3\u30d6\u8a9e" },
            { "pi", "\u30d1\u30fc\u30ea\u8a9e" },
            { "pl", "\u30dd\u30fc\u30e9\u30f3\u30c9\u8a9e" },
            { "ps", "\u30d1\u30b7\u30e5\u30c8\u30a5\u30fc\u8a9e" },
            { "pt", "\u30dd\u30eb\u30c8\u30ac\u30eb\u8a9e" },
            { "qu", "\u30b1\u30c1\u30e5\u30a2\u8a9e" },
            { "rm", "\u30ed\u30de\u30f3\u30b7\u30e5\u8a9e" },
            { "rn", "\u30eb\u30f3\u30c7\u30a3\u8a9e" },
            { "ro", "\u30eb\u30fc\u30de\u30cb\u30a2\u8a9e" },
            { "ru", "\u30ed\u30b7\u30a2\u8a9e" },
            { "rw", "\u30ad\u30cb\u30a2\u30eb\u30ef\u30f3\u30c0\u8a9e" },
            { "sa", "\u30b5\u30f3\u30b9\u30af\u30ea\u30c3\u30c8\u8a9e" },
            { "sc", "\u30b5\u30eb\u30c7\u30fc\u30cb\u30e3\u8a9e" },
            { "sd", "\u30b7\u30f3\u30c9\u8a9e" },
            { "se", "\u5317\u30b5\u30fc\u30df\u8a9e" },
            { "sg", "\u30b5\u30f3\u30b4\u8a9e" },
            { "sh", "\u30bb\u30eb\u30dc\u30fb\u30af\u30ed\u30a2\u30c1\u30a2\u8a9e" },
            { "si", "\u30b7\u30f3\u30cf\u30e9\u8a9e" },
            { "sk", "\u30b9\u30ed\u30d0\u30ad\u30a2\u8a9e" },
            { "sl", "\u30b9\u30ed\u30d9\u30cb\u30a2\u8a9e" },
            { "sm", "\u30b5\u30e2\u30a2\u8a9e" },
            { "sn", "\u30b7\u30e7\u30ca\u8a9e" },
            { "so", "\u30bd\u30de\u30ea\u8a9e" },
            { "sq", "\u30a2\u30eb\u30d0\u30cb\u30a2\u8a9e" },
            { "sr", "\u30bb\u30eb\u30d3\u30a2\u8a9e" },
            { "ss", "\u30b9\u30ef\u30b8\u8a9e" },
            { "st", "\u5357\u90e8\u30bd\u30c8\u8a9e" },
            { "su", "\u30b9\u30f3\u30c0\u8a9e" },
            { "sv", "\u30b9\u30a6\u30a7\u30fc\u30c7\u30f3\u8a9e" },
            { "sw", "\u30b9\u30ef\u30d2\u30ea\u8a9e" },
            { "ta", "\u30bf\u30df\u30eb\u8a9e" },
            { "te", "\u30c6\u30eb\u30b0\u8a9e" },
            { "tg", "\u30bf\u30b8\u30af\u8a9e" },
            { "th", "\u30bf\u30a4\u8a9e" },
            { "ti", "\u30c6\u30a3\u30b0\u30ea\u30cb\u30a2\u8a9e" },
            { "tk", "\u30c8\u30eb\u30af\u30e1\u30f3\u8a9e" },
            { "tl", "\u30bf\u30ac\u30ed\u30b0\u8a9e" },
            { "tn", "\u30c4\u30ef\u30ca\u8a9e" },
            { "to", "\u30c8\u30f3\u30ac\u8a9e" },
            { "tr", "\u30c8\u30eb\u30b3\u8a9e" },
            { "ts", "\u30c4\u30a9\u30f3\u30ac\u8a9e" },
            { "tt", "\u30bf\u30bf\u30fc\u30eb\u8a9e" },
            { "tw", "\u30c8\u30a6\u30a3\u8a9e" },
            { "ty", "\u30bf\u30d2\u30c1\u8a9e" },
            { "ug", "\u30a6\u30a4\u30b0\u30eb\u8a9e" },
            { "uk", "\u30a6\u30af\u30e9\u30a4\u30ca\u8a9e" },
            { "ur", "\u30a6\u30eb\u30c9\u30a5\u30fc\u8a9e" },
            { "uz", "\u30a6\u30ba\u30d9\u30af\u8a9e" },
            { "ve", "\u30d9\u30f3\u30c0\u8a9e" },
            { "vi", "\u30d9\u30c8\u30ca\u30e0\u8a9e" },
            { "vo", "\u30f4\u30a9\u30e9\u30d4\u30e5\u30af\u8a9e" },
            { "wa", "\u30ef\u30ed\u30f3\u8a9e" },
            { "wo", "\u30a6\u30a9\u30ed\u30d5\u8a9e" },
            { "xh", "\u30b3\u30b5\u8a9e" },
            { "yi", "\u30a4\u30c7\u30a3\u30c3\u30b7\u30e5\u8a9e" },
            { "yo", "\u30e8\u30eb\u30d0\u8a9e" },
            { "za", "\u30c1\u30ef\u30f3\u8a9e" },
            { "zh", "\u4e2d\u56fd\u8a9e" },
            { "zu", "\u30ba\u30fc\u30eb\u30fc\u8a9e" },
            { "ace", "\u30a2\u30c1\u30a7\u8a9e" },
            { "ach", "\u30a2\u30c1\u30e7\u30ea\u8a9e" },
            { "ada", "\u30a2\u30c0\u30f3\u30b0\u30e1\u8a9e" },
            { "ady", "\u30a2\u30c7\u30a3\u30b2\u8a9e" },
            { "aeb", "\u30c1\u30e5\u30cb\u30b8\u30a2\u30fb\u30a2\u30e9\u30d3\u30a2\u8a9e" },
            { "afh", "\u30a2\u30d5\u30ea\u30d2\u30ea\u8a9e" },
            { "agq", "\u30a2\u30b2\u30e0\u8a9e" },
            { "ain", "\u30a2\u30a4\u30cc\u8a9e" },
            { "akk", "\u30a2\u30c3\u30ab\u30c9\u8a9e" },
            { "akz", "\u30a2\u30e9\u30d0\u30de\u8a9e" },
            { "ale", "\u30a2\u30ec\u30a6\u30c8\u8a9e" },
            { "aln", "\u30b2\u30b0\u30fb\u30a2\u30eb\u30d0\u30cb\u30a2\u8a9e" },
            { "alt", "\u5357\u30a2\u30eb\u30bf\u30a4\u8a9e" },
            { "ang", "\u53e4\u82f1\u8a9e" },
            { "ann", "\u30aa\u30dc\u30ed\u8a9e" },
            { "anp", "\u30a2\u30f3\u30ae\u30ab\u8a9e" },
            { "arc", "\u30a2\u30e9\u30e0\u8a9e" },
            { "arn", "\u30de\u30d7\u30c1\u30a7\u8a9e" },
            { "aro", "\u30a2\u30e9\u30aa\u30ca\u8a9e" },
            { "arp", "\u30a2\u30e9\u30d1\u30db\u30fc\u8a9e" },
            { "arq", "\u30a2\u30eb\u30b8\u30a7\u30ea\u30a2\u30fb\u30a2\u30e9\u30d3\u30a2\u8a9e" },
            { "ars", "\u30ca\u30b8\u30e5\u30c9\u5730\u65b9\u30fb\u30a2\u30e9\u30d3\u30a2\u8a9e" },
            { "arw", "\u30a2\u30e9\u30ef\u30af\u8a9e" },
            { "ary", "\u30e2\u30ed\u30c3\u30b3\u30fb\u30a2\u30e9\u30d3\u30a2\u8a9e" },
            { "arz", "\u30a8\u30b8\u30d7\u30c8\u30fb\u30a2\u30e9\u30d3\u30a2\u8a9e" },
            { "asa", "\u30a2\u30b9\u8a9e" },
            { "ase", "\u30a2\u30e1\u30ea\u30ab\u624b\u8a71" },
            { "ast", "\u30a2\u30b9\u30c8\u30a5\u30ea\u30a2\u30b9\u8a9e" },
            { "atj", "\u30a2\u30c6\u30a3\u30ab\u30e1\u30af\u8a9e" },
            { "avk", "\u30b3\u30bf\u30f4\u30a1" },
            { "awa", "\u30a2\u30ef\u30c7\u30a3\u30fc\u8a9e" },
            { "bal", "\u30d0\u30eb\u30fc\u30c1\u30fc\u8a9e" },
            { "ban", "\u30d0\u30ea\u8a9e" },
            { "bar", "\u30d0\u30a4\u30a8\u30eb\u30f3\u30fb\u30aa\u30fc\u30b9\u30c8\u30ea\u30a2\u8a9e" },
            { "bas", "\u30d0\u30b5\u8a9e" },
            { "bax", "\u30d0\u30e0\u30f3\u8a9e" },
            { "bbc", "\u30c8\u30d0\u30fb\u30d0\u30bf\u30af\u8a9e" },
            { "bbj", "\u30b4\u30fc\u30de\u30e9\u8a9e" },
            { "bej", "\u30d9\u30b8\u30e3\u8a9e" },
            { "bem", "\u30d9\u30f3\u30d0\u8a9e" },
            { "bew", "\u30d9\u30bf\u30a6\u30a3\u8a9e" },
            { "bez", "\u30d9\u30ca\u8a9e" },
            { "bfd", "\u30d0\u30d5\u30c3\u30c8\u8a9e" },
            { "bfq", "\u30d0\u30c0\u30ac\u8a9e" },
            { "bgc", "\u30cf\u30ea\u30e4\u30fc\u30f3\u30a6\u30a3\u30fc\u8a9e" },
            { "bgn", "\u897f\u30d0\u30ed\u30fc\u30c1\u30fc\u8a9e" },
            { "bho", "\u30dc\u30fc\u30b8\u30e5\u30d7\u30ea\u30fc\u8a9e" },
            { "bik", "\u30d3\u30b3\u30eb\u8a9e" },
            { "bin", "\u30d3\u30cb\u8a9e" },
            { "bjn", "\u30d0\u30f3\u30b8\u30e3\u30eb\u8a9e" },
            { "bkm", "\u30b3\u30e0\u8a9e" },
            { "bla", "\u30b7\u30af\u30b7\u30ab\u8a9e" },
            { "bpy", "\u30d3\u30b7\u30e5\u30cc\u30d7\u30ea\u30e4\u30fb\u30de\u30cb\u30d7\u30ea\u8a9e" },
            { "bqi", "\u30d0\u30d5\u30c6\u30a3\u30e4\u30fc\u30ea\u30fc\u8a9e" },
            { "bra", "\u30d6\u30e9\u30b8\u8a9e" },
            { "brh", "\u30d6\u30e9\u30d5\u30a4\u8a9e" },
            { "brx", "\u30dc\u30c9\u8a9e" },
            { "bss", "\u30a2\u30b3\u30fc\u30b9\u8a9e" },
            { "bua", "\u30d6\u30ea\u30e4\u30fc\u30c8\u8a9e" },
            { "bug", "\u30d6\u30ae\u8a9e" },
            { "bum", "\u30d6\u30eb\u8a9e" },
            { "byn", "\u30d3\u30ea\u30f3\u8a9e" },
            { "byv", "\u30e1\u30c9\u30a5\u30f3\u30d0\u8a9e" },
            { "cad", "\u30ab\u30c9\u30fc\u8a9e" },
            { "car", "\u30ab\u30ea\u30d6\u8a9e" },
            { "cay", "\u30ab\u30e6\u30fc\u30ac\u8a9e" },
            { "cch", "\u30c1\u30e3\u30ef\u30a4\u8a9e" },
            { "ccp", "\u30c1\u30e3\u30af\u30de\u8a9e" },
            { "ceb", "\u30bb\u30d6\u30a2\u30ce\u8a9e" },
            { "cgg", "\u30c1\u30ac\u8a9e" },
            { "chb", "\u30c1\u30d6\u30c1\u30e3\u8a9e" },
            { "chg", "\u30c1\u30e3\u30ac\u30bf\u30a4\u8a9e" },
            { "chk", "\u30c1\u30e5\u30fc\u30af\u8a9e" },
            { "chm", "\u30de\u30ea\u8a9e" },
            { "chn", "\u30c1\u30cc\u30fc\u30af\u6df7\u6210\u8a9e" },
            { "cho", "\u30c1\u30e7\u30af\u30c8\u30fc\u8a9e" },
            { "chp", "\u30c1\u30da\u30ef\u30a4\u30a2\u30f3\u8a9e" },
            { "chr", "\u30c1\u30a7\u30ed\u30ad\u30fc\u8a9e" },
            { "chy", "\u30b7\u30e3\u30a4\u30a2\u30f3\u8a9e" },
            { "ckb", "\u4e2d\u592e\u30af\u30eb\u30c9\u8a9e" },
            { "clc", "\u30c1\u30eb\u30b3\u30fc\u30c6\u30a3\u30f3\u8a9e" },
            { "cop", "\u30b3\u30d7\u30c8\u8a9e" },
            { "cps", "\u30ab\u30d4\u30b9\u8a9e" },
            { "crg", "\u30df\u30c1\u30d5\u8a9e" },
            { "crh", "\u30af\u30ea\u30df\u30a2\u30fb\u30bf\u30bf\u30fc\u30eb\u8a9e" },
            { "crj", "\u6771\u90e8\u30af\u30ea\u30fc\u8a9e(\u5357\u90e8)" },
            { "crk", "\u5e73\u539f\u30af\u30ea\u30fc\u8a9e" },
            { "crl", "\u6771\u90e8\u30af\u30ea\u30fc\u8a9e(\u5317\u90e8)" },
            { "crm", "\u30e0\u30fc\u30b9\u30af\u30ea\u30fc\u8a9e" },
            { "crr", "\u30ab\u30ed\u30e9\u30a4\u30ca\u30fb\u30a2\u30eb\u30b4\u30f3\u30ad\u30f3\u8a9e" },
            { "crs", "\u30bb\u30fc\u30b7\u30a7\u30eb\u30fb\u30af\u30ec\u30aa\u30fc\u30eb\u8a9e" },
            { "csb", "\u30ab\u30b7\u30e5\u30fc\u30d6\u8a9e" },
            { "csw", "\u6e7f\u539f\u30af\u30ea\u30fc\u8a9e" },
            { "dak", "\u30c0\u30b3\u30bf\u8a9e" },
            { "dar", "\u30c0\u30eb\u30b0\u30ef\u8a9e" },
            { "dav", "\u30bf\u30a4\u30bf\u8a9e" },
            { "del", "\u30c7\u30e9\u30a6\u30a7\u30a2\u8a9e" },
            { "den", "\u30b9\u30ec\u30a4\u30d3\u30fc\u8a9e" },
            { "dgr", "\u30c9\u30b0\u30ea\u30d6\u8a9e" },
            { "din", "\u30c7\u30a3\u30f3\u30ab\u8a9e" },
            { "dje", "\u30b6\u30eb\u30de\u8a9e" },
            { "doi", "\u30c9\u30fc\u30b0\u30ea\u30fc\u8a9e" },
            { "dsb", "\u4f4e\u5730\u30bd\u30eb\u30d6\u8a9e" },
            { "dtp", "\u4e2d\u592e\u30c9\u30a5\u30b9\u30f3\u8a9e" },
            { "dua", "\u30c9\u30a5\u30a2\u30e9\u8a9e" },
            { "dum", "\u4e2d\u4e16\u30aa\u30e9\u30f3\u30c0\u8a9e" },
            { "dyo", "\u30b8\u30e7\u30e9\uff1d\u30d5\u30a9\u30cb\u30a3\u8a9e" },
            { "dyu", "\u30b8\u30e5\u30e9\u8a9e" },
            { "dzg", "\u30c0\u30b6\u30ac\u8a9e" },
            { "ebu", "\u30a8\u30f3\u30d6\u8a9e" },
            { "efi", "\u30a8\u30d5\u30a3\u30af\u8a9e" },
            { "egl", "\u30a8\u30df\u30ea\u30a2\u8a9e" },
            { "egy", "\u53e4\u4ee3\u30a8\u30b8\u30d7\u30c8\u8a9e" },
            { "eka", "\u30a8\u30ab\u30b8\u30e5\u30af\u8a9e" },
            { "elx", "\u30a8\u30e9\u30e0\u8a9e" },
            { "enm", "\u4e2d\u82f1\u8a9e" },
            { "esu", "\u4e2d\u592e\u30a2\u30e9\u30b9\u30ab\u30fb\u30e6\u30d4\u30c3\u30af\u8a9e" },
            { "ewo", "\u30a8\u30a6\u30a9\u30f3\u30c9\u8a9e" },
            { "ext", "\u30a8\u30b9\u30c8\u30ec\u30de\u30c9\u30a5\u30fc\u30e9\u8a9e" },
            { "fan", "\u30d5\u30a1\u30f3\u30b0\u8a9e" },
            { "fat", "\u30d5\u30a1\u30f3\u30c6\u30a3\u30fc\u8a9e" },
            { "fil", "\u30d5\u30a3\u30ea\u30d4\u30ce\u8a9e" },
            { "fit", "\u30c8\u30eb\u30cd\u30c0\u30fc\u30eb\u30fb\u30d5\u30a3\u30f3\u30e9\u30f3\u30c9\u8a9e" },
            { "fon", "\u30d5\u30a9\u30f3\u8a9e" },
            { "frc", "\u30b1\u30a4\u30b8\u30e3\u30f3\u30fb\u30d5\u30e9\u30f3\u30b9\u8a9e" },
            { "frm", "\u4e2d\u671f\u30d5\u30e9\u30f3\u30b9\u8a9e" },
            { "fro", "\u53e4\u30d5\u30e9\u30f3\u30b9\u8a9e" },
            { "frp", "\u30a2\u30eb\u30d4\u30bf\u30f3\u8a9e" },
            { "frr", "\u5317\u30d5\u30ea\u30b8\u30a2\u8a9e" },
            { "frs", "\u6771\u30d5\u30ea\u30b8\u30a2\u8a9e" },
            { "fur", "\u30d5\u30ea\u30a6\u30ea\u8a9e" },
            { "gaa", "\u30ac\u8a9e" },
            { "gag", "\u30ac\u30ac\u30a6\u30ba\u8a9e" },
            { "gan", "\u8d1b\u8a9e" },
            { "gay", "\u30ac\u30e8\u8a9e" },
            { "gba", "\u30d0\u30e4\u8a9e" },
            { "gbz", "\u30c0\u30ea\u30fc\u8a9e(\u30be\u30ed\u30a2\u30b9\u30bf\u30fc\u6559)" },
            { "gez", "\u30b2\u30a8\u30ba\u8a9e" },
            { "gil", "\u30ad\u30ea\u30d0\u30b9\u8a9e" },
            { "glk", "\u30ae\u30e9\u30ad\u8a9e" },
            { "gmh", "\u4e2d\u9ad8\u30c9\u30a4\u30c4\u8a9e" },
            { "goh", "\u53e4\u9ad8\u30c9\u30a4\u30c4\u8a9e" },
            { "gom", "\u30b4\u30a2\u30fb\u30b3\u30f3\u30ab\u30cb\u8a9e" },
            { "gon", "\u30b4\u30fc\u30f3\u30c7\u30a3\u30fc\u8a9e" },
            { "gor", "\u30b4\u30ed\u30f3\u30bf\u30ed\u8a9e" },
            { "got", "\u30b4\u30fc\u30c8\u8a9e" },
            { "grb", "\u30b0\u30ec\u30dc\u8a9e" },
            { "grc", "\u53e4\u4ee3\u30ae\u30ea\u30b7\u30e3\u8a9e" },
            { "gsw", "\u30b9\u30a4\u30b9\u30c9\u30a4\u30c4\u8a9e" },
            { "guc", "\u30ef\u30e6\u8a9e" },
            { "gur", "\u30d5\u30e9\u30d5\u30e9\u8a9e" },
            { "guz", "\u30b0\u30b7\u30a4\u8a9e" },
            { "gwi", "\u30b0\u30a6\u30a3\u30c3\u30c1\u30f3\u8a9e" },
            { "hai", "\u30cf\u30a4\u30c0\u8a9e" },
            { "hak", "\u5ba2\u5bb6\u8a9e" },
            { "haw", "\u30cf\u30ef\u30a4\u8a9e" },
            { "hax", "\u5357\u90e8\u30cf\u30a4\u30c0\u8a9e" },
            { "hif", "\u30d5\u30a3\u30b8\u30fc\u30fb\u30d2\u30f3\u30c7\u30a3\u30fc\u8a9e" },
            { "hil", "\u30d2\u30ea\u30ac\u30a4\u30ce\u30f3\u8a9e" },
            { "hit", "\u30d2\u30c3\u30bf\u30a4\u30c8\u8a9e" },
            { "hmn", "\u30d5\u30e2\u30f3\u8a9e" },
            { "hsb", "\u9ad8\u5730\u30bd\u30eb\u30d6\u8a9e" },
            { "hsn", "\u6e58\u8a9e" },
            { "hup", "\u30d5\u30d1\u8a9e" },
            { "hur", "\u30cf\u30eb\u30b3\u30e1\u30ec\u30e0\u8a9e" },
            { "iba", "\u30a4\u30d0\u30f3\u8a9e" },
            { "ibb", "\u30a4\u30d3\u30d3\u30aa\u8a9e" },
            { "ikt", "\u30a4\u30cc\u30a4\u30ca\u30af\u30c8\u30a5\u30f3\u8a9e" },
            { "ilo", "\u30a4\u30ed\u30ab\u30ce\u8a9e" },
            { "inh", "\u30a4\u30f3\u30b0\u30fc\u30b7\u8a9e" },
            { "izh", "\u30a4\u30f3\u30b0\u30ea\u30a2\u8a9e" },
            { "jam", "\u30b8\u30e3\u30de\u30a4\u30ab\u30fb\u30af\u30ec\u30aa\u30fc\u30eb\u8a9e" },
            { "jbo", "\u30ed\u30b8\u30d0\u30f3\u8a9e" },
            { "jgo", "\u30f3\u30b4\u30f3\u30d0\u8a9e" },
            { "jmc", "\u30de\u30c1\u30e3\u30e1\u8a9e" },
            { "jpr", "\u30e6\u30c0\u30e4\u30fb\u30da\u30eb\u30b7\u30a2\u8a9e" },
            { "jrb", "\u30e6\u30c0\u30e4\u30fb\u30a2\u30e9\u30d3\u30a2\u8a9e" },
            { "jut", "\u30e6\u30c8\u30e9\u30f3\u30c9\u8a9e" },
            { "kaa", "\u30ab\u30e9\u30ab\u30eb\u30d1\u30af\u8a9e" },
            { "kab", "\u30ab\u30d3\u30eb\u8a9e" },
            { "kac", "\u30ab\u30c1\u30f3\u8a9e" },
            { "kaj", "\u30ab\u30b8\u30a7\u8a9e" },
            { "kam", "\u30ab\u30f3\u30d0\u8a9e" },
            { "kaw", "\u30ab\u30a6\u30a3\u8a9e" },
            { "kbd", "\u30ab\u30d0\u30eb\u30c9\u8a9e" },
            { "kbl", "\u30ab\u30cd\u30f3\u30d6\u8a9e" },
            { "kcg", "\u30ab\u30bf\u30d6\u8a9e" },
            { "kde", "\u30de\u30b3\u30f3\u30c7\u8a9e" },
            { "kea", "\u30ab\u30fc\u30dc\u30d9\u30eb\u30c7\u30fb\u30af\u30ec\u30aa\u30fc\u30eb\u8a9e" },
            { "ken", "\u30cb\u30e3\u30f3\u8a9e" },
            { "kfo", "\u30b3\u30ed\u8a9e" },
            { "kgp", "\u30ab\u30a4\u30f3\u30ac\u30f3\u30b0\u8a9e" },
            { "kha", "\u30ab\u30b7\u8a9e" },
            { "kho", "\u30b3\u30fc\u30bf\u30f3\u8a9e" },
            { "khq", "\u30b3\u30a4\u30e9\u30fb\u30c1\u30fc\u30cb\u8a9e" },
            { "khw", "\u30b3\u30ef\u30fc\u30eb\u8a9e" },
            { "kiu", "\u30ad\u30eb\u30de\u30f3\u30b8\u30e5\u30ad\u8a9e" },
            { "kkj", "\u30ab\u30b3\u8a9e" },
            { "kln", "\u30ab\u30ec\u30f3\u30b8\u30f3\u8a9e" },
            { "kmb", "\u30ad\u30f3\u30d6\u30f3\u30c9\u8a9e" },
            { "koi", "\u30b3\u30df\u30fb\u30da\u30eb\u30df\u30e3\u30af\u8a9e" },
            { "kok", "\u30b3\u30f3\u30ab\u30cb\u8a9e" },
            { "kos", "\u30b3\u30b9\u30e9\u30a8\u8a9e" },
            { "kpe", "\u30af\u30da\u30ec\u8a9e" },
            { "krc", "\u30ab\u30e9\u30c1\u30e3\u30a4\u30fb\u30d0\u30eb\u30ab\u30eb\u8a9e" },
            { "kri", "\u30af\u30ea\u30aa\u8a9e" },
            { "krj", "\u30ad\u30ca\u30e9\u30a4\u30a2\u8a9e" },
            { "krl", "\u30ab\u30ec\u30ea\u30a2\u8a9e" },
            { "kru", "\u30af\u30eb\u30af\u8a9e" },
            { "ksb", "\u30b5\u30f3\u30d0\u30fc\u8a9e" },
            { "ksf", "\u30d0\u30d5\u30a3\u30a2\u8a9e" },
            { "ksh", "\u30b1\u30eb\u30f3\u8a9e" },
            { "kum", "\u30af\u30e0\u30af\u8a9e" },
            { "kut", "\u30af\u30c6\u30ca\u30a4\u8a9e" },
            { "kwk", "\u30af\u30ee\u30ad\u30a5\u30ef\u30e9\u8a9e" },
            { "lad", "\u30e9\u30c7\u30a3\u30ce\u8a9e" },
            { "lag", "\u30e9\u30f3\u30ae\u8a9e" },
            { "lah", "\u30e9\u30d5\u30f3\u30c0\u30fc\u8a9e" },
            { "lam", "\u30e9\u30f3\u30d0\u8a9e" },
            { "lez", "\u30ec\u30ba\u30ae\u8a9e" },
            { "lfn", "\u30ea\u30f3\u30b0\u30a2\u30fb\u30d5\u30e9\u30f3\u30ab\u30fb\u30ce\u30d0" },
            { "lij", "\u30ea\u30b0\u30ea\u30a2\u8a9e" },
            { "lil", "\u30ea\u30eb\u30a8\u30c3\u30c8\u8a9e" },
            { "liv", "\u30ea\u30f4\u30a9\u30cb\u30a2\u8a9e" },
            { "lkt", "\u30e9\u30b3\u30bf\u8a9e" },
            { "lmo", "\u30ed\u30f3\u30d0\u30eb\u30c9\u8a9e" },
            { "lol", "\u30e2\u30f3\u30b4\u8a9e" },
            { "lou", "\u30eb\u30a4\u30b8\u30a2\u30ca\u30fb\u30af\u30ec\u30aa\u30fc\u30eb\u8a9e" },
            { "loz", "\u30ed\u30b8\u8a9e" },
            { "lrc", "\u5317\u30ed\u30eb\u8a9e" },
            { "lsm", "\u30b5\u30fc\u30df\u30a2\u8a9e" },
            { "ltg", "\u30e9\u30c8\u30ac\u30ea\u30a2\u8a9e" },
            { "lua", "\u30eb\u30d0\u30fb\u30eb\u30eb\u30a2\u8a9e" },
            { "lui", "\u30eb\u30a4\u30bb\u30fc\u30cb\u30e7\u8a9e" },
            { "lun", "\u30eb\u30f3\u30c0\u8a9e" },
            { "luo", "\u30eb\u30aa\u8a9e" },
            { "lus", "\u30df\u30be\u8a9e" },
            { "luy", "\u30eb\u30d2\u30e4\u8a9e" },
            { "lzh", "\u6f22\u6587" },
            { "lzz", "\u30e9\u30ba\u8a9e" },
            { "mad", "\u30de\u30c9\u30a5\u30e9\u8a9e" },
            { "maf", "\u30de\u30d5\u30a1\u8a9e" },
            { "mag", "\u30de\u30ac\u30d2\u30fc\u8a9e" },
            { "mai", "\u30de\u30a4\u30c6\u30a3\u30ea\u30fc\u8a9e" },
            { "mak", "\u30de\u30ab\u30c3\u30b5\u30eb\u8a9e" },
            { "man", "\u30de\u30f3\u30c7\u30a3\u30f3\u30b4\u8a9e" },
            { "mas", "\u30de\u30b5\u30a4\u8a9e" },
            { "mde", "\u30de\u30d0\u8a9e" },
            { "mdf", "\u30e2\u30af\u30b7\u30e3\u8a9e" },
            { "mdr", "\u30de\u30f3\u30c0\u30eb\u8a9e" },
            { "men", "\u30e1\u30f3\u30c7\u8a9e" },
            { "mer", "\u30e1\u30eb\u8a9e" },
            { "mfe", "\u30e2\u30fc\u30ea\u30b7\u30e3\u30b9\u30fb\u30af\u30ec\u30aa\u30fc\u30eb\u8a9e" },
            { "mga", "\u4e2d\u671f\u30a2\u30a4\u30eb\u30e9\u30f3\u30c9\u8a9e" },
            { "mgh", "\u30de\u30af\u30a2\u30fb\u30df\u30fc\u30c8\u8a9e" },
            { "mgo", "\u30e1\u30bf\u8a9e" },
            { "mic", "\u30df\u30af\u30de\u30af\u8a9e" },
            { "min", "\u30df\u30ca\u30f3\u30ab\u30d0\u30a6\u8a9e" },
            { "mnc", "\u6e80\u5dde\u8a9e" },
            { "mni", "\u30de\u30cb\u30d7\u30ea\u8a9e" },
            { "moe", "\u30a4\u30cc\u30fc\uff1d\u30a2\u30a4\u30e0\u30f3\u8a9e" },
            { "moh", "\u30e2\u30fc\u30db\u30fc\u30af\u8a9e" },
            { "mos", "\u30e2\u30b7\u8a9e" },
            { "mrj", "\u5c71\u5730\u30de\u30ea\u8a9e" },
            { "mua", "\u30e0\u30f3\u30c0\u30f3\u8a9e" },
            { "mul", "\u8907\u6570\u8a00\u8a9e" },
            { "mus", "\u30af\u30ea\u30fc\u30af\u8a9e" },
            { "mwl", "\u30df\u30e9\u30f3\u30c0\u8a9e" },
            { "mwr", "\u30de\u30fc\u30eb\u30ef\u30fc\u30ea\u30fc\u8a9e" },
            { "mwv", "\u30e1\u30f3\u30bf\u30ef\u30a4\u8a9e" },
            { "mye", "\u30df\u30a8\u30cd\u8a9e" },
            { "myv", "\u30a8\u30eb\u30b8\u30e3\u8a9e" },
            { "mzn", "\u30de\u30fc\u30b6\u30f3\u30c0\u30e9\u30fc\u30f3\u8a9e" },
            { "nan", "\u95a9\u5357\u8a9e" },
            { "nap", "\u30ca\u30dd\u30ea\u8a9e" },
            { "naq", "\u30ca\u30de\u8a9e" },
            { "nds", "\u4f4e\u5730\u30c9\u30a4\u30c4\u8a9e" },
            { "new", "\u30cd\u30ef\u30fc\u30eb\u8a9e" },
            { "nia", "\u30cb\u30a2\u30b9\u8a9e" },
            { "niu", "\u30cb\u30a6\u30fc\u30a8\u30a4\u8a9e" },
            { "njo", "\u30a2\u30aa\u30fb\u30ca\u30ac\u8a9e" },
            { "nmg", "\u30af\u30ef\u30b7\u30aa\u8a9e" },
            { "nnh", "\u30f3\u30b8\u30a8\u30e0\u30d6\u30fc\u30f3\u8a9e" },
            { "nog", "\u30ce\u30ac\u30a4\u8a9e" },
            { "non", "\u53e4\u30ce\u30eb\u30c9\u8a9e" },
            { "nov", "\u30ce\u30f4\u30a3\u30a2\u30eb" },
            { "nqo", "\u30f3\u30b3\u8a9e" },
            { "nso", "\u5317\u90e8\u30bd\u30c8\u8a9e" },
            { "nus", "\u30cc\u30a8\u30eb\u8a9e" },
            { "nwc", "\u53e4\u5178\u30cd\u30ef\u30fc\u30eb\u8a9e" },
            { "nym", "\u30cb\u30e3\u30e0\u30a6\u30a7\u30b8\u8a9e" },
            { "nyn", "\u30cb\u30e3\u30f3\u30b3\u30ec\u8a9e" },
            { "nyo", "\u30cb\u30e7\u30ed\u8a9e" },
            { "nzi", "\u30f3\u30bc\u30de\u8a9e" },
            { "ojb", "\u5317\u897f\u90e8\u30aa\u30b8\u30d6\u30ef\u8a9e" },
            { "ojc", "\u4e2d\u90e8\u30aa\u30b8\u30d6\u30ef\u8a9e" },
            { "ojs", "\u30bb\u30f4\u30a1\u30fc\u30f3\u30fb\u30aa\u30b8\u30d6\u30ef\u8a9e" },
            { "ojw", "\u897f\u90e8\u30aa\u30b8\u30d6\u30ef\u8a9e" },
            { "oka", "\u30aa\u30ab\u30ca\u30ac\u30f3\u8a9e" },
            { "osa", "\u30aa\u30bb\u30fc\u30b8\u8a9e" },
            { "ota", "\u30aa\u30b9\u30de\u30f3\u30c8\u30eb\u30b3\u8a9e" },
            { "pag", "\u30d1\u30f3\u30ac\u30b7\u30ca\u30f3\u8a9e" },
            { "pal", "\u30d1\u30d5\u30e9\u30f4\u30a3\u30fc\u8a9e" },
            { "pam", "\u30d1\u30f3\u30d1\u30f3\u30ac\u8a9e" },
            { "pap", "\u30d1\u30d4\u30a2\u30e1\u30f3\u30c8\u8a9e" },
            { "pau", "\u30d1\u30e9\u30aa\u8a9e" },
            { "pcd", "\u30d4\u30ab\u30eb\u30c7\u30a3\u8a9e" },
            { "pcm", "\u30ca\u30a4\u30b8\u30a7\u30ea\u30a2\u30fb\u30d4\u30b8\u30f3\u8a9e" },
            { "pdc", "\u30da\u30f3\u30b7\u30eb\u30d9\u30cb\u30a2\u30fb\u30c9\u30a4\u30c4\u8a9e" },
            { "pdt", "\u30e1\u30ce\u30ca\u30a4\u30c8\u4f4e\u5730\u30c9\u30a4\u30c4\u8a9e" },
            { "peo", "\u53e4\u4ee3\u30da\u30eb\u30b7\u30a2\u8a9e" },
            { "pfl", "\u30d7\u30d5\u30a1\u30eb\u30c4\u8a9e" },
            { "phn", "\u30d5\u30a7\u30cb\u30ad\u30a2\u8a9e" },
            { "pis", "\u30d4\u30b8\u30f3\u8a9e" },
            { "pms", "\u30d4\u30a8\u30e2\u30f3\u30c6\u8a9e" },
            { "pnt", "\u30dd\u30f3\u30c8\u30b9\u30fb\u30ae\u30ea\u30b7\u30e3\u8a9e" },
            { "pon", "\u30dd\u30f3\u30da\u30a4\u8a9e" },
            { "pqm", "\u30de\u30ea\u30b7\u30fc\u30c8\uff1d\u30d1\u30b5\u30de\u30b3\u30c7\u30a3\u8a9e" },
            { "prg", "\u30d7\u30ed\u30b7\u30a2\u8a9e" },
            { "pro", "\u53e4\u671f\u30d7\u30ed\u30d0\u30f3\u30b9\u8a9e" },
            { "quc", "\u30ad\u30c1\u30a7\u8a9e" },
            { "qug", "\u30c1\u30f3\u30dc\u30e9\u30bd\u9ad8\u5730\u30b1\u30c1\u30e5\u30a2\u8a9e" },
            { "raj", "\u30e9\u30fc\u30b8\u30e3\u30b9\u30bf\u30fc\u30f3\u8a9e" },
            { "rap", "\u30e9\u30d1\u30cc\u30a4\u8a9e" },
            { "rar", "\u30e9\u30ed\u30c8\u30f3\u30ac\u8a9e" },
            { "rgn", "\u30ed\u30de\u30fc\u30cb\u30e3\u8a9e" },
            { "rhg", "\u30ed\u30d2\u30f3\u30ae\u30e3\u8a9e" },
            { "rif", "\u30ea\u30fc\u30d5\u8a9e" },
            { "rof", "\u30ed\u30f3\u30dc\u8a9e" },
            { "rom", "\u30ed\u30de\u30fc\u30cb\u30fc\u8a9e" },
            { "rtm", "\u30ed\u30c4\u30de\u8a9e" },
            { "rue", "\u30eb\u30b7\u30f3\u8a9e" },
            { "rug", "\u30ed\u30f4\u30a3\u30a2\u30ca\u8a9e" },
            { "rup", "\u30a2\u30eb\u30fc\u30de\u30cb\u30a2\u8a9e" },
            { "rwk", "\u30eb\u30ef\u8a9e" },
            { "sad", "\u30b5\u30f3\u30c0\u30a6\u30a7\u8a9e" },
            { "sah", "\u30b5\u30cf\u8a9e" },
            { "sam", "\u30b5\u30de\u30ea\u30a2\u30fb\u30a2\u30e9\u30e0\u8a9e" },
            { "saq", "\u30b5\u30f3\u30d6\u30eb\u8a9e" },
            { "sas", "\u30b5\u30b5\u30af\u8a9e" },
            { "sat", "\u30b5\u30f3\u30bf\u30fc\u30ea\u30fc\u8a9e" },
            { "saz", "\u30b5\u30a6\u30e9\u30fc\u30b7\u30e5\u30c8\u30e9\u8a9e" },
            { "sba", "\u30f3\u30ac\u30e0\u30d0\u30a4\u8a9e" },
            { "sbp", "\u30b5\u30f3\u30b0\u8a9e" },
            { "scn", "\u30b7\u30c1\u30ea\u30a2\u8a9e" },
            { "sco", "\u30b9\u30b3\u30c3\u30c8\u30e9\u30f3\u30c9\u8a9e" },
            { "sdc", "\u30b5\u30c3\u30b5\u30ea\u30fb\u30b5\u30eb\u30c7\u30fc\u30cb\u30e3\u8a9e" },
            { "sdh", "\u5357\u90e8\u30af\u30eb\u30c9\u8a9e" },
            { "see", "\u30bb\u30cd\u30ab\u8a9e" },
            { "seh", "\u30bb\u30ca\u8a9e" },
            { "sei", "\u30bb\u30ea\u8a9e" },
            { "sel", "\u30bb\u30ea\u30af\u30d7\u8a9e" },
            { "ses", "\u30b3\u30a4\u30e9\u30dc\u30ed\u30fb\u30bb\u30f3\u30cb\u8a9e" },
            { "sga", "\u53e4\u30a2\u30a4\u30eb\u30e9\u30f3\u30c9\u8a9e" },
            { "sgs", "\u30b5\u30e2\u30ae\u30c6\u30a3\u30a2\u8a9e" },
            { "shi", "\u30bf\u30b7\u30eb\u30cf\u30a4\u30c8\u8a9e" },
            { "shn", "\u30b7\u30e3\u30f3\u8a9e" },
            { "shu", "\u30c1\u30e3\u30c9\u30fb\u30a2\u30e9\u30d3\u30a2\u8a9e" },
            { "sid", "\u30b7\u30c0\u30e2\u8a9e" },
            { "slh", "\u5357\u90e8\u30eb\u30b7\u30e5\u30c4\u30a3\u30fc\u30c9\u8a9e" },
            { "sli", "\u4f4e\u30b7\u30ec\u30b8\u30a2\u8a9e" },
            { "sly", "\u30b9\u30e9\u30e4\u30fc\u30eb\u8a9e" },
            { "sma", "\u5357\u30b5\u30fc\u30df\u8a9e" },
            { "smj", "\u30eb\u30ec\u30fb\u30b5\u30fc\u30df\u8a9e" },
            { "smn", "\u30a4\u30ca\u30ea\u30fb\u30b5\u30fc\u30df\u8a9e" },
            { "sms", "\u30b9\u30b3\u30eb\u30c8\u30fb\u30b5\u30fc\u30df\u8a9e" },
            { "snk", "\u30bd\u30cb\u30f3\u30b1\u8a9e" },
            { "sog", "\u30bd\u30b0\u30c9\u8a9e" },
            { "srn", "\u30b9\u30ea\u30ca\u30e0\u8a9e" },
            { "srr", "\u30bb\u30ec\u30eb\u8a9e" },
            { "ssy", metaValue_ssy },
            { "stq", "\u30b6\u30fc\u30bf\u30fc\u30d5\u30ea\u30b8\u30a2\u8a9e" },
            { "str", "\u30b9\u30c8\u30ec\u30a4\u30c4\u30bb\u30a4\u30ea\u30c3\u30b7\u30e5\u8a9e" },
            { "suk", "\u30b9\u30af\u30de\u8a9e" },
            { "sus", "\u30b9\u30b9\u8a9e" },
            { "sux", "\u30b7\u30e5\u30e1\u30fc\u30eb\u8a9e" },
            { "swb", "\u30b3\u30e2\u30ed\u8a9e" },
            { "syc", "\u53e4\u5178\u30b7\u30ea\u30a2\u8a9e" },
            { "syr", "\u30b7\u30ea\u30a2\u8a9e" },
            { "szl", "\u30b7\u30ec\u30b8\u30a2\u8a9e" },
            { "tce", "\u5357\u90e8\u30c8\u30a5\u30b7\u30e7\u30fc\u30cb\u8a9e" },
            { "tcy", "\u30c8\u30a5\u30eb\u8a9e" },
            { "tem", "\u30c6\u30e0\u30cd\u8a9e" },
            { "teo", "\u30c6\u30bd\u8a9e" },
            { "ter", "\u30c6\u30ec\u30fc\u30ce\u8a9e" },
            { "tet", "\u30c6\u30c8\u30a5\u30f3\u8a9e" },
            { "tgx", "\u30bf\u30ae\u30b7\u30e5\u8a9e" },
            { "tht", "\u30bf\u30fc\u30eb\u30bf\u30f3\u8a9e" },
            { "tig", "\u30c6\u30a3\u30b0\u30ec\u8a9e" },
            { "tiv", "\u30c6\u30a3\u30d6\u8a9e" },
            { "tkl", "\u30c8\u30b1\u30e9\u30a6\u8a9e" },
            { "tkr", "\u30c4\u30a1\u30d5\u30eb\u8a9e" },
            { "tlh", "\u30af\u30ea\u30f3\u30b4\u30f3\u8a9e" },
            { "tli", "\u30c8\u30ea\u30f3\u30ae\u30c3\u30c8\u8a9e" },
            { "tly", "\u30bf\u30ea\u30b7\u30e5\u8a9e" },
            { "tmh", "\u30bf\u30de\u30b7\u30a7\u30af\u8a9e" },
            { "tog", "\u30c8\u30f3\u30ac\u8a9e(\u30cb\u30a2\u30b5)" },
            { "tok", "\u30c8\u30ad\u30dd\u30ca\u8a9e" },
            { "tpi", "\u30c8\u30af\u30fb\u30d4\u30b7\u30f3\u8a9e" },
            { "tru", "\u30c8\u30a5\u30ed\u30e8\u8a9e" },
            { "trv", "\u30bf\u30ed\u30b3\u8a9e" },
            { "tsd", "\u30c4\u30a1\u30b3\u30f3\u8a9e" },
            { "tsi", "\u30c1\u30e0\u30b7\u30e5\u8a9e" },
            { "ttm", "\u5317\u90e8\u30c8\u30a5\u30b7\u30e7\u30fc\u30cb\u8a9e" },
            { "ttt", "\u30e0\u30b9\u30ea\u30e0\u30fb\u30bf\u30bf\u30fc\u30eb\u8a9e" },
            { "tum", "\u30c8\u30a5\u30f3\u30d6\u30ab\u8a9e" },
            { "tvl", "\u30c4\u30d0\u30eb\u8a9e" },
            { "twq", "\u30bf\u30b5\u30ef\u30af\u8a9e" },
            { "tyv", "\u30c8\u30a5\u30f4\u30a1\u8a9e" },
            { "tzm", "\u4e2d\u592e\u30a2\u30c8\u30e9\u30b9\u30fb\u30bf\u30de\u30b8\u30af\u30c8\u8a9e" },
            { "udm", "\u30a6\u30c9\u30e0\u30eb\u30c8\u8a9e" },
            { "uga", "\u30a6\u30ac\u30ea\u30c8\u8a9e" },
            { "umb", "\u30e0\u30d6\u30f3\u30c9\u30a5\u8a9e" },
            { "und", "\u8a00\u8a9e\u4e0d\u660e" },
            { "vai", "\u30f4\u30a1\u30a4\u8a9e" },
            { "vec", "\u30f4\u30a7\u30cd\u30c8\u8a9e" },
            { "vep", "\u30f4\u30a7\u30d7\u30b9\u8a9e" },
            { "vls", "\u897f\u30d5\u30e9\u30de\u30f3\u8a9e" },
            { "vmf", "\u30de\u30a4\u30f3\u30d5\u30e9\u30f3\u30af\u8a9e" },
            { "vot", "\u30f4\u30a9\u30fc\u30c8\u8a9e" },
            { "vro", "\u30f4\u30a9\u30ed\u8a9e" },
            { "vun", "\u30f4\u30f3\u30b8\u30e7\u8a9e" },
            { "wae", "\u30f4\u30a1\u30ea\u30b9\u8a9e" },
            { "wal", "\u30a6\u30a9\u30e9\u30a4\u30bf\u8a9e" },
            { "war", "\u30ef\u30e9\u30a4\u8a9e" },
            { "was", "\u30ef\u30b7\u30e7\u8a9e" },
            { "wbp", "\u30ef\u30eb\u30d4\u30ea\u8a9e" },
            { "wuu", "\u5449\u8a9e" },
            { "xal", "\u30ab\u30eb\u30e0\u30a4\u30af\u8a9e" },
            { "xmf", "\u30e1\u30b0\u30ec\u30eb\u8a9e" },
            { "xog", "\u30bd\u30ac\u8a9e" },
            { "yao", "\u30e4\u30aa\u8a9e" },
            { "yap", "\u30e4\u30c3\u30d7\u8a9e" },
            { "yav", "\u30e4\u30f3\u30d9\u30f3\u8a9e" },
            { "ybb", "\u30a4\u30a8\u30f3\u30d0\u8a9e" },
            { "yrl", "\u30cb\u30a7\u30a8\u30f3\u30ac\u30c8\u30a5\u8a9e" },
            { "yue", "\u5e83\u6771\u8a9e" },
            { "zap", "\u30b5\u30dd\u30c6\u30ab\u8a9e" },
            { "zbl", metaValue_zbl },
            { "zea", "\u30bc\u30fc\u30e9\u30f3\u30c8\u8a9e" },
            { "zen", "\u30bc\u30ca\u30ac\u8a9e" },
            { "zgh", "\u6a19\u6e96\u30e2\u30ed\u30c3\u30b3 \u30bf\u30de\u30b8\u30af\u30c8\u8a9e" },
            { "zun", "\u30ba\u30cb\u8a9e" },
            { "zxx", "\u8a00\u8a9e\u7684\u5185\u5bb9\u306a\u3057" },
            { "zza", "\u30b6\u30b6\u8a9e" },
            { "Adlm", "\u30a2\u30c9\u30e9\u30e0\u6587\u5b57" },
            { "Afak", "\u30a2\u30d5\u30a1\u30ab\u6587\u5b57" },
            { "Aghb", "\u30ab\u30d5\u30ab\u30b9\u30fb\u30a2\u30eb\u30d0\u30cb\u30a2\u6587\u5b57" },
            { "Arab", "\u30a2\u30e9\u30d3\u30a2\u6587\u5b57" },
            { "Aran", "\u30ca\u30b9\u30bf\u30a2\u30ea\u30fc\u30af\u4f53" },
            { "Armi", "\u5e1d\u56fd\u30a2\u30e9\u30e0\u6587\u5b57" },
            { "Armn", "\u30a2\u30eb\u30e1\u30cb\u30a2\u6587\u5b57" },
            { "Avst", "\u30a2\u30f4\u30a7\u30b9\u30bf\u30fc\u6587\u5b57" },
            { "Bali", "\u30d0\u30ea\u6587\u5b57" },
            { "Bamu", "\u30d0\u30e0\u30f3\u6587\u5b57" },
            { "Bass", "\u30d0\u30b5\u6587\u5b57" },
            { "Batk", "\u30d0\u30bf\u30af\u6587\u5b57" },
            { "Beng", "\u30d9\u30f3\u30ac\u30eb\u6587\u5b57" },
            { "Blis", metaValue_zbl },
            { "Bopo", "\u6ce8\u97f3\u5b57\u6bcd" },
            { "Brah", "\u30d6\u30e9\u30fc\u30d5\u30df\u30fc\u6587\u5b57" },
            { "Brai", "\u30d6\u30e9\u30a4\u30e6\u70b9\u5b57" },
            { "Bugi", "\u30d6\u30ae\u30b9\u6587\u5b57" },
            { "Buhd", "\u30d6\u30d2\u30c3\u30c9\u6587\u5b57" },
            { "Cakm", "\u30c1\u30e3\u30af\u30de\u6587\u5b57" },
            { "Cans", "\u7d71\u5408\u30ab\u30ca\u30c0\u5148\u4f4f\u6c11\u97f3\u7bc0\u6587\u5b57" },
            { "Cari", "\u30ab\u30ea\u30a2\u6587\u5b57" },
            { "Cham", "\u30c1\u30e3\u30e0\u6587\u5b57" },
            { "Cher", "\u30c1\u30a7\u30ed\u30ad\u30fc\u6587\u5b57" },
            { "Cirt", "\u30ad\u30a2\u30b9\u6587\u5b57" },
            { "Copt", "\u30b3\u30d7\u30c8\u6587\u5b57" },
            { "Cprt", "\u30ad\u30d7\u30ed\u30b9\u6587\u5b57" },
            { "Cyrl", "\u30ad\u30ea\u30eb\u6587\u5b57" },
            { "Cyrs", "\u53e4\u4ee3\u6559\u4f1a\u30b9\u30e9\u30d6\u8a9e\u30ad\u30ea\u30eb\u6587\u5b57" },
            { "Deva", "\u30c7\u30fc\u30d0\u30ca\u30fc\u30ac\u30ea\u30fc\u6587\u5b57" },
            { "Dsrt", "\u30c7\u30bb\u30ec\u30c3\u30c8\u6587\u5b57" },
            { "Dupl", "\u30c7\u30e5\u30d7\u30ed\u30ef\u30a8\u5f0f\u901f\u8a18" },
            { "Egyd", "\u30a8\u30b8\u30d7\u30c8\u6c11\u8846\u6587\u5b57" },
            { "Egyh", "\u30a8\u30b8\u30d7\u30c8\u795e\u5b98\u6587\u5b57" },
            { "Egyp", "\u30a8\u30b8\u30d7\u30c8\u8056\u523b\u6587\u5b57" },
            { "Elba", "\u30a8\u30eb\u30d0\u30b5\u30f3\u6587\u5b57" },
            { "Ethi", "\u30a8\u30c1\u30aa\u30d4\u30a2\u6587\u5b57" },
            { "Geok", "\u30b8\u30e7\u30fc\u30b8\u30a2\u6587\u5b57(\u30d5\u30c4\u30ea)" },
            { "Geor", "\u30b8\u30e7\u30fc\u30b8\u30a2\u6587\u5b57" },
            { "Glag", "\u30b0\u30e9\u30b4\u30eb\u6587\u5b57" },
            { "Goth", "\u30b4\u30fc\u30c8\u6587\u5b57" },
            { "Gran", "\u30b0\u30e9\u30f3\u30bf\u6587\u5b57" },
            { "Grek", "\u30ae\u30ea\u30b7\u30e3\u6587\u5b57" },
            { "Gujr", "\u30b0\u30b8\u30e3\u30e9\u30fc\u30c8\u6587\u5b57" },
            { "Guru", "\u30b0\u30eb\u30e0\u30ad\u30fc\u6587\u5b57" },
            { "Hanb", "\u6f22\u8a9e\u6ce8\u97f3\u5b57\u6bcd" },
            { "Hang", "\u30cf\u30f3\u30b0\u30eb" },
            { "Hani", "\u6f22\u5b57" },
            { "Hano", "\u30cf\u30cc\u30ce\u30aa\u6587\u5b57" },
            { "Hans", "\u7c21\u4f53\u5b57" },
            { "Hant", "\u7e41\u4f53\u5b57" },
            { "Hebr", "\u30d8\u30d6\u30e9\u30a4\u6587\u5b57" },
            { "Hira", "\u3072\u3089\u304c\u306a" },
            { "Hluw", "\u30a2\u30ca\u30c8\u30ea\u30a2\u8c61\u5f62\u6587\u5b57" },
            { "Hmng", "\u30d1\u30cf\u30a6\u30fb\u30d5\u30e2\u30f3\u6587\u5b57" },
            { "Hrkt", "\u4eee\u540d" },
            { "Hung", "\u53e4\u4ee3\u30cf\u30f3\u30ac\u30ea\u30fc\u6587\u5b57" },
            { "Inds", "\u30a4\u30f3\u30c0\u30b9\u6587\u5b57" },
            { "Ital", "\u53e4\u30a4\u30bf\u30ea\u30a2\u6587\u5b57" },
            { "Jamo", "\u5b57\u6bcd" },
            { "Java", "\u30b8\u30e3\u30ef\u6587\u5b57" },
            { "Jpan", "\u65e5\u672c\u8a9e\u306e\u6587\u5b57" },
            { "Jurc", "\u5973\u771f\u6587\u5b57" },
            { "Kali", "\u30ab\u30e4\u30fc\u6587\u5b57" },
            { "Kana", "\u30ab\u30bf\u30ab\u30ca" },
            { "Khar", "\u30ab\u30ed\u30fc\u30b7\u30e5\u30c6\u30a3\u30fc\u6587\u5b57" },
            { "Khmr", "\u30af\u30e1\u30fc\u30eb\u6587\u5b57" },
            { "Khoj", "\u30db\u30b8\u30e3\u6587\u5b57" },
            { "Knda", "\u30ab\u30f3\u30ca\u30c0\u6587\u5b57" },
            { "Kore", "\u97d3\u56fd\u8a9e\u306e\u6587\u5b57" },
            { "Kpel", "\u30af\u30da\u30ec\u6587\u5b57" },
            { "Kthi", "\u30ab\u30a4\u30c6\u30a3\u6587\u5b57" },
            { "Lana", "\u30e9\u30fc\u30f3\u30ca\u30fc\u6587\u5b57" },
            { "Laoo", "\u30e9\u30aa\u6587\u5b57" },
            { "Latf", "\u30e9\u30c6\u30f3\u6587\u5b57(\u30c9\u30a4\u30c4\u6587\u5b57)" },
            { "Latg", "\u30e9\u30c6\u30f3\u6587\u5b57 (\u30b2\u30fc\u30eb\u6587\u5b57)" },
            { "Latn", "\u30e9\u30c6\u30f3\u6587\u5b57" },
            { "Lepc", "\u30ec\u30d7\u30c1\u30e3\u6587\u5b57" },
            { "Limb", "\u30ea\u30f3\u30d6\u6587\u5b57" },
            { "Lina", "\u7dda\u6587\u5b57A" },
            { "Linb", "\u7dda\u6587\u5b57B" },
            { "Lisu", "\u30d5\u30ec\u30a4\u30b6\u30fc\u6587\u5b57" },
            { "Loma", "\u30ed\u30de\u6587\u5b57" },
            { "Lyci", "\u30ea\u30ad\u30a2\u6587\u5b57" },
            { "Lydi", "\u30ea\u30c7\u30a3\u30a2\u6587\u5b57" },
            { "Mahj", "\u30de\u30cf\u30fc\u30b8\u30e3\u30cb\u30fc\u6587\u5b57" },
            { "Mand", "\u30de\u30f3\u30c0\u6587\u5b57" },
            { "Mani", "\u30de\u30cb\u6587\u5b57" },
            { "Maya", "\u30de\u30e4\u8c61\u5f62\u6587\u5b57" },
            { "Mend", "\u30e1\u30f3\u30c7\u6587\u5b57" },
            { "Merc", "\u30e1\u30ed\u30a8\u6587\u5b57\u8349\u66f8\u4f53" },
            { "Mero", "\u30e1\u30ed\u30a8\u6587\u5b57" },
            { "Mlym", "\u30de\u30e9\u30e4\u30fc\u30e9\u30e0\u6587\u5b57" },
            { "Modi", "\u30e2\u30fc\u30c7\u30a3\u30fc\u6587\u5b57" },
            { "Mong", "\u30e2\u30f3\u30b4\u30eb\u6587\u5b57" },
            { "Moon", "\u30e0\u30fc\u30f3\u6587\u5b57" },
            { "Mroo", "\u30e0\u30ed\u6587\u5b57" },
            { "Mtei", "\u30e1\u30a4\u30c6\u30a4\u6587\u5b57" },
            { "Mymr", "\u30df\u30e3\u30f3\u30de\u30fc\u6587\u5b57" },
            { "Narb", "\u53e4\u4ee3\u5317\u30a2\u30e9\u30d3\u30a2\u6587\u5b57" },
            { "Nbat", "\u30ca\u30d0\u30c6\u30a2\u6587\u5b57" },
            { "Nkgb", "\u30ca\u30b7\u65cf\u30b2\u30d0\u6587\u5b57" },
            { "Nkoo", "\u30f3\u30b3\u6587\u5b57" },
            { "Nshu", "\u5973\u66f8" },
            { "Ogam", "\u30aa\u30ac\u30e0\u6587\u5b57" },
            { "Olck", "\u30aa\u30eb\u30c1\u30ad\u6587\u5b57" },
            { "Orkh", "\u30aa\u30eb\u30db\u30f3\u6587\u5b57" },
            { "Orya", "\u30aa\u30c7\u30a3\u30a2\u6587\u5b57" },
            { "Osma", "\u30aa\u30b9\u30de\u30cb\u30a2\u6587\u5b57" },
            { "Palm", "\u30d1\u30eb\u30df\u30e9\u6587\u5b57" },
            { "Pauc", "\u30d1\u30a6\u30fb\u30c1\u30f3\u30fb\u30cf\u30a6\u6587\u5b57" },
            { "Perm", "\u53e4\u307a\u30eb\u30e0\u6587\u5b57" },
            { "Phag", "\u30d1\u30b9\u30d1\u6587\u5b57" },
            { "Phli", "\u7891\u6587\u30d1\u30d5\u30e9\u30f4\u30a3\u30fc\u6587\u5b57" },
            { "Phlp", "\u8a69\u7de8\u7528\u30d1\u30d5\u30e9\u30f4\u30a3\u30fc\u6587\u5b57" },
            { "Phlv", "\u66f8\u7269\u7528\u30d1\u30d5\u30e9\u30f4\u30a3\u30fc\u6587\u5b57" },
            { "Phnx", "\u30d5\u30a7\u30cb\u30ad\u30a2\u6587\u5b57" },
            { "Plrd", "\u30dd\u30e9\u30fc\u30c9\u97f3\u58f0\u8a18\u53f7" },
            { "Prti", "\u7891\u6587\u30d1\u30eb\u30c6\u30a3\u30a2\u6587\u5b57" },
            { "Rjng", "\u30eb\u30b8\u30e3\u30f3\u6587\u5b57" },
            { "Rohg", "\u30ed\u30d2\u30f3\u30ae\u30e3\u6587\u5b57" },
            { "Roro", "\u30ed\u30f3\u30b4\u30ed\u30f3\u30b4\u6587\u5b57" },
            { "Runr", "\u30eb\u30fc\u30f3\u6587\u5b57" },
            { "Samr", "\u30b5\u30de\u30ea\u30a2\u6587\u5b57" },
            { "Sara", "\u30b5\u30e9\u30c6\u30a3\u6587\u5b57" },
            { "Sarb", "\u53e4\u4ee3\u5357\u30a2\u30e9\u30d3\u30a2\u6587\u5b57" },
            { "Saur", "\u30b5\u30a6\u30e9\u30fc\u30b7\u30e5\u30c8\u30e9\u6587\u5b57" },
            { "Sgnw", "\u624b\u8a71\u6587\u5b57" },
            { "Shaw", "\u30b7\u30e7\u30fc\u6587\u5b57" },
            { "Shrd", "\u30b7\u30e3\u30fc\u30e9\u30c0\u30fc\u6587\u5b57" },
            { "Sidd", "\u68b5\u5b57" },
            { "Sind", "\u30af\u30c0\u30ef\u30c7\u30a3\u6587\u5b57" },
            { "Sinh", "\u30b7\u30f3\u30cf\u30e9\u6587\u5b57" },
            { "Sora", "\u30bd\u30e9\u30f3\u30b0\u30fb\u30bd\u30f3\u30da\u30f3\u30b0\u6587\u5b57" },
            { "Sund", "\u30b9\u30f3\u30c0\u6587\u5b57" },
            { "Sylo", "\u30b7\u30ed\u30c6\u30a3\u30fb\u30ca\u30b0\u30ea\u6587\u5b57" },
            { "Syrc", "\u30b7\u30ea\u30a2\u6587\u5b57" },
            { "Syre", "\u30b7\u30ea\u30a2\u6587\u5b57(\u30a8\u30b9\u30c8\u30e9\u30f3\u30b2\u30ed\u6587\u5b57)" },
            { "Syrj", "\u30b7\u30ea\u30a2\u6587\u5b57(\u897f\u65b9\u30b7\u30ea\u30a2\u6587\u5b57)" },
            { "Syrn", "\u30b7\u30ea\u30a2\u6587\u5b57(\u6771\u65b9\u30b7\u30ea\u30a2\u6587\u5b57)" },
            { "Tagb", "\u30bf\u30b0\u30d0\u30f3\u30ef\u6587\u5b57" },
            { "Takr", "\u30bf\u30fc\u30af\u30ea\u30fc\u6587\u5b57" },
            { "Tale", "\u30bf\u30a4\u30fb\u30ec\u6587\u5b57" },
            { "Talu", "\u65b0\u30bf\u30a4\u30fb\u30eb\u30fc\u6587\u5b57" },
            { "Taml", "\u30bf\u30df\u30eb\u6587\u5b57" },
            { "Tang", "\u897f\u590f\u6587\u5b57" },
            { "Tavt", "\u30bf\u30a4\u30fb\u30f4\u30a7\u30c8\u6587\u5b57" },
            { "Telu", "\u30c6\u30eb\u30b0\u6587\u5b57" },
            { "Teng", "\u30c6\u30f3\u30b0\u30ef\u30fc\u30eb\u6587\u5b57" },
            { "Tfng", "\u30c6\u30a3\u30d5\u30ca\u30b0\u6587\u5b57" },
            { "Tglg", "\u30bf\u30ac\u30ed\u30b0\u6587\u5b57" },
            { "Thaa", "\u30bf\u30fc\u30ca\u6587\u5b57" },
            { "Thai", "\u30bf\u30a4\u6587\u5b57" },
            { "Tibt", "\u30c1\u30d9\u30c3\u30c8\u6587\u5b57" },
            { "Tirh", "\u30c6\u30a3\u30eb\u30d5\u30fc\u30bf\u6587\u5b57" },
            { "Ugar", "\u30a6\u30ac\u30ea\u30c3\u30c8\u6587\u5b57" },
            { "Vaii", "\u30f4\u30a1\u30a4\u6587\u5b57" },
            { "Visp", "\u8996\u8a71\u6cd5" },
            { "Wara", "\u30d0\u30e9\u30f3\u30fb\u30af\u30b7\u30c6\u30a3\u6587\u5b57" },
            { "Wole", "\u30a6\u30a9\u30ec\u30a2\u30a4\u6587\u5b57" },
            { "Xpeo", "\u53e4\u4ee3\u30da\u30eb\u30b7\u30a2\u6587\u5b57" },
            { "Xsux", "\u30b7\u30e5\u30e1\u30fc\u30eb\uff1d\u30a2\u30c3\u30ab\u30c9\u8a9e\u6954\u5f62\u6587\u5b57" },
            { "Yiii", "\u30a4\u6587\u5b57" },
            { "Zinh", "\u57fa\u5e95\u6587\u5b57\u306e\u7a2e\u5225\u3092\u7d99\u627f\u3059\u308b\u7d50\u5408\u6587\u5b57" },
            { "Zmth", "\u6570\u5b66\u8a18\u53f7" },
            { "Zsye", "\u7d75\u6587\u5b57" },
            { "Zsym", "\u8a18\u53f7\u6587\u5b57" },
            { "Zxxx", "\u975e\u8868\u8a18" },
            { "Zyyy", "\u5171\u901a\u6587\u5b57" },
            { "Zzzz", "\u4e0d\u660e\u306a\u6587\u5b57" },
            { "de_CH", "\u6a19\u6e96\u30c9\u30a4\u30c4\u8a9e (\u30b9\u30a4\u30b9)" },
            { "en_AU", "\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2\u82f1\u8a9e" },
            { "en_CA", "\u30ab\u30ca\u30c0\u82f1\u8a9e" },
            { "en_GB", "\u30a4\u30ae\u30ea\u30b9\u82f1\u8a9e" },
            { "en_US", "\u30a2\u30e1\u30ea\u30ab\u82f1\u8a9e" },
            { "es_ES", "\u30b9\u30da\u30a4\u30f3\u8a9e (\u30a4\u30d9\u30ea\u30a2\u534a\u5cf6)" },
            { "fa_AF", "\u30c0\u30ea\u30fc\u8a9e" },
            { "nl_BE", "\u30d5\u30e9\u30de\u30f3\u8a9e" },
            { "pt_PT", "\u30dd\u30eb\u30c8\u30ac\u30eb\u8a9e (\u30a4\u30d9\u30ea\u30a2\u534a\u5cf6)" },
            { "ro_MD", "\u30e2\u30eb\u30c0\u30d3\u30a2\u8a9e" },
            { "sw_CD", "\u30b3\u30f3\u30b4\u30fb\u30b9\u30ef\u30d2\u30ea\u8a9e" },
            { "%%1901", "\u30c9\u30a4\u30c4\u8a9e\u65e7\u6b63\u66f8\u6cd5" },
            { "%%1994", "\u6a19\u6e96\u30ec\u30fc\u30b8\u30a2\u65b9\u8a00\u6b63\u66f8\u6cd5" },
            { "%%1996", "\u30c9\u30a4\u30c4\u8a9e\u6b63\u66f8\u6cd5(1996)" },
            { "ar_001", "\u73fe\u4ee3\u6a19\u6e96\u30a2\u30e9\u30d3\u30a2\u8a9e" },
            { "key.ca", "\u66a6\u6cd5" },
            { "key.cf", "\u901a\u8ca8\u30d5\u30a9\u30fc\u30de\u30c3\u30c8" },
            { "key.co", "\u4e26\u3079\u66ff\u3048\u9806\u5e8f" },
            { "key.cu", "\u901a\u8ca8" },
            { "key.hc", "\u6642\u9593\u5236(12 / 24)" },
            { "key.lb", "\u7981\u5247\u51e6\u7406" },
            { "key.ms", "\u5358\u4f4d\u7cfb" },
            { "key.nu", "\u6570\u5024\u66f8\u5f0f" },
            { "key.tz", "\u30bf\u30a4\u30e0\u30be\u30fc\u30f3" },
            { "key.va", "\u30ed\u30b1\u30fc\u30eb\u306e\u30d0\u30ea\u30a2\u30f3\u30c8" },
            { "%%ALUKU", "\u30a2\u30ed\u30b3\u65b9\u8a00" },
            { "%%BISKE", "\u30b5\u30f3\u30fb\u30b8\u30e7\u30eb\u30b8\u30e7/\u30d3\u30fc\u30e9\u65b9\u8a00" },
            { "%%BOONT", "\u30d6\u30fc\u30f3\u30c8\u30ea\u30f3\u30b0" },
            { "%%JAUER", "\u30e4\u30a6\u30a8\u30eb" },
            { "%%KKCOR", "\u5171\u901a\u30b3\u30fc\u30f3\u30a6\u30a9\u30fc\u30eb\u8a9e\u6b63\u66f8\u6cd5" },
            { "%%KSCOR", "\u6a19\u6e96\u30b3\u30fc\u30f3\u30a6\u30a9\u30fc\u30eb\u8a9e\u6b63\u66f8\u6cd5" },
            { "%%LIPAW", "\u30ec\u30fc\u30b8\u30a2\u65b9\u8a00 \u30ea\u30dd\u30f4\u30a1\u30c4\u65b9\u8a00" },
            { "%%NEDIS", "\u30ca\u30c6\u30a3\u30be\u30fc\u30cd\u65b9\u8a00" },
            { "%%NJIVA", "\u30cb\u30f4\u30a1\u65b9\u8a00" },
            { "%%NULIK", "\u73fe\u4ee3\u30f4\u30a9\u30e9\u30d4\u30e5\u30af\u8a9e" },
            { "%%OSOJS", "\u30aa\u30bc\u30a2\u30c3\u30b3/\u30aa\u30bd\u30e4\u30cd\u65b9\u8a00" },
            { "%%POSIX", "\u30b3\u30f3\u30d4\u30e5\u30fc\u30bf" },
            { "%%PUTER", "\u30d7\u30fc\u30bf\u30fc" },
            { "%%RIGIK", "\u53e4\u5178\u30f4\u30a9\u30e9\u30d4\u30e5\u30af\u8a9e" },
            { "%%ROZAJ", "\u30ec\u30b7\u30a2\u65b9\u8a00" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "\u30b9\u30c8\u30eb\u30f4\u30a3\u30c3\u30c4\u30a1/\u30bd\u30eb\u30d3\u30c4\u30a1\u65b9\u8a00" },
            { "%%UCCOR", "\u7d71\u4e00\u30b3\u30fc\u30f3\u30a6\u30a9\u30fc\u30eb\u8a9e\u6b63\u66f8\u6cd5" },
            { "zh_Hans", "\u7c21\u4f53\u4e2d\u56fd\u8a9e" },
            { "zh_Hant", "\u7e41\u4f53\u4e2d\u56fd\u8a9e" },
            { "%%DAJNKO", "\u30c0\u30a4\u30f3\u30c1\u30c3\u30c4\u30a1" },
            { "%%FONIPA", "\u56fd\u969b\u97f3\u58f0\u8a18\u53f7" },
            { "%%FONUPA", "\u30a6\u30e9\u30eb\u97f3\u58f0\u8a18\u53f7" },
            { "%%NDYUKA", "\u30f3\u30b8\u30e5\u30ab\u65b9\u8a00" },
            { "%%PAMAKA", "\u30d1\u30de\u30ab\u65b9\u8a00" },
            { "%%PINYIN", "\u30d4\u30f3\u97f3(\u30ed\u30fc\u30de\u5b57\u8868\u8a18\u6cd5)" },
            { "%%SCOUSE", "\u30ea\u30d0\u30d7\u30fc\u30eb\u65b9\u8a00" },
            { "%%TARASK", "\u30bf\u30e9\u30b7\u30b1\u30f4\u30a3\u30c4\u30a1\u6b63\u66f8\u6cd5" },
            { "%%UCRCOR", "\u6539\u8a02\u7d71\u4e00\u30b3\u30fc\u30f3\u30a6\u30a9\u30fc\u30eb\u8a9e\u6b63\u66f8\u6cd5" },
            { "%%ULSTER", "\u30a2\u30eb\u30b9\u30bf\u30fc" },
            { "%%ALALC97", "ALA-LC\u30e9\u30c6\u30f3\u6587\u5b57\u5316(1997)" },
            { "%%AREVELA", "\u6771\u30a2\u30eb\u30e1\u30cb\u30a2\u6587\u8a9e" },
            { "%%AREVMDA", "\u897f\u30a2\u30eb\u30e1\u30cb\u30a2\u6587\u8a9e" },
            { "%%BAUDDHA", "\u30d0\u30a6\u30c3\u30c0" },
            { "%%BOHORIC", "\u30dc\u30db\u30ea\u30c3\u30c4\u30fb\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8" },
            { "%%EMODENG", "\u521d\u671f\u8fd1\u4ee3\u82f1\u8a9e" },
            { "%%HEPBURN", "\u30d8\u30dc\u30f3\u5f0f\u30ed\u30fc\u30de\u5b57" },
            { "%%ITIHASA", "\u30a4\u30c6\u30a3\u30cf\u30fc\u30b5" },
            { "%%LAUKIKA", "\u30e9\u30a6\u30ad\u30ab" },
            { "%%METELKO", "\u30e1\u30c6\u30eb\u30c1\u30c3\u30c4\u30a1" },
            { "%%MONOTON", "\u30e2\u30ce\u30c8\u30cb\u30c3\u30af" },
            { "%%POLYTON", "\u30dd\u30ea\u30c8\u30cb\u30c3\u30af" },
            { "%%REVISED", "\u6539\u8a02\u7248" },
            { "%%SURSILV", "\u30b9\u30eb\u30b7\u30eb\u30f4\u30a1\u30f3" },
            { "%%SUTSILV", "\u30b9\u30c8\u30b7\u30eb\u30f4\u30a1\u30f3" },
            { "%%VAIDIKA", "\u30f4\u30a1\u30a4\u30c7\u30a3\u30ab" },
            { "%%1606NICT", "\u5f8c\u671f\u4e2d\u4e16\u30d5\u30e9\u30f3\u30b9\u8a9e(\u301c1606)" },
            { "%%1694ACAD", "\u521d\u671f\u73fe\u4ee3\u30d5\u30e9\u30f3\u30b9\u8a9e" },
            { "%%1959ACAD", "\u6a19\u6e96\u30d9\u30e9\u30eb\u30fc\u30b7\u8a9e (1959)" },
            { "%%BAKU1926", "\u7d71\u4e00\u30c8\u30eb\u30b3\u30e9\u30c6\u30f3\u6587\u5b57" },
            { "%%BISCAYAN", "\u30d3\u30b9\u30ab\u30e4\u8a9e" },
            { "%%FONXSAMP", "\u30d5\u30a9\u30f3\u30af\u30b5\u30f3\u30d7" },
            { "%%HOGNORSK", "\u30d8\u30b0\u30ce\u30b7\u30e5\u30af" },
            { "%%JYUTPING", "\u7565\u79f0\u7ca4\u62fc" },
            { "%%SCOTLAND", "\u30b9\u30b3\u30c3\u30c8\u30e9\u30f3\u30c9\u6a19\u6e96\u82f1\u8a9e" },
            { "%%SURMIRAN", "\u30b9\u30eb\u30df\u30e9\u30f3" },
            { "%%VALENCIA", "\u30d0\u30ec\u30f3\u30b7\u30a2\u65b9\u8a00" },
            { "%%VALLADER", "\u30f4\u30a1\u30e9\u30c0\u30fc" },
            { "%%WADEGILE", "\u30a6\u30a7\u30fc\u30c9\u5f0f\u30ed\u30fc\u30de\u5b57\u8868\u8a18\u6cd5" },
            { "type.ca.roc", "\u4e2d\u83ef\u6c11\u56fd\u66a6" },
            { "type.co.eor", "\u30e8\u30fc\u30ed\u30c3\u30d1\u8a00\u8a9e\u6587\u5b57\u306e\u4e26\u3079\u66ff\u3048\u898f\u5247" },
            { "type.hc.h11", "12\u6642\u9593\u5236(0\u301c11)" },
            { "type.hc.h12", "12\u6642\u9593\u5236(1\u301c12)" },
            { "type.hc.h23", "24\u6642\u9593\u5236(0\u301c23)" },
            { "type.hc.h24", "24\u6642\u9593\u5236(1\u301c24)" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.arab", "\u30a2\u30e9\u30d3\u30a2\u30fb\u30a4\u30f3\u30c9\u6570\u5b57" },
            { "type.nu.armn", "\u30a2\u30eb\u30e1\u30cb\u30a2\u6570\u5b57" },
            { "type.nu.bali", "\u30d0\u30ea\u6570\u5b57" },
            { "type.nu.beng", "\u30d9\u30f3\u30ac\u30eb\u6570\u5b57" },
            { "type.nu.brah", "\u30d6\u30e9\u30fc\u30d5\u30df\u30fc\u6570\u5b57" },
            { "type.nu.cakm", "\u30c1\u30e3\u30af\u30de\u6570\u5b57" },
            { "type.nu.cham", "\u30c1\u30e3\u30e0\u6570\u5b57" },
            { "type.nu.deva", "\u30c7\u30fc\u30d0\u30ca\u30fc\u30ac\u30ea\u30fc\u6570\u5b57" },
            { "type.nu.ethi", "\u30a8\u30c1\u30aa\u30d4\u30a2\u6570\u5b57" },
            { "type.nu.geor", "\u30b8\u30e7\u30fc\u30b8\u30a2\u6570\u5b57" },
            { "type.nu.grek", "\u30ae\u30ea\u30b7\u30e3\u6570\u5b57" },
            { "type.nu.gujr", "\u30b0\u30b8\u30e3\u30e9\u30fc\u30c8\u6570\u5b57" },
            { "type.nu.guru", "\u30b0\u30eb\u30e0\u30ad\u30fc\u6570\u5b57" },
            { "type.nu.hans", "\u7c21\u4f53\u6f22\u6570\u5b57" },
            { "type.nu.hant", "\u7e41\u4f53\u6f22\u6570\u5b57" },
            { "type.nu.hebr", "\u30d8\u30d6\u30e9\u30a4\u6570\u5b57" },
            { "type.nu.java", "\u30b8\u30e3\u30ef\u6570\u5b57" },
            { "type.nu.jpan", "\u6f22\u6570\u5b57" },
            { "type.nu.kali", "\u30ab\u30e4\u30fc\u6570\u5b57" },
            { "type.nu.khmr", "\u30af\u30e1\u30fc\u30eb\u6570\u5b57" },
            { "type.nu.knda", "\u30ab\u30f3\u30ca\u30c0\u6570\u5b57" },
            { "type.nu.lana", "\u30e9\u30fc\u30f3\u30ca\u30fc\u6570\u5b57" },
            { "type.nu.laoo", "\u30e9\u30aa\u6570\u5b57" },
            { "type.nu.latn", "\u7b97\u7528\u6570\u5b57" },
            { "type.nu.lepc", "\u30ec\u30d7\u30c1\u30e3\u6570\u5b57" },
            { "type.nu.limb", "\u30ea\u30f3\u30d6\u6570\u5b57" },
            { "type.nu.mlym", "\u30de\u30e9\u30e4\u30fc\u30e9\u30e0\u6570\u5b57" },
            { "type.nu.mong", "\u30e2\u30f3\u30b4\u30eb\u6570\u5b57" },
            { "type.nu.mtei", "\u30de\u30cb\u30d7\u30ea\u6570\u5b57" },
            { "type.nu.mymr", "\u30df\u30e3\u30f3\u30de\u30fc\u6570\u5b57" },
            { "type.nu.nkoo", "\u30f3\u30b3\u6570\u5b57" },
            { "type.nu.olck", "\u30aa\u30eb\u30c1\u30ad\u6570\u5b57" },
            { "type.nu.orya", "\u30aa\u30c7\u30a3\u30a2\u6570\u5b57" },
            { "type.nu.osma", "\u30aa\u30b9\u30de\u30cb\u30a2\u6570\u5b57" },
            { "type.nu.saur", "\u30b5\u30a6\u30e9\u30fc\u30b7\u30e5\u30c8\u30e9\u6570\u5b57" },
            { "type.nu.shrd", "\u30b7\u30e3\u30fc\u30e9\u30c0\u30fc\u6570\u5b57" },
            { "type.nu.sora", "\u30bd\u30e9\u30fb\u30bd\u30f3\u30da\u30f3\u6570\u5b57" },
            { "type.nu.sund", "\u30b9\u30f3\u30c0\u6570\u5b57" },
            { "type.nu.takr", "\u30bf\u30fc\u30af\u30ea\u30fc\u6570\u5b57" },
            { "type.nu.talu", "\u65b0\u30bf\u30a4\u30fb\u30eb\u30fc\u6570\u5b57" },
            { "type.nu.taml", "\u4f1d\u7d71\u7684\u30bf\u30df\u30eb\u6570\u5b57" },
            { "type.nu.telu", "\u30c6\u30eb\u30b0\u6570\u5b57" },
            { "type.nu.thai", "\u30bf\u30a4\u6570\u5b57" },
            { "type.nu.tibt", "\u30c1\u30d9\u30c3\u30c8\u6570\u5b57" },
            { "type.nu.vaii", "\u30f4\u30a1\u30a4\u6587\u5b57\u306e\u8a18\u6570\u6cd5" },
            { "type.ca.dangi", "\u30c0\u30f3\u30ae\u66a6" },
            { "type.co.ducet", "\u30e6\u30cb\u30b3\u30fc\u30c9\u7167\u5408\u9806" },
            { "type.lb.loose", "\u7981\u5247\u51e6\u7406(\u5f31)" },
            { "type.nu.roman", "\u30ed\u30fc\u30de\u6570\u5b57" },
            { "type.ca.coptic", "\u30b3\u30d7\u30c8\u66a6" },
            { "type.ca.hebrew", "\u30e6\u30c0\u30e4\u66a6" },
            { "type.ca.indian", "\u30a4\u30f3\u30c9\u56fd\u5b9a\u66a6" },
            { "type.co.compat", "\u4ee5\u524d\u306e\u9806\u5e8f\uff08\u4e92\u63db\u6027\uff09" },
            { "type.co.pinyin", "\u30d4\u30f3\u30a4\u30f3\u9806" },
            { "type.co.search", "\u6c4e\u7528\u691c\u7d22" },
            { "type.co.stroke", "\u753b\u6570\u9806" },
            { "type.co.unihan", "\u90e8\u9996\u9806" },
            { "type.co.zhuyin", "\u6ce8\u97f3\u9806" },
            { "type.d0.fwidth", "\u5168\u89d2" },
            { "type.d0.hwidth", "\u534a\u89d2" },
            { "type.lb.normal", "\u7981\u5247\u51e6\u7406(\u6a19\u6e96)" },
            { "type.lb.strict", "\u7981\u5247\u51e6\u7406(\u5f37)" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.ms.metric", "\u30e1\u30fc\u30c8\u30eb\u6cd5" },
            { "type.nu.native", "\u72ec\u81ea\u306e\u8a18\u6570\u6cd5" },
            { "type.ca.chinese", "\u4e2d\u56fd\u66a6" },
            { "type.ca.islamic", "\u30a4\u30b9\u30e9\u30e0\u66a6" },
            { "type.ca.iso8601", "ISO-8601" },
            { "type.ca.persian", "\u30da\u30eb\u30b7\u30a2\u66a6" },
            { "type.cf.account", "\u4f1a\u8a08\u901a\u8ca8\u30d5\u30a9\u30fc\u30de\u30c3\u30c8" },
            { "type.co.big5han", "\u7e41\u4f53\u5b57\u4e2d\u56fd\u8a9e\u9806(Big5)" },
            { "type.d0.npinyin", "\u6570\u5b57" },
            { "type.nu.arabext", "\u30da\u30eb\u30b7\u30a2\u6570\u5b57" },
            { "type.nu.armnlow", "\u30a2\u30eb\u30e1\u30cb\u30a2\u6570\u5b57(\u5c0f\u6587\u5b57)" },
            { "type.nu.finance", "\u8ca1\u52d9\u7528\u6f22\u6570\u5b57" },
            { "type.nu.greklow", "\u30ae\u30ea\u30b7\u30e3\u6570\u5b57(\u5c0f\u6587\u5b57)" },
            { "type.nu.hanidec", "\u6f22\u6570\u5b57(\u4f4d\u53d6\u308a\u8a18\u6570\u6cd5)" },
            { "type.nu.hansfin", "\u7c21\u4f53\u5927\u5b57" },
            { "type.nu.hantfin", "\u7e41\u4f53\u5927\u5b57" },
            { "type.nu.jpanfin", "\u5927\u5b57" },
            { "type.nu.tamldec", "\u30bf\u30df\u30eb\u6570\u5b57" },
            { "type.ca.buddhist", "\u4ecf\u66a6" },
            { "type.ca.ethiopic", "\u30a8\u30c1\u30aa\u30d4\u30a2\u66a6" },
            { "type.ca.japanese", "\u548c\u66a6" },
            { "type.cf.standard", "\u6a19\u6e96\u901a\u8ca8\u30d5\u30a9\u30fc\u30de\u30c3\u30c8" },
            { "type.co.phonetic", "\u97f3\u58f0\u9806\u306b\u3088\u308b\u4e26\u3079\u66ff\u3048" },
            { "type.co.reformed", "\u30ea\u30d5\u30a9\u30fc\u30e0" },
            { "type.co.searchjl", "\u30cf\u30f3\u30b0\u30eb\u8a9e\u982d\u5b50\u97f3\u306b\u3088\u308b\u4e26\u3079\u66ff\u3048" },
            { "type.co.standard", "\u6a19\u6e96\u4e26\u3079\u66ff\u3048\u9806\u5e8f" },
            { "type.ms.uksystem", "\u30e4\u30fc\u30c9\u30fb\u30dd\u30f3\u30c9\u6cd5" },
            { "type.ms.ussystem", "\u7c73\u6163\u7fd2\u5358\u4f4d" },
            { "type.nu.fullwide", "\u5168\u89d2\u6570\u5b57" },
            { "type.nu.lanatham", "\u30e9\u30fc\u30f3\u30ca\u30fc\u30fb\u30bf\u30e0\u6570\u5b57" },
            { "type.nu.mymrshan", "\u30df\u30e3\u30f3\u30de\u30fc\u30fb\u30b7\u30e3\u30f3\u6570\u5b57" },
            { "type.nu.romanlow", "\u30ed\u30fc\u30de\u6570\u5b57(\u5c0f\u6587\u5b57)" },
            { "type.ca.gregorian", "\u897f\u66a6(\u30b0\u30ec\u30b4\u30ea\u30aa\u66a6)" },
            { "type.co.gb2312han", "\u7c21\u4f53\u5b57\u4e2d\u56fd\u8a9e\u9806(GB2312)" },
            { "type.co.phonebook", "\u96fb\u8a71\u5e33\u9806" },
            { "type.co.dictionary", "\u8f9e\u66f8\u9806" },
            { "type.co.traditional", "\u30c8\u30e9\u30c7\u30a3\u30c3\u30b7\u30e7\u30ca\u30eb" },
            { "type.nu.traditional", "\u5f93\u6765\u306e\u8a18\u6570\u6cd5" },
            { "type.ca.islamic-civil", "\u30a4\u30b9\u30e9\u30e0\u66a6(\u5b9a\u5468\u671f\u3001\u516c\u6c11\u7d00\u5143)" },
            { "ListCompositionPattern", "{0}\u3001{1}" },
            { "type.ca.islamic-umalqura", "\u30a4\u30b9\u30e9\u30e0\u66a6(\u30a6\u30f3\u30e0\u30fb\u30a2\u30eb\u30af\u30e9\u30fc)" },
            { "type.ca.ethiopic-amete-alem", "\u30a8\u30c1\u30aa\u30d4\u30a2\u5275\u4e16\u7d00\u5143\u66a6" },
        };
        return data;
    }
}
