/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.forms.finder.widgets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.swt.finder.ReferenceBy;
import org.eclipse.swtbot.swt.finder.SWTBotWidget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.MessageFormat;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.hamcrest.SelfDescribing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SWTBotWidget(clasz=ImageHyperlink.class, preferredName="imageHyperlink", referenceBy={ReferenceBy.MNEMONIC})
public class SWTBotImageHyperlink
extends AbstractSWTBotControl<ImageHyperlink> {
    public SWTBotImageHyperlink(ImageHyperlink w) throws WidgetNotFoundException {
        super((Control)w);
    }

    public SWTBotImageHyperlink(ImageHyperlink w, SelfDescribing description) throws WidgetNotFoundException {
        super((Control)w, description);
    }

    public AbstractSWTBot<ImageHyperlink> click() {
        return this.click(true);
    }

    public Image image() {
        return (Image)this.syncExec((Result)new Result<Image>(){

            public Image run() {
                return ((ImageHyperlink)SWTBotImageHyperlink.this.widget).getImage();
            }
        });
    }

    public Image hoverImage() {
        return (Image)this.syncExec((Result)new Result<Image>(){

            public Image run() {
                return ((ImageHyperlink)SWTBotImageHyperlink.this.widget).getHoverImage();
            }
        });
    }

    public Image activeImage() {
        return (Image)this.syncExec((Result)new Result<Image>(){

            public Image run() {
                return ((ImageHyperlink)SWTBotImageHyperlink.this.widget).getActiveImage();
            }
        });
    }

    public AbstractSWTBot<ImageHyperlink> click(String hyperlinkText) {
        this.log.debug((Object)MessageFormat.format((String)"Clicked on {0}", (Object[])new Object[]{SWTUtils.getText((Object)this.widget)}));
        String text = this.getText();
        boolean isText = text.contains(">" + hyperlinkText + "<");
        Assert.isLegal((boolean)isText, (Object)("Link does not contain text (" + hyperlinkText + "). It contains (" + text + ")"));
        hyperlinkText = this.extractHyperlinkTextOrHREF(hyperlinkText, text);
        this.notify(13, this.createHyperlinkEvent(hyperlinkText));
        this.log.debug((Object)MessageFormat.format((String)"Clicked on {0}", (Object[])new Object[]{SWTUtils.getText((Object)this.widget)}));
        return this.click(true);
    }

    private String extractHyperlinkTextOrHREF(String hyperlinkText, String text) {
        Pattern pattern = Pattern.compile(".*<[aA] [hH][rR][eE][fF]\\s*=\\s*['\"](.*)['\"]>" + hyperlinkText + "</[aA]>.*");
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1) : hyperlinkText;
    }

    private Event createHyperlinkEvent(String hyperlinkText) {
        Event e = this.createEvent();
        e.text = hyperlinkText;
        return e;
    }
}

