/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.settings.XMLCodeActionSettings;
import org.eclipse.lemminx.settings.XMLCodeLensSettings;
import org.eclipse.lemminx.settings.XMLCompletionSettings;
import org.eclipse.lemminx.settings.XMLFoldingSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.settings.XMLHoverSettings;
import org.eclipse.lemminx.settings.XMLPreferences;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lemminx.settings.XMLWorkspaceSettings;

public class SharedSettings {
    private final XMLCompletionSettings completionSettings = new XMLCompletionSettings();
    private boolean linkedEditingEnabled = false;
    private final XMLFoldingSettings foldingSettings = new XMLFoldingSettings();
    private final XMLFormattingOptions formattingSettings = new XMLFormattingOptions(true);
    private final XMLValidationRootSettings validationSettings = new XMLValidationRootSettings();
    private final XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
    private final XMLCodeActionSettings codeActionSettings = new XMLCodeActionSettings();
    private final XMLCodeLensSettings codeLensSettings = new XMLCodeLensSettings();
    private final XMLHoverSettings hoverSettings = new XMLHoverSettings();
    private final XMLPreferences preferences = new XMLPreferences();
    private final XMLWorkspaceSettings workspaceSettings = new XMLWorkspaceSettings();
    private boolean actionableNotificationSupport = false;
    private boolean openSettingsCommandSupport = false;
    private boolean bindingWizardSupport;

    public SharedSettings() {
    }

    public SharedSettings(SharedSettings newSettings) {
        this();
        this.completionSettings.merge(newSettings.getCompletionSettings());
        this.foldingSettings.merge(newSettings.getFoldingSettings());
        this.formattingSettings.merge(newSettings.getFormattingSettings());
        this.validationSettings.merge(newSettings.getValidationSettings());
        this.symbolSettings.merge(newSettings.getSymbolSettings());
        this.codeLensSettings.merge(newSettings.getCodeLensSettings());
        this.preferences.merge(newSettings.getPreferences());
        this.actionableNotificationSupport = newSettings.isActionableNotificationSupport();
        this.openSettingsCommandSupport = newSettings.isOpenSettingsCommandSupport();
        this.bindingWizardSupport = newSettings.isBindingWizardSupport();
        this.linkedEditingEnabled = newSettings.isLinkedEditingEnabled();
    }

    public XMLCompletionSettings getCompletionSettings() {
        return this.completionSettings;
    }

    public XMLFoldingSettings getFoldingSettings() {
        return this.foldingSettings;
    }

    public XMLFormattingOptions getFormattingSettings() {
        return this.formattingSettings;
    }

    public XMLValidationRootSettings getValidationSettings() {
        return this.validationSettings;
    }

    public XMLSymbolSettings getSymbolSettings() {
        return this.symbolSettings;
    }

    public XMLCodeActionSettings getCodeActionSettings() {
        return this.codeActionSettings;
    }

    public XMLCodeLensSettings getCodeLensSettings() {
        return this.codeLensSettings;
    }

    public XMLHoverSettings getHoverSettings() {
        return this.hoverSettings;
    }

    public XMLPreferences getPreferences() {
        return this.preferences;
    }

    public XMLWorkspaceSettings getWorkspaceSettings() {
        return this.workspaceSettings;
    }

    public boolean isActionableNotificationSupport() {
        return this.actionableNotificationSupport;
    }

    public void setActionableNotificationSupport(boolean actionableNotificationSupport) {
        this.actionableNotificationSupport = actionableNotificationSupport;
    }

    public boolean isOpenSettingsCommandSupport() {
        return this.openSettingsCommandSupport;
    }

    public void setOpenSettingsCommandSupport(boolean openSettingsCommandSupport) {
        this.openSettingsCommandSupport = openSettingsCommandSupport;
    }

    public boolean isBindingWizardSupport() {
        return this.bindingWizardSupport;
    }

    public void setBindingWizardSupport(boolean bindingWizardSupport) {
        this.bindingWizardSupport = bindingWizardSupport;
    }

    public void setLinkedEditingEnabled(boolean linkedEditingEnabled) {
        this.linkedEditingEnabled = linkedEditingEnabled;
    }

    public boolean isLinkedEditingEnabled() {
        return this.linkedEditingEnabled;
    }
}

