/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.changelog.core.editors;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.linuxtools.changelog.core.editors.FileHyperlink;
import org.eclipse.linuxtools.changelog.core.editors.GNUElementScanner;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class GNUHyperlinkDetector
extends AbstractHyperlinkDetector {
    private IPath documentLocation;

    public GNUHyperlinkDetector() {
    }

    public GNUHyperlinkDetector(ITextViewer textViewer, TextEditor editor) {
        Assert.isNotNull((Object)textViewer);
        this.documentLocation = this.getDocumentLocation((IEditorPart)editor);
    }

    /*
     * Unable to fully structure code
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (this.documentLocation == null) {
            ed = (ITextEditor)this.getAdapter(ITextEditor.class);
            this.documentLocation = this.getDocumentLocation((IEditorPart)ed);
        }
        thisDoc = textViewer.getDocument();
        scanner = new GNUElementScanner();
        scanner.setDefaultReturnToken((IToken)new Token((Object)"default"));
        partitionInfo = null;
        try {
            partitionInfo = thisDoc.getPartition(region.getOffset());
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
            return null;
        }
        scanner.setRange(thisDoc, partitionInfo.getOffset(), partitionInfo.getLength());
        tmpToken = (Token)scanner.nextToken();
        tokenStr = (String)tmpToken.getData();
        if (tokenStr != null) ** GOTO lbl23
        return null;
lbl-1000:
        // 1 sources

        {
            tmpToken = (Token)scanner.nextToken();
            tokenStr = (String)tmpToken.getData();
            if (tokenStr != null) continue;
            return null;
lbl23:
            // 2 sources

            ** while (region.getOffset() < scanner.getTokenOffset() || region.getOffset() > scanner.getOffset() || tokenStr.equals((Object)"default"))
        }
lbl24:
        // 1 sources

        tokenRegion = new Region(scanner.getTokenOffset(), scanner.getTokenLength());
        line = "";
        try {
            line = thisDoc.get(tokenRegion.getOffset(), tokenRegion.getLength());
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
            return null;
        }
        if (tokenStr.equals("_file_name")) {
            pathRegion = null;
            lineOffset = 0;
            if (line.startsWith("* ")) {
                lineOffset = 2;
                line = line.substring(2);
            }
            pathRegion = new Region(tokenRegion.getOffset() + lineOffset, line.length());
            if (this.documentLocation == null) {
                return null;
            }
            line = line.replaceAll("\\\\(.)", "$1");
            filePath = this.documentLocation.append(line);
            return new IHyperlink[]{new FileHyperlink((IRegion)pathRegion, ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(filePath))};
        }
        return null;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IPath getDocumentLocation(IEditorPart currentEditor) {
        IWorkspaceRoot myWorkspaceRoot = this.getWorkspaceRoot();
        String WorkspaceRoot = myWorkspaceRoot.getLocation().toOSString();
        IEditorInput cc = currentEditor.getEditorInput();
        if (cc instanceof IFileEditorInput) {
            IFileEditorInput test = (IFileEditorInput)cc;
            IFile loc = test.getFile();
            IPath docLoc = loc.getLocation();
            docLoc = docLoc.removeLastSegments(1);
            return docLoc;
        }
        if (cc instanceof SyncInfoCompareInput || cc instanceof CompareEditorInput) {
            CompareEditorInput test = (CompareEditorInput)cc;
            if (test.getCompareResult() == null) {
                return null;
            }
            Path docLoc = new Path(String.valueOf(WorkspaceRoot) + test.getCompareResult().toString());
            docLoc = docLoc.removeLastSegments(1);
            return docLoc;
        }
        return null;
    }
}

