/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.ui.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfM4WordDetector;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfMacroWordDetector;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfWhitespaceDetector;

public class AutoconfMacroPartitionRule
implements IPredicateRule {
    protected IToken token;
    private IWordDetector generalMacroWordDetector;
    private IWordDetector m4MacroWordDetector;
    protected IWordDetector fDetector;
    protected IWhitespaceDetector fWsDetector = new AutoconfWhitespaceDetector();
    protected int fColumn = -1;
    protected static final int UNDEFINED = -1;
    private StringBuffer fBuffer = new StringBuffer();

    public AutoconfMacroPartitionRule(IToken inToken) {
        this.token = inToken;
        this.generalMacroWordDetector = new AutoconfMacroWordDetector();
        this.m4MacroWordDetector = new AutoconfM4WordDetector();
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    protected void matchParentheses(ICharacterScanner scanner) {
        boolean finished = false;
        int depth = 1;
        int quoteDepth = 0;
        int c = scanner.read();
        while (!finished && c != -1) {
            if (c == 91) {
                ++quoteDepth;
            } else if (c == 93 && --quoteDepth < 0) {
                finished = true;
            }
            if (quoteDepth == 0) {
                if (c == 41) {
                    if (--depth <= 0) {
                        finished = true;
                    }
                } else if (c == 40) {
                    ++depth;
                }
            }
            c = scanner.read();
        }
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        this.fBuffer.setLength(0);
        this.fBuffer.append((char)c);
        if (c == 65) {
            c = scanner.read();
            this.fBuffer.append((char)c);
            if (c != 67 && c != 72 && c != 77) {
                this.unreadBuffer(scanner);
                return Token.UNDEFINED;
            }
            this.fDetector = this.generalMacroWordDetector;
        } else if (c == 109) {
            c = scanner.read();
            this.fBuffer.append((char)c);
            if (c != 4) {
                this.unreadBuffer(scanner);
                return Token.UNDEFINED;
            }
            this.fDetector = this.m4MacroWordDetector;
        } else {
            this.unreadBuffer(scanner);
            return Token.UNDEFINED;
        }
        c = scanner.read();
        while (c != -1 && this.fDetector.isWordPart((char)c)) {
            this.fBuffer.append((char)c);
            c = scanner.read();
        }
        if (c != -1 && c != 59 && !this.fWsDetector.isWhitespace((char)c)) {
            if (c == 40) {
                this.matchParentheses(scanner);
            } else {
                scanner.unread();
                this.unreadBuffer(scanner);
                return Token.UNDEFINED;
            }
        }
        scanner.unread();
        return this.token;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

